/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ITask;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.Action;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task
extends Asset
implements ITask,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Task";
    String typeName;
    @Attribute
    List<Action> taskActions;
    @Attribute
    String taskCreatedBy;
    @Attribute
    String taskExecutionAction;
    @Attribute
    String taskExecutionComment;
    @Attribute
    @Date
    Long taskExpiresAt;
    @Attribute
    String taskIntegrationConfig;
    @Attribute
    Boolean taskIsRead;
    @Attribute
    String taskProposals;
    @Attribute
    String taskRecipient;
    @Attribute
    String taskRelatedAssetGuid;
    @Attribute
    String taskRequestor;
    @Attribute
    String taskRequestorComment;
    @Attribute
    String taskType;
    @Attribute
    String taskUpdatedBy;

    @Override
    public Task trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Task.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Task.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Task.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Task.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static Task refByGuid(String guid) {
        return Task.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static Task refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((TaskBuilder)((TaskBuilder)Task._internal().guid(guid)).semantic(semantic)).build();
    }

    public static Task refByQualifiedName(String qualifiedName) {
        return Task.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static Task refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((TaskBuilder)((TaskBuilder)Task._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static Task get(AtlanClient client, String id) throws AtlanException {
        return Task.get(client, id, false);
    }

    @JsonIgnore
    public static Task get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Task) {
                return (Task)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof Task) {
            return (Task)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static Task get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return Task.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static Task get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Task.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof Task) {
                return (Task)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Task.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof Task) {
            return (Task)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static TaskBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TaskBuilder)((TaskBuilder)((TaskBuilder)Task._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public TaskBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        Task.validateRequired(TYPE_NAME, map);
        return Task.updater(this.getQualifiedName(), this.getName());
    }

    public static Task removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Task)Asset.removeDescription(client, Task.updater(qualifiedName, name));
    }

    public static Task removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Task)Asset.removeUserDescription(client, Task.updater(qualifiedName, name));
    }

    public static Task removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Task)Asset.removeOwners(client, Task.updater(qualifiedName, name));
    }

    public static Task updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Task)Asset.updateCertificate(client, Task._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Task removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Task)Asset.removeCertificate(client, Task.updater(qualifiedName, name));
    }

    public static Task updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Task)Asset.updateAnnouncement(client, Task._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Task removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Task)Asset.removeAnnouncement(client, Task.updater(qualifiedName, name));
    }

    public static Task replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Task)Asset.replaceTerms(client, Task.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static Task appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Task)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static Task removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Task)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static Task appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Task)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static Task appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Task)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Task(TaskBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Task.$default$typeName();
        this.taskActions = switch (b.taskActions == null ? 0 : b.taskActions.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.taskActions.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Action>(b.taskActions));
        };
        this.taskCreatedBy = b.taskCreatedBy;
        this.taskExecutionAction = b.taskExecutionAction;
        this.taskExecutionComment = b.taskExecutionComment;
        this.taskExpiresAt = b.taskExpiresAt;
        this.taskIntegrationConfig = b.taskIntegrationConfig;
        this.taskIsRead = b.taskIsRead;
        this.taskProposals = b.taskProposals;
        this.taskRecipient = b.taskRecipient;
        this.taskRelatedAssetGuid = b.taskRelatedAssetGuid;
        this.taskRequestor = b.taskRequestor;
        this.taskRequestorComment = b.taskRequestorComment;
        this.taskType = b.taskType;
        this.taskUpdatedBy = b.taskUpdatedBy;
    }

    @Generated
    public static TaskBuilder<?, ?> _internal() {
        return new TaskBuilderImpl();
    }

    @Generated
    public TaskBuilder<?, ?> toBuilder() {
        return new TaskBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public List<Action> getTaskActions() {
        return this.taskActions;
    }

    @Override
    @Generated
    public String getTaskCreatedBy() {
        return this.taskCreatedBy;
    }

    @Override
    @Generated
    public String getTaskExecutionAction() {
        return this.taskExecutionAction;
    }

    @Override
    @Generated
    public String getTaskExecutionComment() {
        return this.taskExecutionComment;
    }

    @Override
    @Generated
    public Long getTaskExpiresAt() {
        return this.taskExpiresAt;
    }

    @Override
    @Generated
    public String getTaskIntegrationConfig() {
        return this.taskIntegrationConfig;
    }

    @Override
    @Generated
    public Boolean getTaskIsRead() {
        return this.taskIsRead;
    }

    @Override
    @Generated
    public String getTaskProposals() {
        return this.taskProposals;
    }

    @Override
    @Generated
    public String getTaskRecipient() {
        return this.taskRecipient;
    }

    @Override
    @Generated
    public String getTaskRelatedAssetGuid() {
        return this.taskRelatedAssetGuid;
    }

    @Override
    @Generated
    public String getTaskRequestor() {
        return this.taskRequestor;
    }

    @Override
    @Generated
    public String getTaskRequestorComment() {
        return this.taskRequestorComment;
    }

    @Override
    @Generated
    public String getTaskType() {
        return this.taskType;
    }

    @Override
    @Generated
    public String getTaskUpdatedBy() {
        return this.taskUpdatedBy;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$taskExpiresAt = this.getTaskExpiresAt();
        Long other$taskExpiresAt = other.getTaskExpiresAt();
        if (this$taskExpiresAt == null ? other$taskExpiresAt != null : !((Object)this$taskExpiresAt).equals(other$taskExpiresAt)) {
            return false;
        }
        Boolean this$taskIsRead = this.getTaskIsRead();
        Boolean other$taskIsRead = other.getTaskIsRead();
        if (this$taskIsRead == null ? other$taskIsRead != null : !((Object)this$taskIsRead).equals(other$taskIsRead)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        List<Action> this$taskActions = this.getTaskActions();
        List<Action> other$taskActions = other.getTaskActions();
        if (this$taskActions == null ? other$taskActions != null : !((Object)this$taskActions).equals(other$taskActions)) {
            return false;
        }
        String this$taskCreatedBy = this.getTaskCreatedBy();
        String other$taskCreatedBy = other.getTaskCreatedBy();
        if (this$taskCreatedBy == null ? other$taskCreatedBy != null : !this$taskCreatedBy.equals(other$taskCreatedBy)) {
            return false;
        }
        String this$taskExecutionAction = this.getTaskExecutionAction();
        String other$taskExecutionAction = other.getTaskExecutionAction();
        if (this$taskExecutionAction == null ? other$taskExecutionAction != null : !this$taskExecutionAction.equals(other$taskExecutionAction)) {
            return false;
        }
        String this$taskExecutionComment = this.getTaskExecutionComment();
        String other$taskExecutionComment = other.getTaskExecutionComment();
        if (this$taskExecutionComment == null ? other$taskExecutionComment != null : !this$taskExecutionComment.equals(other$taskExecutionComment)) {
            return false;
        }
        String this$taskIntegrationConfig = this.getTaskIntegrationConfig();
        String other$taskIntegrationConfig = other.getTaskIntegrationConfig();
        if (this$taskIntegrationConfig == null ? other$taskIntegrationConfig != null : !this$taskIntegrationConfig.equals(other$taskIntegrationConfig)) {
            return false;
        }
        String this$taskProposals = this.getTaskProposals();
        String other$taskProposals = other.getTaskProposals();
        if (this$taskProposals == null ? other$taskProposals != null : !this$taskProposals.equals(other$taskProposals)) {
            return false;
        }
        String this$taskRecipient = this.getTaskRecipient();
        String other$taskRecipient = other.getTaskRecipient();
        if (this$taskRecipient == null ? other$taskRecipient != null : !this$taskRecipient.equals(other$taskRecipient)) {
            return false;
        }
        String this$taskRelatedAssetGuid = this.getTaskRelatedAssetGuid();
        String other$taskRelatedAssetGuid = other.getTaskRelatedAssetGuid();
        if (this$taskRelatedAssetGuid == null ? other$taskRelatedAssetGuid != null : !this$taskRelatedAssetGuid.equals(other$taskRelatedAssetGuid)) {
            return false;
        }
        String this$taskRequestor = this.getTaskRequestor();
        String other$taskRequestor = other.getTaskRequestor();
        if (this$taskRequestor == null ? other$taskRequestor != null : !this$taskRequestor.equals(other$taskRequestor)) {
            return false;
        }
        String this$taskRequestorComment = this.getTaskRequestorComment();
        String other$taskRequestorComment = other.getTaskRequestorComment();
        if (this$taskRequestorComment == null ? other$taskRequestorComment != null : !this$taskRequestorComment.equals(other$taskRequestorComment)) {
            return false;
        }
        String this$taskType = this.getTaskType();
        String other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !this$taskType.equals(other$taskType)) {
            return false;
        }
        String this$taskUpdatedBy = this.getTaskUpdatedBy();
        String other$taskUpdatedBy = other.getTaskUpdatedBy();
        return !(this$taskUpdatedBy == null ? other$taskUpdatedBy != null : !this$taskUpdatedBy.equals(other$taskUpdatedBy));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $taskExpiresAt = this.getTaskExpiresAt();
        result = result * 59 + ($taskExpiresAt == null ? 43 : ((Object)$taskExpiresAt).hashCode());
        Boolean $taskIsRead = this.getTaskIsRead();
        result = result * 59 + ($taskIsRead == null ? 43 : ((Object)$taskIsRead).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        List<Action> $taskActions = this.getTaskActions();
        result = result * 59 + ($taskActions == null ? 43 : ((Object)$taskActions).hashCode());
        String $taskCreatedBy = this.getTaskCreatedBy();
        result = result * 59 + ($taskCreatedBy == null ? 43 : $taskCreatedBy.hashCode());
        String $taskExecutionAction = this.getTaskExecutionAction();
        result = result * 59 + ($taskExecutionAction == null ? 43 : $taskExecutionAction.hashCode());
        String $taskExecutionComment = this.getTaskExecutionComment();
        result = result * 59 + ($taskExecutionComment == null ? 43 : $taskExecutionComment.hashCode());
        String $taskIntegrationConfig = this.getTaskIntegrationConfig();
        result = result * 59 + ($taskIntegrationConfig == null ? 43 : $taskIntegrationConfig.hashCode());
        String $taskProposals = this.getTaskProposals();
        result = result * 59 + ($taskProposals == null ? 43 : $taskProposals.hashCode());
        String $taskRecipient = this.getTaskRecipient();
        result = result * 59 + ($taskRecipient == null ? 43 : $taskRecipient.hashCode());
        String $taskRelatedAssetGuid = this.getTaskRelatedAssetGuid();
        result = result * 59 + ($taskRelatedAssetGuid == null ? 43 : $taskRelatedAssetGuid.hashCode());
        String $taskRequestor = this.getTaskRequestor();
        result = result * 59 + ($taskRequestor == null ? 43 : $taskRequestor.hashCode());
        String $taskRequestorComment = this.getTaskRequestorComment();
        result = result * 59 + ($taskRequestorComment == null ? 43 : $taskRequestorComment.hashCode());
        String $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : $taskType.hashCode());
        String $taskUpdatedBy = this.getTaskUpdatedBy();
        result = result * 59 + ($taskUpdatedBy == null ? 43 : $taskUpdatedBy.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Task(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", taskActions=" + String.valueOf(this.getTaskActions()) + ", taskCreatedBy=" + this.getTaskCreatedBy() + ", taskExecutionAction=" + this.getTaskExecutionAction() + ", taskExecutionComment=" + this.getTaskExecutionComment() + ", taskExpiresAt=" + this.getTaskExpiresAt() + ", taskIntegrationConfig=" + this.getTaskIntegrationConfig() + ", taskIsRead=" + this.getTaskIsRead() + ", taskProposals=" + this.getTaskProposals() + ", taskRecipient=" + this.getTaskRecipient() + ", taskRelatedAssetGuid=" + this.getTaskRelatedAssetGuid() + ", taskRequestor=" + this.getTaskRequestor() + ", taskRequestorComment=" + this.getTaskRequestorComment() + ", taskType=" + this.getTaskType() + ", taskUpdatedBy=" + this.getTaskUpdatedBy() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class TaskBuilder<C extends Task, B extends TaskBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<Action> taskActions;
        @Generated
        private String taskCreatedBy;
        @Generated
        private String taskExecutionAction;
        @Generated
        private String taskExecutionComment;
        @Generated
        private Long taskExpiresAt;
        @Generated
        private String taskIntegrationConfig;
        @Generated
        private Boolean taskIsRead;
        @Generated
        private String taskProposals;
        @Generated
        private String taskRecipient;
        @Generated
        private String taskRelatedAssetGuid;
        @Generated
        private String taskRequestor;
        @Generated
        private String taskRequestorComment;
        @Generated
        private String taskType;
        @Generated
        private String taskUpdatedBy;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TaskBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Task instance, TaskBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.taskActions(instance.taskActions == null ? Collections.emptyList() : instance.taskActions);
            b.taskCreatedBy(instance.taskCreatedBy);
            b.taskExecutionAction(instance.taskExecutionAction);
            b.taskExecutionComment(instance.taskExecutionComment);
            b.taskExpiresAt(instance.taskExpiresAt);
            b.taskIntegrationConfig(instance.taskIntegrationConfig);
            b.taskIsRead(instance.taskIsRead);
            b.taskProposals(instance.taskProposals);
            b.taskRecipient(instance.taskRecipient);
            b.taskRelatedAssetGuid(instance.taskRelatedAssetGuid);
            b.taskRequestor(instance.taskRequestor);
            b.taskRequestorComment(instance.taskRequestorComment);
            b.taskType(instance.taskType);
            b.taskUpdatedBy(instance.taskUpdatedBy);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B taskAction(Action taskAction) {
            if (this.taskActions == null) {
                this.taskActions = new ArrayList();
            }
            this.taskActions.add(taskAction);
            return (B)this.self();
        }

        @Generated
        public B taskActions(Collection<? extends Action> taskActions) {
            if (taskActions == null) {
                throw new NullPointerException("taskActions cannot be null");
            }
            if (this.taskActions == null) {
                this.taskActions = new ArrayList();
            }
            this.taskActions.addAll(taskActions);
            return (B)this.self();
        }

        @Generated
        public B clearTaskActions() {
            if (this.taskActions != null) {
                this.taskActions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B taskCreatedBy(String taskCreatedBy) {
            this.taskCreatedBy = taskCreatedBy;
            return (B)this.self();
        }

        @Generated
        public B taskExecutionAction(String taskExecutionAction) {
            this.taskExecutionAction = taskExecutionAction;
            return (B)this.self();
        }

        @Generated
        public B taskExecutionComment(String taskExecutionComment) {
            this.taskExecutionComment = taskExecutionComment;
            return (B)this.self();
        }

        @Generated
        public B taskExpiresAt(Long taskExpiresAt) {
            this.taskExpiresAt = taskExpiresAt;
            return (B)this.self();
        }

        @Generated
        public B taskIntegrationConfig(String taskIntegrationConfig) {
            this.taskIntegrationConfig = taskIntegrationConfig;
            return (B)this.self();
        }

        @Generated
        public B taskIsRead(Boolean taskIsRead) {
            this.taskIsRead = taskIsRead;
            return (B)this.self();
        }

        @Generated
        public B taskProposals(String taskProposals) {
            this.taskProposals = taskProposals;
            return (B)this.self();
        }

        @Generated
        public B taskRecipient(String taskRecipient) {
            this.taskRecipient = taskRecipient;
            return (B)this.self();
        }

        @Generated
        public B taskRelatedAssetGuid(String taskRelatedAssetGuid) {
            this.taskRelatedAssetGuid = taskRelatedAssetGuid;
            return (B)this.self();
        }

        @Generated
        public B taskRequestor(String taskRequestor) {
            this.taskRequestor = taskRequestor;
            return (B)this.self();
        }

        @Generated
        public B taskRequestorComment(String taskRequestorComment) {
            this.taskRequestorComment = taskRequestorComment;
            return (B)this.self();
        }

        @Generated
        public B taskType(String taskType) {
            this.taskType = taskType;
            return (B)this.self();
        }

        @Generated
        public B taskUpdatedBy(String taskUpdatedBy) {
            this.taskUpdatedBy = taskUpdatedBy;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Task.TaskBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", taskActions=" + String.valueOf(this.taskActions) + ", taskCreatedBy=" + this.taskCreatedBy + ", taskExecutionAction=" + this.taskExecutionAction + ", taskExecutionComment=" + this.taskExecutionComment + ", taskExpiresAt=" + this.taskExpiresAt + ", taskIntegrationConfig=" + this.taskIntegrationConfig + ", taskIsRead=" + this.taskIsRead + ", taskProposals=" + this.taskProposals + ", taskRecipient=" + this.taskRecipient + ", taskRelatedAssetGuid=" + this.taskRelatedAssetGuid + ", taskRequestor=" + this.taskRequestor + ", taskRequestorComment=" + this.taskRequestorComment + ", taskType=" + this.taskType + ", taskUpdatedBy=" + this.taskUpdatedBy + ")";
        }
    }

    @Generated
    private static final class TaskBuilderImpl
    extends TaskBuilder<Task, TaskBuilderImpl> {
        @Generated
        private TaskBuilderImpl() {
        }

        @Override
        @Generated
        protected TaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Task build() {
            return new Task(this);
        }
    }
}

