/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.IWorkflow;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.WorkflowStatus;
import com.atlan.model.enums.WorkflowType;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Workflow
extends Asset
implements IWorkflow,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Workflow.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Workflow";
    String typeName;
    @Attribute
    SortedSet<String> workflowActionChoices;
    @Attribute
    String workflowConfig;
    @Attribute
    String workflowCreatedBy;
    @Attribute
    @Date
    Long workflowDeletedAt;
    @Attribute
    String workflowRunExpiresIn;
    @Attribute
    WorkflowStatus workflowStatus;
    @Attribute
    String workflowTemplateGuid;
    @Attribute
    WorkflowType workflowType;
    @Attribute
    String workflowUpdatedBy;

    @Override
    public Workflow trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Workflow.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Workflow.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Workflow.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Workflow.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static Workflow refByGuid(String guid) {
        return Workflow.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static Workflow refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((WorkflowBuilder)((WorkflowBuilder)Workflow._internal().guid(guid)).semantic(semantic)).build();
    }

    public static Workflow refByQualifiedName(String qualifiedName) {
        return Workflow.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static Workflow refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((WorkflowBuilder)((WorkflowBuilder)Workflow._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static Workflow get(AtlanClient client, String id) throws AtlanException {
        return Workflow.get(client, id, false);
    }

    @JsonIgnore
    public static Workflow get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Workflow) {
                return (Workflow)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof Workflow) {
            return (Workflow)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static Workflow get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return Workflow.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static Workflow get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Workflow.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof Workflow) {
                return (Workflow)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Workflow.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof Workflow) {
            return (Workflow)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static WorkflowBuilder<?, ?> updater(String qualifiedName, String name) {
        return (WorkflowBuilder)((WorkflowBuilder)((WorkflowBuilder)Workflow._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public WorkflowBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        Workflow.validateRequired(TYPE_NAME, map);
        return Workflow.updater(this.getQualifiedName(), this.getName());
    }

    public static Workflow removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Workflow)Asset.removeDescription(client, Workflow.updater(qualifiedName, name));
    }

    public static Workflow removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Workflow)Asset.removeUserDescription(client, Workflow.updater(qualifiedName, name));
    }

    public static Workflow removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Workflow)Asset.removeOwners(client, Workflow.updater(qualifiedName, name));
    }

    public static Workflow updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Workflow)Asset.updateCertificate(client, Workflow._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Workflow removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Workflow)Asset.removeCertificate(client, Workflow.updater(qualifiedName, name));
    }

    public static Workflow updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Workflow)Asset.updateAnnouncement(client, Workflow._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Workflow removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Workflow)Asset.removeAnnouncement(client, Workflow.updater(qualifiedName, name));
    }

    public static Workflow replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Workflow)Asset.replaceTerms(client, Workflow.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static Workflow appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Workflow)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static Workflow removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Workflow)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static Workflow appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Workflow)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static Workflow appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Workflow)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Workflow(WorkflowBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Workflow.$default$typeName();
        SortedSet<String> workflowActionChoices = new TreeSet<String>();
        if (b.workflowActionChoices != null) {
            workflowActionChoices.addAll(b.workflowActionChoices);
        }
        workflowActionChoices = Collections.unmodifiableSortedSet(workflowActionChoices);
        this.workflowActionChoices = workflowActionChoices;
        this.workflowConfig = b.workflowConfig;
        this.workflowCreatedBy = b.workflowCreatedBy;
        this.workflowDeletedAt = b.workflowDeletedAt;
        this.workflowRunExpiresIn = b.workflowRunExpiresIn;
        this.workflowStatus = b.workflowStatus;
        this.workflowTemplateGuid = b.workflowTemplateGuid;
        this.workflowType = b.workflowType;
        this.workflowUpdatedBy = b.workflowUpdatedBy;
    }

    @Generated
    public static WorkflowBuilder<?, ?> _internal() {
        return new WorkflowBuilderImpl();
    }

    @Generated
    public WorkflowBuilder<?, ?> toBuilder() {
        return new WorkflowBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<String> getWorkflowActionChoices() {
        return this.workflowActionChoices;
    }

    @Override
    @Generated
    public String getWorkflowConfig() {
        return this.workflowConfig;
    }

    @Override
    @Generated
    public String getWorkflowCreatedBy() {
        return this.workflowCreatedBy;
    }

    @Override
    @Generated
    public Long getWorkflowDeletedAt() {
        return this.workflowDeletedAt;
    }

    @Override
    @Generated
    public String getWorkflowRunExpiresIn() {
        return this.workflowRunExpiresIn;
    }

    @Override
    @Generated
    public WorkflowStatus getWorkflowStatus() {
        return this.workflowStatus;
    }

    @Override
    @Generated
    public String getWorkflowTemplateGuid() {
        return this.workflowTemplateGuid;
    }

    @Override
    @Generated
    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    @Override
    @Generated
    public String getWorkflowUpdatedBy() {
        return this.workflowUpdatedBy;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Workflow)) {
            return false;
        }
        Workflow other = (Workflow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$workflowDeletedAt = this.getWorkflowDeletedAt();
        Long other$workflowDeletedAt = other.getWorkflowDeletedAt();
        if (this$workflowDeletedAt == null ? other$workflowDeletedAt != null : !((Object)this$workflowDeletedAt).equals(other$workflowDeletedAt)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<String> this$workflowActionChoices = this.getWorkflowActionChoices();
        SortedSet<String> other$workflowActionChoices = other.getWorkflowActionChoices();
        if (this$workflowActionChoices == null ? other$workflowActionChoices != null : !this$workflowActionChoices.equals(other$workflowActionChoices)) {
            return false;
        }
        String this$workflowConfig = this.getWorkflowConfig();
        String other$workflowConfig = other.getWorkflowConfig();
        if (this$workflowConfig == null ? other$workflowConfig != null : !this$workflowConfig.equals(other$workflowConfig)) {
            return false;
        }
        String this$workflowCreatedBy = this.getWorkflowCreatedBy();
        String other$workflowCreatedBy = other.getWorkflowCreatedBy();
        if (this$workflowCreatedBy == null ? other$workflowCreatedBy != null : !this$workflowCreatedBy.equals(other$workflowCreatedBy)) {
            return false;
        }
        String this$workflowRunExpiresIn = this.getWorkflowRunExpiresIn();
        String other$workflowRunExpiresIn = other.getWorkflowRunExpiresIn();
        if (this$workflowRunExpiresIn == null ? other$workflowRunExpiresIn != null : !this$workflowRunExpiresIn.equals(other$workflowRunExpiresIn)) {
            return false;
        }
        WorkflowStatus this$workflowStatus = this.getWorkflowStatus();
        WorkflowStatus other$workflowStatus = other.getWorkflowStatus();
        if (this$workflowStatus == null ? other$workflowStatus != null : !this$workflowStatus.equals(other$workflowStatus)) {
            return false;
        }
        String this$workflowTemplateGuid = this.getWorkflowTemplateGuid();
        String other$workflowTemplateGuid = other.getWorkflowTemplateGuid();
        if (this$workflowTemplateGuid == null ? other$workflowTemplateGuid != null : !this$workflowTemplateGuid.equals(other$workflowTemplateGuid)) {
            return false;
        }
        WorkflowType this$workflowType = this.getWorkflowType();
        WorkflowType other$workflowType = other.getWorkflowType();
        if (this$workflowType == null ? other$workflowType != null : !this$workflowType.equals(other$workflowType)) {
            return false;
        }
        String this$workflowUpdatedBy = this.getWorkflowUpdatedBy();
        String other$workflowUpdatedBy = other.getWorkflowUpdatedBy();
        return !(this$workflowUpdatedBy == null ? other$workflowUpdatedBy != null : !this$workflowUpdatedBy.equals(other$workflowUpdatedBy));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Workflow;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $workflowDeletedAt = this.getWorkflowDeletedAt();
        result = result * 59 + ($workflowDeletedAt == null ? 43 : ((Object)$workflowDeletedAt).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<String> $workflowActionChoices = this.getWorkflowActionChoices();
        result = result * 59 + ($workflowActionChoices == null ? 43 : $workflowActionChoices.hashCode());
        String $workflowConfig = this.getWorkflowConfig();
        result = result * 59 + ($workflowConfig == null ? 43 : $workflowConfig.hashCode());
        String $workflowCreatedBy = this.getWorkflowCreatedBy();
        result = result * 59 + ($workflowCreatedBy == null ? 43 : $workflowCreatedBy.hashCode());
        String $workflowRunExpiresIn = this.getWorkflowRunExpiresIn();
        result = result * 59 + ($workflowRunExpiresIn == null ? 43 : $workflowRunExpiresIn.hashCode());
        WorkflowStatus $workflowStatus = this.getWorkflowStatus();
        result = result * 59 + ($workflowStatus == null ? 43 : $workflowStatus.hashCode());
        String $workflowTemplateGuid = this.getWorkflowTemplateGuid();
        result = result * 59 + ($workflowTemplateGuid == null ? 43 : $workflowTemplateGuid.hashCode());
        WorkflowType $workflowType = this.getWorkflowType();
        result = result * 59 + ($workflowType == null ? 43 : $workflowType.hashCode());
        String $workflowUpdatedBy = this.getWorkflowUpdatedBy();
        result = result * 59 + ($workflowUpdatedBy == null ? 43 : $workflowUpdatedBy.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Workflow(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", workflowActionChoices=" + String.valueOf(this.getWorkflowActionChoices()) + ", workflowConfig=" + this.getWorkflowConfig() + ", workflowCreatedBy=" + this.getWorkflowCreatedBy() + ", workflowDeletedAt=" + this.getWorkflowDeletedAt() + ", workflowRunExpiresIn=" + this.getWorkflowRunExpiresIn() + ", workflowStatus=" + String.valueOf(this.getWorkflowStatus()) + ", workflowTemplateGuid=" + this.getWorkflowTemplateGuid() + ", workflowType=" + String.valueOf(this.getWorkflowType()) + ", workflowUpdatedBy=" + this.getWorkflowUpdatedBy() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class WorkflowBuilder<C extends Workflow, B extends WorkflowBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<String> workflowActionChoices;
        @Generated
        private String workflowConfig;
        @Generated
        private String workflowCreatedBy;
        @Generated
        private Long workflowDeletedAt;
        @Generated
        private String workflowRunExpiresIn;
        @Generated
        private WorkflowStatus workflowStatus;
        @Generated
        private String workflowTemplateGuid;
        @Generated
        private WorkflowType workflowType;
        @Generated
        private String workflowUpdatedBy;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            WorkflowBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Workflow instance, WorkflowBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workflowActionChoices(instance.workflowActionChoices == null ? Collections.emptySortedSet() : instance.workflowActionChoices);
            b.workflowConfig(instance.workflowConfig);
            b.workflowCreatedBy(instance.workflowCreatedBy);
            b.workflowDeletedAt(instance.workflowDeletedAt);
            b.workflowRunExpiresIn(instance.workflowRunExpiresIn);
            b.workflowStatus(instance.workflowStatus);
            b.workflowTemplateGuid(instance.workflowTemplateGuid);
            b.workflowType(instance.workflowType);
            b.workflowUpdatedBy(instance.workflowUpdatedBy);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B workflowActionChoice(String workflowActionChoice) {
            if (this.workflowActionChoices == null) {
                this.workflowActionChoices = new ArrayList();
            }
            this.workflowActionChoices.add(workflowActionChoice);
            return (B)this.self();
        }

        @Generated
        public B workflowActionChoices(Collection<? extends String> workflowActionChoices) {
            if (workflowActionChoices == null) {
                throw new NullPointerException("workflowActionChoices cannot be null");
            }
            if (this.workflowActionChoices == null) {
                this.workflowActionChoices = new ArrayList();
            }
            this.workflowActionChoices.addAll(workflowActionChoices);
            return (B)this.self();
        }

        @Generated
        public B clearWorkflowActionChoices() {
            if (this.workflowActionChoices != null) {
                this.workflowActionChoices.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B workflowConfig(String workflowConfig) {
            this.workflowConfig = workflowConfig;
            return (B)this.self();
        }

        @Generated
        public B workflowCreatedBy(String workflowCreatedBy) {
            this.workflowCreatedBy = workflowCreatedBy;
            return (B)this.self();
        }

        @Generated
        public B workflowDeletedAt(Long workflowDeletedAt) {
            this.workflowDeletedAt = workflowDeletedAt;
            return (B)this.self();
        }

        @Generated
        public B workflowRunExpiresIn(String workflowRunExpiresIn) {
            this.workflowRunExpiresIn = workflowRunExpiresIn;
            return (B)this.self();
        }

        @Generated
        public B workflowStatus(WorkflowStatus workflowStatus) {
            this.workflowStatus = workflowStatus;
            return (B)this.self();
        }

        @Generated
        public B workflowTemplateGuid(String workflowTemplateGuid) {
            this.workflowTemplateGuid = workflowTemplateGuid;
            return (B)this.self();
        }

        @Generated
        public B workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return (B)this.self();
        }

        @Generated
        public B workflowUpdatedBy(String workflowUpdatedBy) {
            this.workflowUpdatedBy = workflowUpdatedBy;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Workflow.WorkflowBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workflowActionChoices=" + String.valueOf(this.workflowActionChoices) + ", workflowConfig=" + this.workflowConfig + ", workflowCreatedBy=" + this.workflowCreatedBy + ", workflowDeletedAt=" + this.workflowDeletedAt + ", workflowRunExpiresIn=" + this.workflowRunExpiresIn + ", workflowStatus=" + String.valueOf(this.workflowStatus) + ", workflowTemplateGuid=" + this.workflowTemplateGuid + ", workflowType=" + String.valueOf(this.workflowType) + ", workflowUpdatedBy=" + this.workflowUpdatedBy + ")";
        }
    }

    @Generated
    private static final class WorkflowBuilderImpl
    extends WorkflowBuilder<Workflow, WorkflowBuilderImpl> {
        @Generated
        private WorkflowBuilderImpl() {
        }

        @Override
        @Generated
        protected WorkflowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Workflow build() {
            return new Workflow(this);
        }
    }
}

