/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.Credential;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class TableauCrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.TABLEAU.getValue();

    public static TableauCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return TableauCrawler.creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null);
    }

    public static TableauCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers) throws AtlanException {
        return ((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)TableauCrawler._internal().setup(PREFIX, "@atlan/tableau", client, TableauCrawler.getConnection(client, connectionName, AtlanConnectorType.TABLEAU, adminRoles, adminGroups, adminUsers, false, false, 0L, "https://img.icons8.com/color/480/000000/tableau-software.png"))).include(null)).exclude((List<String>)null)).crawlHiddenFields(true)).crawlUnpublished(true);
    }

    @Generated
    protected TableauCrawler(TableauCrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static TableauCrawlerBuilder<?, ?> _internal() {
        return new TableauCrawlerBuilderImpl();
    }

    @Generated
    public TableauCrawlerBuilder<?, ?> toBuilder() {
        return new TableauCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauCrawler)) {
            return false;
        }
        TableauCrawler other = (TableauCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TableauCrawler(super=" + super.toString() + ")";
    }

    public static abstract class TableauCrawlerBuilder<C extends TableauCrawler, B extends TableauCrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B direct(String hostname, String site, boolean sslEnabled) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.name("default-tableau-" + this.epoch + "-0")).host(hostname)).port(443)).extra("protocol", sslEnabled ? "https" : "http")).extra("defaultSite", site)).connectorConfigName("atlan-connectors-tableau");
            return (B)((TableauCrawlerBuilder)((TableauCrawlerBuilder)this._parameter("extraction-method", "direct"))._credential(this.localCreds));
        }

        public B basicAuth(String username, String password) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("basic")).username(username)).password(password);
            return (B)((TableauCrawlerBuilder)this._credential(this.localCreds));
        }

        public B personalAccessToken(String username, String accessToken) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("personal_access_token")).username(username)).password(accessToken);
            return (B)((TableauCrawlerBuilder)this._credential(this.localCreds));
        }

        public B include(List<String> projects) throws InvalidRequestException {
            Map<String, Map<String, String>> toIncludeProjects = AbstractCrawler.buildFlatFilter(projects);
            try {
                return (B)((TableauCrawlerBuilder)this._parameter("include-filter", Serde.allInclusiveMapper.writeValueAsString(toIncludeProjects)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(List<String> projects) throws InvalidRequestException {
            Map<String, Map<String, String>> toExcludeProjects = AbstractCrawler.buildFlatFilter(projects);
            try {
                return (B)((TableauCrawlerBuilder)this._parameter("exclude-filter", Serde.allInclusiveMapper.writeValueAsString(toExcludeProjects)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(String regex) {
            return (B)((TableauCrawlerBuilder)this._parameter("exclude-projects-regex", regex));
        }

        public B crawlHiddenFields(boolean enabled) {
            return (B)((TableauCrawlerBuilder)this._parameter("crawl-hidden-datasource-fields", "" + enabled));
        }

        public B crawlUnpublished(boolean enabled) {
            return (B)((TableauCrawlerBuilder)this._parameter("crawl-unpublished-worksheets-dashboards", "" + enabled));
        }

        public B alternateHost(String hostname) {
            return (B)((TableauCrawlerBuilder)this._parameter("tableau-alternate-host", hostname));
        }

        @Override
        protected B metadata() {
            return (B)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)((TableauCrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "tableau"))._label("orchestration.atlan.com/sourceCategory", "bi"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-htableau"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-tableau-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/categories", "tableau,crawler"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6332449996689"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://img.icons8.com/color/480/000000/tableau-software.png"))._annotation("orchestration.atlan.com/logo", "https://img.icons8.com/color/480/000000/tableau-software.png"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/tableau"))._annotation("orchestration.atlan.com/name", "Tableau Assets"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Package to crawl Tableau assets and publish to Atlan for discovery"))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/tableau"))._annotation("package.argoproj.io/keywords", "[\"tableau\",\"bi\",\"connector\",\"crawler\"]"))._annotation("package.argoproj.io/name", "@atlan/tableau"))._annotation("package.argoproj.io/parent", "."))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-tableau-" + this.epoch))._parameters(Map.ofEntries(Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("connection", this.connection.toJson(this.client)), Map.entry("atlas-auth-type", "internal"), Map.entry("publish-mode", "production"))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauCrawler instance, TableauCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TableauCrawler.TableauCrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class TableauCrawlerBuilderImpl
    extends TableauCrawlerBuilder<TableauCrawler, TableauCrawlerBuilderImpl> {
        @Generated
        private TableauCrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauCrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauCrawler build() {
            return new TableauCrawler(this);
        }
    }
}

