/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.relations;

import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.relations.RelationshipAttributes;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.AuditDetail;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(builder=ReferenceBuilderImpl.class)
public class Reference
extends AtlanObject
implements Comparable<Reference>,
AuditDetail {
    private static final long serialVersionUID = 2L;
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<UniqueAttributes> uniqueAttrsComparator = Comparator.comparing(UniqueAttributes::getQualifiedName, stringComparator).thenComparing(UniqueAttributes::getAwsArn, stringComparator);
    private static final Comparator<Reference> referenceComparator = Comparator.comparing(Reference::getRelationshipGuid, stringComparator).thenComparing(Reference::getGuid, stringComparator).thenComparing(Reference::getUniqueAttributes, Comparator.nullsFirst(uniqueAttrsComparator));
    @JsonIgnore
    transient SaveSemantic semantic;
    @JsonIgnore
    transient boolean completeObject;
    String typeName;
    String guid;
    String displayText;
    String entityStatus;
    String relationshipType;
    String relationshipGuid;
    AtlanStatus relationshipStatus;
    RelationshipAttributes relationshipAttributes;
    UniqueAttributes uniqueAttributes;
    List<String> labels;
    Map<String, String> customAttributes;

    public static Reference to(String typeName, String guid) {
        return ((ReferenceBuilder)((ReferenceBuilder)Reference.builder().typeName(typeName)).guid(guid)).build();
    }

    public static Reference by(String typeName, String qualifiedName) {
        return ((ReferenceBuilder)((ReferenceBuilder)Reference.builder().typeName(typeName)).uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    protected static void validateRequired(String typeName, Map<String, String> parameters) throws InvalidRequestException {
        Reference.validate(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, typeName, parameters);
    }

    protected static void validateRelationship(String typeName, Map<String, String> parameters) throws InvalidRequestException {
        Reference.validate(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, typeName, parameters);
    }

    private static void validate(ErrorCode code, String typeName, Map<String, String> parameters) throws InvalidRequestException {
        if (parameters != null && !parameters.isEmpty()) {
            ArrayList<String> missing = new ArrayList<String>();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (entry.getValue() != null && !entry.getValue().isEmpty()) continue;
                missing.add(entry.getKey());
            }
            if (!missing.isEmpty()) {
                throw new InvalidRequestException(code, typeName, String.join((CharSequence)",", missing));
            }
        }
    }

    @JsonIgnore
    public boolean isComplete() {
        return this.completeObject;
    }

    @JsonIgnore
    protected void setCompleteObject() {
        this.completeObject = true;
    }

    @JsonIgnore
    public boolean isValidReferenceByGuid() {
        return this.getTypeName() != null && !this.getTypeName().isEmpty() && this.getGuid() != null && !this.getGuid().isEmpty();
    }

    @JsonIgnore
    public boolean isValidReferenceByQualifiedName() {
        return this.getTypeName() != null && !this.getTypeName().isEmpty() && this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty();
    }

    @JsonIgnore
    public boolean isValidReference() {
        return this.isValidReferenceByGuid() || this.isValidReferenceByQualifiedName();
    }

    @Override
    public int compareTo(Reference o) {
        if (o == null) {
            return -1;
        }
        return referenceComparator.compare(this, o);
    }

    @Generated
    private static SaveSemantic $default$semantic() {
        return SaveSemantic.REPLACE;
    }

    @Generated
    private static boolean $default$completeObject() {
        return false;
    }

    @Generated
    protected Reference(ReferenceBuilder<?, ?> b) {
        super(b);
        Map<Object, Object> customAttributes;
        this.semantic = b.semantic$set ? b.semantic$value : Reference.$default$semantic();
        this.completeObject = b.completeObject$set ? b.completeObject$value : Reference.$default$completeObject();
        this.typeName = b.typeName;
        this.guid = b.guid;
        this.displayText = b.displayText;
        this.entityStatus = b.entityStatus;
        this.relationshipType = b.relationshipType;
        this.relationshipGuid = b.relationshipGuid;
        this.relationshipStatus = b.relationshipStatus;
        this.relationshipAttributes = b.relationshipAttributes;
        this.uniqueAttributes = b.uniqueAttributes;
        this.labels = switch (b.labels == null ? 0 : b.labels.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.labels.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.labels));
        };
        switch (b.customAttributes$key == null ? 0 : b.customAttributes$key.size()) {
            case 0: {
                customAttributes = Collections.emptyMap();
                break;
            }
            case 1: {
                customAttributes = Collections.singletonMap(b.customAttributes$key.get(0), b.customAttributes$value.get(0));
                break;
            }
            default: {
                customAttributes = new LinkedHashMap(b.customAttributes$key.size() < 0x40000000 ? 1 + b.customAttributes$key.size() + (b.customAttributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.customAttributes$key.size(); ++$i) {
                    customAttributes.put(b.customAttributes$key.get($i), b.customAttributes$value.get($i));
                }
                customAttributes = Collections.unmodifiableMap(customAttributes);
            }
        }
        this.customAttributes = customAttributes;
    }

    @Generated
    public static ReferenceBuilder<?, ?> builder() {
        return new ReferenceBuilderImpl();
    }

    @Generated
    public ReferenceBuilder<?, ?> toBuilder() {
        return new ReferenceBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public SaveSemantic getSemantic() {
        return this.semantic;
    }

    @Generated
    public boolean getCompleteObject() {
        return this.completeObject;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getGuid() {
        return this.guid;
    }

    @Generated
    public String getDisplayText() {
        return this.displayText;
    }

    @Generated
    public String getEntityStatus() {
        return this.entityStatus;
    }

    @Generated
    public String getRelationshipType() {
        return this.relationshipType;
    }

    @Generated
    public String getRelationshipGuid() {
        return this.relationshipGuid;
    }

    @Generated
    public AtlanStatus getRelationshipStatus() {
        return this.relationshipStatus;
    }

    @Generated
    public RelationshipAttributes getRelationshipAttributes() {
        return this.relationshipAttributes;
    }

    @Generated
    public UniqueAttributes getUniqueAttributes() {
        return this.uniqueAttributes;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$guid = this.getGuid();
        String other$guid = other.getGuid();
        if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) {
            return false;
        }
        String this$displayText = this.getDisplayText();
        String other$displayText = other.getDisplayText();
        if (this$displayText == null ? other$displayText != null : !this$displayText.equals(other$displayText)) {
            return false;
        }
        String this$entityStatus = this.getEntityStatus();
        String other$entityStatus = other.getEntityStatus();
        if (this$entityStatus == null ? other$entityStatus != null : !this$entityStatus.equals(other$entityStatus)) {
            return false;
        }
        String this$relationshipType = this.getRelationshipType();
        String other$relationshipType = other.getRelationshipType();
        if (this$relationshipType == null ? other$relationshipType != null : !this$relationshipType.equals(other$relationshipType)) {
            return false;
        }
        String this$relationshipGuid = this.getRelationshipGuid();
        String other$relationshipGuid = other.getRelationshipGuid();
        if (this$relationshipGuid == null ? other$relationshipGuid != null : !this$relationshipGuid.equals(other$relationshipGuid)) {
            return false;
        }
        AtlanStatus this$relationshipStatus = this.getRelationshipStatus();
        AtlanStatus other$relationshipStatus = other.getRelationshipStatus();
        if (this$relationshipStatus == null ? other$relationshipStatus != null : !this$relationshipStatus.equals(other$relationshipStatus)) {
            return false;
        }
        RelationshipAttributes this$relationshipAttributes = this.getRelationshipAttributes();
        RelationshipAttributes other$relationshipAttributes = other.getRelationshipAttributes();
        if (this$relationshipAttributes == null ? other$relationshipAttributes != null : !((Object)this$relationshipAttributes).equals(other$relationshipAttributes)) {
            return false;
        }
        UniqueAttributes this$uniqueAttributes = this.getUniqueAttributes();
        UniqueAttributes other$uniqueAttributes = other.getUniqueAttributes();
        if (this$uniqueAttributes == null ? other$uniqueAttributes != null : !((Object)this$uniqueAttributes).equals(other$uniqueAttributes)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Map<String, String> this$customAttributes = this.getCustomAttributes();
        Map<String, String> other$customAttributes = other.getCustomAttributes();
        return !(this$customAttributes == null ? other$customAttributes != null : !((Object)this$customAttributes).equals(other$customAttributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Reference;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $guid = this.getGuid();
        result = result * 59 + ($guid == null ? 43 : $guid.hashCode());
        String $displayText = this.getDisplayText();
        result = result * 59 + ($displayText == null ? 43 : $displayText.hashCode());
        String $entityStatus = this.getEntityStatus();
        result = result * 59 + ($entityStatus == null ? 43 : $entityStatus.hashCode());
        String $relationshipType = this.getRelationshipType();
        result = result * 59 + ($relationshipType == null ? 43 : $relationshipType.hashCode());
        String $relationshipGuid = this.getRelationshipGuid();
        result = result * 59 + ($relationshipGuid == null ? 43 : $relationshipGuid.hashCode());
        AtlanStatus $relationshipStatus = this.getRelationshipStatus();
        result = result * 59 + ($relationshipStatus == null ? 43 : $relationshipStatus.hashCode());
        RelationshipAttributes $relationshipAttributes = this.getRelationshipAttributes();
        result = result * 59 + ($relationshipAttributes == null ? 43 : ((Object)$relationshipAttributes).hashCode());
        UniqueAttributes $uniqueAttributes = this.getUniqueAttributes();
        result = result * 59 + ($uniqueAttributes == null ? 43 : ((Object)$uniqueAttributes).hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Map<String, String> $customAttributes = this.getCustomAttributes();
        result = result * 59 + ($customAttributes == null ? 43 : ((Object)$customAttributes).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Reference(super=" + super.toString() + ", semantic=" + String.valueOf((Object)this.getSemantic()) + ", completeObject=" + this.getCompleteObject() + ", typeName=" + this.getTypeName() + ", guid=" + this.getGuid() + ", displayText=" + this.getDisplayText() + ", entityStatus=" + this.getEntityStatus() + ", relationshipType=" + this.getRelationshipType() + ", relationshipGuid=" + this.getRelationshipGuid() + ", relationshipStatus=" + String.valueOf(this.getRelationshipStatus()) + ", relationshipAttributes=" + String.valueOf(this.getRelationshipAttributes()) + ", uniqueAttributes=" + String.valueOf(this.getUniqueAttributes()) + ", labels=" + String.valueOf(this.getLabels()) + ", customAttributes=" + String.valueOf(this.getCustomAttributes()) + ")";
    }

    public static abstract class ReferenceBuilder<C extends Reference, B extends ReferenceBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private boolean semantic$set;
        @Generated
        private SaveSemantic semantic$value;
        @Generated
        private boolean completeObject$set;
        @Generated
        private boolean completeObject$value;
        @Generated
        private String typeName;
        @Generated
        private String guid;
        @Generated
        private String displayText;
        @Generated
        private String entityStatus;
        @Generated
        private String relationshipType;
        @Generated
        private String relationshipGuid;
        @Generated
        private AtlanStatus relationshipStatus;
        @Generated
        private RelationshipAttributes relationshipAttributes;
        @Generated
        private UniqueAttributes uniqueAttributes;
        @Generated
        private ArrayList<String> labels;
        @Generated
        private ArrayList<String> customAttributes$key;
        @Generated
        private ArrayList<String> customAttributes$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReferenceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Reference instance, ReferenceBuilder<?, ?> b) {
            b.semantic(instance.semantic);
            b.completeObject(instance.completeObject);
            b.typeName(instance.typeName);
            b.guid(instance.guid);
            b.displayText(instance.displayText);
            b.entityStatus(instance.entityStatus);
            b.relationshipType(instance.relationshipType);
            b.relationshipGuid(instance.relationshipGuid);
            b.relationshipStatus(instance.relationshipStatus);
            b.relationshipAttributes(instance.relationshipAttributes);
            b.uniqueAttributes(instance.uniqueAttributes);
            b.labels(instance.labels == null ? Collections.emptyList() : instance.labels);
            b.customAttributes(instance.customAttributes == null ? Collections.emptyMap() : instance.customAttributes);
        }

        @JsonIgnore
        @Generated
        public B semantic(SaveSemantic semantic) {
            this.semantic$value = semantic;
            this.semantic$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B completeObject(boolean completeObject) {
            this.completeObject$value = completeObject;
            this.completeObject$set = true;
            return (B)this.self();
        }

        @Generated
        public B typeName(String typeName) {
            this.typeName = typeName;
            return (B)this.self();
        }

        @Generated
        public B guid(String guid) {
            this.guid = guid;
            return (B)this.self();
        }

        @Generated
        public B displayText(String displayText) {
            this.displayText = displayText;
            return (B)this.self();
        }

        @Generated
        public B entityStatus(String entityStatus) {
            this.entityStatus = entityStatus;
            return (B)this.self();
        }

        @Generated
        public B relationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
            return (B)this.self();
        }

        @Generated
        public B relationshipGuid(String relationshipGuid) {
            this.relationshipGuid = relationshipGuid;
            return (B)this.self();
        }

        @Generated
        public B relationshipStatus(AtlanStatus relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
            return (B)this.self();
        }

        @Generated
        public B relationshipAttributes(RelationshipAttributes relationshipAttributes) {
            this.relationshipAttributes = relationshipAttributes;
            return (B)this.self();
        }

        @Generated
        public B uniqueAttributes(UniqueAttributes uniqueAttributes) {
            this.uniqueAttributes = uniqueAttributes;
            return (B)this.self();
        }

        @Generated
        public B label(String label) {
            if (this.labels == null) {
                this.labels = new ArrayList();
            }
            this.labels.add(label);
            return (B)this.self();
        }

        @Generated
        public B labels(Collection<? extends String> labels) {
            if (labels == null) {
                throw new NullPointerException("labels cannot be null");
            }
            if (this.labels == null) {
                this.labels = new ArrayList();
            }
            this.labels.addAll(labels);
            return (B)this.self();
        }

        @Generated
        public B clearLabels() {
            if (this.labels != null) {
                this.labels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B customAttribute(String customAttributeKey, String customAttributeValue) {
            if (this.customAttributes$key == null) {
                this.customAttributes$key = new ArrayList();
                this.customAttributes$value = new ArrayList();
            }
            this.customAttributes$key.add(customAttributeKey);
            this.customAttributes$value.add(customAttributeValue);
            return (B)this.self();
        }

        @Generated
        public B customAttributes(Map<? extends String, ? extends String> customAttributes) {
            if (customAttributes == null) {
                throw new NullPointerException("customAttributes cannot be null");
            }
            if (this.customAttributes$key == null) {
                this.customAttributes$key = new ArrayList();
                this.customAttributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : customAttributes.entrySet()) {
                this.customAttributes$key.add($lombokEntry.getKey());
                this.customAttributes$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCustomAttributes() {
            if (this.customAttributes$key != null) {
                this.customAttributes$key.clear();
                this.customAttributes$value.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Reference.ReferenceBuilder(super=" + super.toString() + ", semantic$value=" + String.valueOf((Object)this.semantic$value) + ", completeObject$value=" + this.completeObject$value + ", typeName=" + this.typeName + ", guid=" + this.guid + ", displayText=" + this.displayText + ", entityStatus=" + this.entityStatus + ", relationshipType=" + this.relationshipType + ", relationshipGuid=" + this.relationshipGuid + ", relationshipStatus=" + String.valueOf(this.relationshipStatus) + ", relationshipAttributes=" + String.valueOf(this.relationshipAttributes) + ", uniqueAttributes=" + String.valueOf(this.uniqueAttributes) + ", labels=" + String.valueOf(this.labels) + ", customAttributes$key=" + String.valueOf(this.customAttributes$key) + ", customAttributes$value=" + String.valueOf(this.customAttributes$value) + ")";
        }
    }

    public static enum SaveSemantic {
        REPLACE,
        APPEND,
        REMOVE;

    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class ReferenceBuilderImpl
    extends ReferenceBuilder<Reference, ReferenceBuilderImpl> {
        @Generated
        private ReferenceBuilderImpl() {
        }

        @Override
        @Generated
        protected ReferenceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Reference build() {
            return new Reference(this);
        }
    }
}

