/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.typedefs;

import com.atlan.AtlanClient;
import com.atlan.exception.ApiException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.AtlanImage;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanIcon;
import com.atlan.model.enums.AtlanTagColor;
import com.atlan.model.enums.TagIconType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import lombok.Generated;

@JsonDeserialize(builder=AtlanTagOptionsBuilderImpl.class)
public class AtlanTagOptions
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    String color;
    AtlanIcon iconName;
    TagIconType iconType;
    String emoji;
    String imageID;
    Boolean createdFromAtlan;
    Boolean hasTag;

    public static AtlanTagOptions of(AtlanTagColor color) {
        return AtlanTagOptions.of(color, false);
    }

    public static AtlanTagOptions of(AtlanTagColor color, boolean sourceSynced) {
        return AtlanTagOptions.withIcon(AtlanIcon.ATLAN_TAG, color, sourceSynced);
    }

    public static AtlanTagOptions withIcon(AtlanIcon icon, AtlanTagColor color) {
        return AtlanTagOptions.withIcon(icon, color, false);
    }

    public static AtlanTagOptions withIcon(AtlanIcon icon, AtlanTagColor color, boolean sourceSynced) {
        return ((AtlanTagOptionsBuilder)((AtlanTagOptionsBuilder)((AtlanTagOptionsBuilder)((AtlanTagOptionsBuilder)((AtlanTagOptionsBuilder)AtlanTagOptions.builder().color(color.getValue())).iconName(icon)).iconType(TagIconType.ICON)).imageID("")).hasTag(sourceSynced)).build();
    }

    public static AtlanTagOptions withImage(AtlanClient client, String url) throws AtlanException {
        return AtlanTagOptions.withImage(client, url, false);
    }

    public static AtlanTagOptions withImage(AtlanClient client, String url, boolean sourceSynced) throws AtlanException {
        try {
            AtlanImage result = client.images.upload(url);
            return ((AtlanTagOptionsBuilder)((AtlanTagOptionsBuilder)((AtlanTagOptionsBuilder)((AtlanTagOptionsBuilder)((AtlanTagOptionsBuilder)AtlanTagOptions.builder().iconType(TagIconType.IMAGE)).imageID(result.getId())).color(AtlanTagColor.GRAY.getValue())).iconName(AtlanIcon.ATLAN_TAG)).hasTag(sourceSynced)).build();
        }
        catch (MalformedURLException e) {
            throw new InvalidRequestException(ErrorCode.INVALID_URL, (Throwable)e);
        }
        catch (IOException e) {
            throw new ApiException(ErrorCode.INACCESSIBLE_URL, (Throwable)e, new String[0]);
        }
    }

    public static AtlanTagOptions withEmoji(String emoji) {
        return AtlanTagOptions.withEmoji(emoji, false);
    }

    public static AtlanTagOptions withEmoji(String emoji, boolean sourceSynced) {
        return ((AtlanTagOptionsBuilder)((AtlanTagOptionsBuilder)((AtlanTagOptionsBuilder)((AtlanTagOptionsBuilder)((AtlanTagOptionsBuilder)AtlanTagOptions.builder().iconType(TagIconType.EMOJI)).emoji(emoji)).color(AtlanTagColor.GRAY.getValue())).iconName(AtlanIcon.ATLAN_TAG)).hasTag(sourceSynced)).build();
    }

    @Generated
    private static Boolean $default$createdFromAtlan() {
        return false;
    }

    @Generated
    protected AtlanTagOptions(AtlanTagOptionsBuilder<?, ?> b) {
        super(b);
        this.color = b.color;
        this.iconName = b.iconName;
        this.iconType = b.iconType;
        this.emoji = b.emoji;
        this.imageID = b.imageID;
        this.createdFromAtlan = b.createdFromAtlan$set ? b.createdFromAtlan$value : AtlanTagOptions.$default$createdFromAtlan();
        this.hasTag = b.hasTag;
    }

    @Generated
    public static AtlanTagOptionsBuilder<?, ?> builder() {
        return new AtlanTagOptionsBuilderImpl();
    }

    @Generated
    public AtlanTagOptionsBuilder<?, ?> toBuilder() {
        return new AtlanTagOptionsBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public AtlanIcon getIconName() {
        return this.iconName;
    }

    @Generated
    public TagIconType getIconType() {
        return this.iconType;
    }

    @Generated
    public String getEmoji() {
        return this.emoji;
    }

    @Generated
    public String getImageID() {
        return this.imageID;
    }

    @Generated
    public Boolean getCreatedFromAtlan() {
        return this.createdFromAtlan;
    }

    @Generated
    public Boolean getHasTag() {
        return this.hasTag;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanTagOptions)) {
            return false;
        }
        AtlanTagOptions other = (AtlanTagOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$createdFromAtlan = this.getCreatedFromAtlan();
        Boolean other$createdFromAtlan = other.getCreatedFromAtlan();
        if (this$createdFromAtlan == null ? other$createdFromAtlan != null : !((Object)this$createdFromAtlan).equals(other$createdFromAtlan)) {
            return false;
        }
        Boolean this$hasTag = this.getHasTag();
        Boolean other$hasTag = other.getHasTag();
        if (this$hasTag == null ? other$hasTag != null : !((Object)this$hasTag).equals(other$hasTag)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        AtlanIcon this$iconName = this.getIconName();
        AtlanIcon other$iconName = other.getIconName();
        if (this$iconName == null ? other$iconName != null : !this$iconName.equals(other$iconName)) {
            return false;
        }
        TagIconType this$iconType = this.getIconType();
        TagIconType other$iconType = other.getIconType();
        if (this$iconType == null ? other$iconType != null : !this$iconType.equals(other$iconType)) {
            return false;
        }
        String this$emoji = this.getEmoji();
        String other$emoji = other.getEmoji();
        if (this$emoji == null ? other$emoji != null : !this$emoji.equals(other$emoji)) {
            return false;
        }
        String this$imageID = this.getImageID();
        String other$imageID = other.getImageID();
        return !(this$imageID == null ? other$imageID != null : !this$imageID.equals(other$imageID));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanTagOptions;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $createdFromAtlan = this.getCreatedFromAtlan();
        result = result * 59 + ($createdFromAtlan == null ? 43 : ((Object)$createdFromAtlan).hashCode());
        Boolean $hasTag = this.getHasTag();
        result = result * 59 + ($hasTag == null ? 43 : ((Object)$hasTag).hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        AtlanIcon $iconName = this.getIconName();
        result = result * 59 + ($iconName == null ? 43 : $iconName.hashCode());
        TagIconType $iconType = this.getIconType();
        result = result * 59 + ($iconType == null ? 43 : $iconType.hashCode());
        String $emoji = this.getEmoji();
        result = result * 59 + ($emoji == null ? 43 : $emoji.hashCode());
        String $imageID = this.getImageID();
        result = result * 59 + ($imageID == null ? 43 : $imageID.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AtlanTagOptions(super=" + super.toString() + ", color=" + this.getColor() + ", iconName=" + String.valueOf(this.getIconName()) + ", iconType=" + String.valueOf(this.getIconType()) + ", emoji=" + this.getEmoji() + ", imageID=" + this.getImageID() + ", createdFromAtlan=" + this.getCreatedFromAtlan() + ", hasTag=" + this.getHasTag() + ")";
    }

    public static abstract class AtlanTagOptionsBuilder<C extends AtlanTagOptions, B extends AtlanTagOptionsBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private String color;
        @Generated
        private AtlanIcon iconName;
        @Generated
        private TagIconType iconType;
        @Generated
        private String emoji;
        @Generated
        private String imageID;
        @Generated
        private boolean createdFromAtlan$set;
        @Generated
        private Boolean createdFromAtlan$value;
        @Generated
        private Boolean hasTag;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AtlanTagOptionsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AtlanTagOptions instance, AtlanTagOptionsBuilder<?, ?> b) {
            b.color(instance.color);
            b.iconName(instance.iconName);
            b.iconType(instance.iconType);
            b.emoji(instance.emoji);
            b.imageID(instance.imageID);
            b.createdFromAtlan(instance.createdFromAtlan);
            b.hasTag(instance.hasTag);
        }

        @Generated
        public B color(String color) {
            this.color = color;
            return (B)this.self();
        }

        @Generated
        public B iconName(AtlanIcon iconName) {
            this.iconName = iconName;
            return (B)this.self();
        }

        @Generated
        public B iconType(TagIconType iconType) {
            this.iconType = iconType;
            return (B)this.self();
        }

        @Generated
        public B emoji(String emoji) {
            this.emoji = emoji;
            return (B)this.self();
        }

        @Generated
        public B imageID(String imageID) {
            this.imageID = imageID;
            return (B)this.self();
        }

        @Generated
        public B createdFromAtlan(Boolean createdFromAtlan) {
            this.createdFromAtlan$value = createdFromAtlan;
            this.createdFromAtlan$set = true;
            return (B)this.self();
        }

        @Generated
        public B hasTag(Boolean hasTag) {
            this.hasTag = hasTag;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AtlanTagOptions.AtlanTagOptionsBuilder(super=" + super.toString() + ", color=" + this.color + ", iconName=" + String.valueOf(this.iconName) + ", iconType=" + String.valueOf(this.iconType) + ", emoji=" + this.emoji + ", imageID=" + this.imageID + ", createdFromAtlan$value=" + this.createdFromAtlan$value + ", hasTag=" + this.hasTag + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class AtlanTagOptionsBuilderImpl
    extends AtlanTagOptionsBuilder<AtlanTagOptions, AtlanTagOptionsBuilderImpl> {
        @Generated
        private AtlanTagOptionsBuilderImpl() {
        }

        @Override
        @Generated
        protected AtlanTagOptionsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AtlanTagOptions build() {
            return new AtlanTagOptions(this);
        }
    }
}

