/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.workflow;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanWorkflowPhase;
import com.atlan.model.workflow.WorkflowRunResponse;
import com.atlan.model.workflow.WorkflowSearchRequest;
import com.atlan.model.workflow.WorkflowSearchResultDetail;
import com.atlan.model.workflow.WorkflowSearchResultStatus;
import java.util.List;
import lombok.Generated;

public class WorkflowSearchResult
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    String _index;
    String _type;
    String _id;
    Object _seq_no;
    Object _primary_term;
    List<Object> sort;
    WorkflowSearchResultDetail _source;

    public AtlanWorkflowPhase getStatus() {
        WorkflowSearchResultStatus status;
        if (this._source != null && (status = this._source.getStatus()) != null) {
            return status.getPhase();
        }
        return null;
    }

    public WorkflowRunResponse rerun(AtlanClient client) throws AtlanException {
        return this.rerun(client, false);
    }

    public WorkflowRunResponse rerun(AtlanClient client, boolean idempotent) throws AtlanException {
        if (this._source != null) {
            if (idempotent) {
                String name = this._source.getSpec().getWorkflowTemplateRef().get("name");
                try {
                    Thread.sleep(10000L);
                    WorkflowSearchResult running = WorkflowSearchRequest.findCurrentRun(client, name);
                    if (running != null) {
                        WorkflowRunResponse response = new WorkflowRunResponse();
                        response.client = client;
                        response.metadata = running._source.getMetadata();
                        response.spec = running._source.getSpec();
                        response.status = running._source.status;
                        return response;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return client.workflows.run(this._source);
        }
        return null;
    }

    @Generated
    public String get_index() {
        return this._index;
    }

    @Generated
    public String get_type() {
        return this._type;
    }

    @Generated
    public String get_id() {
        return this._id;
    }

    @Generated
    public Object get_seq_no() {
        return this._seq_no;
    }

    @Generated
    public Object get_primary_term() {
        return this._primary_term;
    }

    @Generated
    public List<Object> getSort() {
        return this.sort;
    }

    @Generated
    public WorkflowSearchResultDetail get_source() {
        return this._source;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowSearchResult)) {
            return false;
        }
        WorkflowSearchResult other = (WorkflowSearchResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$_index = this.get_index();
        String other$_index = other.get_index();
        if (this$_index == null ? other$_index != null : !this$_index.equals(other$_index)) {
            return false;
        }
        String this$_type = this.get_type();
        String other$_type = other.get_type();
        if (this$_type == null ? other$_type != null : !this$_type.equals(other$_type)) {
            return false;
        }
        String this$_id = this.get_id();
        String other$_id = other.get_id();
        if (this$_id == null ? other$_id != null : !this$_id.equals(other$_id)) {
            return false;
        }
        Object this$_seq_no = this.get_seq_no();
        Object other$_seq_no = other.get_seq_no();
        if (this$_seq_no == null ? other$_seq_no != null : !this$_seq_no.equals(other$_seq_no)) {
            return false;
        }
        Object this$_primary_term = this.get_primary_term();
        Object other$_primary_term = other.get_primary_term();
        if (this$_primary_term == null ? other$_primary_term != null : !this$_primary_term.equals(other$_primary_term)) {
            return false;
        }
        List<Object> this$sort = this.getSort();
        List<Object> other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        WorkflowSearchResultDetail this$_source = this.get_source();
        WorkflowSearchResultDetail other$_source = other.get_source();
        return !(this$_source == null ? other$_source != null : !((Object)this$_source).equals(other$_source));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowSearchResult;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $_index = this.get_index();
        result = result * 59 + ($_index == null ? 43 : $_index.hashCode());
        String $_type = this.get_type();
        result = result * 59 + ($_type == null ? 43 : $_type.hashCode());
        String $_id = this.get_id();
        result = result * 59 + ($_id == null ? 43 : $_id.hashCode());
        Object $_seq_no = this.get_seq_no();
        result = result * 59 + ($_seq_no == null ? 43 : $_seq_no.hashCode());
        Object $_primary_term = this.get_primary_term();
        result = result * 59 + ($_primary_term == null ? 43 : $_primary_term.hashCode());
        List<Object> $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        WorkflowSearchResultDetail $_source = this.get_source();
        result = result * 59 + ($_source == null ? 43 : ((Object)$_source).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "WorkflowSearchResult(super=" + super.toString() + ", _index=" + this.get_index() + ", _type=" + this.get_type() + ", _id=" + this.get_id() + ", _seq_no=" + String.valueOf(this.get_seq_no()) + ", _primary_term=" + String.valueOf(this.get_primary_term()) + ", sort=" + String.valueOf(this.getSort()) + ", _source=" + String.valueOf(this.get_source()) + ")";
    }
}

