/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.AtlanResponseInterface;
import com.atlan.model.enums.AtlanEnum;
import com.atlan.net.AtlanResponse;
import com.atlan.net.AtlanResponseGetter;
import com.atlan.net.KeyValuePair;
import com.atlan.net.LiveAtlanResponseGetter;
import com.atlan.net.RequestOptions;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class ApiResource
extends AtlanObject
implements AtlanResponseInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiResource.class);
    private static final long serialVersionUID = 2L;
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    static final AtlanResponseGetter atlanResponseGetter = new LiveAtlanResponseGetter();
    @JsonIgnore
    private transient AtlanResponse lastResponse;

    @Override
    @JsonIgnore
    public AtlanResponse getLastResponse() {
        return this.lastResponse;
    }

    @Override
    @JsonIgnore
    public void setLastResponse(AtlanResponse response) {
        this.lastResponse = response;
    }

    @Override
    @JsonIgnore
    public JsonNode getRawJsonObject() {
        if (this.rawJsonObject == null && this.getLastResponse() != null) {
            try {
                this.rawJsonObject = Serde.allInclusiveMapper.readTree((String)this.getLastResponse().body());
            }
            catch (JsonProcessingException e) {
                log.error("Unable to parse raw JSON tree \u2014 invalid JSON? {}", this.getLastResponse().body(), (Object)e);
            }
        }
        return this.rawJsonObject;
    }

    public static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET).replaceAll("%5B", "[").replaceAll("%5D", "]");
    }

    public static String urlEncodeId(String id) throws InvalidRequestException {
        if (id == null) {
            throw new InvalidRequestException(ErrorCode.NOTHING_TO_ENCODE);
        }
        return ApiResource.urlEncode(id);
    }

    public static String createQueryString(Map<String, Object> params) {
        if (params == null) {
            return "";
        }
        Collection flatParams = ApiResource.flattenParamsMap(params).stream().filter(kvp -> kvp.getValue() instanceof String).map(kvp -> new KeyValuePair<String, String>((String)kvp.getKey(), (String)kvp.getValue())).collect(Collectors.toList());
        return ApiResource.createQueryString(flatParams);
    }

    public static String createQueryString(Collection<KeyValuePair<String, String>> nameValueCollection) {
        if (nameValueCollection == null) {
            return "";
        }
        return nameValueCollection.stream().map(kvp -> String.format("%s=%s", ApiResource.urlEncode((String)kvp.getKey()), ApiResource.urlEncode((String)kvp.getValue()))).collect(Collectors.joining("&"));
    }

    private static List<KeyValuePair<String, Object>> flattenParamsValue(Object value, String keyPrefix) {
        List<KeyValuePair<String, Object>> flatParams = value == null ? ApiResource.singleParam(keyPrefix, "") : (value instanceof Map ? ApiResource.flattenParamsMap((Map)value) : (value instanceof String ? ApiResource.singleParam(keyPrefix, value) : (value instanceof Collection ? ApiResource.flattenParamsCollection((Collection)value, keyPrefix) : (value instanceof AtlanEnum ? ApiResource.singleParam(keyPrefix, ((AtlanEnum)value).getValue()) : ApiResource.singleParam(keyPrefix, value.toString())))));
        return flatParams;
    }

    private static List<KeyValuePair<String, Object>> flattenParamsMap(Map<?, ?> map) {
        ArrayList<KeyValuePair<String, Object>> flatParams = new ArrayList<KeyValuePair<String, Object>>();
        if (map == null) {
            return flatParams;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            flatParams.addAll(ApiResource.flattenParamsValue(value, key));
        }
        return flatParams;
    }

    private static List<KeyValuePair<String, Object>> flattenParamsCollection(Collection<?> collection, String keyPrefix) {
        ArrayList<KeyValuePair<String, Object>> flatParams = new ArrayList<KeyValuePair<String, Object>>();
        if (collection == null) {
            return flatParams;
        }
        for (Object value : collection) {
            String newPrefix = String.format("%s", keyPrefix);
            flatParams.addAll(ApiResource.flattenParamsValue(value, newPrefix));
        }
        return flatParams;
    }

    private static List<KeyValuePair<String, Object>> singleParam(String key, Object value) {
        ArrayList<KeyValuePair<String, Object>> flatParams = new ArrayList<KeyValuePair<String, Object>>();
        flatParams.add(new KeyValuePair<String, Object>(key, value));
        return flatParams;
    }

    public static void request(AtlanClient client, RequestMethod method, String url, AtlanObject payload, RequestOptions options) throws AtlanException {
        ApiResource.checkNullTypedParams(url, payload);
        ApiResource.request(client, method, url, payload.toJson(client), options);
    }

    public static void request(AtlanClient client, RequestMethod method, String url, String body, RequestOptions options) throws AtlanException {
        String requestId = UUID.randomUUID().toString();
        MDC.put((String)"X-Atlan-Request-Id", (String)requestId);
        log.debug("({}) {} with: {}", new Object[]{method, url, body});
        atlanResponseGetter.request(client, method, url, body, options, requestId);
        MDC.put((String)"X-Atlan-Request-Id", (String)requestId);
        if (log.isDebugEnabled()) {
            log.debug(" ... empty response.");
        }
    }

    public static <T extends ApiResource> T request(AtlanClient client, RequestMethod method, String url, AtlanObject payload, Class<T> clazz, RequestOptions options) throws AtlanException {
        ApiResource.checkNullTypedParams(url, payload);
        return ApiResource.request(client, method, url, payload.toJson(client), clazz, options);
    }

    public static String requestPlainText(AtlanClient client, RequestMethod method, String url, AtlanObject payload, RequestOptions options) throws AtlanException {
        ApiResource.checkNullTypedParams(url, payload);
        return ApiResource.requestPlainText(client, method, url, payload.toJson(client), options);
    }

    public static <T extends ApiResource> T request(AtlanClient client, RequestMethod method, String url, String body, Class<T> clazz, RequestOptions options) throws AtlanException {
        String requestId = UUID.randomUUID().toString();
        MDC.put((String)"X-Atlan-Request-Id", (String)requestId);
        log.debug("({}) {} with: {}", new Object[]{method, url, body});
        ApiResource response = (ApiResource)atlanResponseGetter.request(client, method, url, body, clazz, options, requestId);
        MDC.put((String)"X-Atlan-Request-Id", (String)requestId);
        if (log.isDebugEnabled()) {
            if (response != null) {
                if (Atlan.enableTelemetry) {
                    log.debug(" ... response ({}): {}", (Object)response.getLastResponse().metrics(), (Object)response.getRawJsonObject());
                } else {
                    log.debug(" ... response: {}", (Object)response.getRawJsonObject());
                }
            } else {
                log.debug(" ... empty response.");
            }
        }
        return (T)response;
    }

    public static String requestPlainText(AtlanClient client, RequestMethod method, String url, String body, RequestOptions options) throws AtlanException {
        String requestId = UUID.randomUUID().toString();
        MDC.put((String)"X-Atlan-Request-Id", (String)requestId);
        log.debug("({}) {} with: {}", new Object[]{method, url, body});
        String response = atlanResponseGetter.requestPlainText(client, method, url, body, options, requestId);
        MDC.put((String)"X-Atlan-Request-Id", (String)requestId);
        if (log.isDebugEnabled()) {
            if (response != null) {
                log.debug(" ... response: {}", (Object)response);
            } else {
                log.debug(" ... empty response.");
            }
        }
        return response;
    }

    public static <T extends ApiResource> T request(AtlanClient client, RequestMethod method, String url, InputStream payload, String filename, Class<T> clazz, RequestOptions options) throws AtlanException {
        return ApiResource.request(client, method, url, payload, filename, clazz, null, options);
    }

    public static <T extends ApiResource> T request(AtlanClient client, RequestMethod method, String url, InputStream payload, String filename, Class<T> clazz, Map<String, String> extras, RequestOptions options) throws AtlanException {
        if (payload == null) {
            throw new IllegalArgumentException(String.format("Found null input stream for %s.", url));
        }
        String requestId = UUID.randomUUID().toString();
        MDC.put((String)"X-Atlan-Request-Id", (String)requestId);
        log.debug("({}) {} with: {}", new Object[]{method, url, filename});
        ApiResource response = (ApiResource)atlanResponseGetter.request(client, method, url, payload, filename, clazz, extras, options, requestId);
        MDC.put((String)"X-Atlan-Request-Id", (String)requestId);
        if (log.isDebugEnabled()) {
            if (response != null) {
                if (Atlan.enableTelemetry) {
                    log.debug(" ... response ({}): {}", (Object)response.getLastResponse().metrics(), (Object)response.getRawJsonObject());
                } else {
                    log.debug(" ... response: {}", (Object)response.getRawJsonObject());
                }
            } else {
                log.debug(" ... empty response.");
            }
        }
        return (T)response;
    }

    public static <T extends ApiResource> T request(AtlanClient client, RequestMethod method, String url, Map<String, Object> map, Class<T> clazz, RequestOptions options) throws AtlanException {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Found null map of key-value pairs for %s.", url));
        }
        String requestId = UUID.randomUUID().toString();
        MDC.put((String)"X-Atlan-Request-Id", (String)requestId);
        ApiResource response = (ApiResource)atlanResponseGetter.request(client, method, url, map, clazz, options, requestId);
        MDC.put((String)"X-Atlan-Request-Id", (String)requestId);
        if (log.isDebugEnabled()) {
            if (response != null) {
                if (Atlan.enableTelemetry) {
                    log.debug(" ... response timing: {}", (Object)response.getLastResponse().metrics());
                }
            } else {
                log.debug(" ... empty response.");
            }
        }
        return (T)response;
    }

    public static void checkNullTypedParams(String url, AtlanObject params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Found null params for %s. Please pass empty params using param builder via `builder().build()` instead.", url));
        }
    }

    @Override
    @Generated
    public String toString() {
        return "ApiResource(super=" + super.toString() + ", lastResponse=" + String.valueOf(this.getLastResponse()) + ")";
    }

    public static enum RequestMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

