/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.cache.ReflectionCache;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.relations.IndistinctRelationship;
import com.atlan.model.relations.RelationshipAttributes;
import com.atlan.serde.Serde;
import com.atlan.util.JacksonUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipAttributesDeserializer
extends StdDeserializer<RelationshipAttributes> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RelationshipAttributesDeserializer.class);
    private static final long serialVersionUID = 2L;
    private final transient AtlanClient client;

    public RelationshipAttributesDeserializer(AtlanClient client) {
        this(Asset.class, client);
    }

    public RelationshipAttributesDeserializer(Class<?> t, AtlanClient client) {
        super(t);
        this.client = client;
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser, context);
    }

    public RelationshipAttributes deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return this.deserialize((JsonNode)parser.getCodec().readTree(parser));
    }

    RelationshipAttributes deserialize(JsonNode root) throws IOException {
        Object result;
        Class relationshipClass;
        RelationshipAttributes.RelationshipAttributesBuilder builder;
        JsonNode attributes = root.get("attributes");
        JsonNode typeNameJson = root.get("typeName");
        String typeName = null;
        if (typeNameJson == null || typeNameJson.isNull()) {
            builder = IndistinctRelationship._internal();
            relationshipClass = IndistinctRelationship.class;
        } else {
            typeName = root.get("typeName").asText();
            try {
                relationshipClass = Serde.getRelationshipAttributesClassForType(typeName);
                Method method = relationshipClass.getMethod("builder", new Class[0]);
                result = method.invoke(null, new Object[0]);
                builder = (RelationshipAttributes.RelationshipAttributesBuilder)result;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Unable to dynamically retrieve relationship for typeName {}, falling back to an IndistinctRelationship.", (Object)typeName, (Object)e);
                builder = IndistinctRelationship._internal();
                relationshipClass = IndistinctRelationship.class;
            }
        }
        ((RelationshipAttributes.RelationshipAttributesBuilder)builder).typeName(JacksonUtils.deserializeString(root, "typeName"));
        Class<?> builderClass = builder.getClass();
        if (attributes != null && !attributes.isNull()) {
            Iterator itr = attributes.fieldNames();
            while (itr.hasNext()) {
                String relnKey = (String)itr.next();
                String deserializeName = ReflectionCache.getDeserializedName(relationshipClass, relnKey);
                Method method = ReflectionCache.getSetter(builderClass, deserializeName);
                if (method == null) continue;
                try {
                    Object value = Serde.deserialize(this.client, attributes.get(relnKey), method, deserializeName);
                    ReflectionCache.setValue(builder, deserializeName, value);
                }
                catch (NoSuchMethodException e) {
                    throw new IOException("Missing fromValue method for enum.", e);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IOException("Failed to deserialize through reflection.", e);
                }
            }
        }
        result = ((RelationshipAttributes.RelationshipAttributesBuilder)builder).build();
        ((AtlanObject)result).setRawJsonObject(root);
        return result;
    }
}

