/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import com.atlan.AtlanClient;
import com.atlan.api.AtlasEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.GlossaryCategory;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetDeletionResponse;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AssetResponse;
import com.atlan.model.core.AsyncCreationResponse;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanDeleteType;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.enums.AtlanTagHandling;
import com.atlan.model.lineage.LineageListRequest;
import com.atlan.model.lineage.LineageListResponse;
import com.atlan.model.search.AuditSearchRequest;
import com.atlan.model.search.AuditSearchResponse;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetEndpoint
extends AtlasEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetEndpoint.class);
    private static final String audit_endpoint = "/entity/auditSearch";
    private static final String bulk_endpoint = "/entity/bulk";
    private static final String guid_endpoint = "/entity/guid/";
    private static final String unique_attr_endpoint = "/entity/uniqueAttribute/type/";
    private static final String search_endpoint = "/search/indexsearch";
    private static final String lineage_list_endpoint = "/lineage/list";

    public AssetEndpoint(AtlanClient client) {
        super(client);
    }

    public FluentSearch.FluentSearchBuilder<?, ?> select() {
        return this.select(false);
    }

    public FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(this.client).where(Asset.SUPER_TYPE_NAMES.eq("Referenceable"));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public AuditSearchResponse auditLogs(AuditSearchRequest request) throws AtlanException {
        return this.auditLogs(request, null);
    }

    public AuditSearchResponse auditLogs(AuditSearchRequest request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), audit_endpoint);
        boolean missingSort = request.getDsl().getSort() == null || request.getDsl().getSort().isEmpty();
        boolean missingGuidSort = true;
        if (!missingSort) {
            for (SortOptions option : request.getDsl().getSort()) {
                if (!option.isField()) continue;
                String fieldName = option.field().field();
                if (!AuditSearchRequest.ENTITY_ID.getKeywordFieldName().equals(fieldName)) continue;
                missingGuidSort = false;
                break;
            }
        }
        if (missingGuidSort) {
            request = ((AuditSearchRequest.AuditSearchRequestBuilder)request.toBuilder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)request.getDsl().toBuilder().sortOption(AuditSearchRequest.ENTITY_ID.order(SortOrder.Asc))).build())).build();
        }
        AuditSearchResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, AuditSearchResponse.class, options);
        response.setClient(this.client);
        response.setRequest((AuditSearchRequest)request);
        return response;
    }

    public AsyncCreationResponse save(Asset value) throws AtlanException {
        return this.save(value, null);
    }

    public AsyncCreationResponse save(List<Asset> values) throws AtlanException {
        return this.save(values, (RequestOptions)null);
    }

    public AsyncCreationResponse save(List<Asset> values, AtlanTagHandling tagHandling) throws AtlanException {
        return this.save(values, tagHandling, null);
    }

    @Deprecated
    public AsyncCreationResponse save(Asset value, boolean replaceAtlanTags) throws AtlanException {
        return this.save(List.of(value), replaceAtlanTags, null);
    }

    @Deprecated
    public AsyncCreationResponse save(Asset value, boolean replaceAtlanTags, RequestOptions options) throws AtlanException {
        return this.save(List.of(value), replaceAtlanTags, options);
    }

    @Deprecated
    public AsyncCreationResponse save(List<Asset> values, boolean replaceAtlanTags) throws AtlanException {
        return this.save(values, replaceAtlanTags, null);
    }

    @Deprecated
    public AsyncCreationResponse save(List<Asset> values, boolean replaceAtlanTags, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?replaceTags=%s&replaceBusinessAttributes=false&overwriteBusinessAttributes=false", bulk_endpoint, replaceAtlanTags));
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(values)).build();
        AsyncCreationResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, AsyncCreationResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    public AsyncCreationResponse save(Asset value, RequestOptions options) throws AtlanException {
        return this.save(List.of(value), options);
    }

    public AsyncCreationResponse save(List<Asset> values, RequestOptions options) throws AtlanException {
        AtlanTagHandling tagHanding = this.getTagHandling(values);
        return this.save(values, tagHanding, options);
    }

    public AsyncCreationResponse save(List<Asset> values, AtlanTagHandling tagHandling, RequestOptions options) throws AtlanException {
        String tagParams = this.getTagParameters(tagHandling);
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?%s&replaceBusinessAttributes=false&overwriteBusinessAttributes=false", bulk_endpoint, tagParams));
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(values)).build();
        AsyncCreationResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, AsyncCreationResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    public AsyncCreationResponse saveNoTagsNoCM(List<Asset> values, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?replaceTags=false&appendTags=false&replaceBusinessAttributes=false&overwriteBusinessAttributes=false", bulk_endpoint));
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(values)).build();
        AsyncCreationResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, AsyncCreationResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    private AtlanTagHandling getTagHandling(List<Asset> values) {
        boolean appendTags = false;
        boolean replaceTags = false;
        for (int i = 0; !(i >= values.size() || appendTags && replaceTags); ++i) {
            Asset value = values.get(i);
            boolean bl = replaceTags = replaceTags || value.getNullFields().contains("atlanTags");
            if (value.getAtlanTags() == null || value.getAtlanTags().isEmpty()) continue;
            for (AtlanTag tag : value.getAtlanTags()) {
                switch (tag.getSemantic()) {
                    case APPEND: 
                    case REMOVE: {
                        appendTags = true;
                        break;
                    }
                    case REPLACE: {
                        replaceTags = true;
                    }
                }
            }
        }
        if (appendTags && replaceTags) {
            log.warn("Provided list of assets includes mixture of tag semantics, falling back to append-only for safety. To avoid this, ensure you send the same mode for all assets in the list.");
        }
        AtlanTagHandling atlanTagHandling = appendTags ? AtlanTagHandling.APPEND : (replaceTags ? AtlanTagHandling.REPLACE : AtlanTagHandling.IGNORE);
        return atlanTagHandling;
    }

    private String getTagParameters(AtlanTagHandling atlanTagHandling) {
        return switch (atlanTagHandling) {
            case AtlanTagHandling.APPEND, AtlanTagHandling.REMOVE -> "replaceTags=false&appendTags=true";
            case AtlanTagHandling.REPLACE -> "replaceTags=true&appendTags=false";
            default -> "replaceTags=false&appendTags=false";
        };
    }

    @Deprecated
    public AsyncCreationResponse saveMergingCM(List<Asset> values, boolean replaceAtlanTags) throws AtlanException {
        return this.saveMergingCM(values, replaceAtlanTags, null);
    }

    @Deprecated
    public AsyncCreationResponse saveMergingCM(List<Asset> values, boolean replaceAtlanTags, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?replaceTags=%s&replaceBusinessAttributes=true&overwriteBusinessAttributes=false", bulk_endpoint, replaceAtlanTags));
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(values)).build();
        AsyncCreationResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, AsyncCreationResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    public AsyncCreationResponse saveMergingCM(List<Asset> values) throws AtlanException {
        return this.saveMergingCM(values, (RequestOptions)null);
    }

    public AsyncCreationResponse saveMergingCM(List<Asset> values, AtlanTagHandling atlanTagHandling) throws AtlanException {
        return this.saveMergingCM(values, atlanTagHandling, null);
    }

    public AsyncCreationResponse saveMergingCM(List<Asset> values, RequestOptions options) throws AtlanException {
        AtlanTagHandling tagHandling = this.getTagHandling(values);
        return this.saveMergingCM(values, tagHandling, options);
    }

    public AsyncCreationResponse saveMergingCM(List<Asset> values, AtlanTagHandling atlanTagHandling, RequestOptions options) throws AtlanException {
        String tagParams = this.getTagParameters(atlanTagHandling);
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?%s&replaceBusinessAttributes=true&overwriteBusinessAttributes=false", bulk_endpoint, tagParams));
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(values)).build();
        AsyncCreationResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, AsyncCreationResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    @Deprecated
    public AsyncCreationResponse saveReplacingCM(List<Asset> values, boolean replaceAtlanTags) throws AtlanException {
        return this.saveReplacingCM(values, replaceAtlanTags, null);
    }

    @Deprecated
    public AsyncCreationResponse saveReplacingCM(List<Asset> values, boolean replaceAtlanTags, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?replaceTags=%s&replaceBusinessAttributes=true&overwriteBusinessAttributes=true", bulk_endpoint, replaceAtlanTags));
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(values)).build();
        AsyncCreationResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, AsyncCreationResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    public AsyncCreationResponse saveReplacingCM(List<Asset> values) throws AtlanException {
        return this.saveReplacingCM(values, (RequestOptions)null);
    }

    public AsyncCreationResponse saveReplacingCM(List<Asset> values, RequestOptions options) throws AtlanException {
        AtlanTagHandling tagHandling = this.getTagHandling(values);
        return this.saveReplacingCM(values, tagHandling, options);
    }

    public AsyncCreationResponse saveReplacingCM(List<Asset> values, AtlanTagHandling atlanTagHandling) throws AtlanException {
        return this.saveReplacingCM(values, atlanTagHandling, null);
    }

    public AsyncCreationResponse saveReplacingCM(List<Asset> values, AtlanTagHandling atlanTagHandling, RequestOptions options) throws AtlanException {
        String tagParams = this.getTagParameters(atlanTagHandling);
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?%s&replaceBusinessAttributes=true&overwriteBusinessAttributes=true", bulk_endpoint, tagParams));
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(values)).build();
        AsyncCreationResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, AsyncCreationResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    public AssetDeletionResponse delete(String guid, AtlanDeleteType deleteType) throws AtlanException {
        return this.delete(List.of(guid), deleteType, null);
    }

    public AssetDeletionResponse delete(List<String> guids, AtlanDeleteType deleteType) throws AtlanException {
        return this.delete(guids, deleteType, null);
    }

    public AssetDeletionResponse delete(List<String> guids, AtlanDeleteType deleteType, RequestOptions options) throws AtlanException {
        if (guids != null) {
            if (deleteType == AtlanDeleteType.SOFT) {
                ArrayList categoryGuids = new ArrayList();
                ((FluentSearch.FluentSearchBuilder)this.client.assets.select().where(Asset.GUID.in(guids))).stream().filter(a -> a instanceof GlossaryCategory).forEach(c -> categoryGuids.add(c.getGuid()));
                if (!categoryGuids.isEmpty()) {
                    throw new InvalidRequestException(ErrorCode.CATEGORIES_CANNOT_BE_ARCHIVED, String.join((CharSequence)",", categoryGuids));
                }
            }
            StringBuilder guidList = new StringBuilder();
            for (String guid : guids) {
                if (guid == null) continue;
                guidList.append("guid=").append(guid).append("&");
            }
            if (!guidList.isEmpty()) {
                guidList.setLength(guidList.length() - 1);
                String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?%s&deleteType=%s", bulk_endpoint, guidList, deleteType));
                AssetDeletionResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.DELETE, url, "", AssetDeletionResponse.class, options);
                response.setClient(this.client);
                return response;
            }
        }
        throw new InvalidRequestException(ErrorCode.MISSING_GUID_FOR_DELETE);
    }

    public AssetMutationResponse restore(Asset value) throws AtlanException {
        return this.restore(List.of(value));
    }

    public AssetMutationResponse restore(Asset value, RequestOptions options) throws AtlanException {
        return this.restore(List.of(value), options);
    }

    public AssetMutationResponse restore(List<Asset> values) throws AtlanException {
        return this.restore(values, null);
    }

    public AssetMutationResponse restore(List<Asset> values, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s?replaceTags=false&replaceBusinessAttributes=false&overwriteBusinessAttributes=false", bulk_endpoint));
        ArrayList<Asset> culled = new ArrayList<Asset>();
        for (Asset one : values) {
            culled.add((Asset)((Asset.AssetBuilder)one.trimToRequired().status(AtlanStatus.ACTIVE)).build());
        }
        AtlanObject beq = ((BulkEntityRequest.BulkEntityRequestBuilder)BulkEntityRequest.builder().entities(culled)).build();
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, beq, AssetMutationResponse.class, options);
    }

    public AssetResponse get(String guid, boolean ignoreRelationships, boolean minExtInfo) throws AtlanException {
        return this.get(guid, ignoreRelationships, minExtInfo, null);
    }

    public AssetResponse get(String guid, boolean ignoreRelationships, boolean minExtInfo, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s?ignoreRelationships=%s&minExtInfo=%s", guid_endpoint, ApiResource.urlEncodeId(guid), ignoreRelationships, minExtInfo));
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", AssetResponse.class, options);
    }

    public void updateCustomMetadataAttributes(String guid, String cmName, CustomMetadataAttributes values) throws AtlanException {
        this.updateCustomMetadataAttributes(guid, cmName, values, null);
    }

    public void updateCustomMetadataAttributes(String guid, String cmName, CustomMetadataAttributes values, RequestOptions options) throws AtlanException {
        if (values != null) {
            this.client.getCustomMetadataCache().getSidForName(cmName);
            String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s/businessmetadata?isOverwrite=false", guid_endpoint, ApiResource.urlEncodeId(guid)));
            CustomMetadataUpdateRequest cmur = new CustomMetadataUpdateRequest(cmName, values.getAttributes(), true);
            ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, cmur, options);
        }
    }

    public void replaceCustomMetadata(String guid, String cmName, CustomMetadataAttributes values) throws AtlanException {
        this.replaceCustomMetadata(guid, cmName, values, null);
    }

    public void replaceCustomMetadata(String guid, String cmName, CustomMetadataAttributes values, RequestOptions options) throws AtlanException {
        String cmId = this.client.getCustomMetadataCache().getSidForName(cmName);
        Map<String, Object> baseMap = this.client.getCustomMetadataCache().getEmptyAttributes(cmName);
        if (values != null && !values.isEmpty()) {
            baseMap.putAll(values.getAttributes());
        }
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s/businessmetadata/%s", guid_endpoint, ApiResource.urlEncodeId(guid), ApiResource.urlEncodeId(cmId)));
        CustomMetadataUpdateRequest cmur = new CustomMetadataUpdateRequest(cmName, baseMap, false);
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, cmur, options);
    }

    public void removeCustomMetadata(String guid, String cmName) throws AtlanException {
        this.removeCustomMetadata(guid, cmName, null);
    }

    public void removeCustomMetadata(String guid, String cmName, RequestOptions options) throws AtlanException {
        this.client.getCustomMetadataCache().getSidForName(cmName);
        Map<String, Object> map = this.client.getCustomMetadataCache().getEmptyAttributes(cmName);
        AtlanObject cma = ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)CustomMetadataAttributes.builder().attributes(map)).build();
        this.updateCustomMetadataAttributes(guid, cmName, (CustomMetadataAttributes)cma, options);
    }

    public AssetResponse get(String typeName, String qualifiedName, boolean ignoreRelationships, boolean minExtInfo) throws AtlanException {
        return this.get(typeName, qualifiedName, ignoreRelationships, minExtInfo, null);
    }

    public AssetResponse get(String typeName, String qualifiedName, boolean ignoreRelationships, boolean minExtInfo, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s?attr:qualifiedName=%s&ignoreRelationships=%s&minExtInfo=%s", unique_attr_endpoint, ApiResource.urlEncodeId(typeName), ApiResource.urlEncodeId(qualifiedName), ignoreRelationships, minExtInfo));
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", AssetResponse.class, options);
    }

    public AssetMutationResponse updateAttributes(String typeName, String qualifiedName, Asset value) throws AtlanException {
        return this.updateAttributes(typeName, qualifiedName, value, null);
    }

    public AssetMutationResponse updateAttributes(String typeName, String qualifiedName, Asset value, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s?attr:qualifiedName=%s", unique_attr_endpoint, typeName, ApiResource.urlEncode(qualifiedName)));
        AtlanObject seq = ((SingleEntityRequest.SingleEntityRequestBuilder)SingleEntityRequest.builder().entity(value)).build();
        return ApiResource.request(this.client, ApiResource.RequestMethod.PUT, url, seq, AssetMutationResponse.class, options);
    }

    public void removeAtlanTag(String typeName, String qualifiedName, String atlanTagName, boolean idempotent) throws AtlanException {
        this.removeAtlanTag(typeName, qualifiedName, atlanTagName, idempotent, null);
    }

    public void removeAtlanTag(String typeName, String qualifiedName, String atlanTagName, boolean idempotent, RequestOptions options) throws AtlanException {
        String atlanTagId = this.client.getAtlanTagCache().getSidForName(atlanTagName);
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s%s/classification/%s?attr:qualifiedName=%s", unique_attr_endpoint, typeName, atlanTagId, ApiResource.urlEncode(qualifiedName)));
        try {
            ApiResource.request(this.client, ApiResource.RequestMethod.DELETE, url, "", options);
        }
        catch (InvalidRequestException e) {
            if (idempotent && e.getMessage().equals("ATLAS-400-00-06D")) {
                log.debug("Attempted to remove Atlan tag '{}' from asset that does not have the Atlan tag, ignoring: {}", (Object)atlanTagName, (Object)qualifiedName);
            }
            throw e;
        }
    }

    public IndexSearchResponse search(IndexSearchRequest request) throws AtlanException {
        return this.search(request, null);
    }

    public IndexSearchResponse search(IndexSearchRequest request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), search_endpoint);
        boolean missingSort = request.getDsl().getSort() == null || request.getDsl().getSort().isEmpty();
        boolean missingGuidSort = true;
        if (!missingSort) {
            for (SortOptions option : request.getDsl().getSort()) {
                if (!option.isField()) continue;
                String fieldName = option.field().field();
                if (!IReferenceable.GUID.getKeywordFieldName().equals(fieldName)) continue;
                missingGuidSort = false;
                break;
            }
        }
        if (missingGuidSort) {
            request = ((IndexSearchRequest.IndexSearchRequestBuilder)request.toBuilder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)request.getDsl().toBuilder().sortOption(IReferenceable.GUID.order(SortOrder.Asc))).build())).build();
        }
        IndexSearchResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, IndexSearchResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    public LineageListResponse lineage(LineageListRequest request) throws AtlanException {
        return this.lineage(request, null);
    }

    public LineageListResponse lineage(LineageListRequest request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), lineage_list_endpoint);
        LineageListResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, LineageListResponse.class, options);
        response.setClient(this.client);
        return response;
    }

    static class BulkEntityRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        List<Asset> entities;

        @Generated
        protected BulkEntityRequest(BulkEntityRequestBuilder<?, ?> b) {
            super(b);
            this.entities = b.entities;
        }

        @Generated
        public static BulkEntityRequestBuilder<?, ?> builder() {
            return new BulkEntityRequestBuilderImpl();
        }

        @Generated
        public List<Asset> getEntities() {
            return this.entities;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkEntityRequest)) {
                return false;
            }
            BulkEntityRequest other = (BulkEntityRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Asset> this$entities = this.getEntities();
            List<Asset> other$entities = other.getEntities();
            return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BulkEntityRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Asset> $entities = this.getEntities();
            result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
            return result;
        }

        @Generated
        public static abstract class BulkEntityRequestBuilder<C extends BulkEntityRequest, B extends BulkEntityRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private List<Asset> entities;

            @Generated
            public B entities(List<Asset> entities) {
                this.entities = entities;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "AssetEndpoint.BulkEntityRequest.BulkEntityRequestBuilder(super=" + super.toString() + ", entities=" + String.valueOf(this.entities) + ")";
            }
        }

        @Generated
        private static final class BulkEntityRequestBuilderImpl
        extends BulkEntityRequestBuilder<BulkEntityRequest, BulkEntityRequestBuilderImpl> {
            @Generated
            private BulkEntityRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected BulkEntityRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public BulkEntityRequest build() {
                return new BulkEntityRequest(this);
            }
        }
    }

    static class CustomMetadataUpdateRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        private final transient boolean includeName;
        private final transient String name;
        private final transient Map<String, Object> attributes;

        public CustomMetadataUpdateRequest(String name, Map<String, Object> attributes, boolean includeName) {
            this.name = name;
            this.attributes = attributes;
            this.includeName = includeName;
        }

        @Override
        public String toJson(AtlanClient client) {
            LinkedHashMap<String, Object> businessMetadataAttributes = new LinkedHashMap<String, Object>();
            try {
                client.getCustomMetadataCache().getIdMapFromNameMap(this.name, this.attributes, businessMetadataAttributes);
                if (this.includeName) {
                    LinkedHashMap<String, LinkedHashMap<String, Object>> wrapped = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
                    String cmId = client.getCustomMetadataCache().getSidForName(this.name);
                    wrapped.put(cmId, businessMetadataAttributes);
                    return client.writeValueAsString(wrapped);
                }
                return client.writeValueAsString(businessMetadataAttributes);
            }
            catch (AtlanException | IOException e) {
                throw new RuntimeException("Unable to serialize custom metadata for '" + this.name + "' with: " + String.valueOf(this.attributes), e);
            }
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomMetadataUpdateRequest)) {
                return false;
            }
            CustomMetadataUpdateRequest other = (CustomMetadataUpdateRequest)o;
            return other.canEqual(this);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomMetadataUpdateRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    static class SingleEntityRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        Asset entity;

        @Generated
        protected SingleEntityRequest(SingleEntityRequestBuilder<?, ?> b) {
            super(b);
            this.entity = b.entity;
        }

        @Generated
        public static SingleEntityRequestBuilder<?, ?> builder() {
            return new SingleEntityRequestBuilderImpl();
        }

        @Generated
        public Asset getEntity() {
            return this.entity;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleEntityRequest)) {
                return false;
            }
            SingleEntityRequest other = (SingleEntityRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Asset this$entity = this.getEntity();
            Asset other$entity = other.getEntity();
            return !(this$entity == null ? other$entity != null : !((Object)this$entity).equals(other$entity));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SingleEntityRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Asset $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : ((Object)$entity).hashCode());
            return result;
        }

        @Generated
        public static abstract class SingleEntityRequestBuilder<C extends SingleEntityRequest, B extends SingleEntityRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private Asset entity;

            @Generated
            public B entity(Asset entity) {
                this.entity = entity;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "AssetEndpoint.SingleEntityRequest.SingleEntityRequestBuilder(super=" + super.toString() + ", entity=" + String.valueOf(this.entity) + ")";
            }
        }

        @Generated
        private static final class SingleEntityRequestBuilderImpl
        extends SingleEntityRequestBuilder<SingleEntityRequest, SingleEntityRequestBuilderImpl> {
            @Generated
            private SingleEntityRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected SingleEntityRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public SingleEntityRequest build() {
                return new SingleEntityRequest(this);
            }
        }
    }
}

