/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.HeraclesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanRequest;
import com.atlan.model.admin.AtlanRequestResponse;
import com.atlan.model.enums.AtlanRequestStatus;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import lombok.Generated;

public class RequestsEndpoint
extends HeraclesEndpoint {
    private static final String endpoint = "/requests";
    private static final int defaultLimit = 40;

    public RequestsEndpoint(AtlanClient client) {
        super(client);
    }

    public AtlanRequest get(String guid) throws AtlanException {
        return this.get(guid, null);
    }

    public AtlanRequest get(String guid, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s", this.getBaseUrl(), endpoint, guid);
        WrappedRequest result = ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", WrappedRequest.class, options);
        if (result != null) {
            AtlanRequest request = result.getRequest();
            request.setRawJsonObject(result.getRawJsonObject());
            return request;
        }
        return null;
    }

    public AtlanRequestResponse list(String filter, String sort, int offset, int limit) throws AtlanException {
        return this.list(filter, sort, offset, limit, null);
    }

    public AtlanRequestResponse list(String filter, String sort, int offset, int limit, RequestOptions options) throws AtlanException {
        if (filter == null) {
            filter = "";
        }
        if (sort == null) {
            sort = "";
        }
        String url = String.format("%s%s?limit=%s&offset=%s&sort=%s&filter=%s", this.getBaseUrl(), endpoint, limit, offset, ApiResource.urlEncode(sort), ApiResource.urlEncode(filter));
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", AtlanRequestResponse.class, options);
    }

    public AtlanRequestResponse list(String filter) throws AtlanException {
        return this.list(filter, null);
    }

    public AtlanRequestResponse list(String filter, RequestOptions options) throws AtlanException {
        return this.list(filter, "-createdAt", 0, 40, options);
    }

    public AtlanRequestResponse list() throws AtlanException {
        return this.list((RequestOptions)null);
    }

    public AtlanRequestResponse list(RequestOptions options) throws AtlanException {
        return this.list("{\"$and\":[{\"isDuplicate\":false},{\"status\":{\"$in\":[\"active\"]}}]}", "-createdAt", 0, 40, options);
    }

    public AtlanRequestResponse listActionable(String filter, String sort, int offset, int limit) throws AtlanException {
        return this.listActionable(filter, sort, offset, limit, null);
    }

    public AtlanRequestResponse listActionable(String filter, String sort, int offset, int limit, RequestOptions options) throws AtlanException {
        if (filter == null) {
            filter = "";
        }
        if (sort == null) {
            sort = "";
        }
        String url = String.format("%s%s/actionable?limit=%s&offset=%s&sort=%s&filter=%s", this.getBaseUrl(), endpoint, limit, offset, ApiResource.urlEncode(sort), ApiResource.urlEncode(filter));
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", AtlanRequestResponse.class, options);
    }

    public AtlanRequestResponse listActionable(String filter) throws AtlanException {
        return this.listActionable(filter, null);
    }

    public AtlanRequestResponse listActionable(String filter, RequestOptions options) throws AtlanException {
        return this.listActionable(filter, "-createdAt", 0, 40, options);
    }

    public AtlanRequestResponse listActionable() throws AtlanException {
        return this.listActionable((RequestOptions)null);
    }

    public AtlanRequestResponse listActionable(RequestOptions options) throws AtlanException {
        return this.listActionable("", "-createdAt", 0, 40, options);
    }

    public void create(AtlanRequest request) throws AtlanException {
        this.create(request, null);
    }

    public void create(AtlanRequest request, RequestOptions options) throws AtlanException {
        if (request != null) {
            this.create(List.of(request), options);
        }
    }

    public void create(List<AtlanRequest> requests) throws AtlanException {
        this.create(requests, null);
    }

    public void create(List<AtlanRequest> requests, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/bulk", this.getBaseUrl(), endpoint);
        BulkRequest br = new BulkRequest(requests);
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, br, null, options);
    }

    public boolean approve(String guid, String message) throws AtlanException {
        return this.approve(guid, message, null);
    }

    public boolean approve(String guid, String message, RequestOptions options) throws AtlanException {
        return this.action(guid, AtlanRequestStatus.APPROVED, message, options);
    }

    public boolean reject(String guid, String message) throws AtlanException {
        return this.reject(guid, message, null);
    }

    public boolean reject(String guid, String message, RequestOptions options) throws AtlanException {
        return this.action(guid, AtlanRequestStatus.REJECTED, message, options);
    }

    private boolean action(String guid, AtlanRequestStatus action, String message, RequestOptions options) throws AtlanException {
        AtlanRequestAction ara;
        WrappedString string;
        String url = String.format("%s%s/%s/action", this.getBaseUrl(), endpoint, guid);
        if (message == null) {
            message = "";
        }
        return (string = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, ara = new AtlanRequestAction(action, message), WrappedString.class, options)) != null && string.getResult() != null && string.getResult().equals("success");
    }

    @JsonSerialize(using=WrappedRequestSerializer.class)
    @JsonDeserialize(using=WrappedRequestDeserializer.class)
    private static final class WrappedRequest
    extends ApiResource {
        private static final long serialVersionUID = 2L;
        AtlanRequest request;

        public WrappedRequest(AtlanRequest request) {
            this.request = request;
        }

        @Generated
        public AtlanRequest getRequest() {
            return this.request;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrappedRequest)) {
                return false;
            }
            WrappedRequest other = (WrappedRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AtlanRequest this$request = this.getRequest();
            AtlanRequest other$request = other.getRequest();
            return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WrappedRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtlanRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            return result;
        }
    }

    private static final class BulkRequest
    extends ApiResource {
        private static final long serialVersionUID = 2L;
        List<AtlanRequest> requests;

        public BulkRequest(List<AtlanRequest> requests) {
            this.requests = requests;
        }

        @Generated
        public List<AtlanRequest> getRequests() {
            return this.requests;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkRequest)) {
                return false;
            }
            BulkRequest other = (BulkRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<AtlanRequest> this$requests = this.getRequests();
            List<AtlanRequest> other$requests = other.getRequests();
            return !(this$requests == null ? other$requests != null : !((Object)this$requests).equals(other$requests));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BulkRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<AtlanRequest> $requests = this.getRequests();
            result = result * 59 + ($requests == null ? 43 : ((Object)$requests).hashCode());
            return result;
        }
    }

    private static final class AtlanRequestAction
    extends ApiResource {
        private static final long serialVersionUID = 2L;
        AtlanRequestStatus action;
        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        String message;

        public AtlanRequestAction(AtlanRequestStatus action, String message) {
            this.action = action;
            this.message = message;
        }

        @Generated
        public AtlanRequestStatus getAction() {
            return this.action;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AtlanRequestAction)) {
                return false;
            }
            AtlanRequestAction other = (AtlanRequestAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AtlanRequestStatus this$action = this.getAction();
            AtlanRequestStatus other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AtlanRequestAction;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtlanRequestStatus $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }
    }

    @JsonSerialize(using=WrappedStringSerializer.class)
    @JsonDeserialize(using=WrappedStringDeserializer.class)
    private static final class WrappedString
    extends ApiResource {
        private static final long serialVersionUID = 2L;
        String result;

        public WrappedString(String result) {
            this.result = result;
        }

        @Generated
        public String getResult() {
            return this.result;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrappedString)) {
                return false;
            }
            WrappedString other = (WrappedString)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$result = this.getResult();
            String other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WrappedString;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }
    }

    private static class WrappedStringSerializer
    extends StdSerializer<WrappedString> {
        private static final long serialVersionUID = 2L;
        private final transient AtlanClient client;

        public WrappedStringSerializer(AtlanClient client) {
            this(WrappedString.class, client);
        }

        public WrappedStringSerializer(Class<WrappedString> t, AtlanClient client) {
            super(t);
            this.client = client;
        }

        public void serialize(WrappedString wrappedString, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
            String string = wrappedString.getResult();
            this.client.writeValue(gen, string);
        }
    }

    private static class WrappedStringDeserializer
    extends StdDeserializer<WrappedString> {
        private static final long serialVersionUID = 2L;

        public WrappedStringDeserializer() {
            this(null);
        }

        public WrappedStringDeserializer(Class<?> t) {
            super(t);
        }

        public WrappedString deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            String string = (String)parser.getCodec().readValue(parser, (TypeReference)new TypeReference<String>(){});
            return new WrappedString(string);
        }
    }

    private static class WrappedRequestSerializer
    extends StdSerializer<WrappedRequest> {
        private static final long serialVersionUID = 2L;
        private final transient AtlanClient client;

        public WrappedRequestSerializer(AtlanClient client) {
            this(WrappedRequest.class, client);
        }

        public WrappedRequestSerializer(Class<WrappedRequest> t, AtlanClient client) {
            super(t);
            this.client = client;
        }

        public void serialize(WrappedRequest wrappedRequest, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
            AtlanRequest request = wrappedRequest.getRequest();
            this.client.writeValue(gen, List.of(request));
        }
    }

    private static class WrappedRequestDeserializer
    extends StdDeserializer<WrappedRequest> {
        private static final long serialVersionUID = 2L;

        public WrappedRequestDeserializer() {
            this(null);
        }

        public WrappedRequestDeserializer(Class<?> t) {
            super(t);
        }

        public WrappedRequest deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            List response = (List)parser.getCodec().readValue(parser, (TypeReference)new TypeReference<List<AtlanRequest>>(){});
            if (response != null && !response.isEmpty()) {
                return new WrappedRequest((AtlanRequest)response.get(0));
            }
            return null;
        }
    }
}

