/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import com.atlan.AtlanClient;
import com.atlan.api.AtlasEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.tasks.AtlanTask;
import com.atlan.model.tasks.FluentTasks;
import com.atlan.model.tasks.TaskSearchRequest;
import com.atlan.model.tasks.TaskSearchResponse;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskEndpoint
extends AtlasEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskEndpoint.class);
    private static final String search_endpoint = "/task/search";

    public TaskEndpoint(AtlanClient client) {
        super(client);
    }

    public FluentTasks.FluentTasksBuilder select() {
        return FluentTasks.builder(this.client);
    }

    public TaskSearchResponse search(TaskSearchRequest request) throws AtlanException {
        return this.search(request, null);
    }

    public TaskSearchResponse search(TaskSearchRequest request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), search_endpoint);
        boolean missingSort = request.getDsl().getSort() == null || request.getDsl().getSort().isEmpty();
        boolean missingTimeSort = true;
        if (!missingSort) {
            for (SortOptions option : request.getDsl().getSort()) {
                if (!option.isField()) continue;
                String fieldName = option.field().field();
                if (!AtlanTask.START_TIME.getNumericFieldName().equals(fieldName)) continue;
                missingTimeSort = false;
                break;
            }
        }
        if (missingTimeSort) {
            request = ((TaskSearchRequest.TaskSearchRequestBuilder)request.toBuilder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)request.getDsl().toBuilder().sortOption(AtlanTask.START_TIME.order(SortOrder.Asc))).build())).build();
        }
        TaskSearchResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, TaskSearchResponse.class, options);
        response.setClient(this.client);
        response.setRequest((TaskSearchRequest)request);
        return response;
    }
}

