/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.cache.AbstractMassCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.core.AtlanObject;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractMassTrackingCache<T extends AtlanObject>
extends AbstractMassCache<T> {
    private volatile Set<String> deletedSids = ConcurrentHashMap.newKeySet();
    private volatile Set<String> deletedNames = ConcurrentHashMap.newKeySet();

    public AbstractMassTrackingCache(AtlanClient client, String name) {
        super(client, name);
    }

    @Override
    protected void refreshCache() throws AtlanException {
        this.deletedSids.clear();
        this.deletedNames.clear();
    }

    protected void refresh(long minimumTime) throws AtlanException {
        if (minimumTime == Long.MAX_VALUE || minimumTime < this.lastRefresh.get()) {
            this.forceRefresh();
        }
    }

    protected boolean isDeletedName(String name) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.deletedNames.contains(name);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void addDeletedName(String name) {
        this.lock.writeLock().lock();
        try {
            this.deletedNames.add(name);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected boolean isDeletedId(String id) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.deletedSids.contains(id);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void addDeletedId(String id) {
        this.lock.writeLock().lock();
        try {
            this.deletedSids.add(id);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String getIdForName(String name, long minimumTime) throws AtlanException {
        if (name != null && this.isDeletedName(name)) {
            return null;
        }
        try {
            return super.getIdForName(name, minimumTime == Long.MAX_VALUE || minimumTime < this.lastRefresh.get());
        }
        catch (NotFoundException e) {
            this.addDeletedName(name);
            throw e;
        }
    }

    public String getNameForId(String id, long minimumTime) throws AtlanException {
        if (id != null && this.isDeletedId(id)) {
            return null;
        }
        try {
            return super.getNameForId(id, minimumTime == Long.MAX_VALUE || minimumTime < this.lastRefresh.get());
        }
        catch (NotFoundException e) {
            this.addDeletedId(id);
            throw e;
        }
    }

    public String getSidForName(String name, long minimumTime) throws AtlanException {
        if (name != null && this.isDeletedName(name)) {
            return null;
        }
        try {
            return super.getSidForName(name, minimumTime == Long.MAX_VALUE || minimumTime < this.lastRefresh.get());
        }
        catch (NotFoundException e) {
            this.addDeletedName(name);
            throw e;
        }
    }

    public String getNameForSid(String sid, long minimumTime) throws AtlanException {
        if (sid != null && this.isDeletedId(sid)) {
            return null;
        }
        try {
            return super.getNameForSid(sid, minimumTime == Long.MAX_VALUE || minimumTime < this.lastRefresh.get());
        }
        catch (NotFoundException e) {
            this.addDeletedId(sid);
            throw e;
        }
    }
}

