/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.api.TypeDefsEndpoint;
import com.atlan.cache.AbstractMassTrackingCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.AuthenticationException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.AtlanTagDef;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.TypeDefResponse;
import com.atlan.net.HttpClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlanTagCache
extends AbstractMassTrackingCache<AtlanTagDef> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtlanTagCache.class);
    private volatile Map<String, String> mapSidToSourceTagsAttrSid = new ConcurrentHashMap<String, String>();
    private final TypeDefsEndpoint typeDefsEndpoint;

    public AtlanTagCache(AtlanClient client) {
        super(client, "tag");
        this.typeDefsEndpoint = client.typeDefs;
    }

    @Override
    protected void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of Atlan tags...");
        TypeDefResponse response = this.typeDefsEndpoint.list(List.of(AtlanTypeCategory.ATLAN_TAG, AtlanTypeCategory.STRUCT));
        try {
            for (int retryCount = 1; retryCount < this.client.getMaxNetworkRetries() && (response == null || response.getStructDefs() == null || response.getStructDefs().isEmpty()); ++retryCount) {
                Thread.sleep(HttpClient.waitTime(retryCount).toMillis());
                response = this.typeDefsEndpoint.list(List.of(AtlanTypeCategory.ATLAN_TAG, AtlanTypeCategory.STRUCT));
            }
        }
        catch (InterruptedException e) {
            log.warn(" ... retry loop interrupted.", (Throwable)e);
        }
        if (response == null || response.getStructDefs() == null || response.getStructDefs().isEmpty()) {
            throw new AuthenticationException(ErrorCode.EXPIRED_API_TOKEN);
        }
        List<AtlanTagDef> tags = response.getAtlanTagDefs();
        this.mapSidToSourceTagsAttrSid.clear();
        super.refreshCache();
        for (AtlanTagDef clsDef : tags) {
            String typeId = clsDef.getName();
            this.cache(clsDef.getGuid(), typeId, clsDef.getDisplayName(), clsDef);
            List<AttributeDef> attrs = clsDef.getAttributeDefs();
            String sourceTagsId = "";
            if (attrs != null && !attrs.isEmpty()) {
                for (AttributeDef attr : attrs) {
                    if (!"sourceTagAttachment".equals(attr.getDisplayName())) continue;
                    sourceTagsId = attr.getName();
                }
            }
            this.mapSidToSourceTagsAttrSid.put(typeId, sourceTagsId);
        }
    }

    @Override
    protected void lookupByName(String name) {
    }

    @Override
    protected void lookupById(String id) {
    }

    private String getSourceTagsAttrIdFromId(String id) {
        this.lock.readLock().lock();
        try {
            String string = this.mapSidToSourceTagsAttrSid.get(id);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getSourceTagsAttrId(String id) throws AtlanException {
        return this.getSourceTagsAttrId(id, true);
    }

    public String getSourceTagsAttrId(String id, boolean allowRefresh) throws AtlanException {
        return this.getSourceTagsAttrId(id, allowRefresh ? Long.MAX_VALUE : Long.MIN_VALUE);
    }

    public String getSourceTagsAttrId(String id, long minimumTime) throws AtlanException {
        if (id == null || id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_ATLAN_TAG_ID);
        }
        String attrId = this.getSourceTagsAttrIdFromId(id);
        if (attrId == null && !this.isDeletedId(id)) {
            this.refresh(minimumTime);
            attrId = this.getSourceTagsAttrIdFromId(id);
            if (attrId == null) {
                this.addDeletedId(id);
                throw new NotFoundException(ErrorCode.ATLAN_TAG_NOT_FOUND_BY_ID, id);
            }
        }
        return attrId;
    }
}

