/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.api.TypeDefsEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.AuthenticationException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.EnumDef;
import com.atlan.model.typedefs.TypeDefResponse;
import com.atlan.net.HttpClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnumCache.class);
    private volatile Map<String, EnumDef> cacheById = new ConcurrentHashMap<String, EnumDef>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final TypeDefsEndpoint typeDefsEndpoint;

    public EnumCache(TypeDefsEndpoint typeDefsEndpoint) {
        this.typeDefsEndpoint = typeDefsEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCache() throws AtlanException {
        this.lock.writeLock().lock();
        try {
            log.debug("Refreshing cache of enumerations...");
            TypeDefResponse response = this.typeDefsEndpoint.list(AtlanTypeCategory.ENUM);
            try {
                for (int retryCount = 1; retryCount < this.typeDefsEndpoint.getClient().getMaxNetworkRetries() && (response == null || response.getEnumDefs() == null || response.getEnumDefs().isEmpty()); ++retryCount) {
                    Thread.sleep(HttpClient.waitTime(retryCount).toMillis());
                    response = this.typeDefsEndpoint.list(List.of(AtlanTypeCategory.ENUM));
                }
            }
            catch (InterruptedException e) {
                log.warn(" ... retry loop interrupted.", (Throwable)e);
            }
            if (response == null || response.getEnumDefs() == null || response.getEnumDefs().isEmpty()) {
                throw new AuthenticationException(ErrorCode.EXPIRED_API_TOKEN);
            }
            List<EnumDef> enumerations = response.getEnumDefs();
            this.cacheById = new ConcurrentHashMap<String, EnumDef>();
            for (EnumDef enumDef : enumerations) {
                String typeId = enumDef.getName();
                this.cacheById.put(typeId, enumDef);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected EnumDef getObjectByName(String name) {
        this.lock.readLock().lock();
        try {
            EnumDef enumDef = this.cacheById.get(name);
            return enumDef;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public EnumDef getByName(String name) throws AtlanException {
        return this.getByName(name, true);
    }

    public EnumDef getByName(String name, boolean allowRefresh) throws AtlanException {
        if (name != null && !name.isEmpty()) {
            EnumDef enumDef = this.getObjectByName(name);
            if (enumDef == null) {
                if (allowRefresh) {
                    this.refreshCache();
                    enumDef = this.getObjectByName(name);
                }
                if (enumDef == null) {
                    throw new NotFoundException(ErrorCode.ENUM_NOT_FOUND, name);
                }
            }
            return enumDef;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ENUM_NAME);
    }
}

