/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.AtlanClient;
import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.SearchableAttribute;
import com.atlan.generators.TypeGenerator;
import com.atlan.generators.lombok.Singulars;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.RelationshipDef;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipGenerator
extends TypeGenerator
implements Comparable<RelationshipGenerator> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RelationshipGenerator.class);
    public static final String DIRECTORY = "relations";
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<RelationshipGenerator> relationshipComparator = Comparator.comparing(TypeGenerator::getOriginalName, stringComparator);
    private final RelationshipDef relationshipDef;
    private SortedSet<SearchableAttribute<?>> nonInheritedAttributes;
    private List<String> mapContainers = null;
    private String endDef1TypeName;
    private String endDef2TypeName;
    private String endDef1AttrName;
    private String endDef2AttrName = null;

    public RelationshipGenerator(AtlanClient client, RelationshipDef relationshipDef, GeneratorConfig cfg) {
        super(client, relationshipDef, cfg);
        this.relationshipDef = relationshipDef;
        this.resolveClassName();
        this.description = this.cache.getTypeDescription(this.originalName);
        this.resolveAttributes();
    }

    @Override
    protected void resolveClassName() {
        this.className = this.cfg.resolveClassName(this.originalName);
    }

    private void resolveAttributes() {
        this.nonInheritedAttributes = new TreeSet();
        for (AttributeDef attributeDef : this.cache.getRelationshipDefCache().get(this.getOriginalName()).getAttributeDefs()) {
            SearchableAttribute attribute = new SearchableAttribute(this.client, this.className, attributeDef, this.cfg);
            if (attribute.getType().getName().equals("Internal")) continue;
            this.nonInheritedAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
        this.endDef1TypeName = this.cfg.resolveClassName(this.relationshipDef.getEndDef1().getType());
        this.endDef2TypeName = this.cfg.resolveClassName(this.relationshipDef.getEndDef2().getType());
        String name1 = this.cfg.resolveAttributeName(this.relationshipDef.getEndDef1().getName());
        String name2 = this.cfg.resolveAttributeName(this.relationshipDef.getEndDef2().getName());
        String name1s = Singulars.autoSingularize(name1);
        String name2s = Singulars.autoSingularize(name2);
        String string = this.endDef1AttrName = name1s == null ? name1 : name1s;
        if (!name1.equals(name2)) {
            this.endDef2AttrName = name2s == null ? name2 : name2s;
        }
    }

    private void checkAndAddMapContainer(SearchableAttribute<?> attribute) {
        if (attribute.getType().getContainer() != null && attribute.getType().getContainer().contains("Map")) {
            if (this.mapContainers == null) {
                this.mapContainers = new ArrayList<String>();
            }
            this.mapContainers.add(attribute.getRenamed());
        }
    }

    @Override
    public int compareTo(RelationshipGenerator o) {
        return relationshipComparator.compare(this, o);
    }

    @Generated
    public RelationshipDef getRelationshipDef() {
        return this.relationshipDef;
    }

    @Generated
    public SortedSet<SearchableAttribute<?>> getNonInheritedAttributes() {
        return this.nonInheritedAttributes;
    }

    @Generated
    public List<String> getMapContainers() {
        return this.mapContainers;
    }

    @Generated
    public String getEndDef1TypeName() {
        return this.endDef1TypeName;
    }

    @Generated
    public String getEndDef2TypeName() {
        return this.endDef2TypeName;
    }

    @Generated
    public String getEndDef1AttrName() {
        return this.endDef1AttrName;
    }

    @Generated
    public String getEndDef2AttrName() {
        return this.endDef2AttrName;
    }
}

