/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.AnaplanModule;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAnaplan;
import com.atlan.model.assets.IAnaplanDimension;
import com.atlan.model.assets.IAnaplanModule;
import com.atlan.model.assets.IAnaplanView;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnaplanView
extends Asset
implements IAnaplanView,
IAnaplan,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnaplanView.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AnaplanView";
    String typeName;
    @Attribute
    SortedSet<IAnaplanDimension> anaplanColumnDimensions;
    @Attribute
    String anaplanModelName;
    @Attribute
    String anaplanModelQualifiedName;
    @Attribute
    IAnaplanModule anaplanModule;
    @Attribute
    String anaplanModuleName;
    @Attribute
    String anaplanModuleQualifiedName;
    @Attribute
    SortedSet<IAnaplanDimension> anaplanPageDimensions;
    @Attribute
    SortedSet<IAnaplanDimension> anaplanRowDimensions;
    @Attribute
    String anaplanSourceId;
    @Attribute
    String anaplanWorkspaceName;
    @Attribute
    String anaplanWorkspaceQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public AnaplanView trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AnaplanView.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AnaplanView.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AnaplanView.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AnaplanView.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AnaplanView refByGuid(String guid) {
        return AnaplanView.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AnaplanView refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AnaplanViewBuilder)((AnaplanViewBuilder)AnaplanView._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AnaplanView refByQualifiedName(String qualifiedName) {
        return AnaplanView.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AnaplanView refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AnaplanViewBuilder)((AnaplanViewBuilder)AnaplanView._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AnaplanView get(AtlanClient client, String id) throws AtlanException {
        return AnaplanView.get(client, id, false);
    }

    @JsonIgnore
    public static AnaplanView get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AnaplanView) {
                return (AnaplanView)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof AnaplanView) {
            return (AnaplanView)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static AnaplanView get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return AnaplanView.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static AnaplanView get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AnaplanView.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof AnaplanView) {
                return (AnaplanView)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AnaplanView.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof AnaplanView) {
            return (AnaplanView)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AnaplanViewBuilder<?, ?> creator(String name, AnaplanModule module) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("connectionQualifiedName", module.getConnectionQualifiedName());
        map.put("workspaceQualifiedName", module.getAnaplanWorkspaceQualifiedName());
        map.put("workspaceName", module.getAnaplanWorkspaceName());
        map.put("modelQualifiedName", module.getAnaplanModelQualifiedName());
        map.put("modelName", module.getAnaplanModelName());
        map.put("moduleQualifiedName", module.getQualifiedName());
        map.put("moduleName", module.getName());
        AnaplanView.validateRelationship("AnaplanWorkspace", map);
        return AnaplanView.creator(name, module.getConnectionQualifiedName(), module.getName(), module.getQualifiedName(), module.getAnaplanModelName(), module.getAnaplanModelQualifiedName(), module.getAnaplanWorkspaceName(), module.getAnaplanWorkspaceQualifiedName()).anaplanModule(module.trimToReference());
    }

    public static AnaplanViewBuilder<?, ?> creator(String name, String moduleQualifiedName) {
        String moduleName = StringUtils.getNameFromQualifiedName(moduleQualifiedName);
        String modelQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(moduleQualifiedName);
        String modelName = StringUtils.getNameFromQualifiedName(modelQualifiedName);
        String workspaceQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(modelQualifiedName);
        String workspaceName = StringUtils.getNameFromQualifiedName(workspaceQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(workspaceQualifiedName);
        return AnaplanView.creator(name, connectionQualifiedName, moduleName, moduleQualifiedName, modelName, modelQualifiedName, workspaceName, workspaceQualifiedName);
    }

    public static AnaplanViewBuilder<?, ?> creator(String name, String connectionQualifiedName, String moduleName, String moduleQualifiedName, String modelName, String modelQualifiedName, String workspaceName, String workspaceQualifiedName) {
        return ((AnaplanViewBuilder)((AnaplanViewBuilder)((AnaplanViewBuilder)((AnaplanViewBuilder)((AnaplanViewBuilder)((AnaplanViewBuilder)((AnaplanViewBuilder)((AnaplanViewBuilder)((AnaplanViewBuilder)((AnaplanViewBuilder)AnaplanView._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(AnaplanView.generateQualifiedName(name, moduleQualifiedName))).connectionQualifiedName(connectionQualifiedName)).anaplanWorkspaceName(workspaceName)).anaplanWorkspaceQualifiedName(workspaceQualifiedName)).anaplanModelName(modelName)).anaplanModelQualifiedName(modelQualifiedName)).anaplanModuleName(moduleName)).anaplanModuleQualifiedName(moduleQualifiedName)).anaplanModule(AnaplanModule.refByQualifiedName(moduleQualifiedName));
    }

    public static String generateQualifiedName(String name, String moduleQualifiedName) {
        return moduleQualifiedName + "/" + name;
    }

    public static AnaplanViewBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AnaplanViewBuilder)((AnaplanViewBuilder)((AnaplanViewBuilder)AnaplanView._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AnaplanViewBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        AnaplanView.validateRequired(TYPE_NAME, map);
        return AnaplanView.updater(this.getQualifiedName(), this.getName());
    }

    public static AnaplanView removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnaplanView)Asset.removeDescription(client, AnaplanView.updater(qualifiedName, name));
    }

    public static AnaplanView removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnaplanView)Asset.removeUserDescription(client, AnaplanView.updater(qualifiedName, name));
    }

    public static AnaplanView removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnaplanView)Asset.removeOwners(client, AnaplanView.updater(qualifiedName, name));
    }

    public static AnaplanView updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AnaplanView)Asset.updateCertificate(client, AnaplanView._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AnaplanView removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnaplanView)Asset.removeCertificate(client, AnaplanView.updater(qualifiedName, name));
    }

    public static AnaplanView updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AnaplanView)Asset.updateAnnouncement(client, AnaplanView._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AnaplanView removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnaplanView)Asset.removeAnnouncement(client, AnaplanView.updater(qualifiedName, name));
    }

    public static AnaplanView replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AnaplanView)Asset.replaceTerms(client, AnaplanView.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static AnaplanView appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AnaplanView)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AnaplanView removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AnaplanView)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AnaplanView appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AnaplanView)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static AnaplanView appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AnaplanView)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AnaplanView(AnaplanViewBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AnaplanView.$default$typeName();
        SortedSet<IAnaplanDimension> anaplanColumnDimensions = new TreeSet<IAnaplanDimension>();
        if (b.anaplanColumnDimensions != null) {
            anaplanColumnDimensions.addAll(b.anaplanColumnDimensions);
        }
        anaplanColumnDimensions = Collections.unmodifiableSortedSet(anaplanColumnDimensions);
        this.anaplanColumnDimensions = anaplanColumnDimensions;
        this.anaplanModelName = b.anaplanModelName;
        this.anaplanModelQualifiedName = b.anaplanModelQualifiedName;
        this.anaplanModule = b.anaplanModule;
        this.anaplanModuleName = b.anaplanModuleName;
        this.anaplanModuleQualifiedName = b.anaplanModuleQualifiedName;
        SortedSet<IAnaplanDimension> anaplanPageDimensions = new TreeSet<IAnaplanDimension>();
        if (b.anaplanPageDimensions != null) {
            anaplanPageDimensions.addAll(b.anaplanPageDimensions);
        }
        anaplanPageDimensions = Collections.unmodifiableSortedSet(anaplanPageDimensions);
        this.anaplanPageDimensions = anaplanPageDimensions;
        SortedSet<IAnaplanDimension> anaplanRowDimensions = new TreeSet<IAnaplanDimension>();
        if (b.anaplanRowDimensions != null) {
            anaplanRowDimensions.addAll(b.anaplanRowDimensions);
        }
        anaplanRowDimensions = Collections.unmodifiableSortedSet(anaplanRowDimensions);
        this.anaplanRowDimensions = anaplanRowDimensions;
        this.anaplanSourceId = b.anaplanSourceId;
        this.anaplanWorkspaceName = b.anaplanWorkspaceName;
        this.anaplanWorkspaceQualifiedName = b.anaplanWorkspaceQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static AnaplanViewBuilder<?, ?> _internal() {
        return new AnaplanViewBuilderImpl();
    }

    @Generated
    public AnaplanViewBuilder<?, ?> toBuilder() {
        return new AnaplanViewBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAnaplanDimension> getAnaplanColumnDimensions() {
        return this.anaplanColumnDimensions;
    }

    @Override
    @Generated
    public String getAnaplanModelName() {
        return this.anaplanModelName;
    }

    @Override
    @Generated
    public String getAnaplanModelQualifiedName() {
        return this.anaplanModelQualifiedName;
    }

    @Override
    @Generated
    public IAnaplanModule getAnaplanModule() {
        return this.anaplanModule;
    }

    @Override
    @Generated
    public String getAnaplanModuleName() {
        return this.anaplanModuleName;
    }

    @Override
    @Generated
    public String getAnaplanModuleQualifiedName() {
        return this.anaplanModuleQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAnaplanDimension> getAnaplanPageDimensions() {
        return this.anaplanPageDimensions;
    }

    @Override
    @Generated
    public SortedSet<IAnaplanDimension> getAnaplanRowDimensions() {
        return this.anaplanRowDimensions;
    }

    @Override
    @Generated
    public String getAnaplanSourceId() {
        return this.anaplanSourceId;
    }

    @Override
    @Generated
    public String getAnaplanWorkspaceName() {
        return this.anaplanWorkspaceName;
    }

    @Override
    @Generated
    public String getAnaplanWorkspaceQualifiedName() {
        return this.anaplanWorkspaceQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnaplanView)) {
            return false;
        }
        AnaplanView other = (AnaplanView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAnaplanDimension> this$anaplanColumnDimensions = this.getAnaplanColumnDimensions();
        SortedSet<IAnaplanDimension> other$anaplanColumnDimensions = other.getAnaplanColumnDimensions();
        if (this$anaplanColumnDimensions == null ? other$anaplanColumnDimensions != null : !this$anaplanColumnDimensions.equals(other$anaplanColumnDimensions)) {
            return false;
        }
        String this$anaplanModelName = this.getAnaplanModelName();
        String other$anaplanModelName = other.getAnaplanModelName();
        if (this$anaplanModelName == null ? other$anaplanModelName != null : !this$anaplanModelName.equals(other$anaplanModelName)) {
            return false;
        }
        String this$anaplanModelQualifiedName = this.getAnaplanModelQualifiedName();
        String other$anaplanModelQualifiedName = other.getAnaplanModelQualifiedName();
        if (this$anaplanModelQualifiedName == null ? other$anaplanModelQualifiedName != null : !this$anaplanModelQualifiedName.equals(other$anaplanModelQualifiedName)) {
            return false;
        }
        IAnaplanModule this$anaplanModule = this.getAnaplanModule();
        IAnaplanModule other$anaplanModule = other.getAnaplanModule();
        if (this$anaplanModule == null ? other$anaplanModule != null : !this$anaplanModule.equals(other$anaplanModule)) {
            return false;
        }
        String this$anaplanModuleName = this.getAnaplanModuleName();
        String other$anaplanModuleName = other.getAnaplanModuleName();
        if (this$anaplanModuleName == null ? other$anaplanModuleName != null : !this$anaplanModuleName.equals(other$anaplanModuleName)) {
            return false;
        }
        String this$anaplanModuleQualifiedName = this.getAnaplanModuleQualifiedName();
        String other$anaplanModuleQualifiedName = other.getAnaplanModuleQualifiedName();
        if (this$anaplanModuleQualifiedName == null ? other$anaplanModuleQualifiedName != null : !this$anaplanModuleQualifiedName.equals(other$anaplanModuleQualifiedName)) {
            return false;
        }
        SortedSet<IAnaplanDimension> this$anaplanPageDimensions = this.getAnaplanPageDimensions();
        SortedSet<IAnaplanDimension> other$anaplanPageDimensions = other.getAnaplanPageDimensions();
        if (this$anaplanPageDimensions == null ? other$anaplanPageDimensions != null : !this$anaplanPageDimensions.equals(other$anaplanPageDimensions)) {
            return false;
        }
        SortedSet<IAnaplanDimension> this$anaplanRowDimensions = this.getAnaplanRowDimensions();
        SortedSet<IAnaplanDimension> other$anaplanRowDimensions = other.getAnaplanRowDimensions();
        if (this$anaplanRowDimensions == null ? other$anaplanRowDimensions != null : !this$anaplanRowDimensions.equals(other$anaplanRowDimensions)) {
            return false;
        }
        String this$anaplanSourceId = this.getAnaplanSourceId();
        String other$anaplanSourceId = other.getAnaplanSourceId();
        if (this$anaplanSourceId == null ? other$anaplanSourceId != null : !this$anaplanSourceId.equals(other$anaplanSourceId)) {
            return false;
        }
        String this$anaplanWorkspaceName = this.getAnaplanWorkspaceName();
        String other$anaplanWorkspaceName = other.getAnaplanWorkspaceName();
        if (this$anaplanWorkspaceName == null ? other$anaplanWorkspaceName != null : !this$anaplanWorkspaceName.equals(other$anaplanWorkspaceName)) {
            return false;
        }
        String this$anaplanWorkspaceQualifiedName = this.getAnaplanWorkspaceQualifiedName();
        String other$anaplanWorkspaceQualifiedName = other.getAnaplanWorkspaceQualifiedName();
        if (this$anaplanWorkspaceQualifiedName == null ? other$anaplanWorkspaceQualifiedName != null : !this$anaplanWorkspaceQualifiedName.equals(other$anaplanWorkspaceQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnaplanView;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAnaplanDimension> $anaplanColumnDimensions = this.getAnaplanColumnDimensions();
        result = result * 59 + ($anaplanColumnDimensions == null ? 43 : $anaplanColumnDimensions.hashCode());
        String $anaplanModelName = this.getAnaplanModelName();
        result = result * 59 + ($anaplanModelName == null ? 43 : $anaplanModelName.hashCode());
        String $anaplanModelQualifiedName = this.getAnaplanModelQualifiedName();
        result = result * 59 + ($anaplanModelQualifiedName == null ? 43 : $anaplanModelQualifiedName.hashCode());
        IAnaplanModule $anaplanModule = this.getAnaplanModule();
        result = result * 59 + ($anaplanModule == null ? 43 : $anaplanModule.hashCode());
        String $anaplanModuleName = this.getAnaplanModuleName();
        result = result * 59 + ($anaplanModuleName == null ? 43 : $anaplanModuleName.hashCode());
        String $anaplanModuleQualifiedName = this.getAnaplanModuleQualifiedName();
        result = result * 59 + ($anaplanModuleQualifiedName == null ? 43 : $anaplanModuleQualifiedName.hashCode());
        SortedSet<IAnaplanDimension> $anaplanPageDimensions = this.getAnaplanPageDimensions();
        result = result * 59 + ($anaplanPageDimensions == null ? 43 : $anaplanPageDimensions.hashCode());
        SortedSet<IAnaplanDimension> $anaplanRowDimensions = this.getAnaplanRowDimensions();
        result = result * 59 + ($anaplanRowDimensions == null ? 43 : $anaplanRowDimensions.hashCode());
        String $anaplanSourceId = this.getAnaplanSourceId();
        result = result * 59 + ($anaplanSourceId == null ? 43 : $anaplanSourceId.hashCode());
        String $anaplanWorkspaceName = this.getAnaplanWorkspaceName();
        result = result * 59 + ($anaplanWorkspaceName == null ? 43 : $anaplanWorkspaceName.hashCode());
        String $anaplanWorkspaceQualifiedName = this.getAnaplanWorkspaceQualifiedName();
        result = result * 59 + ($anaplanWorkspaceQualifiedName == null ? 43 : $anaplanWorkspaceQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AnaplanView(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", anaplanColumnDimensions=" + String.valueOf(this.getAnaplanColumnDimensions()) + ", anaplanModelName=" + this.getAnaplanModelName() + ", anaplanModelQualifiedName=" + this.getAnaplanModelQualifiedName() + ", anaplanModule=" + String.valueOf(this.getAnaplanModule()) + ", anaplanModuleName=" + this.getAnaplanModuleName() + ", anaplanModuleQualifiedName=" + this.getAnaplanModuleQualifiedName() + ", anaplanPageDimensions=" + String.valueOf(this.getAnaplanPageDimensions()) + ", anaplanRowDimensions=" + String.valueOf(this.getAnaplanRowDimensions()) + ", anaplanSourceId=" + this.getAnaplanSourceId() + ", anaplanWorkspaceName=" + this.getAnaplanWorkspaceName() + ", anaplanWorkspaceQualifiedName=" + this.getAnaplanWorkspaceQualifiedName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class AnaplanViewBuilder<C extends AnaplanView, B extends AnaplanViewBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAnaplanDimension> anaplanColumnDimensions;
        @Generated
        private String anaplanModelName;
        @Generated
        private String anaplanModelQualifiedName;
        @Generated
        private IAnaplanModule anaplanModule;
        @Generated
        private String anaplanModuleName;
        @Generated
        private String anaplanModuleQualifiedName;
        @Generated
        private ArrayList<IAnaplanDimension> anaplanPageDimensions;
        @Generated
        private ArrayList<IAnaplanDimension> anaplanRowDimensions;
        @Generated
        private String anaplanSourceId;
        @Generated
        private String anaplanWorkspaceName;
        @Generated
        private String anaplanWorkspaceQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AnaplanViewBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AnaplanView instance, AnaplanViewBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.anaplanColumnDimensions(instance.anaplanColumnDimensions == null ? Collections.emptySortedSet() : instance.anaplanColumnDimensions);
            b.anaplanModelName(instance.anaplanModelName);
            b.anaplanModelQualifiedName(instance.anaplanModelQualifiedName);
            b.anaplanModule(instance.anaplanModule);
            b.anaplanModuleName(instance.anaplanModuleName);
            b.anaplanModuleQualifiedName(instance.anaplanModuleQualifiedName);
            b.anaplanPageDimensions(instance.anaplanPageDimensions == null ? Collections.emptySortedSet() : instance.anaplanPageDimensions);
            b.anaplanRowDimensions(instance.anaplanRowDimensions == null ? Collections.emptySortedSet() : instance.anaplanRowDimensions);
            b.anaplanSourceId(instance.anaplanSourceId);
            b.anaplanWorkspaceName(instance.anaplanWorkspaceName);
            b.anaplanWorkspaceQualifiedName(instance.anaplanWorkspaceQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B anaplanColumnDimension(IAnaplanDimension anaplanColumnDimension) {
            if (this.anaplanColumnDimensions == null) {
                this.anaplanColumnDimensions = new ArrayList();
            }
            this.anaplanColumnDimensions.add(anaplanColumnDimension);
            return (B)this.self();
        }

        @Generated
        public B anaplanColumnDimensions(Collection<? extends IAnaplanDimension> anaplanColumnDimensions) {
            if (anaplanColumnDimensions == null) {
                throw new NullPointerException("anaplanColumnDimensions cannot be null");
            }
            if (this.anaplanColumnDimensions == null) {
                this.anaplanColumnDimensions = new ArrayList();
            }
            this.anaplanColumnDimensions.addAll(anaplanColumnDimensions);
            return (B)this.self();
        }

        @Generated
        public B clearAnaplanColumnDimensions() {
            if (this.anaplanColumnDimensions != null) {
                this.anaplanColumnDimensions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B anaplanModelName(String anaplanModelName) {
            this.anaplanModelName = anaplanModelName;
            return (B)this.self();
        }

        @Generated
        public B anaplanModelQualifiedName(String anaplanModelQualifiedName) {
            this.anaplanModelQualifiedName = anaplanModelQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B anaplanModule(IAnaplanModule anaplanModule) {
            this.anaplanModule = anaplanModule;
            return (B)this.self();
        }

        @Generated
        public B anaplanModuleName(String anaplanModuleName) {
            this.anaplanModuleName = anaplanModuleName;
            return (B)this.self();
        }

        @Generated
        public B anaplanModuleQualifiedName(String anaplanModuleQualifiedName) {
            this.anaplanModuleQualifiedName = anaplanModuleQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B anaplanPageDimension(IAnaplanDimension anaplanPageDimension) {
            if (this.anaplanPageDimensions == null) {
                this.anaplanPageDimensions = new ArrayList();
            }
            this.anaplanPageDimensions.add(anaplanPageDimension);
            return (B)this.self();
        }

        @Generated
        public B anaplanPageDimensions(Collection<? extends IAnaplanDimension> anaplanPageDimensions) {
            if (anaplanPageDimensions == null) {
                throw new NullPointerException("anaplanPageDimensions cannot be null");
            }
            if (this.anaplanPageDimensions == null) {
                this.anaplanPageDimensions = new ArrayList();
            }
            this.anaplanPageDimensions.addAll(anaplanPageDimensions);
            return (B)this.self();
        }

        @Generated
        public B clearAnaplanPageDimensions() {
            if (this.anaplanPageDimensions != null) {
                this.anaplanPageDimensions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B anaplanRowDimension(IAnaplanDimension anaplanRowDimension) {
            if (this.anaplanRowDimensions == null) {
                this.anaplanRowDimensions = new ArrayList();
            }
            this.anaplanRowDimensions.add(anaplanRowDimension);
            return (B)this.self();
        }

        @Generated
        public B anaplanRowDimensions(Collection<? extends IAnaplanDimension> anaplanRowDimensions) {
            if (anaplanRowDimensions == null) {
                throw new NullPointerException("anaplanRowDimensions cannot be null");
            }
            if (this.anaplanRowDimensions == null) {
                this.anaplanRowDimensions = new ArrayList();
            }
            this.anaplanRowDimensions.addAll(anaplanRowDimensions);
            return (B)this.self();
        }

        @Generated
        public B clearAnaplanRowDimensions() {
            if (this.anaplanRowDimensions != null) {
                this.anaplanRowDimensions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B anaplanSourceId(String anaplanSourceId) {
            this.anaplanSourceId = anaplanSourceId;
            return (B)this.self();
        }

        @Generated
        public B anaplanWorkspaceName(String anaplanWorkspaceName) {
            this.anaplanWorkspaceName = anaplanWorkspaceName;
            return (B)this.self();
        }

        @Generated
        public B anaplanWorkspaceQualifiedName(String anaplanWorkspaceQualifiedName) {
            this.anaplanWorkspaceQualifiedName = anaplanWorkspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AnaplanView.AnaplanViewBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", anaplanColumnDimensions=" + String.valueOf(this.anaplanColumnDimensions) + ", anaplanModelName=" + this.anaplanModelName + ", anaplanModelQualifiedName=" + this.anaplanModelQualifiedName + ", anaplanModule=" + String.valueOf(this.anaplanModule) + ", anaplanModuleName=" + this.anaplanModuleName + ", anaplanModuleQualifiedName=" + this.anaplanModuleQualifiedName + ", anaplanPageDimensions=" + String.valueOf(this.anaplanPageDimensions) + ", anaplanRowDimensions=" + String.valueOf(this.anaplanRowDimensions) + ", anaplanSourceId=" + this.anaplanSourceId + ", anaplanWorkspaceName=" + this.anaplanWorkspaceName + ", anaplanWorkspaceQualifiedName=" + this.anaplanWorkspaceQualifiedName + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class AnaplanViewBuilderImpl
    extends AnaplanViewBuilder<AnaplanView, AnaplanViewBuilderImpl> {
        @Generated
        private AnaplanViewBuilderImpl() {
        }

        @Override
        @Generated
        protected AnaplanViewBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AnaplanView build() {
            return new AnaplanView(this);
        }
    }
}

