/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAzureServiceBus;
import com.atlan.model.assets.IAzureServiceBusSchema;
import com.atlan.model.assets.IAzureServiceBusTopic;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IEventStore;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureServiceBusSchema
extends Asset
implements IAzureServiceBusSchema,
IAzureServiceBus,
IEventStore,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureServiceBusSchema.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AzureServiceBusSchema";
    String typeName;
    @Attribute
    String azureServiceBusNamespaceName;
    @Attribute
    String azureServiceBusNamespaceQualifiedName;
    @Attribute
    String azureServiceBusSchemaQualifiedName;
    @Attribute
    SortedSet<IAzureServiceBusTopic> azureServiceBusTopics;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public AzureServiceBusSchema trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AzureServiceBusSchema.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AzureServiceBusSchema.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AzureServiceBusSchema.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AzureServiceBusSchema.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AzureServiceBusSchema refByGuid(String guid) {
        return AzureServiceBusSchema.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AzureServiceBusSchema refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AzureServiceBusSchemaBuilder)((AzureServiceBusSchemaBuilder)AzureServiceBusSchema._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AzureServiceBusSchema refByQualifiedName(String qualifiedName) {
        return AzureServiceBusSchema.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AzureServiceBusSchema refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AzureServiceBusSchemaBuilder)((AzureServiceBusSchemaBuilder)AzureServiceBusSchema._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AzureServiceBusSchema get(AtlanClient client, String id) throws AtlanException {
        return AzureServiceBusSchema.get(client, id, false);
    }

    @JsonIgnore
    public static AzureServiceBusSchema get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AzureServiceBusSchema) {
                return (AzureServiceBusSchema)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof AzureServiceBusSchema) {
            return (AzureServiceBusSchema)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static AzureServiceBusSchema get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return AzureServiceBusSchema.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static AzureServiceBusSchema get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AzureServiceBusSchema.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof AzureServiceBusSchema) {
                return (AzureServiceBusSchema)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AzureServiceBusSchema.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof AzureServiceBusSchema) {
            return (AzureServiceBusSchema)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AzureServiceBusSchemaBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AzureServiceBusSchemaBuilder)((AzureServiceBusSchemaBuilder)((AzureServiceBusSchemaBuilder)AzureServiceBusSchema._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AzureServiceBusSchemaBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        AzureServiceBusSchema.validateRequired(TYPE_NAME, map);
        return AzureServiceBusSchema.updater(this.getQualifiedName(), this.getName());
    }

    public static AzureServiceBusSchema removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureServiceBusSchema)Asset.removeDescription(client, AzureServiceBusSchema.updater(qualifiedName, name));
    }

    public static AzureServiceBusSchema removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureServiceBusSchema)Asset.removeUserDescription(client, AzureServiceBusSchema.updater(qualifiedName, name));
    }

    public static AzureServiceBusSchema removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureServiceBusSchema)Asset.removeOwners(client, AzureServiceBusSchema.updater(qualifiedName, name));
    }

    public static AzureServiceBusSchema updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AzureServiceBusSchema)Asset.updateCertificate(client, AzureServiceBusSchema._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AzureServiceBusSchema removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureServiceBusSchema)Asset.removeCertificate(client, AzureServiceBusSchema.updater(qualifiedName, name));
    }

    public static AzureServiceBusSchema updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AzureServiceBusSchema)Asset.updateAnnouncement(client, AzureServiceBusSchema._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AzureServiceBusSchema removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AzureServiceBusSchema)Asset.removeAnnouncement(client, AzureServiceBusSchema.updater(qualifiedName, name));
    }

    public static AzureServiceBusSchema replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AzureServiceBusSchema)Asset.replaceTerms(client, AzureServiceBusSchema.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static AzureServiceBusSchema appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AzureServiceBusSchema)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AzureServiceBusSchema removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AzureServiceBusSchema)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AzureServiceBusSchema appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AzureServiceBusSchema)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static AzureServiceBusSchema appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AzureServiceBusSchema)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AzureServiceBusSchema(AzureServiceBusSchemaBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AzureServiceBusSchema.$default$typeName();
        this.azureServiceBusNamespaceName = b.azureServiceBusNamespaceName;
        this.azureServiceBusNamespaceQualifiedName = b.azureServiceBusNamespaceQualifiedName;
        this.azureServiceBusSchemaQualifiedName = b.azureServiceBusSchemaQualifiedName;
        SortedSet<IAzureServiceBusTopic> azureServiceBusTopics = new TreeSet<IAzureServiceBusTopic>();
        if (b.azureServiceBusTopics != null) {
            azureServiceBusTopics.addAll(b.azureServiceBusTopics);
        }
        azureServiceBusTopics = Collections.unmodifiableSortedSet(azureServiceBusTopics);
        this.azureServiceBusTopics = azureServiceBusTopics;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static AzureServiceBusSchemaBuilder<?, ?> _internal() {
        return new AzureServiceBusSchemaBuilderImpl();
    }

    @Generated
    public AzureServiceBusSchemaBuilder<?, ?> toBuilder() {
        return new AzureServiceBusSchemaBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getAzureServiceBusNamespaceName() {
        return this.azureServiceBusNamespaceName;
    }

    @Override
    @Generated
    public String getAzureServiceBusNamespaceQualifiedName() {
        return this.azureServiceBusNamespaceQualifiedName;
    }

    @Override
    @Generated
    public String getAzureServiceBusSchemaQualifiedName() {
        return this.azureServiceBusSchemaQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAzureServiceBusTopic> getAzureServiceBusTopics() {
        return this.azureServiceBusTopics;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureServiceBusSchema)) {
            return false;
        }
        AzureServiceBusSchema other = (AzureServiceBusSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$azureServiceBusNamespaceName = this.getAzureServiceBusNamespaceName();
        String other$azureServiceBusNamespaceName = other.getAzureServiceBusNamespaceName();
        if (this$azureServiceBusNamespaceName == null ? other$azureServiceBusNamespaceName != null : !this$azureServiceBusNamespaceName.equals(other$azureServiceBusNamespaceName)) {
            return false;
        }
        String this$azureServiceBusNamespaceQualifiedName = this.getAzureServiceBusNamespaceQualifiedName();
        String other$azureServiceBusNamespaceQualifiedName = other.getAzureServiceBusNamespaceQualifiedName();
        if (this$azureServiceBusNamespaceQualifiedName == null ? other$azureServiceBusNamespaceQualifiedName != null : !this$azureServiceBusNamespaceQualifiedName.equals(other$azureServiceBusNamespaceQualifiedName)) {
            return false;
        }
        String this$azureServiceBusSchemaQualifiedName = this.getAzureServiceBusSchemaQualifiedName();
        String other$azureServiceBusSchemaQualifiedName = other.getAzureServiceBusSchemaQualifiedName();
        if (this$azureServiceBusSchemaQualifiedName == null ? other$azureServiceBusSchemaQualifiedName != null : !this$azureServiceBusSchemaQualifiedName.equals(other$azureServiceBusSchemaQualifiedName)) {
            return false;
        }
        SortedSet<IAzureServiceBusTopic> this$azureServiceBusTopics = this.getAzureServiceBusTopics();
        SortedSet<IAzureServiceBusTopic> other$azureServiceBusTopics = other.getAzureServiceBusTopics();
        if (this$azureServiceBusTopics == null ? other$azureServiceBusTopics != null : !this$azureServiceBusTopics.equals(other$azureServiceBusTopics)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AzureServiceBusSchema;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $azureServiceBusNamespaceName = this.getAzureServiceBusNamespaceName();
        result = result * 59 + ($azureServiceBusNamespaceName == null ? 43 : $azureServiceBusNamespaceName.hashCode());
        String $azureServiceBusNamespaceQualifiedName = this.getAzureServiceBusNamespaceQualifiedName();
        result = result * 59 + ($azureServiceBusNamespaceQualifiedName == null ? 43 : $azureServiceBusNamespaceQualifiedName.hashCode());
        String $azureServiceBusSchemaQualifiedName = this.getAzureServiceBusSchemaQualifiedName();
        result = result * 59 + ($azureServiceBusSchemaQualifiedName == null ? 43 : $azureServiceBusSchemaQualifiedName.hashCode());
        SortedSet<IAzureServiceBusTopic> $azureServiceBusTopics = this.getAzureServiceBusTopics();
        result = result * 59 + ($azureServiceBusTopics == null ? 43 : $azureServiceBusTopics.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AzureServiceBusSchema(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", azureServiceBusNamespaceName=" + this.getAzureServiceBusNamespaceName() + ", azureServiceBusNamespaceQualifiedName=" + this.getAzureServiceBusNamespaceQualifiedName() + ", azureServiceBusSchemaQualifiedName=" + this.getAzureServiceBusSchemaQualifiedName() + ", azureServiceBusTopics=" + String.valueOf(this.getAzureServiceBusTopics()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class AzureServiceBusSchemaBuilder<C extends AzureServiceBusSchema, B extends AzureServiceBusSchemaBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String azureServiceBusNamespaceName;
        @Generated
        private String azureServiceBusNamespaceQualifiedName;
        @Generated
        private String azureServiceBusSchemaQualifiedName;
        @Generated
        private ArrayList<IAzureServiceBusTopic> azureServiceBusTopics;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AzureServiceBusSchemaBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AzureServiceBusSchema instance, AzureServiceBusSchemaBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.azureServiceBusNamespaceName(instance.azureServiceBusNamespaceName);
            b.azureServiceBusNamespaceQualifiedName(instance.azureServiceBusNamespaceQualifiedName);
            b.azureServiceBusSchemaQualifiedName(instance.azureServiceBusSchemaQualifiedName);
            b.azureServiceBusTopics(instance.azureServiceBusTopics == null ? Collections.emptySortedSet() : instance.azureServiceBusTopics);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B azureServiceBusNamespaceName(String azureServiceBusNamespaceName) {
            this.azureServiceBusNamespaceName = azureServiceBusNamespaceName;
            return (B)this.self();
        }

        @Generated
        public B azureServiceBusNamespaceQualifiedName(String azureServiceBusNamespaceQualifiedName) {
            this.azureServiceBusNamespaceQualifiedName = azureServiceBusNamespaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B azureServiceBusSchemaQualifiedName(String azureServiceBusSchemaQualifiedName) {
            this.azureServiceBusSchemaQualifiedName = azureServiceBusSchemaQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B azureServiceBusTopic(IAzureServiceBusTopic azureServiceBusTopic) {
            if (this.azureServiceBusTopics == null) {
                this.azureServiceBusTopics = new ArrayList();
            }
            this.azureServiceBusTopics.add(azureServiceBusTopic);
            return (B)this.self();
        }

        @Generated
        public B azureServiceBusTopics(Collection<? extends IAzureServiceBusTopic> azureServiceBusTopics) {
            if (azureServiceBusTopics == null) {
                throw new NullPointerException("azureServiceBusTopics cannot be null");
            }
            if (this.azureServiceBusTopics == null) {
                this.azureServiceBusTopics = new ArrayList();
            }
            this.azureServiceBusTopics.addAll(azureServiceBusTopics);
            return (B)this.self();
        }

        @Generated
        public B clearAzureServiceBusTopics() {
            if (this.azureServiceBusTopics != null) {
                this.azureServiceBusTopics.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AzureServiceBusSchema.AzureServiceBusSchemaBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", azureServiceBusNamespaceName=" + this.azureServiceBusNamespaceName + ", azureServiceBusNamespaceQualifiedName=" + this.azureServiceBusNamespaceQualifiedName + ", azureServiceBusSchemaQualifiedName=" + this.azureServiceBusSchemaQualifiedName + ", azureServiceBusTopics=" + String.valueOf(this.azureServiceBusTopics) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class AzureServiceBusSchemaBuilderImpl
    extends AzureServiceBusSchemaBuilder<AzureServiceBusSchema, AzureServiceBusSchemaBuilderImpl> {
        @Generated
        private AzureServiceBusSchemaBuilderImpl() {
        }

        @Override
        @Generated
        protected AzureServiceBusSchemaBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AzureServiceBusSchema build() {
            return new AzureServiceBusSchema(this);
        }
    }
}

