/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBusinessPolicyIncident;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IIncident;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.IncidentSeverity;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessPolicyIncident
extends Asset
implements IBusinessPolicyIncident,
IIncident,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessPolicyIncident.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "BusinessPolicyIncident";
    String typeName;
    @Attribute
    String businessPolicyIncidentFilterDSL;
    @Attribute
    Long businessPolicyIncidentNoncompliantCount;
    @Attribute
    SortedSet<String> businessPolicyIncidentRelatedPolicyGUIDs;
    @Attribute
    IncidentSeverity incidentSeverity;

    @Override
    public BusinessPolicyIncident trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return BusinessPolicyIncident.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return BusinessPolicyIncident.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return BusinessPolicyIncident.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return BusinessPolicyIncident.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static BusinessPolicyIncident refByGuid(String guid) {
        return BusinessPolicyIncident.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static BusinessPolicyIncident refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((BusinessPolicyIncidentBuilder)((BusinessPolicyIncidentBuilder)BusinessPolicyIncident._internal().guid(guid)).semantic(semantic)).build();
    }

    public static BusinessPolicyIncident refByQualifiedName(String qualifiedName) {
        return BusinessPolicyIncident.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static BusinessPolicyIncident refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((BusinessPolicyIncidentBuilder)((BusinessPolicyIncidentBuilder)BusinessPolicyIncident._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static BusinessPolicyIncident get(AtlanClient client, String id) throws AtlanException {
        return BusinessPolicyIncident.get(client, id, false);
    }

    @JsonIgnore
    public static BusinessPolicyIncident get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof BusinessPolicyIncident) {
                return (BusinessPolicyIncident)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof BusinessPolicyIncident) {
            return (BusinessPolicyIncident)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static BusinessPolicyIncident get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return BusinessPolicyIncident.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static BusinessPolicyIncident get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)BusinessPolicyIncident.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof BusinessPolicyIncident) {
                return (BusinessPolicyIncident)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)BusinessPolicyIncident.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof BusinessPolicyIncident) {
            return (BusinessPolicyIncident)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static BusinessPolicyIncidentBuilder<?, ?> updater(String qualifiedName, String name) {
        return (BusinessPolicyIncidentBuilder)((BusinessPolicyIncidentBuilder)((BusinessPolicyIncidentBuilder)BusinessPolicyIncident._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public BusinessPolicyIncidentBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        BusinessPolicyIncident.validateRequired(TYPE_NAME, map);
        return BusinessPolicyIncident.updater(this.getQualifiedName(), this.getName());
    }

    public static BusinessPolicyIncident removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyIncident)Asset.removeDescription(client, BusinessPolicyIncident.updater(qualifiedName, name));
    }

    public static BusinessPolicyIncident removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyIncident)Asset.removeUserDescription(client, BusinessPolicyIncident.updater(qualifiedName, name));
    }

    public static BusinessPolicyIncident removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyIncident)Asset.removeOwners(client, BusinessPolicyIncident.updater(qualifiedName, name));
    }

    public static BusinessPolicyIncident updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (BusinessPolicyIncident)Asset.updateCertificate(client, BusinessPolicyIncident._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static BusinessPolicyIncident removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyIncident)Asset.removeCertificate(client, BusinessPolicyIncident.updater(qualifiedName, name));
    }

    public static BusinessPolicyIncident updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (BusinessPolicyIncident)Asset.updateAnnouncement(client, BusinessPolicyIncident._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static BusinessPolicyIncident removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyIncident)Asset.removeAnnouncement(client, BusinessPolicyIncident.updater(qualifiedName, name));
    }

    public static BusinessPolicyIncident replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicyIncident)Asset.replaceTerms(client, BusinessPolicyIncident.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static BusinessPolicyIncident appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicyIncident)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static BusinessPolicyIncident removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicyIncident)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static BusinessPolicyIncident appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (BusinessPolicyIncident)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static BusinessPolicyIncident appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (BusinessPolicyIncident)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected BusinessPolicyIncident(BusinessPolicyIncidentBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : BusinessPolicyIncident.$default$typeName();
        this.businessPolicyIncidentFilterDSL = b.businessPolicyIncidentFilterDSL;
        this.businessPolicyIncidentNoncompliantCount = b.businessPolicyIncidentNoncompliantCount;
        SortedSet<String> businessPolicyIncidentRelatedPolicyGUIDs = new TreeSet<String>();
        if (b.businessPolicyIncidentRelatedPolicyGUIDs != null) {
            businessPolicyIncidentRelatedPolicyGUIDs.addAll(b.businessPolicyIncidentRelatedPolicyGUIDs);
        }
        businessPolicyIncidentRelatedPolicyGUIDs = Collections.unmodifiableSortedSet(businessPolicyIncidentRelatedPolicyGUIDs);
        this.businessPolicyIncidentRelatedPolicyGUIDs = businessPolicyIncidentRelatedPolicyGUIDs;
        this.incidentSeverity = b.incidentSeverity;
    }

    @Generated
    public static BusinessPolicyIncidentBuilder<?, ?> _internal() {
        return new BusinessPolicyIncidentBuilderImpl();
    }

    @Generated
    public BusinessPolicyIncidentBuilder<?, ?> toBuilder() {
        return new BusinessPolicyIncidentBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getBusinessPolicyIncidentFilterDSL() {
        return this.businessPolicyIncidentFilterDSL;
    }

    @Override
    @Generated
    public Long getBusinessPolicyIncidentNoncompliantCount() {
        return this.businessPolicyIncidentNoncompliantCount;
    }

    @Override
    @Generated
    public SortedSet<String> getBusinessPolicyIncidentRelatedPolicyGUIDs() {
        return this.businessPolicyIncidentRelatedPolicyGUIDs;
    }

    @Override
    @Generated
    public IncidentSeverity getIncidentSeverity() {
        return this.incidentSeverity;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessPolicyIncident)) {
            return false;
        }
        BusinessPolicyIncident other = (BusinessPolicyIncident)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$businessPolicyIncidentNoncompliantCount = this.getBusinessPolicyIncidentNoncompliantCount();
        Long other$businessPolicyIncidentNoncompliantCount = other.getBusinessPolicyIncidentNoncompliantCount();
        if (this$businessPolicyIncidentNoncompliantCount == null ? other$businessPolicyIncidentNoncompliantCount != null : !((Object)this$businessPolicyIncidentNoncompliantCount).equals(other$businessPolicyIncidentNoncompliantCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$businessPolicyIncidentFilterDSL = this.getBusinessPolicyIncidentFilterDSL();
        String other$businessPolicyIncidentFilterDSL = other.getBusinessPolicyIncidentFilterDSL();
        if (this$businessPolicyIncidentFilterDSL == null ? other$businessPolicyIncidentFilterDSL != null : !this$businessPolicyIncidentFilterDSL.equals(other$businessPolicyIncidentFilterDSL)) {
            return false;
        }
        SortedSet<String> this$businessPolicyIncidentRelatedPolicyGUIDs = this.getBusinessPolicyIncidentRelatedPolicyGUIDs();
        SortedSet<String> other$businessPolicyIncidentRelatedPolicyGUIDs = other.getBusinessPolicyIncidentRelatedPolicyGUIDs();
        if (this$businessPolicyIncidentRelatedPolicyGUIDs == null ? other$businessPolicyIncidentRelatedPolicyGUIDs != null : !this$businessPolicyIncidentRelatedPolicyGUIDs.equals(other$businessPolicyIncidentRelatedPolicyGUIDs)) {
            return false;
        }
        IncidentSeverity this$incidentSeverity = this.getIncidentSeverity();
        IncidentSeverity other$incidentSeverity = other.getIncidentSeverity();
        return !(this$incidentSeverity == null ? other$incidentSeverity != null : !this$incidentSeverity.equals(other$incidentSeverity));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BusinessPolicyIncident;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $businessPolicyIncidentNoncompliantCount = this.getBusinessPolicyIncidentNoncompliantCount();
        result = result * 59 + ($businessPolicyIncidentNoncompliantCount == null ? 43 : ((Object)$businessPolicyIncidentNoncompliantCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $businessPolicyIncidentFilterDSL = this.getBusinessPolicyIncidentFilterDSL();
        result = result * 59 + ($businessPolicyIncidentFilterDSL == null ? 43 : $businessPolicyIncidentFilterDSL.hashCode());
        SortedSet<String> $businessPolicyIncidentRelatedPolicyGUIDs = this.getBusinessPolicyIncidentRelatedPolicyGUIDs();
        result = result * 59 + ($businessPolicyIncidentRelatedPolicyGUIDs == null ? 43 : $businessPolicyIncidentRelatedPolicyGUIDs.hashCode());
        IncidentSeverity $incidentSeverity = this.getIncidentSeverity();
        result = result * 59 + ($incidentSeverity == null ? 43 : $incidentSeverity.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BusinessPolicyIncident(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", businessPolicyIncidentFilterDSL=" + this.getBusinessPolicyIncidentFilterDSL() + ", businessPolicyIncidentNoncompliantCount=" + this.getBusinessPolicyIncidentNoncompliantCount() + ", businessPolicyIncidentRelatedPolicyGUIDs=" + String.valueOf(this.getBusinessPolicyIncidentRelatedPolicyGUIDs()) + ", incidentSeverity=" + String.valueOf(this.getIncidentSeverity()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class BusinessPolicyIncidentBuilder<C extends BusinessPolicyIncident, B extends BusinessPolicyIncidentBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String businessPolicyIncidentFilterDSL;
        @Generated
        private Long businessPolicyIncidentNoncompliantCount;
        @Generated
        private ArrayList<String> businessPolicyIncidentRelatedPolicyGUIDs;
        @Generated
        private IncidentSeverity incidentSeverity;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BusinessPolicyIncidentBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BusinessPolicyIncident instance, BusinessPolicyIncidentBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.businessPolicyIncidentFilterDSL(instance.businessPolicyIncidentFilterDSL);
            b.businessPolicyIncidentNoncompliantCount(instance.businessPolicyIncidentNoncompliantCount);
            b.businessPolicyIncidentRelatedPolicyGUIDs(instance.businessPolicyIncidentRelatedPolicyGUIDs == null ? Collections.emptySortedSet() : instance.businessPolicyIncidentRelatedPolicyGUIDs);
            b.incidentSeverity(instance.incidentSeverity);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyIncidentFilterDSL(String businessPolicyIncidentFilterDSL) {
            this.businessPolicyIncidentFilterDSL = businessPolicyIncidentFilterDSL;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyIncidentNoncompliantCount(Long businessPolicyIncidentNoncompliantCount) {
            this.businessPolicyIncidentNoncompliantCount = businessPolicyIncidentNoncompliantCount;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyIncidentRelatedPolicyGUID(String businessPolicyIncidentRelatedPolicyGUID) {
            if (this.businessPolicyIncidentRelatedPolicyGUIDs == null) {
                this.businessPolicyIncidentRelatedPolicyGUIDs = new ArrayList();
            }
            this.businessPolicyIncidentRelatedPolicyGUIDs.add(businessPolicyIncidentRelatedPolicyGUID);
            return (B)this.self();
        }

        @Generated
        public B businessPolicyIncidentRelatedPolicyGUIDs(Collection<? extends String> businessPolicyIncidentRelatedPolicyGUIDs) {
            if (businessPolicyIncidentRelatedPolicyGUIDs == null) {
                throw new NullPointerException("businessPolicyIncidentRelatedPolicyGUIDs cannot be null");
            }
            if (this.businessPolicyIncidentRelatedPolicyGUIDs == null) {
                this.businessPolicyIncidentRelatedPolicyGUIDs = new ArrayList();
            }
            this.businessPolicyIncidentRelatedPolicyGUIDs.addAll(businessPolicyIncidentRelatedPolicyGUIDs);
            return (B)this.self();
        }

        @Generated
        public B clearBusinessPolicyIncidentRelatedPolicyGUIDs() {
            if (this.businessPolicyIncidentRelatedPolicyGUIDs != null) {
                this.businessPolicyIncidentRelatedPolicyGUIDs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B incidentSeverity(IncidentSeverity incidentSeverity) {
            this.incidentSeverity = incidentSeverity;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BusinessPolicyIncident.BusinessPolicyIncidentBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", businessPolicyIncidentFilterDSL=" + this.businessPolicyIncidentFilterDSL + ", businessPolicyIncidentNoncompliantCount=" + this.businessPolicyIncidentNoncompliantCount + ", businessPolicyIncidentRelatedPolicyGUIDs=" + String.valueOf(this.businessPolicyIncidentRelatedPolicyGUIDs) + ", incidentSeverity=" + String.valueOf(this.incidentSeverity) + ")";
        }
    }

    @Generated
    private static final class BusinessPolicyIncidentBuilderImpl
    extends BusinessPolicyIncidentBuilder<BusinessPolicyIncident, BusinessPolicyIncidentBuilderImpl> {
        @Generated
        private BusinessPolicyIncidentBuilderImpl() {
        }

        @Override
        @Generated
        protected BusinessPolicyIncidentBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BusinessPolicyIncident build() {
            return new BusinessPolicyIncident(this);
        }
    }
}

