/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICassandra;
import com.atlan.model.assets.ICassandraColumn;
import com.atlan.model.assets.ICassandraTable;
import com.atlan.model.assets.ICassandraView;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.INoSQL;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraColumn
extends Asset
implements ICassandraColumn,
ICassandra,
INoSQL,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraColumn.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CassandraColumn";
    String typeName;
    @Attribute
    String cassandraColumnClusteringOrder;
    @Attribute
    Boolean cassandraColumnIsClusteringKey;
    @Attribute
    Boolean cassandraColumnIsPartitionKey;
    @Attribute
    Boolean cassandraColumnIsStatic;
    @Attribute
    String cassandraColumnKind;
    @Attribute
    Long cassandraColumnPosition;
    @Attribute
    String cassandraColumnType;
    @Attribute
    String cassandraKeyspaceName;
    @Attribute
    ICassandraTable cassandraTable;
    @Attribute
    String cassandraTableName;
    @Attribute
    String cassandraTableQualifiedName;
    @Attribute
    ICassandraView cassandraView;
    @Attribute
    String cassandraViewName;
    @Attribute
    String cassandraViewQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    String noSQLSchemaDefinition;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public CassandraColumn trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return CassandraColumn.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return CassandraColumn.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return CassandraColumn.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return CassandraColumn.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static CassandraColumn refByGuid(String guid) {
        return CassandraColumn.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static CassandraColumn refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((CassandraColumnBuilder)((CassandraColumnBuilder)CassandraColumn._internal().guid(guid)).semantic(semantic)).build();
    }

    public static CassandraColumn refByQualifiedName(String qualifiedName) {
        return CassandraColumn.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static CassandraColumn refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((CassandraColumnBuilder)((CassandraColumnBuilder)CassandraColumn._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static CassandraColumn get(AtlanClient client, String id) throws AtlanException {
        return CassandraColumn.get(client, id, false);
    }

    @JsonIgnore
    public static CassandraColumn get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof CassandraColumn) {
                return (CassandraColumn)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof CassandraColumn) {
            return (CassandraColumn)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static CassandraColumn get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return CassandraColumn.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static CassandraColumn get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CassandraColumn.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof CassandraColumn) {
                return (CassandraColumn)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CassandraColumn.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof CassandraColumn) {
            return (CassandraColumn)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static CassandraColumnBuilder<?, ?> updater(String qualifiedName, String name) {
        return (CassandraColumnBuilder)((CassandraColumnBuilder)((CassandraColumnBuilder)CassandraColumn._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public CassandraColumnBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        CassandraColumn.validateRequired(TYPE_NAME, map);
        return CassandraColumn.updater(this.getQualifiedName(), this.getName());
    }

    public static CassandraColumn removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraColumn)Asset.removeDescription(client, CassandraColumn.updater(qualifiedName, name));
    }

    public static CassandraColumn removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraColumn)Asset.removeUserDescription(client, CassandraColumn.updater(qualifiedName, name));
    }

    public static CassandraColumn removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraColumn)Asset.removeOwners(client, CassandraColumn.updater(qualifiedName, name));
    }

    public static CassandraColumn updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CassandraColumn)Asset.updateCertificate(client, CassandraColumn._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static CassandraColumn removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraColumn)Asset.removeCertificate(client, CassandraColumn.updater(qualifiedName, name));
    }

    public static CassandraColumn updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CassandraColumn)Asset.updateAnnouncement(client, CassandraColumn._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static CassandraColumn removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraColumn)Asset.removeAnnouncement(client, CassandraColumn.updater(qualifiedName, name));
    }

    public static CassandraColumn replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraColumn)Asset.replaceTerms(client, CassandraColumn.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static CassandraColumn appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraColumn)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CassandraColumn removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraColumn)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CassandraColumn appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CassandraColumn)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static CassandraColumn appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CassandraColumn)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected CassandraColumn(CassandraColumnBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : CassandraColumn.$default$typeName();
        this.cassandraColumnClusteringOrder = b.cassandraColumnClusteringOrder;
        this.cassandraColumnIsClusteringKey = b.cassandraColumnIsClusteringKey;
        this.cassandraColumnIsPartitionKey = b.cassandraColumnIsPartitionKey;
        this.cassandraColumnIsStatic = b.cassandraColumnIsStatic;
        this.cassandraColumnKind = b.cassandraColumnKind;
        this.cassandraColumnPosition = b.cassandraColumnPosition;
        this.cassandraColumnType = b.cassandraColumnType;
        this.cassandraKeyspaceName = b.cassandraKeyspaceName;
        this.cassandraTable = b.cassandraTable;
        this.cassandraTableName = b.cassandraTableName;
        this.cassandraTableQualifiedName = b.cassandraTableQualifiedName;
        this.cassandraView = b.cassandraView;
        this.cassandraViewName = b.cassandraViewName;
        this.cassandraViewQualifiedName = b.cassandraViewQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        this.noSQLSchemaDefinition = b.noSQLSchemaDefinition;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static CassandraColumnBuilder<?, ?> _internal() {
        return new CassandraColumnBuilderImpl();
    }

    @Generated
    public CassandraColumnBuilder<?, ?> toBuilder() {
        return new CassandraColumnBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getCassandraColumnClusteringOrder() {
        return this.cassandraColumnClusteringOrder;
    }

    @Override
    @Generated
    public Boolean getCassandraColumnIsClusteringKey() {
        return this.cassandraColumnIsClusteringKey;
    }

    @Override
    @Generated
    public Boolean getCassandraColumnIsPartitionKey() {
        return this.cassandraColumnIsPartitionKey;
    }

    @Override
    @Generated
    public Boolean getCassandraColumnIsStatic() {
        return this.cassandraColumnIsStatic;
    }

    @Override
    @Generated
    public String getCassandraColumnKind() {
        return this.cassandraColumnKind;
    }

    @Override
    @Generated
    public Long getCassandraColumnPosition() {
        return this.cassandraColumnPosition;
    }

    @Override
    @Generated
    public String getCassandraColumnType() {
        return this.cassandraColumnType;
    }

    @Override
    @Generated
    public String getCassandraKeyspaceName() {
        return this.cassandraKeyspaceName;
    }

    @Override
    @Generated
    public ICassandraTable getCassandraTable() {
        return this.cassandraTable;
    }

    @Override
    @Generated
    public String getCassandraTableName() {
        return this.cassandraTableName;
    }

    @Override
    @Generated
    public String getCassandraTableQualifiedName() {
        return this.cassandraTableQualifiedName;
    }

    @Override
    @Generated
    public ICassandraView getCassandraView() {
        return this.cassandraView;
    }

    @Override
    @Generated
    public String getCassandraViewName() {
        return this.cassandraViewName;
    }

    @Override
    @Generated
    public String getCassandraViewQualifiedName() {
        return this.cassandraViewQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public String getNoSQLSchemaDefinition() {
        return this.noSQLSchemaDefinition;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraColumn)) {
            return false;
        }
        CassandraColumn other = (CassandraColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$cassandraColumnIsClusteringKey = this.getCassandraColumnIsClusteringKey();
        Boolean other$cassandraColumnIsClusteringKey = other.getCassandraColumnIsClusteringKey();
        if (this$cassandraColumnIsClusteringKey == null ? other$cassandraColumnIsClusteringKey != null : !((Object)this$cassandraColumnIsClusteringKey).equals(other$cassandraColumnIsClusteringKey)) {
            return false;
        }
        Boolean this$cassandraColumnIsPartitionKey = this.getCassandraColumnIsPartitionKey();
        Boolean other$cassandraColumnIsPartitionKey = other.getCassandraColumnIsPartitionKey();
        if (this$cassandraColumnIsPartitionKey == null ? other$cassandraColumnIsPartitionKey != null : !((Object)this$cassandraColumnIsPartitionKey).equals(other$cassandraColumnIsPartitionKey)) {
            return false;
        }
        Boolean this$cassandraColumnIsStatic = this.getCassandraColumnIsStatic();
        Boolean other$cassandraColumnIsStatic = other.getCassandraColumnIsStatic();
        if (this$cassandraColumnIsStatic == null ? other$cassandraColumnIsStatic != null : !((Object)this$cassandraColumnIsStatic).equals(other$cassandraColumnIsStatic)) {
            return false;
        }
        Long this$cassandraColumnPosition = this.getCassandraColumnPosition();
        Long other$cassandraColumnPosition = other.getCassandraColumnPosition();
        if (this$cassandraColumnPosition == null ? other$cassandraColumnPosition != null : !((Object)this$cassandraColumnPosition).equals(other$cassandraColumnPosition)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$cassandraColumnClusteringOrder = this.getCassandraColumnClusteringOrder();
        String other$cassandraColumnClusteringOrder = other.getCassandraColumnClusteringOrder();
        if (this$cassandraColumnClusteringOrder == null ? other$cassandraColumnClusteringOrder != null : !this$cassandraColumnClusteringOrder.equals(other$cassandraColumnClusteringOrder)) {
            return false;
        }
        String this$cassandraColumnKind = this.getCassandraColumnKind();
        String other$cassandraColumnKind = other.getCassandraColumnKind();
        if (this$cassandraColumnKind == null ? other$cassandraColumnKind != null : !this$cassandraColumnKind.equals(other$cassandraColumnKind)) {
            return false;
        }
        String this$cassandraColumnType = this.getCassandraColumnType();
        String other$cassandraColumnType = other.getCassandraColumnType();
        if (this$cassandraColumnType == null ? other$cassandraColumnType != null : !this$cassandraColumnType.equals(other$cassandraColumnType)) {
            return false;
        }
        String this$cassandraKeyspaceName = this.getCassandraKeyspaceName();
        String other$cassandraKeyspaceName = other.getCassandraKeyspaceName();
        if (this$cassandraKeyspaceName == null ? other$cassandraKeyspaceName != null : !this$cassandraKeyspaceName.equals(other$cassandraKeyspaceName)) {
            return false;
        }
        ICassandraTable this$cassandraTable = this.getCassandraTable();
        ICassandraTable other$cassandraTable = other.getCassandraTable();
        if (this$cassandraTable == null ? other$cassandraTable != null : !this$cassandraTable.equals(other$cassandraTable)) {
            return false;
        }
        String this$cassandraTableName = this.getCassandraTableName();
        String other$cassandraTableName = other.getCassandraTableName();
        if (this$cassandraTableName == null ? other$cassandraTableName != null : !this$cassandraTableName.equals(other$cassandraTableName)) {
            return false;
        }
        String this$cassandraTableQualifiedName = this.getCassandraTableQualifiedName();
        String other$cassandraTableQualifiedName = other.getCassandraTableQualifiedName();
        if (this$cassandraTableQualifiedName == null ? other$cassandraTableQualifiedName != null : !this$cassandraTableQualifiedName.equals(other$cassandraTableQualifiedName)) {
            return false;
        }
        ICassandraView this$cassandraView = this.getCassandraView();
        ICassandraView other$cassandraView = other.getCassandraView();
        if (this$cassandraView == null ? other$cassandraView != null : !this$cassandraView.equals(other$cassandraView)) {
            return false;
        }
        String this$cassandraViewName = this.getCassandraViewName();
        String other$cassandraViewName = other.getCassandraViewName();
        if (this$cassandraViewName == null ? other$cassandraViewName != null : !this$cassandraViewName.equals(other$cassandraViewName)) {
            return false;
        }
        String this$cassandraViewQualifiedName = this.getCassandraViewQualifiedName();
        String other$cassandraViewQualifiedName = other.getCassandraViewQualifiedName();
        if (this$cassandraViewQualifiedName == null ? other$cassandraViewQualifiedName != null : !this$cassandraViewQualifiedName.equals(other$cassandraViewQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        String this$noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        String other$noSQLSchemaDefinition = other.getNoSQLSchemaDefinition();
        if (this$noSQLSchemaDefinition == null ? other$noSQLSchemaDefinition != null : !this$noSQLSchemaDefinition.equals(other$noSQLSchemaDefinition)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CassandraColumn;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $cassandraColumnIsClusteringKey = this.getCassandraColumnIsClusteringKey();
        result = result * 59 + ($cassandraColumnIsClusteringKey == null ? 43 : ((Object)$cassandraColumnIsClusteringKey).hashCode());
        Boolean $cassandraColumnIsPartitionKey = this.getCassandraColumnIsPartitionKey();
        result = result * 59 + ($cassandraColumnIsPartitionKey == null ? 43 : ((Object)$cassandraColumnIsPartitionKey).hashCode());
        Boolean $cassandraColumnIsStatic = this.getCassandraColumnIsStatic();
        result = result * 59 + ($cassandraColumnIsStatic == null ? 43 : ((Object)$cassandraColumnIsStatic).hashCode());
        Long $cassandraColumnPosition = this.getCassandraColumnPosition();
        result = result * 59 + ($cassandraColumnPosition == null ? 43 : ((Object)$cassandraColumnPosition).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $cassandraColumnClusteringOrder = this.getCassandraColumnClusteringOrder();
        result = result * 59 + ($cassandraColumnClusteringOrder == null ? 43 : $cassandraColumnClusteringOrder.hashCode());
        String $cassandraColumnKind = this.getCassandraColumnKind();
        result = result * 59 + ($cassandraColumnKind == null ? 43 : $cassandraColumnKind.hashCode());
        String $cassandraColumnType = this.getCassandraColumnType();
        result = result * 59 + ($cassandraColumnType == null ? 43 : $cassandraColumnType.hashCode());
        String $cassandraKeyspaceName = this.getCassandraKeyspaceName();
        result = result * 59 + ($cassandraKeyspaceName == null ? 43 : $cassandraKeyspaceName.hashCode());
        ICassandraTable $cassandraTable = this.getCassandraTable();
        result = result * 59 + ($cassandraTable == null ? 43 : $cassandraTable.hashCode());
        String $cassandraTableName = this.getCassandraTableName();
        result = result * 59 + ($cassandraTableName == null ? 43 : $cassandraTableName.hashCode());
        String $cassandraTableQualifiedName = this.getCassandraTableQualifiedName();
        result = result * 59 + ($cassandraTableQualifiedName == null ? 43 : $cassandraTableQualifiedName.hashCode());
        ICassandraView $cassandraView = this.getCassandraView();
        result = result * 59 + ($cassandraView == null ? 43 : $cassandraView.hashCode());
        String $cassandraViewName = this.getCassandraViewName();
        result = result * 59 + ($cassandraViewName == null ? 43 : $cassandraViewName.hashCode());
        String $cassandraViewQualifiedName = this.getCassandraViewQualifiedName();
        result = result * 59 + ($cassandraViewQualifiedName == null ? 43 : $cassandraViewQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        String $noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        result = result * 59 + ($noSQLSchemaDefinition == null ? 43 : $noSQLSchemaDefinition.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CassandraColumn(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cassandraColumnClusteringOrder=" + this.getCassandraColumnClusteringOrder() + ", cassandraColumnIsClusteringKey=" + this.getCassandraColumnIsClusteringKey() + ", cassandraColumnIsPartitionKey=" + this.getCassandraColumnIsPartitionKey() + ", cassandraColumnIsStatic=" + this.getCassandraColumnIsStatic() + ", cassandraColumnKind=" + this.getCassandraColumnKind() + ", cassandraColumnPosition=" + this.getCassandraColumnPosition() + ", cassandraColumnType=" + this.getCassandraColumnType() + ", cassandraKeyspaceName=" + this.getCassandraKeyspaceName() + ", cassandraTable=" + String.valueOf(this.getCassandraTable()) + ", cassandraTableName=" + this.getCassandraTableName() + ", cassandraTableQualifiedName=" + this.getCassandraTableQualifiedName() + ", cassandraView=" + String.valueOf(this.getCassandraView()) + ", cassandraViewName=" + this.getCassandraViewName() + ", cassandraViewQualifiedName=" + this.getCassandraViewQualifiedName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", noSQLSchemaDefinition=" + this.getNoSQLSchemaDefinition() + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class CassandraColumnBuilder<C extends CassandraColumn, B extends CassandraColumnBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String cassandraColumnClusteringOrder;
        @Generated
        private Boolean cassandraColumnIsClusteringKey;
        @Generated
        private Boolean cassandraColumnIsPartitionKey;
        @Generated
        private Boolean cassandraColumnIsStatic;
        @Generated
        private String cassandraColumnKind;
        @Generated
        private Long cassandraColumnPosition;
        @Generated
        private String cassandraColumnType;
        @Generated
        private String cassandraKeyspaceName;
        @Generated
        private ICassandraTable cassandraTable;
        @Generated
        private String cassandraTableName;
        @Generated
        private String cassandraTableQualifiedName;
        @Generated
        private ICassandraView cassandraView;
        @Generated
        private String cassandraViewName;
        @Generated
        private String cassandraViewQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private String noSQLSchemaDefinition;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CassandraColumnBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CassandraColumn instance, CassandraColumnBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cassandraColumnClusteringOrder(instance.cassandraColumnClusteringOrder);
            b.cassandraColumnIsClusteringKey(instance.cassandraColumnIsClusteringKey);
            b.cassandraColumnIsPartitionKey(instance.cassandraColumnIsPartitionKey);
            b.cassandraColumnIsStatic(instance.cassandraColumnIsStatic);
            b.cassandraColumnKind(instance.cassandraColumnKind);
            b.cassandraColumnPosition(instance.cassandraColumnPosition);
            b.cassandraColumnType(instance.cassandraColumnType);
            b.cassandraKeyspaceName(instance.cassandraKeyspaceName);
            b.cassandraTable(instance.cassandraTable);
            b.cassandraTableName(instance.cassandraTableName);
            b.cassandraTableQualifiedName(instance.cassandraTableQualifiedName);
            b.cassandraView(instance.cassandraView);
            b.cassandraViewName(instance.cassandraViewName);
            b.cassandraViewQualifiedName(instance.cassandraViewQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.noSQLSchemaDefinition(instance.noSQLSchemaDefinition);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B cassandraColumnClusteringOrder(String cassandraColumnClusteringOrder) {
            this.cassandraColumnClusteringOrder = cassandraColumnClusteringOrder;
            return (B)this.self();
        }

        @Generated
        public B cassandraColumnIsClusteringKey(Boolean cassandraColumnIsClusteringKey) {
            this.cassandraColumnIsClusteringKey = cassandraColumnIsClusteringKey;
            return (B)this.self();
        }

        @Generated
        public B cassandraColumnIsPartitionKey(Boolean cassandraColumnIsPartitionKey) {
            this.cassandraColumnIsPartitionKey = cassandraColumnIsPartitionKey;
            return (B)this.self();
        }

        @Generated
        public B cassandraColumnIsStatic(Boolean cassandraColumnIsStatic) {
            this.cassandraColumnIsStatic = cassandraColumnIsStatic;
            return (B)this.self();
        }

        @Generated
        public B cassandraColumnKind(String cassandraColumnKind) {
            this.cassandraColumnKind = cassandraColumnKind;
            return (B)this.self();
        }

        @Generated
        public B cassandraColumnPosition(Long cassandraColumnPosition) {
            this.cassandraColumnPosition = cassandraColumnPosition;
            return (B)this.self();
        }

        @Generated
        public B cassandraColumnType(String cassandraColumnType) {
            this.cassandraColumnType = cassandraColumnType;
            return (B)this.self();
        }

        @Generated
        public B cassandraKeyspaceName(String cassandraKeyspaceName) {
            this.cassandraKeyspaceName = cassandraKeyspaceName;
            return (B)this.self();
        }

        @Generated
        public B cassandraTable(ICassandraTable cassandraTable) {
            this.cassandraTable = cassandraTable;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableName(String cassandraTableName) {
            this.cassandraTableName = cassandraTableName;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableQualifiedName(String cassandraTableQualifiedName) {
            this.cassandraTableQualifiedName = cassandraTableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cassandraView(ICassandraView cassandraView) {
            this.cassandraView = cassandraView;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewName(String cassandraViewName) {
            this.cassandraViewName = cassandraViewName;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewQualifiedName(String cassandraViewQualifiedName) {
            this.cassandraViewQualifiedName = cassandraViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B noSQLSchemaDefinition(String noSQLSchemaDefinition) {
            this.noSQLSchemaDefinition = noSQLSchemaDefinition;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CassandraColumn.CassandraColumnBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cassandraColumnClusteringOrder=" + this.cassandraColumnClusteringOrder + ", cassandraColumnIsClusteringKey=" + this.cassandraColumnIsClusteringKey + ", cassandraColumnIsPartitionKey=" + this.cassandraColumnIsPartitionKey + ", cassandraColumnIsStatic=" + this.cassandraColumnIsStatic + ", cassandraColumnKind=" + this.cassandraColumnKind + ", cassandraColumnPosition=" + this.cassandraColumnPosition + ", cassandraColumnType=" + this.cassandraColumnType + ", cassandraKeyspaceName=" + this.cassandraKeyspaceName + ", cassandraTable=" + String.valueOf(this.cassandraTable) + ", cassandraTableName=" + this.cassandraTableName + ", cassandraTableQualifiedName=" + this.cassandraTableQualifiedName + ", cassandraView=" + String.valueOf(this.cassandraView) + ", cassandraViewName=" + this.cassandraViewName + ", cassandraViewQualifiedName=" + this.cassandraViewQualifiedName + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", noSQLSchemaDefinition=" + this.noSQLSchemaDefinition + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class CassandraColumnBuilderImpl
    extends CassandraColumnBuilder<CassandraColumn, CassandraColumnBuilderImpl> {
        @Generated
        private CassandraColumnBuilderImpl() {
        }

        @Override
        @Generated
        protected CassandraColumnBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CassandraColumn build() {
            return new CassandraColumn(this);
        }
    }
}

