/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICassandra;
import com.atlan.model.assets.ICassandraKeyspace;
import com.atlan.model.assets.ICassandraTable;
import com.atlan.model.assets.ICassandraView;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.INoSQL;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraKeyspace
extends Asset
implements ICassandraKeyspace,
ICassandra,
INoSQL,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraKeyspace.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CassandraKeyspace";
    String typeName;
    @Attribute
    Boolean cassandraKeyspaceDurableWrites;
    @Attribute
    String cassandraKeyspaceName;
    @Attribute
    String cassandraKeyspaceQuery;
    @Attribute
    Map<String, String> cassandraKeyspaceReplication;
    @Attribute
    Boolean cassandraKeyspaceVirtual;
    @Attribute
    String cassandraTableName;
    @Attribute
    String cassandraTableQualifiedName;
    @Attribute
    SortedSet<ICassandraTable> cassandraTables;
    @Attribute
    String cassandraViewName;
    @Attribute
    String cassandraViewQualifiedName;
    @Attribute
    SortedSet<ICassandraView> cassandraViews;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    String noSQLSchemaDefinition;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public CassandraKeyspace trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return CassandraKeyspace.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return CassandraKeyspace.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return CassandraKeyspace.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return CassandraKeyspace.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static CassandraKeyspace refByGuid(String guid) {
        return CassandraKeyspace.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static CassandraKeyspace refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((CassandraKeyspaceBuilder)((CassandraKeyspaceBuilder)CassandraKeyspace._internal().guid(guid)).semantic(semantic)).build();
    }

    public static CassandraKeyspace refByQualifiedName(String qualifiedName) {
        return CassandraKeyspace.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static CassandraKeyspace refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((CassandraKeyspaceBuilder)((CassandraKeyspaceBuilder)CassandraKeyspace._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static CassandraKeyspace get(AtlanClient client, String id) throws AtlanException {
        return CassandraKeyspace.get(client, id, false);
    }

    @JsonIgnore
    public static CassandraKeyspace get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof CassandraKeyspace) {
                return (CassandraKeyspace)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof CassandraKeyspace) {
            return (CassandraKeyspace)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static CassandraKeyspace get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return CassandraKeyspace.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static CassandraKeyspace get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CassandraKeyspace.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof CassandraKeyspace) {
                return (CassandraKeyspace)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CassandraKeyspace.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof CassandraKeyspace) {
            return (CassandraKeyspace)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static CassandraKeyspaceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (CassandraKeyspaceBuilder)((CassandraKeyspaceBuilder)((CassandraKeyspaceBuilder)CassandraKeyspace._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public CassandraKeyspaceBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        CassandraKeyspace.validateRequired(TYPE_NAME, map);
        return CassandraKeyspace.updater(this.getQualifiedName(), this.getName());
    }

    public static CassandraKeyspace removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraKeyspace)Asset.removeDescription(client, CassandraKeyspace.updater(qualifiedName, name));
    }

    public static CassandraKeyspace removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraKeyspace)Asset.removeUserDescription(client, CassandraKeyspace.updater(qualifiedName, name));
    }

    public static CassandraKeyspace removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraKeyspace)Asset.removeOwners(client, CassandraKeyspace.updater(qualifiedName, name));
    }

    public static CassandraKeyspace updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CassandraKeyspace)Asset.updateCertificate(client, CassandraKeyspace._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static CassandraKeyspace removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraKeyspace)Asset.removeCertificate(client, CassandraKeyspace.updater(qualifiedName, name));
    }

    public static CassandraKeyspace updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CassandraKeyspace)Asset.updateAnnouncement(client, CassandraKeyspace._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static CassandraKeyspace removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraKeyspace)Asset.removeAnnouncement(client, CassandraKeyspace.updater(qualifiedName, name));
    }

    public static CassandraKeyspace replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraKeyspace)Asset.replaceTerms(client, CassandraKeyspace.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static CassandraKeyspace appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraKeyspace)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CassandraKeyspace removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraKeyspace)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CassandraKeyspace appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CassandraKeyspace)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static CassandraKeyspace appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CassandraKeyspace)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected CassandraKeyspace(CassandraKeyspaceBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> cassandraKeyspaceReplication;
        this.typeName = b.typeName$set ? b.typeName$value : CassandraKeyspace.$default$typeName();
        this.cassandraKeyspaceDurableWrites = b.cassandraKeyspaceDurableWrites;
        this.cassandraKeyspaceName = b.cassandraKeyspaceName;
        this.cassandraKeyspaceQuery = b.cassandraKeyspaceQuery;
        switch (b.cassandraKeyspaceReplication$key == null ? 0 : b.cassandraKeyspaceReplication$key.size()) {
            case 0: {
                cassandraKeyspaceReplication = Collections.emptyMap();
                break;
            }
            case 1: {
                cassandraKeyspaceReplication = Collections.singletonMap(b.cassandraKeyspaceReplication$key.get(0), b.cassandraKeyspaceReplication$value.get(0));
                break;
            }
            default: {
                cassandraKeyspaceReplication = new LinkedHashMap(b.cassandraKeyspaceReplication$key.size() < 0x40000000 ? 1 + b.cassandraKeyspaceReplication$key.size() + (b.cassandraKeyspaceReplication$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.cassandraKeyspaceReplication$key.size(); ++$i) {
                    cassandraKeyspaceReplication.put(b.cassandraKeyspaceReplication$key.get($i), b.cassandraKeyspaceReplication$value.get($i));
                }
                cassandraKeyspaceReplication = Collections.unmodifiableMap(cassandraKeyspaceReplication);
            }
        }
        this.cassandraKeyspaceReplication = cassandraKeyspaceReplication;
        this.cassandraKeyspaceVirtual = b.cassandraKeyspaceVirtual;
        this.cassandraTableName = b.cassandraTableName;
        this.cassandraTableQualifiedName = b.cassandraTableQualifiedName;
        SortedSet<ICassandraTable> cassandraTables = new TreeSet<ICassandraTable>();
        if (b.cassandraTables != null) {
            cassandraTables.addAll(b.cassandraTables);
        }
        cassandraTables = Collections.unmodifiableSortedSet(cassandraTables);
        this.cassandraTables = cassandraTables;
        this.cassandraViewName = b.cassandraViewName;
        this.cassandraViewQualifiedName = b.cassandraViewQualifiedName;
        SortedSet<ICassandraView> cassandraViews = new TreeSet<ICassandraView>();
        if (b.cassandraViews != null) {
            cassandraViews.addAll(b.cassandraViews);
        }
        cassandraViews = Collections.unmodifiableSortedSet(cassandraViews);
        this.cassandraViews = cassandraViews;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        this.noSQLSchemaDefinition = b.noSQLSchemaDefinition;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static CassandraKeyspaceBuilder<?, ?> _internal() {
        return new CassandraKeyspaceBuilderImpl();
    }

    @Generated
    public CassandraKeyspaceBuilder<?, ?> toBuilder() {
        return new CassandraKeyspaceBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Boolean getCassandraKeyspaceDurableWrites() {
        return this.cassandraKeyspaceDurableWrites;
    }

    @Override
    @Generated
    public String getCassandraKeyspaceName() {
        return this.cassandraKeyspaceName;
    }

    @Override
    @Generated
    public String getCassandraKeyspaceQuery() {
        return this.cassandraKeyspaceQuery;
    }

    @Override
    @Generated
    public Map<String, String> getCassandraKeyspaceReplication() {
        return this.cassandraKeyspaceReplication;
    }

    @Override
    @Generated
    public Boolean getCassandraKeyspaceVirtual() {
        return this.cassandraKeyspaceVirtual;
    }

    @Override
    @Generated
    public String getCassandraTableName() {
        return this.cassandraTableName;
    }

    @Override
    @Generated
    public String getCassandraTableQualifiedName() {
        return this.cassandraTableQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ICassandraTable> getCassandraTables() {
        return this.cassandraTables;
    }

    @Override
    @Generated
    public String getCassandraViewName() {
        return this.cassandraViewName;
    }

    @Override
    @Generated
    public String getCassandraViewQualifiedName() {
        return this.cassandraViewQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ICassandraView> getCassandraViews() {
        return this.cassandraViews;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public String getNoSQLSchemaDefinition() {
        return this.noSQLSchemaDefinition;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraKeyspace)) {
            return false;
        }
        CassandraKeyspace other = (CassandraKeyspace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$cassandraKeyspaceDurableWrites = this.getCassandraKeyspaceDurableWrites();
        Boolean other$cassandraKeyspaceDurableWrites = other.getCassandraKeyspaceDurableWrites();
        if (this$cassandraKeyspaceDurableWrites == null ? other$cassandraKeyspaceDurableWrites != null : !((Object)this$cassandraKeyspaceDurableWrites).equals(other$cassandraKeyspaceDurableWrites)) {
            return false;
        }
        Boolean this$cassandraKeyspaceVirtual = this.getCassandraKeyspaceVirtual();
        Boolean other$cassandraKeyspaceVirtual = other.getCassandraKeyspaceVirtual();
        if (this$cassandraKeyspaceVirtual == null ? other$cassandraKeyspaceVirtual != null : !((Object)this$cassandraKeyspaceVirtual).equals(other$cassandraKeyspaceVirtual)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$cassandraKeyspaceName = this.getCassandraKeyspaceName();
        String other$cassandraKeyspaceName = other.getCassandraKeyspaceName();
        if (this$cassandraKeyspaceName == null ? other$cassandraKeyspaceName != null : !this$cassandraKeyspaceName.equals(other$cassandraKeyspaceName)) {
            return false;
        }
        String this$cassandraKeyspaceQuery = this.getCassandraKeyspaceQuery();
        String other$cassandraKeyspaceQuery = other.getCassandraKeyspaceQuery();
        if (this$cassandraKeyspaceQuery == null ? other$cassandraKeyspaceQuery != null : !this$cassandraKeyspaceQuery.equals(other$cassandraKeyspaceQuery)) {
            return false;
        }
        Map<String, String> this$cassandraKeyspaceReplication = this.getCassandraKeyspaceReplication();
        Map<String, String> other$cassandraKeyspaceReplication = other.getCassandraKeyspaceReplication();
        if (this$cassandraKeyspaceReplication == null ? other$cassandraKeyspaceReplication != null : !((Object)this$cassandraKeyspaceReplication).equals(other$cassandraKeyspaceReplication)) {
            return false;
        }
        String this$cassandraTableName = this.getCassandraTableName();
        String other$cassandraTableName = other.getCassandraTableName();
        if (this$cassandraTableName == null ? other$cassandraTableName != null : !this$cassandraTableName.equals(other$cassandraTableName)) {
            return false;
        }
        String this$cassandraTableQualifiedName = this.getCassandraTableQualifiedName();
        String other$cassandraTableQualifiedName = other.getCassandraTableQualifiedName();
        if (this$cassandraTableQualifiedName == null ? other$cassandraTableQualifiedName != null : !this$cassandraTableQualifiedName.equals(other$cassandraTableQualifiedName)) {
            return false;
        }
        SortedSet<ICassandraTable> this$cassandraTables = this.getCassandraTables();
        SortedSet<ICassandraTable> other$cassandraTables = other.getCassandraTables();
        if (this$cassandraTables == null ? other$cassandraTables != null : !this$cassandraTables.equals(other$cassandraTables)) {
            return false;
        }
        String this$cassandraViewName = this.getCassandraViewName();
        String other$cassandraViewName = other.getCassandraViewName();
        if (this$cassandraViewName == null ? other$cassandraViewName != null : !this$cassandraViewName.equals(other$cassandraViewName)) {
            return false;
        }
        String this$cassandraViewQualifiedName = this.getCassandraViewQualifiedName();
        String other$cassandraViewQualifiedName = other.getCassandraViewQualifiedName();
        if (this$cassandraViewQualifiedName == null ? other$cassandraViewQualifiedName != null : !this$cassandraViewQualifiedName.equals(other$cassandraViewQualifiedName)) {
            return false;
        }
        SortedSet<ICassandraView> this$cassandraViews = this.getCassandraViews();
        SortedSet<ICassandraView> other$cassandraViews = other.getCassandraViews();
        if (this$cassandraViews == null ? other$cassandraViews != null : !this$cassandraViews.equals(other$cassandraViews)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        String this$noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        String other$noSQLSchemaDefinition = other.getNoSQLSchemaDefinition();
        if (this$noSQLSchemaDefinition == null ? other$noSQLSchemaDefinition != null : !this$noSQLSchemaDefinition.equals(other$noSQLSchemaDefinition)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CassandraKeyspace;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $cassandraKeyspaceDurableWrites = this.getCassandraKeyspaceDurableWrites();
        result = result * 59 + ($cassandraKeyspaceDurableWrites == null ? 43 : ((Object)$cassandraKeyspaceDurableWrites).hashCode());
        Boolean $cassandraKeyspaceVirtual = this.getCassandraKeyspaceVirtual();
        result = result * 59 + ($cassandraKeyspaceVirtual == null ? 43 : ((Object)$cassandraKeyspaceVirtual).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $cassandraKeyspaceName = this.getCassandraKeyspaceName();
        result = result * 59 + ($cassandraKeyspaceName == null ? 43 : $cassandraKeyspaceName.hashCode());
        String $cassandraKeyspaceQuery = this.getCassandraKeyspaceQuery();
        result = result * 59 + ($cassandraKeyspaceQuery == null ? 43 : $cassandraKeyspaceQuery.hashCode());
        Map<String, String> $cassandraKeyspaceReplication = this.getCassandraKeyspaceReplication();
        result = result * 59 + ($cassandraKeyspaceReplication == null ? 43 : ((Object)$cassandraKeyspaceReplication).hashCode());
        String $cassandraTableName = this.getCassandraTableName();
        result = result * 59 + ($cassandraTableName == null ? 43 : $cassandraTableName.hashCode());
        String $cassandraTableQualifiedName = this.getCassandraTableQualifiedName();
        result = result * 59 + ($cassandraTableQualifiedName == null ? 43 : $cassandraTableQualifiedName.hashCode());
        SortedSet<ICassandraTable> $cassandraTables = this.getCassandraTables();
        result = result * 59 + ($cassandraTables == null ? 43 : $cassandraTables.hashCode());
        String $cassandraViewName = this.getCassandraViewName();
        result = result * 59 + ($cassandraViewName == null ? 43 : $cassandraViewName.hashCode());
        String $cassandraViewQualifiedName = this.getCassandraViewQualifiedName();
        result = result * 59 + ($cassandraViewQualifiedName == null ? 43 : $cassandraViewQualifiedName.hashCode());
        SortedSet<ICassandraView> $cassandraViews = this.getCassandraViews();
        result = result * 59 + ($cassandraViews == null ? 43 : $cassandraViews.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        String $noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        result = result * 59 + ($noSQLSchemaDefinition == null ? 43 : $noSQLSchemaDefinition.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CassandraKeyspace(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cassandraKeyspaceDurableWrites=" + this.getCassandraKeyspaceDurableWrites() + ", cassandraKeyspaceName=" + this.getCassandraKeyspaceName() + ", cassandraKeyspaceQuery=" + this.getCassandraKeyspaceQuery() + ", cassandraKeyspaceReplication=" + String.valueOf(this.getCassandraKeyspaceReplication()) + ", cassandraKeyspaceVirtual=" + this.getCassandraKeyspaceVirtual() + ", cassandraTableName=" + this.getCassandraTableName() + ", cassandraTableQualifiedName=" + this.getCassandraTableQualifiedName() + ", cassandraTables=" + String.valueOf(this.getCassandraTables()) + ", cassandraViewName=" + this.getCassandraViewName() + ", cassandraViewQualifiedName=" + this.getCassandraViewQualifiedName() + ", cassandraViews=" + String.valueOf(this.getCassandraViews()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", noSQLSchemaDefinition=" + this.getNoSQLSchemaDefinition() + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class CassandraKeyspaceBuilder<C extends CassandraKeyspace, B extends CassandraKeyspaceBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Boolean cassandraKeyspaceDurableWrites;
        @Generated
        private String cassandraKeyspaceName;
        @Generated
        private String cassandraKeyspaceQuery;
        @Generated
        private ArrayList<String> cassandraKeyspaceReplication$key;
        @Generated
        private ArrayList<String> cassandraKeyspaceReplication$value;
        @Generated
        private Boolean cassandraKeyspaceVirtual;
        @Generated
        private String cassandraTableName;
        @Generated
        private String cassandraTableQualifiedName;
        @Generated
        private ArrayList<ICassandraTable> cassandraTables;
        @Generated
        private String cassandraViewName;
        @Generated
        private String cassandraViewQualifiedName;
        @Generated
        private ArrayList<ICassandraView> cassandraViews;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private String noSQLSchemaDefinition;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CassandraKeyspaceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CassandraKeyspace instance, CassandraKeyspaceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cassandraKeyspaceDurableWrites(instance.cassandraKeyspaceDurableWrites);
            b.cassandraKeyspaceName(instance.cassandraKeyspaceName);
            b.cassandraKeyspaceQuery(instance.cassandraKeyspaceQuery);
            b.cassandraKeyspaceReplication(instance.cassandraKeyspaceReplication == null ? Collections.emptyMap() : instance.cassandraKeyspaceReplication);
            b.cassandraKeyspaceVirtual(instance.cassandraKeyspaceVirtual);
            b.cassandraTableName(instance.cassandraTableName);
            b.cassandraTableQualifiedName(instance.cassandraTableQualifiedName);
            b.cassandraTables(instance.cassandraTables == null ? Collections.emptySortedSet() : instance.cassandraTables);
            b.cassandraViewName(instance.cassandraViewName);
            b.cassandraViewQualifiedName(instance.cassandraViewQualifiedName);
            b.cassandraViews(instance.cassandraViews == null ? Collections.emptySortedSet() : instance.cassandraViews);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.noSQLSchemaDefinition(instance.noSQLSchemaDefinition);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B cassandraKeyspaceDurableWrites(Boolean cassandraKeyspaceDurableWrites) {
            this.cassandraKeyspaceDurableWrites = cassandraKeyspaceDurableWrites;
            return (B)this.self();
        }

        @Generated
        public B cassandraKeyspaceName(String cassandraKeyspaceName) {
            this.cassandraKeyspaceName = cassandraKeyspaceName;
            return (B)this.self();
        }

        @Generated
        public B cassandraKeyspaceQuery(String cassandraKeyspaceQuery) {
            this.cassandraKeyspaceQuery = cassandraKeyspaceQuery;
            return (B)this.self();
        }

        @Generated
        public B putCassandraKeyspaceReplication(String putCassandraKeyspaceReplicationKey, String putCassandraKeyspaceReplicationValue) {
            if (this.cassandraKeyspaceReplication$key == null) {
                this.cassandraKeyspaceReplication$key = new ArrayList();
                this.cassandraKeyspaceReplication$value = new ArrayList();
            }
            this.cassandraKeyspaceReplication$key.add(putCassandraKeyspaceReplicationKey);
            this.cassandraKeyspaceReplication$value.add(putCassandraKeyspaceReplicationValue);
            return (B)this.self();
        }

        @Generated
        public B cassandraKeyspaceReplication(Map<? extends String, ? extends String> cassandraKeyspaceReplication) {
            if (cassandraKeyspaceReplication == null) {
                throw new NullPointerException("cassandraKeyspaceReplication cannot be null");
            }
            if (this.cassandraKeyspaceReplication$key == null) {
                this.cassandraKeyspaceReplication$key = new ArrayList();
                this.cassandraKeyspaceReplication$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : cassandraKeyspaceReplication.entrySet()) {
                this.cassandraKeyspaceReplication$key.add($lombokEntry.getKey());
                this.cassandraKeyspaceReplication$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCassandraKeyspaceReplication() {
            if (this.cassandraKeyspaceReplication$key != null) {
                this.cassandraKeyspaceReplication$key.clear();
                this.cassandraKeyspaceReplication$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cassandraKeyspaceVirtual(Boolean cassandraKeyspaceVirtual) {
            this.cassandraKeyspaceVirtual = cassandraKeyspaceVirtual;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableName(String cassandraTableName) {
            this.cassandraTableName = cassandraTableName;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableQualifiedName(String cassandraTableQualifiedName) {
            this.cassandraTableQualifiedName = cassandraTableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cassandraTable(ICassandraTable cassandraTable) {
            if (this.cassandraTables == null) {
                this.cassandraTables = new ArrayList();
            }
            this.cassandraTables.add(cassandraTable);
            return (B)this.self();
        }

        @Generated
        public B cassandraTables(Collection<? extends ICassandraTable> cassandraTables) {
            if (cassandraTables == null) {
                throw new NullPointerException("cassandraTables cannot be null");
            }
            if (this.cassandraTables == null) {
                this.cassandraTables = new ArrayList();
            }
            this.cassandraTables.addAll(cassandraTables);
            return (B)this.self();
        }

        @Generated
        public B clearCassandraTables() {
            if (this.cassandraTables != null) {
                this.cassandraTables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cassandraViewName(String cassandraViewName) {
            this.cassandraViewName = cassandraViewName;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewQualifiedName(String cassandraViewQualifiedName) {
            this.cassandraViewQualifiedName = cassandraViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cassandraView(ICassandraView cassandraView) {
            if (this.cassandraViews == null) {
                this.cassandraViews = new ArrayList();
            }
            this.cassandraViews.add(cassandraView);
            return (B)this.self();
        }

        @Generated
        public B cassandraViews(Collection<? extends ICassandraView> cassandraViews) {
            if (cassandraViews == null) {
                throw new NullPointerException("cassandraViews cannot be null");
            }
            if (this.cassandraViews == null) {
                this.cassandraViews = new ArrayList();
            }
            this.cassandraViews.addAll(cassandraViews);
            return (B)this.self();
        }

        @Generated
        public B clearCassandraViews() {
            if (this.cassandraViews != null) {
                this.cassandraViews.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B noSQLSchemaDefinition(String noSQLSchemaDefinition) {
            this.noSQLSchemaDefinition = noSQLSchemaDefinition;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CassandraKeyspace.CassandraKeyspaceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cassandraKeyspaceDurableWrites=" + this.cassandraKeyspaceDurableWrites + ", cassandraKeyspaceName=" + this.cassandraKeyspaceName + ", cassandraKeyspaceQuery=" + this.cassandraKeyspaceQuery + ", cassandraKeyspaceReplication$key=" + String.valueOf(this.cassandraKeyspaceReplication$key) + ", cassandraKeyspaceReplication$value=" + String.valueOf(this.cassandraKeyspaceReplication$value) + ", cassandraKeyspaceVirtual=" + this.cassandraKeyspaceVirtual + ", cassandraTableName=" + this.cassandraTableName + ", cassandraTableQualifiedName=" + this.cassandraTableQualifiedName + ", cassandraTables=" + String.valueOf(this.cassandraTables) + ", cassandraViewName=" + this.cassandraViewName + ", cassandraViewQualifiedName=" + this.cassandraViewQualifiedName + ", cassandraViews=" + String.valueOf(this.cassandraViews) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", noSQLSchemaDefinition=" + this.noSQLSchemaDefinition + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class CassandraKeyspaceBuilderImpl
    extends CassandraKeyspaceBuilder<CassandraKeyspace, CassandraKeyspaceBuilderImpl> {
        @Generated
        private CassandraKeyspaceBuilderImpl() {
        }

        @Override
        @Generated
        protected CassandraKeyspaceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CassandraKeyspace build() {
            return new CassandraKeyspace(this);
        }
    }
}

