/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICassandra;
import com.atlan.model.assets.ICassandraColumn;
import com.atlan.model.assets.ICassandraIndex;
import com.atlan.model.assets.ICassandraKeyspace;
import com.atlan.model.assets.ICassandraTable;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.INoSQL;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraTable
extends Asset
implements ICassandraTable,
ICassandra,
INoSQL,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraTable.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CassandraTable";
    String typeName;
    @Attribute
    SortedSet<ICassandraColumn> cassandraColumns;
    @Attribute
    SortedSet<ICassandraIndex> cassandraIndexes;
    @Attribute
    ICassandraKeyspace cassandraKeyspace;
    @Attribute
    String cassandraKeyspaceName;
    @Attribute
    Double cassandraTableBloomFilterFPChance;
    @Attribute
    Double cassandraTableCRCCheckChance;
    @Attribute
    Map<String, String> cassandraTableCaching;
    @Attribute
    String cassandraTableComment;
    @Attribute
    Map<String, String> cassandraTableCompaction;
    @Attribute
    Map<String, String> cassandraTableCompression;
    @Attribute
    Double cassandraTableDCLocalReadRepairChance;
    @Attribute
    Long cassandraTableDefaultTTL;
    @Attribute
    SortedSet<String> cassandraTableFlags;
    @Attribute
    Long cassandraTableGCGraceSeconds;
    @Attribute
    String cassandraTableId;
    @Attribute
    Long cassandraTableMaxIndexInterval;
    @Attribute
    Long cassandraTableMemtableFlushPeriodInMs;
    @Attribute
    Long cassandraTableMinIndexInterval;
    @Attribute
    String cassandraTableName;
    @Attribute
    String cassandraTableQualifiedName;
    @Attribute
    String cassandraTableQuery;
    @Attribute
    Double cassandraTableReadRepairChance;
    @Attribute
    String cassandraTableSpeculativeRetry;
    @Attribute
    Boolean cassandraTableVirtual;
    @Attribute
    String cassandraViewName;
    @Attribute
    String cassandraViewQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    String noSQLSchemaDefinition;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public CassandraTable trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return CassandraTable.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return CassandraTable.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return CassandraTable.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return CassandraTable.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static CassandraTable refByGuid(String guid) {
        return CassandraTable.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static CassandraTable refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((CassandraTableBuilder)((CassandraTableBuilder)CassandraTable._internal().guid(guid)).semantic(semantic)).build();
    }

    public static CassandraTable refByQualifiedName(String qualifiedName) {
        return CassandraTable.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static CassandraTable refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((CassandraTableBuilder)((CassandraTableBuilder)CassandraTable._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static CassandraTable get(AtlanClient client, String id) throws AtlanException {
        return CassandraTable.get(client, id, false);
    }

    @JsonIgnore
    public static CassandraTable get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof CassandraTable) {
                return (CassandraTable)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof CassandraTable) {
            return (CassandraTable)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static CassandraTable get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return CassandraTable.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static CassandraTable get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CassandraTable.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof CassandraTable) {
                return (CassandraTable)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CassandraTable.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof CassandraTable) {
            return (CassandraTable)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static CassandraTableBuilder<?, ?> updater(String qualifiedName, String name) {
        return (CassandraTableBuilder)((CassandraTableBuilder)((CassandraTableBuilder)CassandraTable._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public CassandraTableBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        CassandraTable.validateRequired(TYPE_NAME, map);
        return CassandraTable.updater(this.getQualifiedName(), this.getName());
    }

    public static CassandraTable removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraTable)Asset.removeDescription(client, CassandraTable.updater(qualifiedName, name));
    }

    public static CassandraTable removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraTable)Asset.removeUserDescription(client, CassandraTable.updater(qualifiedName, name));
    }

    public static CassandraTable removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraTable)Asset.removeOwners(client, CassandraTable.updater(qualifiedName, name));
    }

    public static CassandraTable updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CassandraTable)Asset.updateCertificate(client, CassandraTable._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static CassandraTable removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraTable)Asset.removeCertificate(client, CassandraTable.updater(qualifiedName, name));
    }

    public static CassandraTable updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CassandraTable)Asset.updateAnnouncement(client, CassandraTable._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static CassandraTable removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CassandraTable)Asset.removeAnnouncement(client, CassandraTable.updater(qualifiedName, name));
    }

    public static CassandraTable replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraTable)Asset.replaceTerms(client, CassandraTable.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static CassandraTable appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraTable)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CassandraTable removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CassandraTable)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CassandraTable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CassandraTable)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static CassandraTable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CassandraTable)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected CassandraTable(CassandraTableBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> cassandraTableCompression;
        Map<Object, Object> cassandraTableCompaction;
        Map<Object, Object> cassandraTableCaching;
        this.typeName = b.typeName$set ? b.typeName$value : CassandraTable.$default$typeName();
        SortedSet<ICassandraColumn> cassandraColumns = new TreeSet<ICassandraColumn>();
        if (b.cassandraColumns != null) {
            cassandraColumns.addAll(b.cassandraColumns);
        }
        cassandraColumns = Collections.unmodifiableSortedSet(cassandraColumns);
        this.cassandraColumns = cassandraColumns;
        SortedSet<ICassandraIndex> cassandraIndexes = new TreeSet<ICassandraIndex>();
        if (b.cassandraIndexes != null) {
            cassandraIndexes.addAll(b.cassandraIndexes);
        }
        cassandraIndexes = Collections.unmodifiableSortedSet(cassandraIndexes);
        this.cassandraIndexes = cassandraIndexes;
        this.cassandraKeyspace = b.cassandraKeyspace;
        this.cassandraKeyspaceName = b.cassandraKeyspaceName;
        this.cassandraTableBloomFilterFPChance = b.cassandraTableBloomFilterFPChance;
        this.cassandraTableCRCCheckChance = b.cassandraTableCRCCheckChance;
        switch (b.cassandraTableCaching$key == null ? 0 : b.cassandraTableCaching$key.size()) {
            case 0: {
                cassandraTableCaching = Collections.emptyMap();
                break;
            }
            case 1: {
                cassandraTableCaching = Collections.singletonMap(b.cassandraTableCaching$key.get(0), b.cassandraTableCaching$value.get(0));
                break;
            }
            default: {
                cassandraTableCaching = new LinkedHashMap(b.cassandraTableCaching$key.size() < 0x40000000 ? 1 + b.cassandraTableCaching$key.size() + (b.cassandraTableCaching$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.cassandraTableCaching$key.size(); ++$i) {
                    cassandraTableCaching.put(b.cassandraTableCaching$key.get($i), b.cassandraTableCaching$value.get($i));
                }
                cassandraTableCaching = Collections.unmodifiableMap(cassandraTableCaching);
            }
        }
        this.cassandraTableCaching = cassandraTableCaching;
        this.cassandraTableComment = b.cassandraTableComment;
        switch (b.cassandraTableCompaction$key == null ? 0 : b.cassandraTableCompaction$key.size()) {
            case 0: {
                cassandraTableCompaction = Collections.emptyMap();
                break;
            }
            case 1: {
                cassandraTableCompaction = Collections.singletonMap(b.cassandraTableCompaction$key.get(0), b.cassandraTableCompaction$value.get(0));
                break;
            }
            default: {
                cassandraTableCompaction = new LinkedHashMap(b.cassandraTableCompaction$key.size() < 0x40000000 ? 1 + b.cassandraTableCompaction$key.size() + (b.cassandraTableCompaction$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.cassandraTableCompaction$key.size(); ++$i) {
                    cassandraTableCompaction.put(b.cassandraTableCompaction$key.get($i), b.cassandraTableCompaction$value.get($i));
                }
                cassandraTableCompaction = Collections.unmodifiableMap(cassandraTableCompaction);
            }
        }
        this.cassandraTableCompaction = cassandraTableCompaction;
        switch (b.cassandraTableCompression$key == null ? 0 : b.cassandraTableCompression$key.size()) {
            case 0: {
                cassandraTableCompression = Collections.emptyMap();
                break;
            }
            case 1: {
                cassandraTableCompression = Collections.singletonMap(b.cassandraTableCompression$key.get(0), b.cassandraTableCompression$value.get(0));
                break;
            }
            default: {
                cassandraTableCompression = new LinkedHashMap(b.cassandraTableCompression$key.size() < 0x40000000 ? 1 + b.cassandraTableCompression$key.size() + (b.cassandraTableCompression$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.cassandraTableCompression$key.size(); ++$i) {
                    cassandraTableCompression.put(b.cassandraTableCompression$key.get($i), b.cassandraTableCompression$value.get($i));
                }
                cassandraTableCompression = Collections.unmodifiableMap(cassandraTableCompression);
            }
        }
        this.cassandraTableCompression = cassandraTableCompression;
        this.cassandraTableDCLocalReadRepairChance = b.cassandraTableDCLocalReadRepairChance;
        this.cassandraTableDefaultTTL = b.cassandraTableDefaultTTL;
        SortedSet<String> cassandraTableFlags = new TreeSet<String>();
        if (b.cassandraTableFlags != null) {
            cassandraTableFlags.addAll(b.cassandraTableFlags);
        }
        cassandraTableFlags = Collections.unmodifiableSortedSet(cassandraTableFlags);
        this.cassandraTableFlags = cassandraTableFlags;
        this.cassandraTableGCGraceSeconds = b.cassandraTableGCGraceSeconds;
        this.cassandraTableId = b.cassandraTableId;
        this.cassandraTableMaxIndexInterval = b.cassandraTableMaxIndexInterval;
        this.cassandraTableMemtableFlushPeriodInMs = b.cassandraTableMemtableFlushPeriodInMs;
        this.cassandraTableMinIndexInterval = b.cassandraTableMinIndexInterval;
        this.cassandraTableName = b.cassandraTableName;
        this.cassandraTableQualifiedName = b.cassandraTableQualifiedName;
        this.cassandraTableQuery = b.cassandraTableQuery;
        this.cassandraTableReadRepairChance = b.cassandraTableReadRepairChance;
        this.cassandraTableSpeculativeRetry = b.cassandraTableSpeculativeRetry;
        this.cassandraTableVirtual = b.cassandraTableVirtual;
        this.cassandraViewName = b.cassandraViewName;
        this.cassandraViewQualifiedName = b.cassandraViewQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        this.noSQLSchemaDefinition = b.noSQLSchemaDefinition;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static CassandraTableBuilder<?, ?> _internal() {
        return new CassandraTableBuilderImpl();
    }

    @Generated
    public CassandraTableBuilder<?, ?> toBuilder() {
        return new CassandraTableBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<ICassandraColumn> getCassandraColumns() {
        return this.cassandraColumns;
    }

    @Override
    @Generated
    public SortedSet<ICassandraIndex> getCassandraIndexes() {
        return this.cassandraIndexes;
    }

    @Override
    @Generated
    public ICassandraKeyspace getCassandraKeyspace() {
        return this.cassandraKeyspace;
    }

    @Override
    @Generated
    public String getCassandraKeyspaceName() {
        return this.cassandraKeyspaceName;
    }

    @Override
    @Generated
    public Double getCassandraTableBloomFilterFPChance() {
        return this.cassandraTableBloomFilterFPChance;
    }

    @Override
    @Generated
    public Double getCassandraTableCRCCheckChance() {
        return this.cassandraTableCRCCheckChance;
    }

    @Override
    @Generated
    public Map<String, String> getCassandraTableCaching() {
        return this.cassandraTableCaching;
    }

    @Override
    @Generated
    public String getCassandraTableComment() {
        return this.cassandraTableComment;
    }

    @Override
    @Generated
    public Map<String, String> getCassandraTableCompaction() {
        return this.cassandraTableCompaction;
    }

    @Override
    @Generated
    public Map<String, String> getCassandraTableCompression() {
        return this.cassandraTableCompression;
    }

    @Override
    @Generated
    public Double getCassandraTableDCLocalReadRepairChance() {
        return this.cassandraTableDCLocalReadRepairChance;
    }

    @Override
    @Generated
    public Long getCassandraTableDefaultTTL() {
        return this.cassandraTableDefaultTTL;
    }

    @Override
    @Generated
    public SortedSet<String> getCassandraTableFlags() {
        return this.cassandraTableFlags;
    }

    @Override
    @Generated
    public Long getCassandraTableGCGraceSeconds() {
        return this.cassandraTableGCGraceSeconds;
    }

    @Override
    @Generated
    public String getCassandraTableId() {
        return this.cassandraTableId;
    }

    @Override
    @Generated
    public Long getCassandraTableMaxIndexInterval() {
        return this.cassandraTableMaxIndexInterval;
    }

    @Override
    @Generated
    public Long getCassandraTableMemtableFlushPeriodInMs() {
        return this.cassandraTableMemtableFlushPeriodInMs;
    }

    @Override
    @Generated
    public Long getCassandraTableMinIndexInterval() {
        return this.cassandraTableMinIndexInterval;
    }

    @Override
    @Generated
    public String getCassandraTableName() {
        return this.cassandraTableName;
    }

    @Override
    @Generated
    public String getCassandraTableQualifiedName() {
        return this.cassandraTableQualifiedName;
    }

    @Override
    @Generated
    public String getCassandraTableQuery() {
        return this.cassandraTableQuery;
    }

    @Override
    @Generated
    public Double getCassandraTableReadRepairChance() {
        return this.cassandraTableReadRepairChance;
    }

    @Override
    @Generated
    public String getCassandraTableSpeculativeRetry() {
        return this.cassandraTableSpeculativeRetry;
    }

    @Override
    @Generated
    public Boolean getCassandraTableVirtual() {
        return this.cassandraTableVirtual;
    }

    @Override
    @Generated
    public String getCassandraViewName() {
        return this.cassandraViewName;
    }

    @Override
    @Generated
    public String getCassandraViewQualifiedName() {
        return this.cassandraViewQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public String getNoSQLSchemaDefinition() {
        return this.noSQLSchemaDefinition;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraTable)) {
            return false;
        }
        CassandraTable other = (CassandraTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$cassandraTableBloomFilterFPChance = this.getCassandraTableBloomFilterFPChance();
        Double other$cassandraTableBloomFilterFPChance = other.getCassandraTableBloomFilterFPChance();
        if (this$cassandraTableBloomFilterFPChance == null ? other$cassandraTableBloomFilterFPChance != null : !((Object)this$cassandraTableBloomFilterFPChance).equals(other$cassandraTableBloomFilterFPChance)) {
            return false;
        }
        Double this$cassandraTableCRCCheckChance = this.getCassandraTableCRCCheckChance();
        Double other$cassandraTableCRCCheckChance = other.getCassandraTableCRCCheckChance();
        if (this$cassandraTableCRCCheckChance == null ? other$cassandraTableCRCCheckChance != null : !((Object)this$cassandraTableCRCCheckChance).equals(other$cassandraTableCRCCheckChance)) {
            return false;
        }
        Double this$cassandraTableDCLocalReadRepairChance = this.getCassandraTableDCLocalReadRepairChance();
        Double other$cassandraTableDCLocalReadRepairChance = other.getCassandraTableDCLocalReadRepairChance();
        if (this$cassandraTableDCLocalReadRepairChance == null ? other$cassandraTableDCLocalReadRepairChance != null : !((Object)this$cassandraTableDCLocalReadRepairChance).equals(other$cassandraTableDCLocalReadRepairChance)) {
            return false;
        }
        Long this$cassandraTableDefaultTTL = this.getCassandraTableDefaultTTL();
        Long other$cassandraTableDefaultTTL = other.getCassandraTableDefaultTTL();
        if (this$cassandraTableDefaultTTL == null ? other$cassandraTableDefaultTTL != null : !((Object)this$cassandraTableDefaultTTL).equals(other$cassandraTableDefaultTTL)) {
            return false;
        }
        Long this$cassandraTableGCGraceSeconds = this.getCassandraTableGCGraceSeconds();
        Long other$cassandraTableGCGraceSeconds = other.getCassandraTableGCGraceSeconds();
        if (this$cassandraTableGCGraceSeconds == null ? other$cassandraTableGCGraceSeconds != null : !((Object)this$cassandraTableGCGraceSeconds).equals(other$cassandraTableGCGraceSeconds)) {
            return false;
        }
        Long this$cassandraTableMaxIndexInterval = this.getCassandraTableMaxIndexInterval();
        Long other$cassandraTableMaxIndexInterval = other.getCassandraTableMaxIndexInterval();
        if (this$cassandraTableMaxIndexInterval == null ? other$cassandraTableMaxIndexInterval != null : !((Object)this$cassandraTableMaxIndexInterval).equals(other$cassandraTableMaxIndexInterval)) {
            return false;
        }
        Long this$cassandraTableMemtableFlushPeriodInMs = this.getCassandraTableMemtableFlushPeriodInMs();
        Long other$cassandraTableMemtableFlushPeriodInMs = other.getCassandraTableMemtableFlushPeriodInMs();
        if (this$cassandraTableMemtableFlushPeriodInMs == null ? other$cassandraTableMemtableFlushPeriodInMs != null : !((Object)this$cassandraTableMemtableFlushPeriodInMs).equals(other$cassandraTableMemtableFlushPeriodInMs)) {
            return false;
        }
        Long this$cassandraTableMinIndexInterval = this.getCassandraTableMinIndexInterval();
        Long other$cassandraTableMinIndexInterval = other.getCassandraTableMinIndexInterval();
        if (this$cassandraTableMinIndexInterval == null ? other$cassandraTableMinIndexInterval != null : !((Object)this$cassandraTableMinIndexInterval).equals(other$cassandraTableMinIndexInterval)) {
            return false;
        }
        Double this$cassandraTableReadRepairChance = this.getCassandraTableReadRepairChance();
        Double other$cassandraTableReadRepairChance = other.getCassandraTableReadRepairChance();
        if (this$cassandraTableReadRepairChance == null ? other$cassandraTableReadRepairChance != null : !((Object)this$cassandraTableReadRepairChance).equals(other$cassandraTableReadRepairChance)) {
            return false;
        }
        Boolean this$cassandraTableVirtual = this.getCassandraTableVirtual();
        Boolean other$cassandraTableVirtual = other.getCassandraTableVirtual();
        if (this$cassandraTableVirtual == null ? other$cassandraTableVirtual != null : !((Object)this$cassandraTableVirtual).equals(other$cassandraTableVirtual)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<ICassandraColumn> this$cassandraColumns = this.getCassandraColumns();
        SortedSet<ICassandraColumn> other$cassandraColumns = other.getCassandraColumns();
        if (this$cassandraColumns == null ? other$cassandraColumns != null : !this$cassandraColumns.equals(other$cassandraColumns)) {
            return false;
        }
        SortedSet<ICassandraIndex> this$cassandraIndexes = this.getCassandraIndexes();
        SortedSet<ICassandraIndex> other$cassandraIndexes = other.getCassandraIndexes();
        if (this$cassandraIndexes == null ? other$cassandraIndexes != null : !this$cassandraIndexes.equals(other$cassandraIndexes)) {
            return false;
        }
        ICassandraKeyspace this$cassandraKeyspace = this.getCassandraKeyspace();
        ICassandraKeyspace other$cassandraKeyspace = other.getCassandraKeyspace();
        if (this$cassandraKeyspace == null ? other$cassandraKeyspace != null : !this$cassandraKeyspace.equals(other$cassandraKeyspace)) {
            return false;
        }
        String this$cassandraKeyspaceName = this.getCassandraKeyspaceName();
        String other$cassandraKeyspaceName = other.getCassandraKeyspaceName();
        if (this$cassandraKeyspaceName == null ? other$cassandraKeyspaceName != null : !this$cassandraKeyspaceName.equals(other$cassandraKeyspaceName)) {
            return false;
        }
        Map<String, String> this$cassandraTableCaching = this.getCassandraTableCaching();
        Map<String, String> other$cassandraTableCaching = other.getCassandraTableCaching();
        if (this$cassandraTableCaching == null ? other$cassandraTableCaching != null : !((Object)this$cassandraTableCaching).equals(other$cassandraTableCaching)) {
            return false;
        }
        String this$cassandraTableComment = this.getCassandraTableComment();
        String other$cassandraTableComment = other.getCassandraTableComment();
        if (this$cassandraTableComment == null ? other$cassandraTableComment != null : !this$cassandraTableComment.equals(other$cassandraTableComment)) {
            return false;
        }
        Map<String, String> this$cassandraTableCompaction = this.getCassandraTableCompaction();
        Map<String, String> other$cassandraTableCompaction = other.getCassandraTableCompaction();
        if (this$cassandraTableCompaction == null ? other$cassandraTableCompaction != null : !((Object)this$cassandraTableCompaction).equals(other$cassandraTableCompaction)) {
            return false;
        }
        Map<String, String> this$cassandraTableCompression = this.getCassandraTableCompression();
        Map<String, String> other$cassandraTableCompression = other.getCassandraTableCompression();
        if (this$cassandraTableCompression == null ? other$cassandraTableCompression != null : !((Object)this$cassandraTableCompression).equals(other$cassandraTableCompression)) {
            return false;
        }
        SortedSet<String> this$cassandraTableFlags = this.getCassandraTableFlags();
        SortedSet<String> other$cassandraTableFlags = other.getCassandraTableFlags();
        if (this$cassandraTableFlags == null ? other$cassandraTableFlags != null : !this$cassandraTableFlags.equals(other$cassandraTableFlags)) {
            return false;
        }
        String this$cassandraTableId = this.getCassandraTableId();
        String other$cassandraTableId = other.getCassandraTableId();
        if (this$cassandraTableId == null ? other$cassandraTableId != null : !this$cassandraTableId.equals(other$cassandraTableId)) {
            return false;
        }
        String this$cassandraTableName = this.getCassandraTableName();
        String other$cassandraTableName = other.getCassandraTableName();
        if (this$cassandraTableName == null ? other$cassandraTableName != null : !this$cassandraTableName.equals(other$cassandraTableName)) {
            return false;
        }
        String this$cassandraTableQualifiedName = this.getCassandraTableQualifiedName();
        String other$cassandraTableQualifiedName = other.getCassandraTableQualifiedName();
        if (this$cassandraTableQualifiedName == null ? other$cassandraTableQualifiedName != null : !this$cassandraTableQualifiedName.equals(other$cassandraTableQualifiedName)) {
            return false;
        }
        String this$cassandraTableQuery = this.getCassandraTableQuery();
        String other$cassandraTableQuery = other.getCassandraTableQuery();
        if (this$cassandraTableQuery == null ? other$cassandraTableQuery != null : !this$cassandraTableQuery.equals(other$cassandraTableQuery)) {
            return false;
        }
        String this$cassandraTableSpeculativeRetry = this.getCassandraTableSpeculativeRetry();
        String other$cassandraTableSpeculativeRetry = other.getCassandraTableSpeculativeRetry();
        if (this$cassandraTableSpeculativeRetry == null ? other$cassandraTableSpeculativeRetry != null : !this$cassandraTableSpeculativeRetry.equals(other$cassandraTableSpeculativeRetry)) {
            return false;
        }
        String this$cassandraViewName = this.getCassandraViewName();
        String other$cassandraViewName = other.getCassandraViewName();
        if (this$cassandraViewName == null ? other$cassandraViewName != null : !this$cassandraViewName.equals(other$cassandraViewName)) {
            return false;
        }
        String this$cassandraViewQualifiedName = this.getCassandraViewQualifiedName();
        String other$cassandraViewQualifiedName = other.getCassandraViewQualifiedName();
        if (this$cassandraViewQualifiedName == null ? other$cassandraViewQualifiedName != null : !this$cassandraViewQualifiedName.equals(other$cassandraViewQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        String this$noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        String other$noSQLSchemaDefinition = other.getNoSQLSchemaDefinition();
        if (this$noSQLSchemaDefinition == null ? other$noSQLSchemaDefinition != null : !this$noSQLSchemaDefinition.equals(other$noSQLSchemaDefinition)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CassandraTable;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $cassandraTableBloomFilterFPChance = this.getCassandraTableBloomFilterFPChance();
        result = result * 59 + ($cassandraTableBloomFilterFPChance == null ? 43 : ((Object)$cassandraTableBloomFilterFPChance).hashCode());
        Double $cassandraTableCRCCheckChance = this.getCassandraTableCRCCheckChance();
        result = result * 59 + ($cassandraTableCRCCheckChance == null ? 43 : ((Object)$cassandraTableCRCCheckChance).hashCode());
        Double $cassandraTableDCLocalReadRepairChance = this.getCassandraTableDCLocalReadRepairChance();
        result = result * 59 + ($cassandraTableDCLocalReadRepairChance == null ? 43 : ((Object)$cassandraTableDCLocalReadRepairChance).hashCode());
        Long $cassandraTableDefaultTTL = this.getCassandraTableDefaultTTL();
        result = result * 59 + ($cassandraTableDefaultTTL == null ? 43 : ((Object)$cassandraTableDefaultTTL).hashCode());
        Long $cassandraTableGCGraceSeconds = this.getCassandraTableGCGraceSeconds();
        result = result * 59 + ($cassandraTableGCGraceSeconds == null ? 43 : ((Object)$cassandraTableGCGraceSeconds).hashCode());
        Long $cassandraTableMaxIndexInterval = this.getCassandraTableMaxIndexInterval();
        result = result * 59 + ($cassandraTableMaxIndexInterval == null ? 43 : ((Object)$cassandraTableMaxIndexInterval).hashCode());
        Long $cassandraTableMemtableFlushPeriodInMs = this.getCassandraTableMemtableFlushPeriodInMs();
        result = result * 59 + ($cassandraTableMemtableFlushPeriodInMs == null ? 43 : ((Object)$cassandraTableMemtableFlushPeriodInMs).hashCode());
        Long $cassandraTableMinIndexInterval = this.getCassandraTableMinIndexInterval();
        result = result * 59 + ($cassandraTableMinIndexInterval == null ? 43 : ((Object)$cassandraTableMinIndexInterval).hashCode());
        Double $cassandraTableReadRepairChance = this.getCassandraTableReadRepairChance();
        result = result * 59 + ($cassandraTableReadRepairChance == null ? 43 : ((Object)$cassandraTableReadRepairChance).hashCode());
        Boolean $cassandraTableVirtual = this.getCassandraTableVirtual();
        result = result * 59 + ($cassandraTableVirtual == null ? 43 : ((Object)$cassandraTableVirtual).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<ICassandraColumn> $cassandraColumns = this.getCassandraColumns();
        result = result * 59 + ($cassandraColumns == null ? 43 : $cassandraColumns.hashCode());
        SortedSet<ICassandraIndex> $cassandraIndexes = this.getCassandraIndexes();
        result = result * 59 + ($cassandraIndexes == null ? 43 : $cassandraIndexes.hashCode());
        ICassandraKeyspace $cassandraKeyspace = this.getCassandraKeyspace();
        result = result * 59 + ($cassandraKeyspace == null ? 43 : $cassandraKeyspace.hashCode());
        String $cassandraKeyspaceName = this.getCassandraKeyspaceName();
        result = result * 59 + ($cassandraKeyspaceName == null ? 43 : $cassandraKeyspaceName.hashCode());
        Map<String, String> $cassandraTableCaching = this.getCassandraTableCaching();
        result = result * 59 + ($cassandraTableCaching == null ? 43 : ((Object)$cassandraTableCaching).hashCode());
        String $cassandraTableComment = this.getCassandraTableComment();
        result = result * 59 + ($cassandraTableComment == null ? 43 : $cassandraTableComment.hashCode());
        Map<String, String> $cassandraTableCompaction = this.getCassandraTableCompaction();
        result = result * 59 + ($cassandraTableCompaction == null ? 43 : ((Object)$cassandraTableCompaction).hashCode());
        Map<String, String> $cassandraTableCompression = this.getCassandraTableCompression();
        result = result * 59 + ($cassandraTableCompression == null ? 43 : ((Object)$cassandraTableCompression).hashCode());
        SortedSet<String> $cassandraTableFlags = this.getCassandraTableFlags();
        result = result * 59 + ($cassandraTableFlags == null ? 43 : $cassandraTableFlags.hashCode());
        String $cassandraTableId = this.getCassandraTableId();
        result = result * 59 + ($cassandraTableId == null ? 43 : $cassandraTableId.hashCode());
        String $cassandraTableName = this.getCassandraTableName();
        result = result * 59 + ($cassandraTableName == null ? 43 : $cassandraTableName.hashCode());
        String $cassandraTableQualifiedName = this.getCassandraTableQualifiedName();
        result = result * 59 + ($cassandraTableQualifiedName == null ? 43 : $cassandraTableQualifiedName.hashCode());
        String $cassandraTableQuery = this.getCassandraTableQuery();
        result = result * 59 + ($cassandraTableQuery == null ? 43 : $cassandraTableQuery.hashCode());
        String $cassandraTableSpeculativeRetry = this.getCassandraTableSpeculativeRetry();
        result = result * 59 + ($cassandraTableSpeculativeRetry == null ? 43 : $cassandraTableSpeculativeRetry.hashCode());
        String $cassandraViewName = this.getCassandraViewName();
        result = result * 59 + ($cassandraViewName == null ? 43 : $cassandraViewName.hashCode());
        String $cassandraViewQualifiedName = this.getCassandraViewQualifiedName();
        result = result * 59 + ($cassandraViewQualifiedName == null ? 43 : $cassandraViewQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        String $noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        result = result * 59 + ($noSQLSchemaDefinition == null ? 43 : $noSQLSchemaDefinition.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CassandraTable(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cassandraColumns=" + String.valueOf(this.getCassandraColumns()) + ", cassandraIndexes=" + String.valueOf(this.getCassandraIndexes()) + ", cassandraKeyspace=" + String.valueOf(this.getCassandraKeyspace()) + ", cassandraKeyspaceName=" + this.getCassandraKeyspaceName() + ", cassandraTableBloomFilterFPChance=" + this.getCassandraTableBloomFilterFPChance() + ", cassandraTableCRCCheckChance=" + this.getCassandraTableCRCCheckChance() + ", cassandraTableCaching=" + String.valueOf(this.getCassandraTableCaching()) + ", cassandraTableComment=" + this.getCassandraTableComment() + ", cassandraTableCompaction=" + String.valueOf(this.getCassandraTableCompaction()) + ", cassandraTableCompression=" + String.valueOf(this.getCassandraTableCompression()) + ", cassandraTableDCLocalReadRepairChance=" + this.getCassandraTableDCLocalReadRepairChance() + ", cassandraTableDefaultTTL=" + this.getCassandraTableDefaultTTL() + ", cassandraTableFlags=" + String.valueOf(this.getCassandraTableFlags()) + ", cassandraTableGCGraceSeconds=" + this.getCassandraTableGCGraceSeconds() + ", cassandraTableId=" + this.getCassandraTableId() + ", cassandraTableMaxIndexInterval=" + this.getCassandraTableMaxIndexInterval() + ", cassandraTableMemtableFlushPeriodInMs=" + this.getCassandraTableMemtableFlushPeriodInMs() + ", cassandraTableMinIndexInterval=" + this.getCassandraTableMinIndexInterval() + ", cassandraTableName=" + this.getCassandraTableName() + ", cassandraTableQualifiedName=" + this.getCassandraTableQualifiedName() + ", cassandraTableQuery=" + this.getCassandraTableQuery() + ", cassandraTableReadRepairChance=" + this.getCassandraTableReadRepairChance() + ", cassandraTableSpeculativeRetry=" + this.getCassandraTableSpeculativeRetry() + ", cassandraTableVirtual=" + this.getCassandraTableVirtual() + ", cassandraViewName=" + this.getCassandraViewName() + ", cassandraViewQualifiedName=" + this.getCassandraViewQualifiedName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", noSQLSchemaDefinition=" + this.getNoSQLSchemaDefinition() + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class CassandraTableBuilder<C extends CassandraTable, B extends CassandraTableBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<ICassandraColumn> cassandraColumns;
        @Generated
        private ArrayList<ICassandraIndex> cassandraIndexes;
        @Generated
        private ICassandraKeyspace cassandraKeyspace;
        @Generated
        private String cassandraKeyspaceName;
        @Generated
        private Double cassandraTableBloomFilterFPChance;
        @Generated
        private Double cassandraTableCRCCheckChance;
        @Generated
        private ArrayList<String> cassandraTableCaching$key;
        @Generated
        private ArrayList<String> cassandraTableCaching$value;
        @Generated
        private String cassandraTableComment;
        @Generated
        private ArrayList<String> cassandraTableCompaction$key;
        @Generated
        private ArrayList<String> cassandraTableCompaction$value;
        @Generated
        private ArrayList<String> cassandraTableCompression$key;
        @Generated
        private ArrayList<String> cassandraTableCompression$value;
        @Generated
        private Double cassandraTableDCLocalReadRepairChance;
        @Generated
        private Long cassandraTableDefaultTTL;
        @Generated
        private ArrayList<String> cassandraTableFlags;
        @Generated
        private Long cassandraTableGCGraceSeconds;
        @Generated
        private String cassandraTableId;
        @Generated
        private Long cassandraTableMaxIndexInterval;
        @Generated
        private Long cassandraTableMemtableFlushPeriodInMs;
        @Generated
        private Long cassandraTableMinIndexInterval;
        @Generated
        private String cassandraTableName;
        @Generated
        private String cassandraTableQualifiedName;
        @Generated
        private String cassandraTableQuery;
        @Generated
        private Double cassandraTableReadRepairChance;
        @Generated
        private String cassandraTableSpeculativeRetry;
        @Generated
        private Boolean cassandraTableVirtual;
        @Generated
        private String cassandraViewName;
        @Generated
        private String cassandraViewQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private String noSQLSchemaDefinition;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CassandraTableBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CassandraTable instance, CassandraTableBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cassandraColumns(instance.cassandraColumns == null ? Collections.emptySortedSet() : instance.cassandraColumns);
            b.cassandraIndexes(instance.cassandraIndexes == null ? Collections.emptySortedSet() : instance.cassandraIndexes);
            b.cassandraKeyspace(instance.cassandraKeyspace);
            b.cassandraKeyspaceName(instance.cassandraKeyspaceName);
            b.cassandraTableBloomFilterFPChance(instance.cassandraTableBloomFilterFPChance);
            b.cassandraTableCRCCheckChance(instance.cassandraTableCRCCheckChance);
            b.cassandraTableCaching(instance.cassandraTableCaching == null ? Collections.emptyMap() : instance.cassandraTableCaching);
            b.cassandraTableComment(instance.cassandraTableComment);
            b.cassandraTableCompaction(instance.cassandraTableCompaction == null ? Collections.emptyMap() : instance.cassandraTableCompaction);
            b.cassandraTableCompression(instance.cassandraTableCompression == null ? Collections.emptyMap() : instance.cassandraTableCompression);
            b.cassandraTableDCLocalReadRepairChance(instance.cassandraTableDCLocalReadRepairChance);
            b.cassandraTableDefaultTTL(instance.cassandraTableDefaultTTL);
            b.cassandraTableFlags(instance.cassandraTableFlags == null ? Collections.emptySortedSet() : instance.cassandraTableFlags);
            b.cassandraTableGCGraceSeconds(instance.cassandraTableGCGraceSeconds);
            b.cassandraTableId(instance.cassandraTableId);
            b.cassandraTableMaxIndexInterval(instance.cassandraTableMaxIndexInterval);
            b.cassandraTableMemtableFlushPeriodInMs(instance.cassandraTableMemtableFlushPeriodInMs);
            b.cassandraTableMinIndexInterval(instance.cassandraTableMinIndexInterval);
            b.cassandraTableName(instance.cassandraTableName);
            b.cassandraTableQualifiedName(instance.cassandraTableQualifiedName);
            b.cassandraTableQuery(instance.cassandraTableQuery);
            b.cassandraTableReadRepairChance(instance.cassandraTableReadRepairChance);
            b.cassandraTableSpeculativeRetry(instance.cassandraTableSpeculativeRetry);
            b.cassandraTableVirtual(instance.cassandraTableVirtual);
            b.cassandraViewName(instance.cassandraViewName);
            b.cassandraViewQualifiedName(instance.cassandraViewQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.noSQLSchemaDefinition(instance.noSQLSchemaDefinition);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B cassandraColumn(ICassandraColumn cassandraColumn) {
            if (this.cassandraColumns == null) {
                this.cassandraColumns = new ArrayList();
            }
            this.cassandraColumns.add(cassandraColumn);
            return (B)this.self();
        }

        @Generated
        public B cassandraColumns(Collection<? extends ICassandraColumn> cassandraColumns) {
            if (cassandraColumns == null) {
                throw new NullPointerException("cassandraColumns cannot be null");
            }
            if (this.cassandraColumns == null) {
                this.cassandraColumns = new ArrayList();
            }
            this.cassandraColumns.addAll(cassandraColumns);
            return (B)this.self();
        }

        @Generated
        public B clearCassandraColumns() {
            if (this.cassandraColumns != null) {
                this.cassandraColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cassandraIndex(ICassandraIndex cassandraIndex) {
            if (this.cassandraIndexes == null) {
                this.cassandraIndexes = new ArrayList();
            }
            this.cassandraIndexes.add(cassandraIndex);
            return (B)this.self();
        }

        @Generated
        public B cassandraIndexes(Collection<? extends ICassandraIndex> cassandraIndexes) {
            if (cassandraIndexes == null) {
                throw new NullPointerException("cassandraIndexes cannot be null");
            }
            if (this.cassandraIndexes == null) {
                this.cassandraIndexes = new ArrayList();
            }
            this.cassandraIndexes.addAll(cassandraIndexes);
            return (B)this.self();
        }

        @Generated
        public B clearCassandraIndexes() {
            if (this.cassandraIndexes != null) {
                this.cassandraIndexes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cassandraKeyspace(ICassandraKeyspace cassandraKeyspace) {
            this.cassandraKeyspace = cassandraKeyspace;
            return (B)this.self();
        }

        @Generated
        public B cassandraKeyspaceName(String cassandraKeyspaceName) {
            this.cassandraKeyspaceName = cassandraKeyspaceName;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableBloomFilterFPChance(Double cassandraTableBloomFilterFPChance) {
            this.cassandraTableBloomFilterFPChance = cassandraTableBloomFilterFPChance;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableCRCCheckChance(Double cassandraTableCRCCheckChance) {
            this.cassandraTableCRCCheckChance = cassandraTableCRCCheckChance;
            return (B)this.self();
        }

        @Generated
        public B putCassandraTableCaching(String putCassandraTableCachingKey, String putCassandraTableCachingValue) {
            if (this.cassandraTableCaching$key == null) {
                this.cassandraTableCaching$key = new ArrayList();
                this.cassandraTableCaching$value = new ArrayList();
            }
            this.cassandraTableCaching$key.add(putCassandraTableCachingKey);
            this.cassandraTableCaching$value.add(putCassandraTableCachingValue);
            return (B)this.self();
        }

        @Generated
        public B cassandraTableCaching(Map<? extends String, ? extends String> cassandraTableCaching) {
            if (cassandraTableCaching == null) {
                throw new NullPointerException("cassandraTableCaching cannot be null");
            }
            if (this.cassandraTableCaching$key == null) {
                this.cassandraTableCaching$key = new ArrayList();
                this.cassandraTableCaching$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : cassandraTableCaching.entrySet()) {
                this.cassandraTableCaching$key.add($lombokEntry.getKey());
                this.cassandraTableCaching$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCassandraTableCaching() {
            if (this.cassandraTableCaching$key != null) {
                this.cassandraTableCaching$key.clear();
                this.cassandraTableCaching$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cassandraTableComment(String cassandraTableComment) {
            this.cassandraTableComment = cassandraTableComment;
            return (B)this.self();
        }

        @Generated
        public B putCassandraTableCompaction(String putCassandraTableCompactionKey, String putCassandraTableCompactionValue) {
            if (this.cassandraTableCompaction$key == null) {
                this.cassandraTableCompaction$key = new ArrayList();
                this.cassandraTableCompaction$value = new ArrayList();
            }
            this.cassandraTableCompaction$key.add(putCassandraTableCompactionKey);
            this.cassandraTableCompaction$value.add(putCassandraTableCompactionValue);
            return (B)this.self();
        }

        @Generated
        public B cassandraTableCompaction(Map<? extends String, ? extends String> cassandraTableCompaction) {
            if (cassandraTableCompaction == null) {
                throw new NullPointerException("cassandraTableCompaction cannot be null");
            }
            if (this.cassandraTableCompaction$key == null) {
                this.cassandraTableCompaction$key = new ArrayList();
                this.cassandraTableCompaction$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : cassandraTableCompaction.entrySet()) {
                this.cassandraTableCompaction$key.add($lombokEntry.getKey());
                this.cassandraTableCompaction$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCassandraTableCompaction() {
            if (this.cassandraTableCompaction$key != null) {
                this.cassandraTableCompaction$key.clear();
                this.cassandraTableCompaction$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B putCassandraTableCompression(String putCassandraTableCompressionKey, String putCassandraTableCompressionValue) {
            if (this.cassandraTableCompression$key == null) {
                this.cassandraTableCompression$key = new ArrayList();
                this.cassandraTableCompression$value = new ArrayList();
            }
            this.cassandraTableCompression$key.add(putCassandraTableCompressionKey);
            this.cassandraTableCompression$value.add(putCassandraTableCompressionValue);
            return (B)this.self();
        }

        @Generated
        public B cassandraTableCompression(Map<? extends String, ? extends String> cassandraTableCompression) {
            if (cassandraTableCompression == null) {
                throw new NullPointerException("cassandraTableCompression cannot be null");
            }
            if (this.cassandraTableCompression$key == null) {
                this.cassandraTableCompression$key = new ArrayList();
                this.cassandraTableCompression$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : cassandraTableCompression.entrySet()) {
                this.cassandraTableCompression$key.add($lombokEntry.getKey());
                this.cassandraTableCompression$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCassandraTableCompression() {
            if (this.cassandraTableCompression$key != null) {
                this.cassandraTableCompression$key.clear();
                this.cassandraTableCompression$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cassandraTableDCLocalReadRepairChance(Double cassandraTableDCLocalReadRepairChance) {
            this.cassandraTableDCLocalReadRepairChance = cassandraTableDCLocalReadRepairChance;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableDefaultTTL(Long cassandraTableDefaultTTL) {
            this.cassandraTableDefaultTTL = cassandraTableDefaultTTL;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableFlag(String cassandraTableFlag) {
            if (this.cassandraTableFlags == null) {
                this.cassandraTableFlags = new ArrayList();
            }
            this.cassandraTableFlags.add(cassandraTableFlag);
            return (B)this.self();
        }

        @Generated
        public B cassandraTableFlags(Collection<? extends String> cassandraTableFlags) {
            if (cassandraTableFlags == null) {
                throw new NullPointerException("cassandraTableFlags cannot be null");
            }
            if (this.cassandraTableFlags == null) {
                this.cassandraTableFlags = new ArrayList();
            }
            this.cassandraTableFlags.addAll(cassandraTableFlags);
            return (B)this.self();
        }

        @Generated
        public B clearCassandraTableFlags() {
            if (this.cassandraTableFlags != null) {
                this.cassandraTableFlags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cassandraTableGCGraceSeconds(Long cassandraTableGCGraceSeconds) {
            this.cassandraTableGCGraceSeconds = cassandraTableGCGraceSeconds;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableId(String cassandraTableId) {
            this.cassandraTableId = cassandraTableId;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableMaxIndexInterval(Long cassandraTableMaxIndexInterval) {
            this.cassandraTableMaxIndexInterval = cassandraTableMaxIndexInterval;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableMemtableFlushPeriodInMs(Long cassandraTableMemtableFlushPeriodInMs) {
            this.cassandraTableMemtableFlushPeriodInMs = cassandraTableMemtableFlushPeriodInMs;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableMinIndexInterval(Long cassandraTableMinIndexInterval) {
            this.cassandraTableMinIndexInterval = cassandraTableMinIndexInterval;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableName(String cassandraTableName) {
            this.cassandraTableName = cassandraTableName;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableQualifiedName(String cassandraTableQualifiedName) {
            this.cassandraTableQualifiedName = cassandraTableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableQuery(String cassandraTableQuery) {
            this.cassandraTableQuery = cassandraTableQuery;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableReadRepairChance(Double cassandraTableReadRepairChance) {
            this.cassandraTableReadRepairChance = cassandraTableReadRepairChance;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableSpeculativeRetry(String cassandraTableSpeculativeRetry) {
            this.cassandraTableSpeculativeRetry = cassandraTableSpeculativeRetry;
            return (B)this.self();
        }

        @Generated
        public B cassandraTableVirtual(Boolean cassandraTableVirtual) {
            this.cassandraTableVirtual = cassandraTableVirtual;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewName(String cassandraViewName) {
            this.cassandraViewName = cassandraViewName;
            return (B)this.self();
        }

        @Generated
        public B cassandraViewQualifiedName(String cassandraViewQualifiedName) {
            this.cassandraViewQualifiedName = cassandraViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B noSQLSchemaDefinition(String noSQLSchemaDefinition) {
            this.noSQLSchemaDefinition = noSQLSchemaDefinition;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CassandraTable.CassandraTableBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cassandraColumns=" + String.valueOf(this.cassandraColumns) + ", cassandraIndexes=" + String.valueOf(this.cassandraIndexes) + ", cassandraKeyspace=" + String.valueOf(this.cassandraKeyspace) + ", cassandraKeyspaceName=" + this.cassandraKeyspaceName + ", cassandraTableBloomFilterFPChance=" + this.cassandraTableBloomFilterFPChance + ", cassandraTableCRCCheckChance=" + this.cassandraTableCRCCheckChance + ", cassandraTableCaching$key=" + String.valueOf(this.cassandraTableCaching$key) + ", cassandraTableCaching$value=" + String.valueOf(this.cassandraTableCaching$value) + ", cassandraTableComment=" + this.cassandraTableComment + ", cassandraTableCompaction$key=" + String.valueOf(this.cassandraTableCompaction$key) + ", cassandraTableCompaction$value=" + String.valueOf(this.cassandraTableCompaction$value) + ", cassandraTableCompression$key=" + String.valueOf(this.cassandraTableCompression$key) + ", cassandraTableCompression$value=" + String.valueOf(this.cassandraTableCompression$value) + ", cassandraTableDCLocalReadRepairChance=" + this.cassandraTableDCLocalReadRepairChance + ", cassandraTableDefaultTTL=" + this.cassandraTableDefaultTTL + ", cassandraTableFlags=" + String.valueOf(this.cassandraTableFlags) + ", cassandraTableGCGraceSeconds=" + this.cassandraTableGCGraceSeconds + ", cassandraTableId=" + this.cassandraTableId + ", cassandraTableMaxIndexInterval=" + this.cassandraTableMaxIndexInterval + ", cassandraTableMemtableFlushPeriodInMs=" + this.cassandraTableMemtableFlushPeriodInMs + ", cassandraTableMinIndexInterval=" + this.cassandraTableMinIndexInterval + ", cassandraTableName=" + this.cassandraTableName + ", cassandraTableQualifiedName=" + this.cassandraTableQualifiedName + ", cassandraTableQuery=" + this.cassandraTableQuery + ", cassandraTableReadRepairChance=" + this.cassandraTableReadRepairChance + ", cassandraTableSpeculativeRetry=" + this.cassandraTableSpeculativeRetry + ", cassandraTableVirtual=" + this.cassandraTableVirtual + ", cassandraViewName=" + this.cassandraViewName + ", cassandraViewQualifiedName=" + this.cassandraViewQualifiedName + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", noSQLSchemaDefinition=" + this.noSQLSchemaDefinition + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class CassandraTableBuilderImpl
    extends CassandraTableBuilder<CassandraTable, CassandraTableBuilderImpl> {
        @Generated
        private CassandraTableBuilderImpl() {
        }

        @Override
        @Generated
        protected CassandraTableBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CassandraTable build() {
            return new CassandraTable(this);
        }
    }
}

