/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAdfActivity;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumnProcess;
import com.atlan.model.assets.IFivetranConnector;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMatillionComponent;
import com.atlan.model.assets.IPowerBIDataflow;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.LineageProcess;
import com.atlan.model.enums.AIDatasetType;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnProcess
extends Asset
implements IColumnProcess,
ILineageProcess,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ColumnProcess.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ColumnProcess";
    String typeName;
    @Attribute
    String additionalEtlContext;
    @Attribute
    IAdfActivity adfActivity;
    @Attribute
    AIDatasetType aiDatasetType;
    @Attribute
    SortedSet<IAirflowTask> airflowTasks;
    @Attribute
    String ast;
    @Attribute
    String code;
    @Attribute
    SortedSet<IColumnProcess> columnProcesses;
    @Attribute
    IFivetranConnector fivetranConnector;
    @Attribute
    SortedSet<ICatalog> inputs;
    @Attribute
    IMatillionComponent matillionComponent;
    @Attribute
    SortedSet<ICatalog> outputs;
    @Attribute
    @JsonProperty(value="parentConnectionProcessQualifiedName")
    SortedSet<String> parentConnectionProcessQualifiedNames;
    @Attribute
    IPowerBIDataflow powerBIDataflow;
    @Attribute
    ILineageProcess process;
    @Attribute
    SortedSet<ISparkJob> sparkJobs;
    @Attribute
    String sql;

    @Override
    public ColumnProcess trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ColumnProcess.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ColumnProcess.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ColumnProcess.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ColumnProcess.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static ColumnProcess refByGuid(String guid) {
        return ColumnProcess.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static ColumnProcess refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ColumnProcessBuilder)((ColumnProcessBuilder)ColumnProcess._internal().guid(guid)).semantic(semantic)).build();
    }

    public static ColumnProcess refByQualifiedName(String qualifiedName) {
        return ColumnProcess.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static ColumnProcess refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ColumnProcessBuilder)((ColumnProcessBuilder)ColumnProcess._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static ColumnProcess get(AtlanClient client, String id) throws AtlanException {
        return ColumnProcess.get(client, id, false);
    }

    @JsonIgnore
    public static ColumnProcess get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ColumnProcess) {
                return (ColumnProcess)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof ColumnProcess) {
            return (ColumnProcess)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static ColumnProcess get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return ColumnProcess.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static ColumnProcess get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)ColumnProcess.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof ColumnProcess) {
                return (ColumnProcess)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)ColumnProcess.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof ColumnProcess) {
            return (ColumnProcess)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ColumnProcessBuilder<?, ?> creator(String name, String connectionQualifiedName, String id, List<ICatalog> inputs, List<ICatalog> outputs, LineageProcess parent) {
        String connectionName = StringUtils.getNameFromQualifiedName(connectionQualifiedName);
        Object builder = ((ColumnProcessBuilder)((ColumnProcessBuilder)((ColumnProcessBuilder)((ColumnProcessBuilder)((ColumnProcessBuilder)((ColumnProcessBuilder)ColumnProcess._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(LineageProcess.generateQualifiedName(name, connectionQualifiedName, id, inputs, outputs, parent))).name(name)).connectionName(connectionName)).connectionQualifiedName(connectionQualifiedName)).inputs(inputs)).outputs(outputs);
        if (parent != null) {
            ((ColumnProcessBuilder)builder).process(parent);
        }
        return builder;
    }

    public static ColumnProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ColumnProcessBuilder)((ColumnProcessBuilder)((ColumnProcessBuilder)ColumnProcess._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ColumnProcessBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        ColumnProcess.validateRequired(TYPE_NAME, map);
        return ColumnProcess.updater(this.getQualifiedName(), this.getName());
    }

    public static ColumnProcess removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess)Asset.removeDescription(client, ColumnProcess.updater(qualifiedName, name));
    }

    public static ColumnProcess removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess)Asset.removeUserDescription(client, ColumnProcess.updater(qualifiedName, name));
    }

    public static ColumnProcess removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess)Asset.removeOwners(client, ColumnProcess.updater(qualifiedName, name));
    }

    public static ColumnProcess updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ColumnProcess)Asset.updateCertificate(client, ColumnProcess._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ColumnProcess removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess)Asset.removeCertificate(client, ColumnProcess.updater(qualifiedName, name));
    }

    public static ColumnProcess updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ColumnProcess)Asset.updateAnnouncement(client, ColumnProcess._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ColumnProcess removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess)Asset.removeAnnouncement(client, ColumnProcess.updater(qualifiedName, name));
    }

    public static ColumnProcess replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ColumnProcess)Asset.replaceTerms(client, ColumnProcess.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static ColumnProcess appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ColumnProcess)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static ColumnProcess removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ColumnProcess)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static ColumnProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ColumnProcess)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static ColumnProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ColumnProcess)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ColumnProcess(ColumnProcessBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ColumnProcess.$default$typeName();
        this.additionalEtlContext = b.additionalEtlContext;
        this.adfActivity = b.adfActivity;
        this.aiDatasetType = b.aiDatasetType;
        SortedSet<IAirflowTask> airflowTasks = new TreeSet<IAirflowTask>();
        if (b.airflowTasks != null) {
            airflowTasks.addAll(b.airflowTasks);
        }
        airflowTasks = Collections.unmodifiableSortedSet(airflowTasks);
        this.airflowTasks = airflowTasks;
        this.ast = b.ast;
        this.code = b.code;
        SortedSet<IColumnProcess> columnProcesses = new TreeSet<IColumnProcess>();
        if (b.columnProcesses != null) {
            columnProcesses.addAll(b.columnProcesses);
        }
        columnProcesses = Collections.unmodifiableSortedSet(columnProcesses);
        this.columnProcesses = columnProcesses;
        this.fivetranConnector = b.fivetranConnector;
        SortedSet<ICatalog> inputs = new TreeSet<ICatalog>();
        if (b.inputs != null) {
            inputs.addAll(b.inputs);
        }
        inputs = Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        this.matillionComponent = b.matillionComponent;
        SortedSet<ICatalog> outputs = new TreeSet<ICatalog>();
        if (b.outputs != null) {
            outputs.addAll(b.outputs);
        }
        outputs = Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
        SortedSet<String> parentConnectionProcessQualifiedNames = new TreeSet<String>();
        if (b.parentConnectionProcessQualifiedNames != null) {
            parentConnectionProcessQualifiedNames.addAll(b.parentConnectionProcessQualifiedNames);
        }
        parentConnectionProcessQualifiedNames = Collections.unmodifiableSortedSet(parentConnectionProcessQualifiedNames);
        this.parentConnectionProcessQualifiedNames = parentConnectionProcessQualifiedNames;
        this.powerBIDataflow = b.powerBIDataflow;
        this.process = b.process;
        SortedSet<ISparkJob> sparkJobs = new TreeSet<ISparkJob>();
        if (b.sparkJobs != null) {
            sparkJobs.addAll(b.sparkJobs);
        }
        sparkJobs = Collections.unmodifiableSortedSet(sparkJobs);
        this.sparkJobs = sparkJobs;
        this.sql = b.sql;
    }

    @Generated
    public static ColumnProcessBuilder<?, ?> _internal() {
        return new ColumnProcessBuilderImpl();
    }

    @Generated
    public ColumnProcessBuilder<?, ?> toBuilder() {
        return new ColumnProcessBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getAdditionalEtlContext() {
        return this.additionalEtlContext;
    }

    @Override
    @Generated
    public IAdfActivity getAdfActivity() {
        return this.adfActivity;
    }

    @Override
    @Generated
    public AIDatasetType getAiDatasetType() {
        return this.aiDatasetType;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getAirflowTasks() {
        return this.airflowTasks;
    }

    @Override
    @Generated
    public String getAst() {
        return this.ast;
    }

    @Override
    @Generated
    public String getCode() {
        return this.code;
    }

    @Override
    @Generated
    public SortedSet<IColumnProcess> getColumnProcesses() {
        return this.columnProcesses;
    }

    @Override
    @Generated
    public IFivetranConnector getFivetranConnector() {
        return this.fivetranConnector;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getInputs() {
        return this.inputs;
    }

    @Override
    @Generated
    public IMatillionComponent getMatillionComponent() {
        return this.matillionComponent;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getOutputs() {
        return this.outputs;
    }

    @Override
    @Generated
    public SortedSet<String> getParentConnectionProcessQualifiedNames() {
        return this.parentConnectionProcessQualifiedNames;
    }

    @Override
    @Generated
    public IPowerBIDataflow getPowerBIDataflow() {
        return this.powerBIDataflow;
    }

    @Override
    @Generated
    public ILineageProcess getProcess() {
        return this.process;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getSparkJobs() {
        return this.sparkJobs;
    }

    @Override
    @Generated
    public String getSql() {
        return this.sql;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnProcess)) {
            return false;
        }
        ColumnProcess other = (ColumnProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$additionalEtlContext = this.getAdditionalEtlContext();
        String other$additionalEtlContext = other.getAdditionalEtlContext();
        if (this$additionalEtlContext == null ? other$additionalEtlContext != null : !this$additionalEtlContext.equals(other$additionalEtlContext)) {
            return false;
        }
        IAdfActivity this$adfActivity = this.getAdfActivity();
        IAdfActivity other$adfActivity = other.getAdfActivity();
        if (this$adfActivity == null ? other$adfActivity != null : !this$adfActivity.equals(other$adfActivity)) {
            return false;
        }
        AIDatasetType this$aiDatasetType = this.getAiDatasetType();
        AIDatasetType other$aiDatasetType = other.getAiDatasetType();
        if (this$aiDatasetType == null ? other$aiDatasetType != null : !this$aiDatasetType.equals(other$aiDatasetType)) {
            return false;
        }
        SortedSet<IAirflowTask> this$airflowTasks = this.getAirflowTasks();
        SortedSet<IAirflowTask> other$airflowTasks = other.getAirflowTasks();
        if (this$airflowTasks == null ? other$airflowTasks != null : !this$airflowTasks.equals(other$airflowTasks)) {
            return false;
        }
        String this$ast = this.getAst();
        String other$ast = other.getAst();
        if (this$ast == null ? other$ast != null : !this$ast.equals(other$ast)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        SortedSet<IColumnProcess> this$columnProcesses = this.getColumnProcesses();
        SortedSet<IColumnProcess> other$columnProcesses = other.getColumnProcesses();
        if (this$columnProcesses == null ? other$columnProcesses != null : !this$columnProcesses.equals(other$columnProcesses)) {
            return false;
        }
        IFivetranConnector this$fivetranConnector = this.getFivetranConnector();
        IFivetranConnector other$fivetranConnector = other.getFivetranConnector();
        if (this$fivetranConnector == null ? other$fivetranConnector != null : !this$fivetranConnector.equals(other$fivetranConnector)) {
            return false;
        }
        SortedSet<ICatalog> this$inputs = this.getInputs();
        SortedSet<ICatalog> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        IMatillionComponent this$matillionComponent = this.getMatillionComponent();
        IMatillionComponent other$matillionComponent = other.getMatillionComponent();
        if (this$matillionComponent == null ? other$matillionComponent != null : !this$matillionComponent.equals(other$matillionComponent)) {
            return false;
        }
        SortedSet<ICatalog> this$outputs = this.getOutputs();
        SortedSet<ICatalog> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) {
            return false;
        }
        SortedSet<String> this$parentConnectionProcessQualifiedNames = this.getParentConnectionProcessQualifiedNames();
        SortedSet<String> other$parentConnectionProcessQualifiedNames = other.getParentConnectionProcessQualifiedNames();
        if (this$parentConnectionProcessQualifiedNames == null ? other$parentConnectionProcessQualifiedNames != null : !this$parentConnectionProcessQualifiedNames.equals(other$parentConnectionProcessQualifiedNames)) {
            return false;
        }
        IPowerBIDataflow this$powerBIDataflow = this.getPowerBIDataflow();
        IPowerBIDataflow other$powerBIDataflow = other.getPowerBIDataflow();
        if (this$powerBIDataflow == null ? other$powerBIDataflow != null : !this$powerBIDataflow.equals(other$powerBIDataflow)) {
            return false;
        }
        ILineageProcess this$process = this.getProcess();
        ILineageProcess other$process = other.getProcess();
        if (this$process == null ? other$process != null : !this$process.equals(other$process)) {
            return false;
        }
        SortedSet<ISparkJob> this$sparkJobs = this.getSparkJobs();
        SortedSet<ISparkJob> other$sparkJobs = other.getSparkJobs();
        if (this$sparkJobs == null ? other$sparkJobs != null : !this$sparkJobs.equals(other$sparkJobs)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ColumnProcess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $additionalEtlContext = this.getAdditionalEtlContext();
        result = result * 59 + ($additionalEtlContext == null ? 43 : $additionalEtlContext.hashCode());
        IAdfActivity $adfActivity = this.getAdfActivity();
        result = result * 59 + ($adfActivity == null ? 43 : $adfActivity.hashCode());
        AIDatasetType $aiDatasetType = this.getAiDatasetType();
        result = result * 59 + ($aiDatasetType == null ? 43 : $aiDatasetType.hashCode());
        SortedSet<IAirflowTask> $airflowTasks = this.getAirflowTasks();
        result = result * 59 + ($airflowTasks == null ? 43 : $airflowTasks.hashCode());
        String $ast = this.getAst();
        result = result * 59 + ($ast == null ? 43 : $ast.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        SortedSet<IColumnProcess> $columnProcesses = this.getColumnProcesses();
        result = result * 59 + ($columnProcesses == null ? 43 : $columnProcesses.hashCode());
        IFivetranConnector $fivetranConnector = this.getFivetranConnector();
        result = result * 59 + ($fivetranConnector == null ? 43 : $fivetranConnector.hashCode());
        SortedSet<ICatalog> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : $inputs.hashCode());
        IMatillionComponent $matillionComponent = this.getMatillionComponent();
        result = result * 59 + ($matillionComponent == null ? 43 : $matillionComponent.hashCode());
        SortedSet<ICatalog> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : $outputs.hashCode());
        SortedSet<String> $parentConnectionProcessQualifiedNames = this.getParentConnectionProcessQualifiedNames();
        result = result * 59 + ($parentConnectionProcessQualifiedNames == null ? 43 : $parentConnectionProcessQualifiedNames.hashCode());
        IPowerBIDataflow $powerBIDataflow = this.getPowerBIDataflow();
        result = result * 59 + ($powerBIDataflow == null ? 43 : $powerBIDataflow.hashCode());
        ILineageProcess $process = this.getProcess();
        result = result * 59 + ($process == null ? 43 : $process.hashCode());
        SortedSet<ISparkJob> $sparkJobs = this.getSparkJobs();
        result = result * 59 + ($sparkJobs == null ? 43 : $sparkJobs.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ColumnProcess(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", additionalEtlContext=" + this.getAdditionalEtlContext() + ", adfActivity=" + String.valueOf(this.getAdfActivity()) + ", aiDatasetType=" + String.valueOf(this.getAiDatasetType()) + ", airflowTasks=" + String.valueOf(this.getAirflowTasks()) + ", ast=" + this.getAst() + ", code=" + this.getCode() + ", columnProcesses=" + String.valueOf(this.getColumnProcesses()) + ", fivetranConnector=" + String.valueOf(this.getFivetranConnector()) + ", inputs=" + String.valueOf(this.getInputs()) + ", matillionComponent=" + String.valueOf(this.getMatillionComponent()) + ", outputs=" + String.valueOf(this.getOutputs()) + ", parentConnectionProcessQualifiedNames=" + String.valueOf(this.getParentConnectionProcessQualifiedNames()) + ", powerBIDataflow=" + String.valueOf(this.getPowerBIDataflow()) + ", process=" + String.valueOf(this.getProcess()) + ", sparkJobs=" + String.valueOf(this.getSparkJobs()) + ", sql=" + this.getSql() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class ColumnProcessBuilder<C extends ColumnProcess, B extends ColumnProcessBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String additionalEtlContext;
        @Generated
        private IAdfActivity adfActivity;
        @Generated
        private AIDatasetType aiDatasetType;
        @Generated
        private ArrayList<IAirflowTask> airflowTasks;
        @Generated
        private String ast;
        @Generated
        private String code;
        @Generated
        private ArrayList<IColumnProcess> columnProcesses;
        @Generated
        private IFivetranConnector fivetranConnector;
        @Generated
        private ArrayList<ICatalog> inputs;
        @Generated
        private IMatillionComponent matillionComponent;
        @Generated
        private ArrayList<ICatalog> outputs;
        @Generated
        private ArrayList<String> parentConnectionProcessQualifiedNames;
        @Generated
        private IPowerBIDataflow powerBIDataflow;
        @Generated
        private ILineageProcess process;
        @Generated
        private ArrayList<ISparkJob> sparkJobs;
        @Generated
        private String sql;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ColumnProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ColumnProcess instance, ColumnProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.additionalEtlContext(instance.additionalEtlContext);
            b.adfActivity(instance.adfActivity);
            b.aiDatasetType(instance.aiDatasetType);
            b.airflowTasks(instance.airflowTasks == null ? Collections.emptySortedSet() : instance.airflowTasks);
            b.ast(instance.ast);
            b.code(instance.code);
            b.columnProcesses(instance.columnProcesses == null ? Collections.emptySortedSet() : instance.columnProcesses);
            b.fivetranConnector(instance.fivetranConnector);
            b.inputs(instance.inputs == null ? Collections.emptySortedSet() : instance.inputs);
            b.matillionComponent(instance.matillionComponent);
            b.outputs(instance.outputs == null ? Collections.emptySortedSet() : instance.outputs);
            b.parentConnectionProcessQualifiedNames(instance.parentConnectionProcessQualifiedNames == null ? Collections.emptySortedSet() : instance.parentConnectionProcessQualifiedNames);
            b.powerBIDataflow(instance.powerBIDataflow);
            b.process(instance.process);
            b.sparkJobs(instance.sparkJobs == null ? Collections.emptySortedSet() : instance.sparkJobs);
            b.sql(instance.sql);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B additionalEtlContext(String additionalEtlContext) {
            this.additionalEtlContext = additionalEtlContext;
            return (B)this.self();
        }

        @Generated
        public B adfActivity(IAdfActivity adfActivity) {
            this.adfActivity = adfActivity;
            return (B)this.self();
        }

        @Generated
        public B aiDatasetType(AIDatasetType aiDatasetType) {
            this.aiDatasetType = aiDatasetType;
            return (B)this.self();
        }

        @Generated
        public B airflowTask(IAirflowTask airflowTask) {
            if (this.airflowTasks == null) {
                this.airflowTasks = new ArrayList();
            }
            this.airflowTasks.add(airflowTask);
            return (B)this.self();
        }

        @Generated
        public B airflowTasks(Collection<? extends IAirflowTask> airflowTasks) {
            if (airflowTasks == null) {
                throw new NullPointerException("airflowTasks cannot be null");
            }
            if (this.airflowTasks == null) {
                this.airflowTasks = new ArrayList();
            }
            this.airflowTasks.addAll(airflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearAirflowTasks() {
            if (this.airflowTasks != null) {
                this.airflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B ast(String ast) {
            this.ast = ast;
            return (B)this.self();
        }

        @Generated
        public B code(String code) {
            this.code = code;
            return (B)this.self();
        }

        @Generated
        public B columnProcess(IColumnProcess columnProcess) {
            if (this.columnProcesses == null) {
                this.columnProcesses = new ArrayList();
            }
            this.columnProcesses.add(columnProcess);
            return (B)this.self();
        }

        @Generated
        public B columnProcesses(Collection<? extends IColumnProcess> columnProcesses) {
            if (columnProcesses == null) {
                throw new NullPointerException("columnProcesses cannot be null");
            }
            if (this.columnProcesses == null) {
                this.columnProcesses = new ArrayList();
            }
            this.columnProcesses.addAll(columnProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearColumnProcesses() {
            if (this.columnProcesses != null) {
                this.columnProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B fivetranConnector(IFivetranConnector fivetranConnector) {
            this.fivetranConnector = fivetranConnector;
            return (B)this.self();
        }

        @Generated
        public B input(ICatalog input) {
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.add(input);
            return (B)this.self();
        }

        @Generated
        public B inputs(Collection<? extends ICatalog> inputs) {
            if (inputs == null) {
                throw new NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.addAll(inputs);
            return (B)this.self();
        }

        @Generated
        public B clearInputs() {
            if (this.inputs != null) {
                this.inputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B matillionComponent(IMatillionComponent matillionComponent) {
            this.matillionComponent = matillionComponent;
            return (B)this.self();
        }

        @Generated
        public B output(ICatalog output) {
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.add(output);
            return (B)this.self();
        }

        @Generated
        public B outputs(Collection<? extends ICatalog> outputs) {
            if (outputs == null) {
                throw new NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.addAll(outputs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputs() {
            if (this.outputs != null) {
                this.outputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B parentConnectionProcessQualifiedName(String parentConnectionProcessQualifiedName) {
            if (this.parentConnectionProcessQualifiedNames == null) {
                this.parentConnectionProcessQualifiedNames = new ArrayList();
            }
            this.parentConnectionProcessQualifiedNames.add(parentConnectionProcessQualifiedName);
            return (B)this.self();
        }

        @JsonProperty(value="parentConnectionProcessQualifiedName")
        @Generated
        public B parentConnectionProcessQualifiedNames(Collection<? extends String> parentConnectionProcessQualifiedNames) {
            if (parentConnectionProcessQualifiedNames == null) {
                throw new NullPointerException("parentConnectionProcessQualifiedNames cannot be null");
            }
            if (this.parentConnectionProcessQualifiedNames == null) {
                this.parentConnectionProcessQualifiedNames = new ArrayList();
            }
            this.parentConnectionProcessQualifiedNames.addAll(parentConnectionProcessQualifiedNames);
            return (B)this.self();
        }

        @Generated
        public B clearParentConnectionProcessQualifiedNames() {
            if (this.parentConnectionProcessQualifiedNames != null) {
                this.parentConnectionProcessQualifiedNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflow(IPowerBIDataflow powerBIDataflow) {
            this.powerBIDataflow = powerBIDataflow;
            return (B)this.self();
        }

        @Generated
        public B process(ILineageProcess process) {
            this.process = process;
            return (B)this.self();
        }

        @Generated
        public B sparkJob(ISparkJob sparkJob) {
            if (this.sparkJobs == null) {
                this.sparkJobs = new ArrayList();
            }
            this.sparkJobs.add(sparkJob);
            return (B)this.self();
        }

        @Generated
        public B sparkJobs(Collection<? extends ISparkJob> sparkJobs) {
            if (sparkJobs == null) {
                throw new NullPointerException("sparkJobs cannot be null");
            }
            if (this.sparkJobs == null) {
                this.sparkJobs = new ArrayList();
            }
            this.sparkJobs.addAll(sparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearSparkJobs() {
            if (this.sparkJobs != null) {
                this.sparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sql(String sql) {
            this.sql = sql;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ColumnProcess.ColumnProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", additionalEtlContext=" + this.additionalEtlContext + ", adfActivity=" + String.valueOf(this.adfActivity) + ", aiDatasetType=" + String.valueOf(this.aiDatasetType) + ", airflowTasks=" + String.valueOf(this.airflowTasks) + ", ast=" + this.ast + ", code=" + this.code + ", columnProcesses=" + String.valueOf(this.columnProcesses) + ", fivetranConnector=" + String.valueOf(this.fivetranConnector) + ", inputs=" + String.valueOf(this.inputs) + ", matillionComponent=" + String.valueOf(this.matillionComponent) + ", outputs=" + String.valueOf(this.outputs) + ", parentConnectionProcessQualifiedNames=" + String.valueOf(this.parentConnectionProcessQualifiedNames) + ", powerBIDataflow=" + String.valueOf(this.powerBIDataflow) + ", process=" + String.valueOf(this.process) + ", sparkJobs=" + String.valueOf(this.sparkJobs) + ", sql=" + this.sql + ")";
        }
    }

    @Generated
    private static final class ColumnProcessBuilderImpl
    extends ColumnProcessBuilder<ColumnProcess, ColumnProcessBuilderImpl> {
        @Generated
        private ColumnProcessBuilderImpl() {
        }

        @Override
        @Generated
        protected ColumnProcessBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ColumnProcess build() {
            return new ColumnProcess(this);
        }
    }
}

