/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDataDomain;
import com.atlan.model.assets.IDataMesh;
import com.atlan.model.assets.IDataProduct;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.IStakeholder;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDomain
extends Asset
implements IDataDomain,
IDataMesh,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataDomain.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DataDomain";
    String typeName;
    @Attribute
    SortedSet<IDataProduct> dataProducts;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    IDataDomain parentDomain;
    @Attribute
    String parentDomainQualifiedName;
    @Attribute
    SortedSet<IStakeholder> stakeholders;
    @Attribute
    SortedSet<IDataDomain> subDomains;
    @Attribute
    String superDomainQualifiedName;

    @Override
    public DataDomain trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DataDomain.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DataDomain.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DataDomain.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DataDomain.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DataDomain refByGuid(String guid) {
        return DataDomain.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DataDomain refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DataDomainBuilder)((DataDomainBuilder)DataDomain._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DataDomain refByQualifiedName(String qualifiedName) {
        return DataDomain.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DataDomain refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DataDomainBuilder)((DataDomainBuilder)DataDomain._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DataDomain get(AtlanClient client, String id) throws AtlanException {
        return DataDomain.get(client, id, false);
    }

    @JsonIgnore
    public static DataDomain get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DataDomain) {
                return (DataDomain)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof DataDomain) {
            return (DataDomain)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static DataDomain get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return DataDomain.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static DataDomain get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataDomain.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof DataDomain) {
                return (DataDomain)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataDomain.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof DataDomain) {
            return (DataDomain)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DataDomainBuilder<?, ?> creator(String name) throws InvalidRequestException {
        return DataDomain.creator(name, null);
    }

    public static DataDomainBuilder<?, ?> creator(String name, String parentDomainQualifiedName) throws InvalidRequestException {
        DataDomainBuilder builder = (DataDomainBuilder)((DataDomainBuilder)((DataDomainBuilder)DataDomain._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(name)).name(name);
        if (parentDomainQualifiedName != null) {
            ((DataDomainBuilder)((DataDomainBuilder)builder.parentDomain(DataDomain.refByQualifiedName(parentDomainQualifiedName))).parentDomainQualifiedName(parentDomainQualifiedName)).superDomainQualifiedName(StringUtils.getSuperDomainQualifiedName(parentDomainQualifiedName));
        }
        return builder;
    }

    public static DataDomainBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DataDomainBuilder)((DataDomainBuilder)((DataDomainBuilder)DataDomain._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DataDomainBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        DataDomain.validateRequired(TYPE_NAME, map);
        return DataDomain.updater(this.getQualifiedName(), this.getName());
    }

    public static List<DataDomain> findByName(AtlanClient client, String name) throws AtlanException {
        return DataDomain.findByName(client, name, (List<AtlanField>)null);
    }

    public static List<DataDomain> findByName(AtlanClient client, String name, Collection<String> attributes) throws AtlanException {
        ArrayList<DataDomain> results = new ArrayList<DataDomain>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataDomain.select(client).where(NAME.eq(name)))._includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof DataDomain).forEach(d -> results.add((DataDomain)d));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        return results;
    }

    public static List<DataDomain> findByName(AtlanClient client, String name, List<AtlanField> attributes) throws AtlanException {
        ArrayList<DataDomain> results = new ArrayList<DataDomain>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataDomain.select(client).where(NAME.eq(name))).includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof DataDomain).forEach(d -> results.add((DataDomain)d));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        return results;
    }

    public static DataDomain removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataDomain)Asset.removeDescription(client, DataDomain.updater(qualifiedName, name));
    }

    public static DataDomain removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataDomain)Asset.removeUserDescription(client, DataDomain.updater(qualifiedName, name));
    }

    public static DataDomain removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataDomain)Asset.removeOwners(client, DataDomain.updater(qualifiedName, name));
    }

    public static DataDomain updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DataDomain)Asset.updateCertificate(client, DataDomain._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DataDomain removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataDomain)Asset.removeCertificate(client, DataDomain.updater(qualifiedName, name));
    }

    public static DataDomain updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DataDomain)Asset.updateAnnouncement(client, DataDomain._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DataDomain removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataDomain)Asset.removeAnnouncement(client, DataDomain.updater(qualifiedName, name));
    }

    public static DataDomain replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataDomain)Asset.replaceTerms(client, DataDomain.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static DataDomain appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataDomain)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static DataDomain removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataDomain)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static DataDomain appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DataDomain)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static DataDomain appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DataDomain)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DataDomain(DataDomainBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DataDomain.$default$typeName();
        SortedSet<IDataProduct> dataProducts = new TreeSet<IDataProduct>();
        if (b.dataProducts != null) {
            dataProducts.addAll(b.dataProducts);
        }
        dataProducts = Collections.unmodifiableSortedSet(dataProducts);
        this.dataProducts = dataProducts;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.parentDomain = b.parentDomain;
        this.parentDomainQualifiedName = b.parentDomainQualifiedName;
        SortedSet<IStakeholder> stakeholders = new TreeSet<IStakeholder>();
        if (b.stakeholders != null) {
            stakeholders.addAll(b.stakeholders);
        }
        stakeholders = Collections.unmodifiableSortedSet(stakeholders);
        this.stakeholders = stakeholders;
        SortedSet<IDataDomain> subDomains = new TreeSet<IDataDomain>();
        if (b.subDomains != null) {
            subDomains.addAll(b.subDomains);
        }
        subDomains = Collections.unmodifiableSortedSet(subDomains);
        this.subDomains = subDomains;
        this.superDomainQualifiedName = b.superDomainQualifiedName;
    }

    @Generated
    public static DataDomainBuilder<?, ?> _internal() {
        return new DataDomainBuilderImpl();
    }

    @Generated
    public DataDomainBuilder<?, ?> toBuilder() {
        return new DataDomainBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IDataProduct> getDataProducts() {
        return this.dataProducts;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public IDataDomain getParentDomain() {
        return this.parentDomain;
    }

    @Override
    @Generated
    public String getParentDomainQualifiedName() {
        return this.parentDomainQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IStakeholder> getStakeholders() {
        return this.stakeholders;
    }

    @Override
    @Generated
    public SortedSet<IDataDomain> getSubDomains() {
        return this.subDomains;
    }

    @Override
    @Generated
    public String getSuperDomainQualifiedName() {
        return this.superDomainQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataDomain)) {
            return false;
        }
        DataDomain other = (DataDomain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IDataProduct> this$dataProducts = this.getDataProducts();
        SortedSet<IDataProduct> other$dataProducts = other.getDataProducts();
        if (this$dataProducts == null ? other$dataProducts != null : !this$dataProducts.equals(other$dataProducts)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        IDataDomain this$parentDomain = this.getParentDomain();
        IDataDomain other$parentDomain = other.getParentDomain();
        if (this$parentDomain == null ? other$parentDomain != null : !this$parentDomain.equals(other$parentDomain)) {
            return false;
        }
        String this$parentDomainQualifiedName = this.getParentDomainQualifiedName();
        String other$parentDomainQualifiedName = other.getParentDomainQualifiedName();
        if (this$parentDomainQualifiedName == null ? other$parentDomainQualifiedName != null : !this$parentDomainQualifiedName.equals(other$parentDomainQualifiedName)) {
            return false;
        }
        SortedSet<IStakeholder> this$stakeholders = this.getStakeholders();
        SortedSet<IStakeholder> other$stakeholders = other.getStakeholders();
        if (this$stakeholders == null ? other$stakeholders != null : !this$stakeholders.equals(other$stakeholders)) {
            return false;
        }
        SortedSet<IDataDomain> this$subDomains = this.getSubDomains();
        SortedSet<IDataDomain> other$subDomains = other.getSubDomains();
        if (this$subDomains == null ? other$subDomains != null : !this$subDomains.equals(other$subDomains)) {
            return false;
        }
        String this$superDomainQualifiedName = this.getSuperDomainQualifiedName();
        String other$superDomainQualifiedName = other.getSuperDomainQualifiedName();
        return !(this$superDomainQualifiedName == null ? other$superDomainQualifiedName != null : !this$superDomainQualifiedName.equals(other$superDomainQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataDomain;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IDataProduct> $dataProducts = this.getDataProducts();
        result = result * 59 + ($dataProducts == null ? 43 : $dataProducts.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        IDataDomain $parentDomain = this.getParentDomain();
        result = result * 59 + ($parentDomain == null ? 43 : $parentDomain.hashCode());
        String $parentDomainQualifiedName = this.getParentDomainQualifiedName();
        result = result * 59 + ($parentDomainQualifiedName == null ? 43 : $parentDomainQualifiedName.hashCode());
        SortedSet<IStakeholder> $stakeholders = this.getStakeholders();
        result = result * 59 + ($stakeholders == null ? 43 : $stakeholders.hashCode());
        SortedSet<IDataDomain> $subDomains = this.getSubDomains();
        result = result * 59 + ($subDomains == null ? 43 : $subDomains.hashCode());
        String $superDomainQualifiedName = this.getSuperDomainQualifiedName();
        result = result * 59 + ($superDomainQualifiedName == null ? 43 : $superDomainQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DataDomain(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dataProducts=" + String.valueOf(this.getDataProducts()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", parentDomain=" + String.valueOf(this.getParentDomain()) + ", parentDomainQualifiedName=" + this.getParentDomainQualifiedName() + ", stakeholders=" + String.valueOf(this.getStakeholders()) + ", subDomains=" + String.valueOf(this.getSubDomains()) + ", superDomainQualifiedName=" + this.getSuperDomainQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class DataDomainBuilder<C extends DataDomain, B extends DataDomainBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IDataProduct> dataProducts;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private IDataDomain parentDomain;
        @Generated
        private String parentDomainQualifiedName;
        @Generated
        private ArrayList<IStakeholder> stakeholders;
        @Generated
        private ArrayList<IDataDomain> subDomains;
        @Generated
        private String superDomainQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DataDomainBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DataDomain instance, DataDomainBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dataProducts(instance.dataProducts == null ? Collections.emptySortedSet() : instance.dataProducts);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.parentDomain(instance.parentDomain);
            b.parentDomainQualifiedName(instance.parentDomainQualifiedName);
            b.stakeholders(instance.stakeholders == null ? Collections.emptySortedSet() : instance.stakeholders);
            b.subDomains(instance.subDomains == null ? Collections.emptySortedSet() : instance.subDomains);
            b.superDomainQualifiedName(instance.superDomainQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dataProduct(IDataProduct dataProduct) {
            if (this.dataProducts == null) {
                this.dataProducts = new ArrayList();
            }
            this.dataProducts.add(dataProduct);
            return (B)this.self();
        }

        @Generated
        public B dataProducts(Collection<? extends IDataProduct> dataProducts) {
            if (dataProducts == null) {
                throw new NullPointerException("dataProducts cannot be null");
            }
            if (this.dataProducts == null) {
                this.dataProducts = new ArrayList();
            }
            this.dataProducts.addAll(dataProducts);
            return (B)this.self();
        }

        @Generated
        public B clearDataProducts() {
            if (this.dataProducts != null) {
                this.dataProducts.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B parentDomain(IDataDomain parentDomain) {
            this.parentDomain = parentDomain;
            return (B)this.self();
        }

        @Generated
        public B parentDomainQualifiedName(String parentDomainQualifiedName) {
            this.parentDomainQualifiedName = parentDomainQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B stakeholder(IStakeholder stakeholder) {
            if (this.stakeholders == null) {
                this.stakeholders = new ArrayList();
            }
            this.stakeholders.add(stakeholder);
            return (B)this.self();
        }

        @Generated
        public B stakeholders(Collection<? extends IStakeholder> stakeholders) {
            if (stakeholders == null) {
                throw new NullPointerException("stakeholders cannot be null");
            }
            if (this.stakeholders == null) {
                this.stakeholders = new ArrayList();
            }
            this.stakeholders.addAll(stakeholders);
            return (B)this.self();
        }

        @Generated
        public B clearStakeholders() {
            if (this.stakeholders != null) {
                this.stakeholders.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B subDomain(IDataDomain subDomain) {
            if (this.subDomains == null) {
                this.subDomains = new ArrayList();
            }
            this.subDomains.add(subDomain);
            return (B)this.self();
        }

        @Generated
        public B subDomains(Collection<? extends IDataDomain> subDomains) {
            if (subDomains == null) {
                throw new NullPointerException("subDomains cannot be null");
            }
            if (this.subDomains == null) {
                this.subDomains = new ArrayList();
            }
            this.subDomains.addAll(subDomains);
            return (B)this.self();
        }

        @Generated
        public B clearSubDomains() {
            if (this.subDomains != null) {
                this.subDomains.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B superDomainQualifiedName(String superDomainQualifiedName) {
            this.superDomainQualifiedName = superDomainQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DataDomain.DataDomainBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dataProducts=" + String.valueOf(this.dataProducts) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", parentDomain=" + String.valueOf(this.parentDomain) + ", parentDomainQualifiedName=" + this.parentDomainQualifiedName + ", stakeholders=" + String.valueOf(this.stakeholders) + ", subDomains=" + String.valueOf(this.subDomains) + ", superDomainQualifiedName=" + this.superDomainQualifiedName + ")";
        }
    }

    @Generated
    private static final class DataDomainBuilderImpl
    extends DataDomainBuilder<DataDomain, DataDomainBuilderImpl> {
        @Generated
        private DataDomainBuilderImpl() {
        }

        @Override
        @Generated
        protected DataDomainBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DataDomain build() {
            return new DataDomain(this);
        }
    }
}

