/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDataverse;
import com.atlan.model.assets.IDataverseAttribute;
import com.atlan.model.assets.IDataverseEntity;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISaaS;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataverseEntity
extends Asset
implements IDataverseEntity,
IDataverse,
ISaaS,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataverseEntity.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DataverseEntity";
    String typeName;
    @Attribute
    SortedSet<IDataverseAttribute> dataverseAttributes;
    @Attribute
    String dataverseEntitySchemaName;
    @Attribute
    String dataverseEntityTableType;
    @Attribute
    Boolean dataverseIsAuditEnabled;
    @Attribute
    Boolean dataverseIsCustom;
    @Attribute
    Boolean dataverseIsCustomizable;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public DataverseEntity trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DataverseEntity.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DataverseEntity.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DataverseEntity.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DataverseEntity.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DataverseEntity refByGuid(String guid) {
        return DataverseEntity.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DataverseEntity refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DataverseEntityBuilder)((DataverseEntityBuilder)DataverseEntity._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DataverseEntity refByQualifiedName(String qualifiedName) {
        return DataverseEntity.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DataverseEntity refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DataverseEntityBuilder)((DataverseEntityBuilder)DataverseEntity._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DataverseEntity get(AtlanClient client, String id) throws AtlanException {
        return DataverseEntity.get(client, id, false);
    }

    @JsonIgnore
    public static DataverseEntity get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DataverseEntity) {
                return (DataverseEntity)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof DataverseEntity) {
            return (DataverseEntity)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static DataverseEntity get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return DataverseEntity.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static DataverseEntity get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataverseEntity.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof DataverseEntity) {
                return (DataverseEntity)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataverseEntity.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof DataverseEntity) {
            return (DataverseEntity)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DataverseEntityBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return (DataverseEntityBuilder)((DataverseEntityBuilder)((DataverseEntityBuilder)((DataverseEntityBuilder)DataverseEntity._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(connectionQualifiedName + "/" + name)).name(name)).connectionQualifiedName(connectionQualifiedName);
    }

    public static DataverseEntityBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DataverseEntityBuilder)((DataverseEntityBuilder)((DataverseEntityBuilder)DataverseEntity._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DataverseEntityBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        DataverseEntity.validateRequired(TYPE_NAME, map);
        return DataverseEntity.updater(this.getQualifiedName(), this.getName());
    }

    public static DataverseEntity removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataverseEntity)Asset.removeDescription(client, DataverseEntity.updater(qualifiedName, name));
    }

    public static DataverseEntity removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataverseEntity)Asset.removeUserDescription(client, DataverseEntity.updater(qualifiedName, name));
    }

    public static DataverseEntity removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataverseEntity)Asset.removeOwners(client, DataverseEntity.updater(qualifiedName, name));
    }

    public static DataverseEntity updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DataverseEntity)Asset.updateCertificate(client, DataverseEntity._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DataverseEntity removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataverseEntity)Asset.removeCertificate(client, DataverseEntity.updater(qualifiedName, name));
    }

    public static DataverseEntity updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DataverseEntity)Asset.updateAnnouncement(client, DataverseEntity._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DataverseEntity removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataverseEntity)Asset.removeAnnouncement(client, DataverseEntity.updater(qualifiedName, name));
    }

    public static DataverseEntity replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataverseEntity)Asset.replaceTerms(client, DataverseEntity.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static DataverseEntity appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataverseEntity)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static DataverseEntity removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataverseEntity)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static DataverseEntity appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DataverseEntity)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static DataverseEntity appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DataverseEntity)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DataverseEntity(DataverseEntityBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DataverseEntity.$default$typeName();
        SortedSet<IDataverseAttribute> dataverseAttributes = new TreeSet<IDataverseAttribute>();
        if (b.dataverseAttributes != null) {
            dataverseAttributes.addAll(b.dataverseAttributes);
        }
        dataverseAttributes = Collections.unmodifiableSortedSet(dataverseAttributes);
        this.dataverseAttributes = dataverseAttributes;
        this.dataverseEntitySchemaName = b.dataverseEntitySchemaName;
        this.dataverseEntityTableType = b.dataverseEntityTableType;
        this.dataverseIsAuditEnabled = b.dataverseIsAuditEnabled;
        this.dataverseIsCustom = b.dataverseIsCustom;
        this.dataverseIsCustomizable = b.dataverseIsCustomizable;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static DataverseEntityBuilder<?, ?> _internal() {
        return new DataverseEntityBuilderImpl();
    }

    @Generated
    public DataverseEntityBuilder<?, ?> toBuilder() {
        return new DataverseEntityBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IDataverseAttribute> getDataverseAttributes() {
        return this.dataverseAttributes;
    }

    @Override
    @Generated
    public String getDataverseEntitySchemaName() {
        return this.dataverseEntitySchemaName;
    }

    @Override
    @Generated
    public String getDataverseEntityTableType() {
        return this.dataverseEntityTableType;
    }

    @Override
    @Generated
    public Boolean getDataverseIsAuditEnabled() {
        return this.dataverseIsAuditEnabled;
    }

    @Override
    @Generated
    public Boolean getDataverseIsCustom() {
        return this.dataverseIsCustom;
    }

    @Override
    @Generated
    public Boolean getDataverseIsCustomizable() {
        return this.dataverseIsCustomizable;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataverseEntity)) {
            return false;
        }
        DataverseEntity other = (DataverseEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$dataverseIsAuditEnabled = this.getDataverseIsAuditEnabled();
        Boolean other$dataverseIsAuditEnabled = other.getDataverseIsAuditEnabled();
        if (this$dataverseIsAuditEnabled == null ? other$dataverseIsAuditEnabled != null : !((Object)this$dataverseIsAuditEnabled).equals(other$dataverseIsAuditEnabled)) {
            return false;
        }
        Boolean this$dataverseIsCustom = this.getDataverseIsCustom();
        Boolean other$dataverseIsCustom = other.getDataverseIsCustom();
        if (this$dataverseIsCustom == null ? other$dataverseIsCustom != null : !((Object)this$dataverseIsCustom).equals(other$dataverseIsCustom)) {
            return false;
        }
        Boolean this$dataverseIsCustomizable = this.getDataverseIsCustomizable();
        Boolean other$dataverseIsCustomizable = other.getDataverseIsCustomizable();
        if (this$dataverseIsCustomizable == null ? other$dataverseIsCustomizable != null : !((Object)this$dataverseIsCustomizable).equals(other$dataverseIsCustomizable)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IDataverseAttribute> this$dataverseAttributes = this.getDataverseAttributes();
        SortedSet<IDataverseAttribute> other$dataverseAttributes = other.getDataverseAttributes();
        if (this$dataverseAttributes == null ? other$dataverseAttributes != null : !this$dataverseAttributes.equals(other$dataverseAttributes)) {
            return false;
        }
        String this$dataverseEntitySchemaName = this.getDataverseEntitySchemaName();
        String other$dataverseEntitySchemaName = other.getDataverseEntitySchemaName();
        if (this$dataverseEntitySchemaName == null ? other$dataverseEntitySchemaName != null : !this$dataverseEntitySchemaName.equals(other$dataverseEntitySchemaName)) {
            return false;
        }
        String this$dataverseEntityTableType = this.getDataverseEntityTableType();
        String other$dataverseEntityTableType = other.getDataverseEntityTableType();
        if (this$dataverseEntityTableType == null ? other$dataverseEntityTableType != null : !this$dataverseEntityTableType.equals(other$dataverseEntityTableType)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataverseEntity;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $dataverseIsAuditEnabled = this.getDataverseIsAuditEnabled();
        result = result * 59 + ($dataverseIsAuditEnabled == null ? 43 : ((Object)$dataverseIsAuditEnabled).hashCode());
        Boolean $dataverseIsCustom = this.getDataverseIsCustom();
        result = result * 59 + ($dataverseIsCustom == null ? 43 : ((Object)$dataverseIsCustom).hashCode());
        Boolean $dataverseIsCustomizable = this.getDataverseIsCustomizable();
        result = result * 59 + ($dataverseIsCustomizable == null ? 43 : ((Object)$dataverseIsCustomizable).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IDataverseAttribute> $dataverseAttributes = this.getDataverseAttributes();
        result = result * 59 + ($dataverseAttributes == null ? 43 : $dataverseAttributes.hashCode());
        String $dataverseEntitySchemaName = this.getDataverseEntitySchemaName();
        result = result * 59 + ($dataverseEntitySchemaName == null ? 43 : $dataverseEntitySchemaName.hashCode());
        String $dataverseEntityTableType = this.getDataverseEntityTableType();
        result = result * 59 + ($dataverseEntityTableType == null ? 43 : $dataverseEntityTableType.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DataverseEntity(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dataverseAttributes=" + String.valueOf(this.getDataverseAttributes()) + ", dataverseEntitySchemaName=" + this.getDataverseEntitySchemaName() + ", dataverseEntityTableType=" + this.getDataverseEntityTableType() + ", dataverseIsAuditEnabled=" + this.getDataverseIsAuditEnabled() + ", dataverseIsCustom=" + this.getDataverseIsCustom() + ", dataverseIsCustomizable=" + this.getDataverseIsCustomizable() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class DataverseEntityBuilder<C extends DataverseEntity, B extends DataverseEntityBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IDataverseAttribute> dataverseAttributes;
        @Generated
        private String dataverseEntitySchemaName;
        @Generated
        private String dataverseEntityTableType;
        @Generated
        private Boolean dataverseIsAuditEnabled;
        @Generated
        private Boolean dataverseIsCustom;
        @Generated
        private Boolean dataverseIsCustomizable;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DataverseEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DataverseEntity instance, DataverseEntityBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dataverseAttributes(instance.dataverseAttributes == null ? Collections.emptySortedSet() : instance.dataverseAttributes);
            b.dataverseEntitySchemaName(instance.dataverseEntitySchemaName);
            b.dataverseEntityTableType(instance.dataverseEntityTableType);
            b.dataverseIsAuditEnabled(instance.dataverseIsAuditEnabled);
            b.dataverseIsCustom(instance.dataverseIsCustom);
            b.dataverseIsCustomizable(instance.dataverseIsCustomizable);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dataverseAttribute(IDataverseAttribute dataverseAttribute) {
            if (this.dataverseAttributes == null) {
                this.dataverseAttributes = new ArrayList();
            }
            this.dataverseAttributes.add(dataverseAttribute);
            return (B)this.self();
        }

        @Generated
        public B dataverseAttributes(Collection<? extends IDataverseAttribute> dataverseAttributes) {
            if (dataverseAttributes == null) {
                throw new NullPointerException("dataverseAttributes cannot be null");
            }
            if (this.dataverseAttributes == null) {
                this.dataverseAttributes = new ArrayList();
            }
            this.dataverseAttributes.addAll(dataverseAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearDataverseAttributes() {
            if (this.dataverseAttributes != null) {
                this.dataverseAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataverseEntitySchemaName(String dataverseEntitySchemaName) {
            this.dataverseEntitySchemaName = dataverseEntitySchemaName;
            return (B)this.self();
        }

        @Generated
        public B dataverseEntityTableType(String dataverseEntityTableType) {
            this.dataverseEntityTableType = dataverseEntityTableType;
            return (B)this.self();
        }

        @Generated
        public B dataverseIsAuditEnabled(Boolean dataverseIsAuditEnabled) {
            this.dataverseIsAuditEnabled = dataverseIsAuditEnabled;
            return (B)this.self();
        }

        @Generated
        public B dataverseIsCustom(Boolean dataverseIsCustom) {
            this.dataverseIsCustom = dataverseIsCustom;
            return (B)this.self();
        }

        @Generated
        public B dataverseIsCustomizable(Boolean dataverseIsCustomizable) {
            this.dataverseIsCustomizable = dataverseIsCustomizable;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DataverseEntity.DataverseEntityBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dataverseAttributes=" + String.valueOf(this.dataverseAttributes) + ", dataverseEntitySchemaName=" + this.dataverseEntitySchemaName + ", dataverseEntityTableType=" + this.dataverseEntityTableType + ", dataverseIsAuditEnabled=" + this.dataverseIsAuditEnabled + ", dataverseIsCustom=" + this.dataverseIsCustom + ", dataverseIsCustomizable=" + this.dataverseIsCustomizable + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class DataverseEntityBuilderImpl
    extends DataverseEntityBuilder<DataverseEntity, DataverseEntityBuilderImpl> {
        @Generated
        private DataverseEntityBuilderImpl() {
        }

        @Override
        @Generated
        protected DataverseEntityBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DataverseEntity build() {
            return new DataverseEntity(this);
        }
    }
}

