/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import co.elastic.clients.elasticsearch._types.SortOrder;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryCategory;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IGlossary;
import com.atlan.model.assets.IGlossaryCategory;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlasGlossaryType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Glossary
extends Asset
implements IGlossary,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Glossary.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AtlasGlossary";
    String typeName;
    @Attribute
    Map<String, String> additionalAttributes;
    @Attribute
    SortedSet<IGlossaryCategory> categories;
    @Attribute
    AtlasGlossaryType glossaryType;
    @Attribute
    String language;
    @Attribute
    String longDescription;
    @Attribute
    String shortDescription;
    @Attribute
    SortedSet<IGlossaryTerm> terms;
    @Attribute
    String usage;

    @Override
    public Glossary trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Glossary.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Glossary.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Glossary.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Glossary.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static Glossary refByGuid(String guid) {
        return Glossary.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static Glossary refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((GlossaryBuilder)((GlossaryBuilder)Glossary._internal().guid(guid)).semantic(semantic)).build();
    }

    public static Glossary refByQualifiedName(String qualifiedName) {
        return Glossary.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static Glossary refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((GlossaryBuilder)((GlossaryBuilder)Glossary._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static Glossary get(AtlanClient client, String id) throws AtlanException {
        return Glossary.get(client, id, false);
    }

    @JsonIgnore
    public static Glossary get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Glossary) {
                return (Glossary)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof Glossary) {
            return (Glossary)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static Glossary get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return Glossary.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static Glossary get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Glossary.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof Glossary) {
                return (Glossary)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Glossary.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof Glossary) {
            return (Glossary)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static GlossaryBuilder<?, ?> creator(String name) {
        return (GlossaryBuilder)((GlossaryBuilder)((GlossaryBuilder)Glossary._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(name)).name(name);
    }

    public static GlossaryBuilder<?, ?> updater(String guid, String name) {
        return (GlossaryBuilder)((GlossaryBuilder)((GlossaryBuilder)Glossary._internal().guid(guid)).qualifiedName(name)).name(name);
    }

    public GlossaryBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        Glossary.validateRequired(TYPE_NAME, map);
        return Glossary.updater(this.getGuid(), this.getName());
    }

    public static Glossary findByName(AtlanClient client, String name) throws AtlanException {
        return Glossary.findByName(client, name, (List<AtlanField>)null);
    }

    public static Glossary findByName(AtlanClient client, String name, Collection<String> attributes) throws AtlanException {
        ArrayList results = new ArrayList();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Glossary.select(client).where(NAME.eq(name)))._includesOnResults(attributes == null ? Collections.emptyList() : attributes)).includeOnRelations(Asset.NAME)).pageSize(2)).stream().limit(2L).filter(a -> a instanceof Glossary).forEach(g -> results.add((Glossary)g));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        if (results.size() > 1) {
            log.warn("Multiple glossaries found with the name '{}', returning only the first.", (Object)name);
        }
        return (Glossary)results.get(0);
    }

    public static Glossary findByName(AtlanClient client, String name, List<AtlanField> attributes) throws AtlanException {
        ArrayList results = new ArrayList();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Glossary.select(client).where(NAME.eq(name))).includesOnResults(attributes == null ? Collections.emptyList() : attributes)).includeOnRelations(Asset.NAME)).pageSize(2)).stream().limit(2L).filter(a -> a instanceof Glossary).forEach(g -> results.add((Glossary)g));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        if (results.size() > 1) {
            log.warn("Multiple glossaries found with the name '{}', returning only the first.", (Object)name);
        }
        return (Glossary)results.get(0);
    }

    public static List<String> getAllQualifiedNames(AtlanClient client) throws AtlanException {
        return ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Glossary.select(client).includeOnResults(QUALIFIED_NAME)).pageSize(50)).stream().map(Asset::getQualifiedName).collect(Collectors.toList());
    }

    public CategoryHierarchy getHierarchy(AtlanClient client) throws AtlanException {
        return this.getHierarchy(client, (List<AtlanField>)null);
    }

    public CategoryHierarchy getHierarchy(AtlanClient client, Collection<String> attributes) throws AtlanException {
        return this._getHierarchy(client, attributes, null);
    }

    public CategoryHierarchy getHierarchy(AtlanClient client, List<AtlanField> attributes) throws AtlanException {
        return this.getHierarchy(client, attributes, null);
    }

    public CategoryHierarchy getHierarchy(AtlanClient client, List<AtlanField> attributes, List<AtlanField> relatedAttributes) throws AtlanException {
        List<String> stringAttributes = new ArrayList<String>();
        if (attributes != null) {
            stringAttributes = attributes.stream().map(AtlanField::getAtlanFieldName).collect(Collectors.toList());
        }
        return this._getHierarchy(client, stringAttributes, relatedAttributes);
    }

    private CategoryHierarchy _getHierarchy(AtlanClient client, Collection<String> attributes, List<AtlanField> relatedAttributes) throws AtlanException {
        if (this.qualifiedName == null) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_QUERY_PARAM, TYPE_NAME, "qualifiedName");
        }
        LinkedHashSet<String> topCategories = new LinkedHashSet<String>();
        HashMap<String, GlossaryCategory> categoryMap = new HashMap<String, GlossaryCategory>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)GlossaryCategory.select(client).where(GlossaryCategory.ANCHOR.eq(this.getQualifiedName()))).includeOnResults(GlossaryCategory.PARENT_CATEGORY))._includesOnResults(attributes == null ? Collections.emptyList() : attributes)).includesOnRelations(relatedAttributes == null ? Collections.emptyList() : relatedAttributes)).sort(GlossaryCategory.NAME.order(SortOrder.Asc))).stream().filter(a -> a instanceof GlossaryCategory).forEach(c -> {
            GlossaryCategory category = (GlossaryCategory)c;
            categoryMap.put(category.getGuid(), category);
            if (category.getParentCategory() == null) {
                topCategories.add(category.getGuid());
            }
        });
        if (topCategories.isEmpty()) {
            throw new NotFoundException(ErrorCode.NO_CATEGORIES, this.getGuid(), this.getQualifiedName());
        }
        return new CategoryHierarchy(client, topCategories, categoryMap, attributes, relatedAttributes);
    }

    public static Glossary removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Glossary)Asset.removeDescription(client, ((GlossaryBuilder)Glossary._internal().qualifiedName(qualifiedName)).name(name));
    }

    public static Glossary removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Glossary)Asset.removeUserDescription(client, ((GlossaryBuilder)Glossary._internal().qualifiedName(qualifiedName)).name(name));
    }

    public static Glossary removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Glossary)Asset.removeOwners(client, ((GlossaryBuilder)Glossary._internal().qualifiedName(qualifiedName)).name(name));
    }

    public static Glossary updateCertificate(AtlanClient client, String qualifiedName, String name, CertificateStatus certificate, String message) throws AtlanException {
        return (Glossary)Asset.updateCertificate(client, Glossary._internal().name(name), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Glossary removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Glossary)Asset.removeCertificate(client, ((GlossaryBuilder)Glossary._internal().qualifiedName(qualifiedName)).name(name));
    }

    public static Glossary updateAnnouncement(AtlanClient client, String qualifiedName, String name, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Glossary)Asset.updateAnnouncement(client, Glossary._internal().name(name), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Glossary removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Glossary)Asset.removeAnnouncement(client, ((GlossaryBuilder)Glossary._internal().qualifiedName(qualifiedName)).name(name));
    }

    @Deprecated
    public static Glossary appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Glossary)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static Glossary appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Glossary)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Glossary(GlossaryBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> additionalAttributes;
        this.typeName = b.typeName$set ? b.typeName$value : Glossary.$default$typeName();
        switch (b.additionalAttributes$key == null ? 0 : b.additionalAttributes$key.size()) {
            case 0: {
                additionalAttributes = Collections.emptyMap();
                break;
            }
            case 1: {
                additionalAttributes = Collections.singletonMap(b.additionalAttributes$key.get(0), b.additionalAttributes$value.get(0));
                break;
            }
            default: {
                additionalAttributes = new LinkedHashMap(b.additionalAttributes$key.size() < 0x40000000 ? 1 + b.additionalAttributes$key.size() + (b.additionalAttributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.additionalAttributes$key.size(); ++$i) {
                    additionalAttributes.put(b.additionalAttributes$key.get($i), b.additionalAttributes$value.get($i));
                }
                additionalAttributes = Collections.unmodifiableMap(additionalAttributes);
            }
        }
        this.additionalAttributes = additionalAttributes;
        SortedSet<IGlossaryCategory> categories = new TreeSet<IGlossaryCategory>();
        if (b.categories != null) {
            categories.addAll(b.categories);
        }
        categories = Collections.unmodifiableSortedSet(categories);
        this.categories = categories;
        this.glossaryType = b.glossaryType;
        this.language = b.language;
        this.longDescription = b.longDescription;
        this.shortDescription = b.shortDescription;
        SortedSet<IGlossaryTerm> terms = new TreeSet<IGlossaryTerm>();
        if (b.terms != null) {
            terms.addAll(b.terms);
        }
        terms = Collections.unmodifiableSortedSet(terms);
        this.terms = terms;
        this.usage = b.usage;
    }

    @Generated
    public static GlossaryBuilder<?, ?> _internal() {
        return new GlossaryBuilderImpl();
    }

    @Generated
    public GlossaryBuilder<?, ?> toBuilder() {
        return new GlossaryBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryCategory> getCategories() {
        return this.categories;
    }

    @Override
    @Generated
    public AtlasGlossaryType getGlossaryType() {
        return this.glossaryType;
    }

    @Override
    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Override
    @Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    @Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getTerms() {
        return this.terms;
    }

    @Override
    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Glossary)) {
            return false;
        }
        Glossary other = (Glossary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        Map<String, String> this$additionalAttributes = this.getAdditionalAttributes();
        Map<String, String> other$additionalAttributes = other.getAdditionalAttributes();
        if (this$additionalAttributes == null ? other$additionalAttributes != null : !((Object)this$additionalAttributes).equals(other$additionalAttributes)) {
            return false;
        }
        SortedSet<IGlossaryCategory> this$categories = this.getCategories();
        SortedSet<IGlossaryCategory> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !this$categories.equals(other$categories)) {
            return false;
        }
        AtlasGlossaryType this$glossaryType = this.getGlossaryType();
        AtlasGlossaryType other$glossaryType = other.getGlossaryType();
        if (this$glossaryType == null ? other$glossaryType != null : !this$glossaryType.equals(other$glossaryType)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$longDescription = this.getLongDescription();
        String other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) {
            return false;
        }
        String this$shortDescription = this.getShortDescription();
        String other$shortDescription = other.getShortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$terms = this.getTerms();
        SortedSet<IGlossaryTerm> other$terms = other.getTerms();
        if (this$terms == null ? other$terms != null : !this$terms.equals(other$terms)) {
            return false;
        }
        String this$usage = this.getUsage();
        String other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !this$usage.equals(other$usage));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Glossary;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        Map<String, String> $additionalAttributes = this.getAdditionalAttributes();
        result = result * 59 + ($additionalAttributes == null ? 43 : ((Object)$additionalAttributes).hashCode());
        SortedSet<IGlossaryCategory> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : $categories.hashCode());
        AtlasGlossaryType $glossaryType = this.getGlossaryType();
        result = result * 59 + ($glossaryType == null ? 43 : $glossaryType.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $longDescription = this.getLongDescription();
        result = result * 59 + ($longDescription == null ? 43 : $longDescription.hashCode());
        String $shortDescription = this.getShortDescription();
        result = result * 59 + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        SortedSet<IGlossaryTerm> $terms = this.getTerms();
        result = result * 59 + ($terms == null ? 43 : $terms.hashCode());
        String $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Glossary(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", additionalAttributes=" + String.valueOf(this.getAdditionalAttributes()) + ", categories=" + String.valueOf(this.getCategories()) + ", glossaryType=" + String.valueOf(this.getGlossaryType()) + ", language=" + this.getLanguage() + ", longDescription=" + this.getLongDescription() + ", shortDescription=" + this.getShortDescription() + ", terms=" + String.valueOf(this.getTerms()) + ", usage=" + this.getUsage() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class GlossaryBuilder<C extends Glossary, B extends GlossaryBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<String> additionalAttributes$key;
        @Generated
        private ArrayList<String> additionalAttributes$value;
        @Generated
        private ArrayList<IGlossaryCategory> categories;
        @Generated
        private AtlasGlossaryType glossaryType;
        @Generated
        private String language;
        @Generated
        private String longDescription;
        @Generated
        private String shortDescription;
        @Generated
        private ArrayList<IGlossaryTerm> terms;
        @Generated
        private String usage;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GlossaryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Glossary instance, GlossaryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.additionalAttributes(instance.additionalAttributes == null ? Collections.emptyMap() : instance.additionalAttributes);
            b.categories(instance.categories == null ? Collections.emptySortedSet() : instance.categories);
            b.glossaryType(instance.glossaryType);
            b.language(instance.language);
            b.longDescription(instance.longDescription);
            b.shortDescription(instance.shortDescription);
            b.terms(instance.terms == null ? Collections.emptySortedSet() : instance.terms);
            b.usage(instance.usage);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B additionalAttribute(String additionalAttributeKey, String additionalAttributeValue) {
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new ArrayList();
                this.additionalAttributes$value = new ArrayList();
            }
            this.additionalAttributes$key.add(additionalAttributeKey);
            this.additionalAttributes$value.add(additionalAttributeValue);
            return (B)this.self();
        }

        @Generated
        public B additionalAttributes(Map<? extends String, ? extends String> additionalAttributes) {
            if (additionalAttributes == null) {
                throw new NullPointerException("additionalAttributes cannot be null");
            }
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new ArrayList();
                this.additionalAttributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : additionalAttributes.entrySet()) {
                this.additionalAttributes$key.add($lombokEntry.getKey());
                this.additionalAttributes$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearAdditionalAttributes() {
            if (this.additionalAttributes$key != null) {
                this.additionalAttributes$key.clear();
                this.additionalAttributes$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B category(IGlossaryCategory category) {
            if (this.categories == null) {
                this.categories = new ArrayList();
            }
            this.categories.add(category);
            return (B)this.self();
        }

        @Generated
        public B categories(Collection<? extends IGlossaryCategory> categories) {
            if (categories == null) {
                throw new NullPointerException("categories cannot be null");
            }
            if (this.categories == null) {
                this.categories = new ArrayList();
            }
            this.categories.addAll(categories);
            return (B)this.self();
        }

        @Generated
        public B clearCategories() {
            if (this.categories != null) {
                this.categories.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B glossaryType(AtlasGlossaryType glossaryType) {
            this.glossaryType = glossaryType;
            return (B)this.self();
        }

        @Generated
        public B language(String language) {
            this.language = language;
            return (B)this.self();
        }

        @Generated
        public B longDescription(String longDescription) {
            this.longDescription = longDescription;
            return (B)this.self();
        }

        @Generated
        public B shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return (B)this.self();
        }

        @Generated
        public B term(IGlossaryTerm term) {
            if (this.terms == null) {
                this.terms = new ArrayList();
            }
            this.terms.add(term);
            return (B)this.self();
        }

        @Generated
        public B terms(Collection<? extends IGlossaryTerm> terms) {
            if (terms == null) {
                throw new NullPointerException("terms cannot be null");
            }
            if (this.terms == null) {
                this.terms = new ArrayList();
            }
            this.terms.addAll(terms);
            return (B)this.self();
        }

        @Generated
        public B clearTerms() {
            if (this.terms != null) {
                this.terms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B usage(String usage) {
            this.usage = usage;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Glossary.GlossaryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", additionalAttributes$key=" + String.valueOf(this.additionalAttributes$key) + ", additionalAttributes$value=" + String.valueOf(this.additionalAttributes$value) + ", categories=" + String.valueOf(this.categories) + ", glossaryType=" + String.valueOf(this.glossaryType) + ", language=" + this.language + ", longDescription=" + this.longDescription + ", shortDescription=" + this.shortDescription + ", terms=" + String.valueOf(this.terms) + ", usage=" + this.usage + ")";
        }
    }

    public static class CategoryHierarchy {
        private final transient AtlanClient client;
        private final Collection<String> attributes;
        private final List<AtlanField> relatedAttributes;
        private final Set<String> topLevel;
        private final List<GlossaryCategory> rootCategories;
        private final Map<String, GlossaryCategory> map;

        private CategoryHierarchy(AtlanClient client, Set<String> topLevel, Map<String, GlossaryCategory> stubMap, Collection<String> attributes, List<AtlanField> relatedAttributes) {
            this.client = client;
            this.attributes = attributes;
            this.relatedAttributes = relatedAttributes;
            this.topLevel = topLevel;
            this.rootCategories = new ArrayList<GlossaryCategory>();
            this.map = new LinkedHashMap<String, GlossaryCategory>();
            this.buildMaps(stubMap);
        }

        private void buildMaps(Map<String, GlossaryCategory> stubMap) {
            for (Map.Entry<String, GlossaryCategory> entry : stubMap.entrySet()) {
                GlossaryCategory category = entry.getValue();
                IGlossaryCategory parent = category.getParentCategory();
                if (parent != null) {
                    String parentGuid = parent.getGuid();
                    GlossaryCategory fullParent = this.map.getOrDefault(parentGuid, stubMap.get(parentGuid));
                    if (fullParent != null) {
                        TreeSet<IGlossaryCategory> children = new TreeSet<IGlossaryCategory>(fullParent.getChildrenCategories());
                        children.add(category);
                        fullParent.setChildrenCategories(children);
                        this.map.put(parent.getGuid(), fullParent);
                    } else {
                        log.debug("Unable to find referenced parent category '{}', could be in a different glossary.", (Object)parentGuid);
                        try {
                            ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)GlossaryCategory.select(this.client).where(GlossaryCategory.GUID.eq(parentGuid))).includeOnResults(GlossaryCategory.PARENT_CATEGORY))._includesOnResults(this.attributes == null ? Collections.emptyList() : this.attributes)).includesOnRelations(this.relatedAttributes == null ? Collections.emptyList() : this.relatedAttributes)).sort(GlossaryCategory.NAME.order(SortOrder.Asc))).stream().filter(a -> a instanceof GlossaryCategory).forEach(c -> {
                                GlossaryCategory fetched = (GlossaryCategory)c;
                                this.map.put(fetched.getGuid(), fetched);
                                if (fetched.getParentCategory() == null) {
                                    this.topLevel.add(fetched.getGuid());
                                }
                            });
                        }
                        catch (AtlanException e) {
                            log.warn("Unable to find referenced parent category '{}', skipping it in traversal.", (Object)parentGuid);
                            log.debug("Full details: ", (Throwable)e);
                        }
                    }
                }
                this.map.put(category.getGuid(), category);
            }
        }

        public GlossaryCategory getCategory(String guid) {
            return this.map.get(guid);
        }

        public List<IGlossaryCategory> getRootCategories() {
            if (this.rootCategories.isEmpty()) {
                for (String top : this.topLevel) {
                    this.rootCategories.add(this.map.get(top));
                }
            }
            return Collections.unmodifiableList(this.rootCategories);
        }

        public List<IGlossaryCategory> breadthFirst() {
            List<IGlossaryCategory> top = this.getRootCategories();
            ArrayList<IGlossaryCategory> all = new ArrayList<IGlossaryCategory>(top);
            this.bfs(all, top);
            return Collections.unmodifiableList(all);
        }

        public List<IGlossaryCategory> depthFirst() {
            ArrayList<IGlossaryCategory> all = new ArrayList<IGlossaryCategory>();
            this.dfs(all, this.getRootCategories());
            return Collections.unmodifiableList(all);
        }

        private void bfs(List<IGlossaryCategory> list, Collection<IGlossaryCategory> toAdd) {
            for (IGlossaryCategory node : toAdd) {
                list.addAll(node.getChildrenCategories());
            }
            for (IGlossaryCategory node : toAdd) {
                this.bfs(list, node.getChildrenCategories());
            }
        }

        private void dfs(List<IGlossaryCategory> list, Collection<IGlossaryCategory> toAdd) {
            for (IGlossaryCategory node : toAdd) {
                list.add(node);
                this.dfs(list, node.getChildrenCategories());
            }
        }
    }

    @Generated
    private static final class GlossaryBuilderImpl
    extends GlossaryBuilder<Glossary, GlossaryBuilderImpl> {
        @Generated
        private GlossaryBuilderImpl() {
        }

        @Override
        @Generated
        protected GlossaryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Glossary build() {
            return new Glossary(this);
        }
    }
}

