/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.ILooker;
import com.atlan.model.assets.ILookerDashboard;
import com.atlan.model.assets.ILookerExplore;
import com.atlan.model.assets.ILookerField;
import com.atlan.model.assets.ILookerLook;
import com.atlan.model.assets.ILookerModel;
import com.atlan.model.assets.ILookerProject;
import com.atlan.model.assets.ILookerTile;
import com.atlan.model.assets.ILookerView;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookerField
extends Asset
implements ILookerField,
ILooker,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookerField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerField";
    String typeName;
    @Attribute
    ILookerDashboard dashboard;
    @Attribute
    ILookerExplore explore;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    ILookerLook look;
    @Attribute
    String lookerDashboardQualifiedName;
    @Attribute
    String lookerExploreQualifiedName;
    @Attribute
    String lookerFieldDataType;
    @Attribute
    Boolean lookerFieldIsRefined;
    @Attribute
    String lookerFieldRefinementFilePath;
    @Attribute
    String lookerFieldRefinementLineNumber;
    @Attribute
    String lookerLookQualifiedName;
    @Attribute
    String lookerSlug;
    @Attribute
    String lookerTileQualifiedName;
    @Attribute
    Integer lookerTimesUsed;
    @Attribute
    String lookerViewQualifiedName;
    @Attribute
    ILookerModel model;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    String modelName;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    ILookerProject project;
    @Attribute
    String projectName;
    @Attribute
    String sourceDefinition;
    @Attribute
    ILookerTile tile;
    @Attribute
    ILookerView view;

    @Override
    public LookerField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return LookerField.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return LookerField.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return LookerField.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return LookerField.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static LookerField refByGuid(String guid) {
        return LookerField.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static LookerField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((LookerFieldBuilder)((LookerFieldBuilder)LookerField._internal().guid(guid)).semantic(semantic)).build();
    }

    public static LookerField refByQualifiedName(String qualifiedName) {
        return LookerField.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static LookerField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((LookerFieldBuilder)((LookerFieldBuilder)LookerField._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static LookerField get(AtlanClient client, String id) throws AtlanException {
        return LookerField.get(client, id, false);
    }

    @JsonIgnore
    public static LookerField get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof LookerField) {
                return (LookerField)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof LookerField) {
            return (LookerField)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static LookerField get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return LookerField.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static LookerField get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)LookerField.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof LookerField) {
                return (LookerField)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)LookerField.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof LookerField) {
            return (LookerField)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static LookerFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerFieldBuilder)((LookerFieldBuilder)((LookerFieldBuilder)LookerField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public LookerFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        LookerField.validateRequired(TYPE_NAME, map);
        return LookerField.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeDescription(client, LookerField.updater(qualifiedName, name));
    }

    public static LookerField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeUserDescription(client, LookerField.updater(qualifiedName, name));
    }

    public static LookerField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeOwners(client, LookerField.updater(qualifiedName, name));
    }

    public static LookerField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerField)Asset.updateCertificate(client, LookerField._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeCertificate(client, LookerField.updater(qualifiedName, name));
    }

    public static LookerField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerField)Asset.updateAnnouncement(client, LookerField._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeAnnouncement(client, LookerField.updater(qualifiedName, name));
    }

    public static LookerField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerField)Asset.replaceTerms(client, LookerField.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static LookerField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerField)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static LookerField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerField)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static LookerField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static LookerField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerField(LookerFieldBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerField.$default$typeName();
        this.dashboard = b.dashboard;
        this.explore = b.explore;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.look = b.look;
        this.lookerDashboardQualifiedName = b.lookerDashboardQualifiedName;
        this.lookerExploreQualifiedName = b.lookerExploreQualifiedName;
        this.lookerFieldDataType = b.lookerFieldDataType;
        this.lookerFieldIsRefined = b.lookerFieldIsRefined;
        this.lookerFieldRefinementFilePath = b.lookerFieldRefinementFilePath;
        this.lookerFieldRefinementLineNumber = b.lookerFieldRefinementLineNumber;
        this.lookerLookQualifiedName = b.lookerLookQualifiedName;
        this.lookerSlug = b.lookerSlug;
        this.lookerTileQualifiedName = b.lookerTileQualifiedName;
        this.lookerTimesUsed = b.lookerTimesUsed;
        this.lookerViewQualifiedName = b.lookerViewQualifiedName;
        this.model = b.model;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        this.modelName = b.modelName;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.project = b.project;
        this.projectName = b.projectName;
        this.sourceDefinition = b.sourceDefinition;
        this.tile = b.tile;
        this.view = b.view;
    }

    @Generated
    public static LookerFieldBuilder<?, ?> _internal() {
        return new LookerFieldBuilderImpl();
    }

    @Generated
    public LookerFieldBuilder<?, ?> toBuilder() {
        return new LookerFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public ILookerDashboard getDashboard() {
        return this.dashboard;
    }

    @Override
    @Generated
    public ILookerExplore getExplore() {
        return this.explore;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public ILookerLook getLook() {
        return this.look;
    }

    @Override
    @Generated
    public String getLookerDashboardQualifiedName() {
        return this.lookerDashboardQualifiedName;
    }

    @Override
    @Generated
    public String getLookerExploreQualifiedName() {
        return this.lookerExploreQualifiedName;
    }

    @Override
    @Generated
    public String getLookerFieldDataType() {
        return this.lookerFieldDataType;
    }

    @Override
    @Generated
    public Boolean getLookerFieldIsRefined() {
        return this.lookerFieldIsRefined;
    }

    @Override
    @Generated
    public String getLookerFieldRefinementFilePath() {
        return this.lookerFieldRefinementFilePath;
    }

    @Override
    @Generated
    public String getLookerFieldRefinementLineNumber() {
        return this.lookerFieldRefinementLineNumber;
    }

    @Override
    @Generated
    public String getLookerLookQualifiedName() {
        return this.lookerLookQualifiedName;
    }

    @Override
    @Generated
    public String getLookerSlug() {
        return this.lookerSlug;
    }

    @Override
    @Generated
    public String getLookerTileQualifiedName() {
        return this.lookerTileQualifiedName;
    }

    @Override
    @Generated
    public Integer getLookerTimesUsed() {
        return this.lookerTimesUsed;
    }

    @Override
    @Generated
    public String getLookerViewQualifiedName() {
        return this.lookerViewQualifiedName;
    }

    @Override
    @Generated
    public ILookerModel getModel() {
        return this.model;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public ILookerProject getProject() {
        return this.project;
    }

    @Override
    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    @Generated
    public String getSourceDefinition() {
        return this.sourceDefinition;
    }

    @Override
    @Generated
    public ILookerTile getTile() {
        return this.tile;
    }

    @Override
    @Generated
    public ILookerView getView() {
        return this.view;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerField)) {
            return false;
        }
        LookerField other = (LookerField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$lookerFieldIsRefined = this.getLookerFieldIsRefined();
        Boolean other$lookerFieldIsRefined = other.getLookerFieldIsRefined();
        if (this$lookerFieldIsRefined == null ? other$lookerFieldIsRefined != null : !((Object)this$lookerFieldIsRefined).equals(other$lookerFieldIsRefined)) {
            return false;
        }
        Integer this$lookerTimesUsed = this.getLookerTimesUsed();
        Integer other$lookerTimesUsed = other.getLookerTimesUsed();
        if (this$lookerTimesUsed == null ? other$lookerTimesUsed != null : !((Object)this$lookerTimesUsed).equals(other$lookerTimesUsed)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        ILookerDashboard this$dashboard = this.getDashboard();
        ILookerDashboard other$dashboard = other.getDashboard();
        if (this$dashboard == null ? other$dashboard != null : !this$dashboard.equals(other$dashboard)) {
            return false;
        }
        ILookerExplore this$explore = this.getExplore();
        ILookerExplore other$explore = other.getExplore();
        if (this$explore == null ? other$explore != null : !this$explore.equals(other$explore)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        ILookerLook this$look = this.getLook();
        ILookerLook other$look = other.getLook();
        if (this$look == null ? other$look != null : !this$look.equals(other$look)) {
            return false;
        }
        String this$lookerDashboardQualifiedName = this.getLookerDashboardQualifiedName();
        String other$lookerDashboardQualifiedName = other.getLookerDashboardQualifiedName();
        if (this$lookerDashboardQualifiedName == null ? other$lookerDashboardQualifiedName != null : !this$lookerDashboardQualifiedName.equals(other$lookerDashboardQualifiedName)) {
            return false;
        }
        String this$lookerExploreQualifiedName = this.getLookerExploreQualifiedName();
        String other$lookerExploreQualifiedName = other.getLookerExploreQualifiedName();
        if (this$lookerExploreQualifiedName == null ? other$lookerExploreQualifiedName != null : !this$lookerExploreQualifiedName.equals(other$lookerExploreQualifiedName)) {
            return false;
        }
        String this$lookerFieldDataType = this.getLookerFieldDataType();
        String other$lookerFieldDataType = other.getLookerFieldDataType();
        if (this$lookerFieldDataType == null ? other$lookerFieldDataType != null : !this$lookerFieldDataType.equals(other$lookerFieldDataType)) {
            return false;
        }
        String this$lookerFieldRefinementFilePath = this.getLookerFieldRefinementFilePath();
        String other$lookerFieldRefinementFilePath = other.getLookerFieldRefinementFilePath();
        if (this$lookerFieldRefinementFilePath == null ? other$lookerFieldRefinementFilePath != null : !this$lookerFieldRefinementFilePath.equals(other$lookerFieldRefinementFilePath)) {
            return false;
        }
        String this$lookerFieldRefinementLineNumber = this.getLookerFieldRefinementLineNumber();
        String other$lookerFieldRefinementLineNumber = other.getLookerFieldRefinementLineNumber();
        if (this$lookerFieldRefinementLineNumber == null ? other$lookerFieldRefinementLineNumber != null : !this$lookerFieldRefinementLineNumber.equals(other$lookerFieldRefinementLineNumber)) {
            return false;
        }
        String this$lookerLookQualifiedName = this.getLookerLookQualifiedName();
        String other$lookerLookQualifiedName = other.getLookerLookQualifiedName();
        if (this$lookerLookQualifiedName == null ? other$lookerLookQualifiedName != null : !this$lookerLookQualifiedName.equals(other$lookerLookQualifiedName)) {
            return false;
        }
        String this$lookerSlug = this.getLookerSlug();
        String other$lookerSlug = other.getLookerSlug();
        if (this$lookerSlug == null ? other$lookerSlug != null : !this$lookerSlug.equals(other$lookerSlug)) {
            return false;
        }
        String this$lookerTileQualifiedName = this.getLookerTileQualifiedName();
        String other$lookerTileQualifiedName = other.getLookerTileQualifiedName();
        if (this$lookerTileQualifiedName == null ? other$lookerTileQualifiedName != null : !this$lookerTileQualifiedName.equals(other$lookerTileQualifiedName)) {
            return false;
        }
        String this$lookerViewQualifiedName = this.getLookerViewQualifiedName();
        String other$lookerViewQualifiedName = other.getLookerViewQualifiedName();
        if (this$lookerViewQualifiedName == null ? other$lookerViewQualifiedName != null : !this$lookerViewQualifiedName.equals(other$lookerViewQualifiedName)) {
            return false;
        }
        ILookerModel this$model = this.getModel();
        ILookerModel other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        ILookerProject this$project = this.getProject();
        ILookerProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$sourceDefinition = this.getSourceDefinition();
        String other$sourceDefinition = other.getSourceDefinition();
        if (this$sourceDefinition == null ? other$sourceDefinition != null : !this$sourceDefinition.equals(other$sourceDefinition)) {
            return false;
        }
        ILookerTile this$tile = this.getTile();
        ILookerTile other$tile = other.getTile();
        if (this$tile == null ? other$tile != null : !this$tile.equals(other$tile)) {
            return false;
        }
        ILookerView this$view = this.getView();
        ILookerView other$view = other.getView();
        return !(this$view == null ? other$view != null : !this$view.equals(other$view));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $lookerFieldIsRefined = this.getLookerFieldIsRefined();
        result = result * 59 + ($lookerFieldIsRefined == null ? 43 : ((Object)$lookerFieldIsRefined).hashCode());
        Integer $lookerTimesUsed = this.getLookerTimesUsed();
        result = result * 59 + ($lookerTimesUsed == null ? 43 : ((Object)$lookerTimesUsed).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        ILookerDashboard $dashboard = this.getDashboard();
        result = result * 59 + ($dashboard == null ? 43 : $dashboard.hashCode());
        ILookerExplore $explore = this.getExplore();
        result = result * 59 + ($explore == null ? 43 : $explore.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        ILookerLook $look = this.getLook();
        result = result * 59 + ($look == null ? 43 : $look.hashCode());
        String $lookerDashboardQualifiedName = this.getLookerDashboardQualifiedName();
        result = result * 59 + ($lookerDashboardQualifiedName == null ? 43 : $lookerDashboardQualifiedName.hashCode());
        String $lookerExploreQualifiedName = this.getLookerExploreQualifiedName();
        result = result * 59 + ($lookerExploreQualifiedName == null ? 43 : $lookerExploreQualifiedName.hashCode());
        String $lookerFieldDataType = this.getLookerFieldDataType();
        result = result * 59 + ($lookerFieldDataType == null ? 43 : $lookerFieldDataType.hashCode());
        String $lookerFieldRefinementFilePath = this.getLookerFieldRefinementFilePath();
        result = result * 59 + ($lookerFieldRefinementFilePath == null ? 43 : $lookerFieldRefinementFilePath.hashCode());
        String $lookerFieldRefinementLineNumber = this.getLookerFieldRefinementLineNumber();
        result = result * 59 + ($lookerFieldRefinementLineNumber == null ? 43 : $lookerFieldRefinementLineNumber.hashCode());
        String $lookerLookQualifiedName = this.getLookerLookQualifiedName();
        result = result * 59 + ($lookerLookQualifiedName == null ? 43 : $lookerLookQualifiedName.hashCode());
        String $lookerSlug = this.getLookerSlug();
        result = result * 59 + ($lookerSlug == null ? 43 : $lookerSlug.hashCode());
        String $lookerTileQualifiedName = this.getLookerTileQualifiedName();
        result = result * 59 + ($lookerTileQualifiedName == null ? 43 : $lookerTileQualifiedName.hashCode());
        String $lookerViewQualifiedName = this.getLookerViewQualifiedName();
        result = result * 59 + ($lookerViewQualifiedName == null ? 43 : $lookerViewQualifiedName.hashCode());
        ILookerModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        ILookerProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $sourceDefinition = this.getSourceDefinition();
        result = result * 59 + ($sourceDefinition == null ? 43 : $sourceDefinition.hashCode());
        ILookerTile $tile = this.getTile();
        result = result * 59 + ($tile == null ? 43 : $tile.hashCode());
        ILookerView $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LookerField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dashboard=" + String.valueOf(this.getDashboard()) + ", explore=" + String.valueOf(this.getExplore()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", look=" + String.valueOf(this.getLook()) + ", lookerDashboardQualifiedName=" + this.getLookerDashboardQualifiedName() + ", lookerExploreQualifiedName=" + this.getLookerExploreQualifiedName() + ", lookerFieldDataType=" + this.getLookerFieldDataType() + ", lookerFieldIsRefined=" + this.getLookerFieldIsRefined() + ", lookerFieldRefinementFilePath=" + this.getLookerFieldRefinementFilePath() + ", lookerFieldRefinementLineNumber=" + this.getLookerFieldRefinementLineNumber() + ", lookerLookQualifiedName=" + this.getLookerLookQualifiedName() + ", lookerSlug=" + this.getLookerSlug() + ", lookerTileQualifiedName=" + this.getLookerTileQualifiedName() + ", lookerTimesUsed=" + this.getLookerTimesUsed() + ", lookerViewQualifiedName=" + this.getLookerViewQualifiedName() + ", model=" + String.valueOf(this.getModel()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", modelName=" + this.getModelName() + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", project=" + String.valueOf(this.getProject()) + ", projectName=" + this.getProjectName() + ", sourceDefinition=" + this.getSourceDefinition() + ", tile=" + String.valueOf(this.getTile()) + ", view=" + String.valueOf(this.getView()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class LookerFieldBuilder<C extends LookerField, B extends LookerFieldBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ILookerDashboard dashboard;
        @Generated
        private ILookerExplore explore;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ILookerLook look;
        @Generated
        private String lookerDashboardQualifiedName;
        @Generated
        private String lookerExploreQualifiedName;
        @Generated
        private String lookerFieldDataType;
        @Generated
        private Boolean lookerFieldIsRefined;
        @Generated
        private String lookerFieldRefinementFilePath;
        @Generated
        private String lookerFieldRefinementLineNumber;
        @Generated
        private String lookerLookQualifiedName;
        @Generated
        private String lookerSlug;
        @Generated
        private String lookerTileQualifiedName;
        @Generated
        private Integer lookerTimesUsed;
        @Generated
        private String lookerViewQualifiedName;
        @Generated
        private ILookerModel model;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private String modelName;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ILookerProject project;
        @Generated
        private String projectName;
        @Generated
        private String sourceDefinition;
        @Generated
        private ILookerTile tile;
        @Generated
        private ILookerView view;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerField instance, LookerFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dashboard(instance.dashboard);
            b.explore(instance.explore);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.look(instance.look);
            b.lookerDashboardQualifiedName(instance.lookerDashboardQualifiedName);
            b.lookerExploreQualifiedName(instance.lookerExploreQualifiedName);
            b.lookerFieldDataType(instance.lookerFieldDataType);
            b.lookerFieldIsRefined(instance.lookerFieldIsRefined);
            b.lookerFieldRefinementFilePath(instance.lookerFieldRefinementFilePath);
            b.lookerFieldRefinementLineNumber(instance.lookerFieldRefinementLineNumber);
            b.lookerLookQualifiedName(instance.lookerLookQualifiedName);
            b.lookerSlug(instance.lookerSlug);
            b.lookerTileQualifiedName(instance.lookerTileQualifiedName);
            b.lookerTimesUsed(instance.lookerTimesUsed);
            b.lookerViewQualifiedName(instance.lookerViewQualifiedName);
            b.model(instance.model);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.modelName(instance.modelName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.project(instance.project);
            b.projectName(instance.projectName);
            b.sourceDefinition(instance.sourceDefinition);
            b.tile(instance.tile);
            b.view(instance.view);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dashboard(ILookerDashboard dashboard) {
            this.dashboard = dashboard;
            return (B)this.self();
        }

        @Generated
        public B explore(ILookerExplore explore) {
            this.explore = explore;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B look(ILookerLook look) {
            this.look = look;
            return (B)this.self();
        }

        @Generated
        public B lookerDashboardQualifiedName(String lookerDashboardQualifiedName) {
            this.lookerDashboardQualifiedName = lookerDashboardQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B lookerExploreQualifiedName(String lookerExploreQualifiedName) {
            this.lookerExploreQualifiedName = lookerExploreQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B lookerFieldDataType(String lookerFieldDataType) {
            this.lookerFieldDataType = lookerFieldDataType;
            return (B)this.self();
        }

        @Generated
        public B lookerFieldIsRefined(Boolean lookerFieldIsRefined) {
            this.lookerFieldIsRefined = lookerFieldIsRefined;
            return (B)this.self();
        }

        @Generated
        public B lookerFieldRefinementFilePath(String lookerFieldRefinementFilePath) {
            this.lookerFieldRefinementFilePath = lookerFieldRefinementFilePath;
            return (B)this.self();
        }

        @Generated
        public B lookerFieldRefinementLineNumber(String lookerFieldRefinementLineNumber) {
            this.lookerFieldRefinementLineNumber = lookerFieldRefinementLineNumber;
            return (B)this.self();
        }

        @Generated
        public B lookerLookQualifiedName(String lookerLookQualifiedName) {
            this.lookerLookQualifiedName = lookerLookQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B lookerSlug(String lookerSlug) {
            this.lookerSlug = lookerSlug;
            return (B)this.self();
        }

        @Generated
        public B lookerTileQualifiedName(String lookerTileQualifiedName) {
            this.lookerTileQualifiedName = lookerTileQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B lookerTimesUsed(Integer lookerTimesUsed) {
            this.lookerTimesUsed = lookerTimesUsed;
            return (B)this.self();
        }

        @Generated
        public B lookerViewQualifiedName(String lookerViewQualifiedName) {
            this.lookerViewQualifiedName = lookerViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B model(ILookerModel model) {
            this.model = model;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelName(String modelName) {
            this.modelName = modelName;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B project(ILookerProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Generated
        public B projectName(String projectName) {
            this.projectName = projectName;
            return (B)this.self();
        }

        @Generated
        public B sourceDefinition(String sourceDefinition) {
            this.sourceDefinition = sourceDefinition;
            return (B)this.self();
        }

        @Generated
        public B tile(ILookerTile tile) {
            this.tile = tile;
            return (B)this.self();
        }

        @Generated
        public B view(ILookerView view) {
            this.view = view;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LookerField.LookerFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dashboard=" + String.valueOf(this.dashboard) + ", explore=" + String.valueOf(this.explore) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", look=" + String.valueOf(this.look) + ", lookerDashboardQualifiedName=" + this.lookerDashboardQualifiedName + ", lookerExploreQualifiedName=" + this.lookerExploreQualifiedName + ", lookerFieldDataType=" + this.lookerFieldDataType + ", lookerFieldIsRefined=" + this.lookerFieldIsRefined + ", lookerFieldRefinementFilePath=" + this.lookerFieldRefinementFilePath + ", lookerFieldRefinementLineNumber=" + this.lookerFieldRefinementLineNumber + ", lookerLookQualifiedName=" + this.lookerLookQualifiedName + ", lookerSlug=" + this.lookerSlug + ", lookerTileQualifiedName=" + this.lookerTileQualifiedName + ", lookerTimesUsed=" + this.lookerTimesUsed + ", lookerViewQualifiedName=" + this.lookerViewQualifiedName + ", model=" + String.valueOf(this.model) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", modelName=" + this.modelName + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", project=" + String.valueOf(this.project) + ", projectName=" + this.projectName + ", sourceDefinition=" + this.sourceDefinition + ", tile=" + String.valueOf(this.tile) + ", view=" + String.valueOf(this.view) + ")";
        }
    }

    @Generated
    private static final class LookerFieldBuilderImpl
    extends LookerFieldBuilder<LookerField, LookerFieldBuilderImpl> {
        @Generated
        private LookerFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerField build() {
            return new LookerField(this);
        }
    }
}

