/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDataQuality;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMCIncident;
import com.atlan.model.assets.IMCMonitor;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IMonteCarlo;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCIncident
extends Asset
implements IMCIncident,
IMonteCarlo,
IDataQuality,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MCIncident.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MCIncident";
    String typeName;
    @Attribute
    Boolean dqIsPartOfContract;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<String> mcAssetQualifiedNames;
    @Attribute
    SortedSet<IAsset> mcIncidentAssets;
    @Attribute
    String mcIncidentId;
    @Attribute
    String mcIncidentPriority;
    @Attribute
    String mcIncidentSeverity;
    @Attribute
    String mcIncidentState;
    @Attribute
    SortedSet<String> mcIncidentSubTypes;
    @Attribute
    String mcIncidentType;
    @Attribute
    String mcIncidentWarehouse;
    @Attribute
    SortedSet<String> mcLabels;
    @Attribute
    IMCMonitor mcMonitor;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public MCIncident trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return MCIncident.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return MCIncident.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return MCIncident.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return MCIncident.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static MCIncident refByGuid(String guid) {
        return MCIncident.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static MCIncident refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((MCIncidentBuilder)((MCIncidentBuilder)MCIncident._internal().guid(guid)).semantic(semantic)).build();
    }

    public static MCIncident refByQualifiedName(String qualifiedName) {
        return MCIncident.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static MCIncident refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((MCIncidentBuilder)((MCIncidentBuilder)MCIncident._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static MCIncident get(AtlanClient client, String id) throws AtlanException {
        return MCIncident.get(client, id, false);
    }

    @JsonIgnore
    public static MCIncident get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof MCIncident) {
                return (MCIncident)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof MCIncident) {
            return (MCIncident)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static MCIncident get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return MCIncident.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static MCIncident get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)MCIncident.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof MCIncident) {
                return (MCIncident)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)MCIncident.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof MCIncident) {
            return (MCIncident)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static MCIncidentBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MCIncidentBuilder)((MCIncidentBuilder)((MCIncidentBuilder)MCIncident._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public MCIncidentBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        MCIncident.validateRequired(TYPE_NAME, map);
        return MCIncident.updater(this.getQualifiedName(), this.getName());
    }

    public static MCIncident removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCIncident)Asset.removeDescription(client, MCIncident.updater(qualifiedName, name));
    }

    public static MCIncident removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCIncident)Asset.removeUserDescription(client, MCIncident.updater(qualifiedName, name));
    }

    public static MCIncident removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCIncident)Asset.removeOwners(client, MCIncident.updater(qualifiedName, name));
    }

    public static MCIncident updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MCIncident)Asset.updateCertificate(client, MCIncident._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MCIncident removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCIncident)Asset.removeCertificate(client, MCIncident.updater(qualifiedName, name));
    }

    public static MCIncident updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MCIncident)Asset.updateAnnouncement(client, MCIncident._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MCIncident removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCIncident)Asset.removeAnnouncement(client, MCIncident.updater(qualifiedName, name));
    }

    public static MCIncident replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MCIncident)Asset.replaceTerms(client, MCIncident.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static MCIncident appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MCIncident)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static MCIncident removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MCIncident)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static MCIncident appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MCIncident)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static MCIncident appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MCIncident)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MCIncident(MCIncidentBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : MCIncident.$default$typeName();
        this.dqIsPartOfContract = b.dqIsPartOfContract;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<String> mcAssetQualifiedNames = new TreeSet<String>();
        if (b.mcAssetQualifiedNames != null) {
            mcAssetQualifiedNames.addAll(b.mcAssetQualifiedNames);
        }
        mcAssetQualifiedNames = Collections.unmodifiableSortedSet(mcAssetQualifiedNames);
        this.mcAssetQualifiedNames = mcAssetQualifiedNames;
        SortedSet<IAsset> mcIncidentAssets = new TreeSet<IAsset>();
        if (b.mcIncidentAssets != null) {
            mcIncidentAssets.addAll(b.mcIncidentAssets);
        }
        mcIncidentAssets = Collections.unmodifiableSortedSet(mcIncidentAssets);
        this.mcIncidentAssets = mcIncidentAssets;
        this.mcIncidentId = b.mcIncidentId;
        this.mcIncidentPriority = b.mcIncidentPriority;
        this.mcIncidentSeverity = b.mcIncidentSeverity;
        this.mcIncidentState = b.mcIncidentState;
        SortedSet<String> mcIncidentSubTypes = new TreeSet<String>();
        if (b.mcIncidentSubTypes != null) {
            mcIncidentSubTypes.addAll(b.mcIncidentSubTypes);
        }
        mcIncidentSubTypes = Collections.unmodifiableSortedSet(mcIncidentSubTypes);
        this.mcIncidentSubTypes = mcIncidentSubTypes;
        this.mcIncidentType = b.mcIncidentType;
        this.mcIncidentWarehouse = b.mcIncidentWarehouse;
        SortedSet<String> mcLabels = new TreeSet<String>();
        if (b.mcLabels != null) {
            mcLabels.addAll(b.mcLabels);
        }
        mcLabels = Collections.unmodifiableSortedSet(mcLabels);
        this.mcLabels = mcLabels;
        this.mcMonitor = b.mcMonitor;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static MCIncidentBuilder<?, ?> _internal() {
        return new MCIncidentBuilderImpl();
    }

    @Generated
    public MCIncidentBuilder<?, ?> toBuilder() {
        return new MCIncidentBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Boolean getDqIsPartOfContract() {
        return this.dqIsPartOfContract;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<String> getMcAssetQualifiedNames() {
        return this.mcAssetQualifiedNames;
    }

    @Override
    @Generated
    public SortedSet<IAsset> getMcIncidentAssets() {
        return this.mcIncidentAssets;
    }

    @Override
    @Generated
    public String getMcIncidentId() {
        return this.mcIncidentId;
    }

    @Override
    @Generated
    public String getMcIncidentPriority() {
        return this.mcIncidentPriority;
    }

    @Override
    @Generated
    public String getMcIncidentSeverity() {
        return this.mcIncidentSeverity;
    }

    @Override
    @Generated
    public String getMcIncidentState() {
        return this.mcIncidentState;
    }

    @Override
    @Generated
    public SortedSet<String> getMcIncidentSubTypes() {
        return this.mcIncidentSubTypes;
    }

    @Override
    @Generated
    public String getMcIncidentType() {
        return this.mcIncidentType;
    }

    @Override
    @Generated
    public String getMcIncidentWarehouse() {
        return this.mcIncidentWarehouse;
    }

    @Override
    @Generated
    public SortedSet<String> getMcLabels() {
        return this.mcLabels;
    }

    @Override
    @Generated
    public IMCMonitor getMcMonitor() {
        return this.mcMonitor;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MCIncident)) {
            return false;
        }
        MCIncident other = (MCIncident)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$dqIsPartOfContract = this.getDqIsPartOfContract();
        Boolean other$dqIsPartOfContract = other.getDqIsPartOfContract();
        if (this$dqIsPartOfContract == null ? other$dqIsPartOfContract != null : !((Object)this$dqIsPartOfContract).equals(other$dqIsPartOfContract)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<String> this$mcAssetQualifiedNames = this.getMcAssetQualifiedNames();
        SortedSet<String> other$mcAssetQualifiedNames = other.getMcAssetQualifiedNames();
        if (this$mcAssetQualifiedNames == null ? other$mcAssetQualifiedNames != null : !this$mcAssetQualifiedNames.equals(other$mcAssetQualifiedNames)) {
            return false;
        }
        SortedSet<IAsset> this$mcIncidentAssets = this.getMcIncidentAssets();
        SortedSet<IAsset> other$mcIncidentAssets = other.getMcIncidentAssets();
        if (this$mcIncidentAssets == null ? other$mcIncidentAssets != null : !this$mcIncidentAssets.equals(other$mcIncidentAssets)) {
            return false;
        }
        String this$mcIncidentId = this.getMcIncidentId();
        String other$mcIncidentId = other.getMcIncidentId();
        if (this$mcIncidentId == null ? other$mcIncidentId != null : !this$mcIncidentId.equals(other$mcIncidentId)) {
            return false;
        }
        String this$mcIncidentPriority = this.getMcIncidentPriority();
        String other$mcIncidentPriority = other.getMcIncidentPriority();
        if (this$mcIncidentPriority == null ? other$mcIncidentPriority != null : !this$mcIncidentPriority.equals(other$mcIncidentPriority)) {
            return false;
        }
        String this$mcIncidentSeverity = this.getMcIncidentSeverity();
        String other$mcIncidentSeverity = other.getMcIncidentSeverity();
        if (this$mcIncidentSeverity == null ? other$mcIncidentSeverity != null : !this$mcIncidentSeverity.equals(other$mcIncidentSeverity)) {
            return false;
        }
        String this$mcIncidentState = this.getMcIncidentState();
        String other$mcIncidentState = other.getMcIncidentState();
        if (this$mcIncidentState == null ? other$mcIncidentState != null : !this$mcIncidentState.equals(other$mcIncidentState)) {
            return false;
        }
        SortedSet<String> this$mcIncidentSubTypes = this.getMcIncidentSubTypes();
        SortedSet<String> other$mcIncidentSubTypes = other.getMcIncidentSubTypes();
        if (this$mcIncidentSubTypes == null ? other$mcIncidentSubTypes != null : !this$mcIncidentSubTypes.equals(other$mcIncidentSubTypes)) {
            return false;
        }
        String this$mcIncidentType = this.getMcIncidentType();
        String other$mcIncidentType = other.getMcIncidentType();
        if (this$mcIncidentType == null ? other$mcIncidentType != null : !this$mcIncidentType.equals(other$mcIncidentType)) {
            return false;
        }
        String this$mcIncidentWarehouse = this.getMcIncidentWarehouse();
        String other$mcIncidentWarehouse = other.getMcIncidentWarehouse();
        if (this$mcIncidentWarehouse == null ? other$mcIncidentWarehouse != null : !this$mcIncidentWarehouse.equals(other$mcIncidentWarehouse)) {
            return false;
        }
        SortedSet<String> this$mcLabels = this.getMcLabels();
        SortedSet<String> other$mcLabels = other.getMcLabels();
        if (this$mcLabels == null ? other$mcLabels != null : !this$mcLabels.equals(other$mcLabels)) {
            return false;
        }
        IMCMonitor this$mcMonitor = this.getMcMonitor();
        IMCMonitor other$mcMonitor = other.getMcMonitor();
        if (this$mcMonitor == null ? other$mcMonitor != null : !this$mcMonitor.equals(other$mcMonitor)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MCIncident;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $dqIsPartOfContract = this.getDqIsPartOfContract();
        result = result * 59 + ($dqIsPartOfContract == null ? 43 : ((Object)$dqIsPartOfContract).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<String> $mcAssetQualifiedNames = this.getMcAssetQualifiedNames();
        result = result * 59 + ($mcAssetQualifiedNames == null ? 43 : $mcAssetQualifiedNames.hashCode());
        SortedSet<IAsset> $mcIncidentAssets = this.getMcIncidentAssets();
        result = result * 59 + ($mcIncidentAssets == null ? 43 : $mcIncidentAssets.hashCode());
        String $mcIncidentId = this.getMcIncidentId();
        result = result * 59 + ($mcIncidentId == null ? 43 : $mcIncidentId.hashCode());
        String $mcIncidentPriority = this.getMcIncidentPriority();
        result = result * 59 + ($mcIncidentPriority == null ? 43 : $mcIncidentPriority.hashCode());
        String $mcIncidentSeverity = this.getMcIncidentSeverity();
        result = result * 59 + ($mcIncidentSeverity == null ? 43 : $mcIncidentSeverity.hashCode());
        String $mcIncidentState = this.getMcIncidentState();
        result = result * 59 + ($mcIncidentState == null ? 43 : $mcIncidentState.hashCode());
        SortedSet<String> $mcIncidentSubTypes = this.getMcIncidentSubTypes();
        result = result * 59 + ($mcIncidentSubTypes == null ? 43 : $mcIncidentSubTypes.hashCode());
        String $mcIncidentType = this.getMcIncidentType();
        result = result * 59 + ($mcIncidentType == null ? 43 : $mcIncidentType.hashCode());
        String $mcIncidentWarehouse = this.getMcIncidentWarehouse();
        result = result * 59 + ($mcIncidentWarehouse == null ? 43 : $mcIncidentWarehouse.hashCode());
        SortedSet<String> $mcLabels = this.getMcLabels();
        result = result * 59 + ($mcLabels == null ? 43 : $mcLabels.hashCode());
        IMCMonitor $mcMonitor = this.getMcMonitor();
        result = result * 59 + ($mcMonitor == null ? 43 : $mcMonitor.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "MCIncident(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dqIsPartOfContract=" + this.getDqIsPartOfContract() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", mcAssetQualifiedNames=" + String.valueOf(this.getMcAssetQualifiedNames()) + ", mcIncidentAssets=" + String.valueOf(this.getMcIncidentAssets()) + ", mcIncidentId=" + this.getMcIncidentId() + ", mcIncidentPriority=" + this.getMcIncidentPriority() + ", mcIncidentSeverity=" + this.getMcIncidentSeverity() + ", mcIncidentState=" + this.getMcIncidentState() + ", mcIncidentSubTypes=" + String.valueOf(this.getMcIncidentSubTypes()) + ", mcIncidentType=" + this.getMcIncidentType() + ", mcIncidentWarehouse=" + this.getMcIncidentWarehouse() + ", mcLabels=" + String.valueOf(this.getMcLabels()) + ", mcMonitor=" + String.valueOf(this.getMcMonitor()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class MCIncidentBuilder<C extends MCIncident, B extends MCIncidentBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Boolean dqIsPartOfContract;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<String> mcAssetQualifiedNames;
        @Generated
        private ArrayList<IAsset> mcIncidentAssets;
        @Generated
        private String mcIncidentId;
        @Generated
        private String mcIncidentPriority;
        @Generated
        private String mcIncidentSeverity;
        @Generated
        private String mcIncidentState;
        @Generated
        private ArrayList<String> mcIncidentSubTypes;
        @Generated
        private String mcIncidentType;
        @Generated
        private String mcIncidentWarehouse;
        @Generated
        private ArrayList<String> mcLabels;
        @Generated
        private IMCMonitor mcMonitor;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MCIncidentBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MCIncident instance, MCIncidentBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dqIsPartOfContract(instance.dqIsPartOfContract);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.mcAssetQualifiedNames(instance.mcAssetQualifiedNames == null ? Collections.emptySortedSet() : instance.mcAssetQualifiedNames);
            b.mcIncidentAssets(instance.mcIncidentAssets == null ? Collections.emptySortedSet() : instance.mcIncidentAssets);
            b.mcIncidentId(instance.mcIncidentId);
            b.mcIncidentPriority(instance.mcIncidentPriority);
            b.mcIncidentSeverity(instance.mcIncidentSeverity);
            b.mcIncidentState(instance.mcIncidentState);
            b.mcIncidentSubTypes(instance.mcIncidentSubTypes == null ? Collections.emptySortedSet() : instance.mcIncidentSubTypes);
            b.mcIncidentType(instance.mcIncidentType);
            b.mcIncidentWarehouse(instance.mcIncidentWarehouse);
            b.mcLabels(instance.mcLabels == null ? Collections.emptySortedSet() : instance.mcLabels);
            b.mcMonitor(instance.mcMonitor);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dqIsPartOfContract(Boolean dqIsPartOfContract) {
            this.dqIsPartOfContract = dqIsPartOfContract;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B mcAssetQualifiedName(String mcAssetQualifiedName) {
            if (this.mcAssetQualifiedNames == null) {
                this.mcAssetQualifiedNames = new ArrayList();
            }
            this.mcAssetQualifiedNames.add(mcAssetQualifiedName);
            return (B)this.self();
        }

        @Generated
        public B mcAssetQualifiedNames(Collection<? extends String> mcAssetQualifiedNames) {
            if (mcAssetQualifiedNames == null) {
                throw new NullPointerException("mcAssetQualifiedNames cannot be null");
            }
            if (this.mcAssetQualifiedNames == null) {
                this.mcAssetQualifiedNames = new ArrayList();
            }
            this.mcAssetQualifiedNames.addAll(mcAssetQualifiedNames);
            return (B)this.self();
        }

        @Generated
        public B clearMcAssetQualifiedNames() {
            if (this.mcAssetQualifiedNames != null) {
                this.mcAssetQualifiedNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B mcIncidentAsset(IAsset mcIncidentAsset) {
            if (this.mcIncidentAssets == null) {
                this.mcIncidentAssets = new ArrayList();
            }
            this.mcIncidentAssets.add(mcIncidentAsset);
            return (B)this.self();
        }

        @Generated
        public B mcIncidentAssets(Collection<? extends IAsset> mcIncidentAssets) {
            if (mcIncidentAssets == null) {
                throw new NullPointerException("mcIncidentAssets cannot be null");
            }
            if (this.mcIncidentAssets == null) {
                this.mcIncidentAssets = new ArrayList();
            }
            this.mcIncidentAssets.addAll(mcIncidentAssets);
            return (B)this.self();
        }

        @Generated
        public B clearMcIncidentAssets() {
            if (this.mcIncidentAssets != null) {
                this.mcIncidentAssets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B mcIncidentId(String mcIncidentId) {
            this.mcIncidentId = mcIncidentId;
            return (B)this.self();
        }

        @Generated
        public B mcIncidentPriority(String mcIncidentPriority) {
            this.mcIncidentPriority = mcIncidentPriority;
            return (B)this.self();
        }

        @Generated
        public B mcIncidentSeverity(String mcIncidentSeverity) {
            this.mcIncidentSeverity = mcIncidentSeverity;
            return (B)this.self();
        }

        @Generated
        public B mcIncidentState(String mcIncidentState) {
            this.mcIncidentState = mcIncidentState;
            return (B)this.self();
        }

        @Generated
        public B mcIncidentSubType(String mcIncidentSubType) {
            if (this.mcIncidentSubTypes == null) {
                this.mcIncidentSubTypes = new ArrayList();
            }
            this.mcIncidentSubTypes.add(mcIncidentSubType);
            return (B)this.self();
        }

        @Generated
        public B mcIncidentSubTypes(Collection<? extends String> mcIncidentSubTypes) {
            if (mcIncidentSubTypes == null) {
                throw new NullPointerException("mcIncidentSubTypes cannot be null");
            }
            if (this.mcIncidentSubTypes == null) {
                this.mcIncidentSubTypes = new ArrayList();
            }
            this.mcIncidentSubTypes.addAll(mcIncidentSubTypes);
            return (B)this.self();
        }

        @Generated
        public B clearMcIncidentSubTypes() {
            if (this.mcIncidentSubTypes != null) {
                this.mcIncidentSubTypes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B mcIncidentType(String mcIncidentType) {
            this.mcIncidentType = mcIncidentType;
            return (B)this.self();
        }

        @Generated
        public B mcIncidentWarehouse(String mcIncidentWarehouse) {
            this.mcIncidentWarehouse = mcIncidentWarehouse;
            return (B)this.self();
        }

        @Generated
        public B mcLabel(String mcLabel) {
            if (this.mcLabels == null) {
                this.mcLabels = new ArrayList();
            }
            this.mcLabels.add(mcLabel);
            return (B)this.self();
        }

        @Generated
        public B mcLabels(Collection<? extends String> mcLabels) {
            if (mcLabels == null) {
                throw new NullPointerException("mcLabels cannot be null");
            }
            if (this.mcLabels == null) {
                this.mcLabels = new ArrayList();
            }
            this.mcLabels.addAll(mcLabels);
            return (B)this.self();
        }

        @Generated
        public B clearMcLabels() {
            if (this.mcLabels != null) {
                this.mcLabels.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public B mcMonitor(IMCMonitor mcMonitor) {
            this.mcMonitor = mcMonitor;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MCIncident.MCIncidentBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dqIsPartOfContract=" + this.dqIsPartOfContract + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", mcAssetQualifiedNames=" + String.valueOf(this.mcAssetQualifiedNames) + ", mcIncidentAssets=" + String.valueOf(this.mcIncidentAssets) + ", mcIncidentId=" + this.mcIncidentId + ", mcIncidentPriority=" + this.mcIncidentPriority + ", mcIncidentSeverity=" + this.mcIncidentSeverity + ", mcIncidentState=" + this.mcIncidentState + ", mcIncidentSubTypes=" + String.valueOf(this.mcIncidentSubTypes) + ", mcIncidentType=" + this.mcIncidentType + ", mcIncidentWarehouse=" + this.mcIncidentWarehouse + ", mcLabels=" + String.valueOf(this.mcLabels) + ", mcMonitor=" + String.valueOf(this.mcMonitor) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class MCIncidentBuilderImpl
    extends MCIncidentBuilder<MCIncident, MCIncidentBuilderImpl> {
        @Generated
        private MCIncidentBuilderImpl() {
        }

        @Override
        @Generated
        protected MCIncidentBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MCIncident build() {
            return new MCIncident(this);
        }
    }
}

