/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModel;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelAttributeAssociation;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.ModelEntity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelAttribute
extends Asset
implements IModelAttribute,
IModel,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelAttribute.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModelAttribute";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    String modelAttributeDataType;
    @Attribute
    SortedSet<IModelEntity> modelAttributeEntities;
    @Attribute
    Boolean modelAttributeHasRelationships;
    @Attribute
    SortedSet<ICatalog> modelAttributeImplementedByAssets;
    @Attribute
    Boolean modelAttributeIsDerived;
    @Attribute
    Boolean modelAttributeIsForeign;
    @Attribute
    Boolean modelAttributeIsNullable;
    @Attribute
    Boolean modelAttributeIsPrimary;
    @Attribute
    SortedSet<IModelAttribute> modelAttributeMappedFromAttributes;
    @Attribute
    SortedSet<IModelAttribute> modelAttributeMappedToAttributes;
    @Attribute
    Long modelAttributePrecision;
    @Attribute
    SortedSet<IModelAttributeAssociation> modelAttributeRelatedFromAttributes;
    @Attribute
    SortedSet<IModelAttributeAssociation> modelAttributeRelatedToAttributes;
    @Attribute
    Long modelAttributeScale;
    @Attribute
    @Date
    Long modelBusinessDate;
    @Attribute
    String modelDomain;
    @Attribute
    String modelEntityName;
    @Attribute
    String modelEntityQualifiedName;
    @Attribute
    @Date
    Long modelExpiredAtBusinessDate;
    @Attribute
    @Date
    Long modelExpiredAtSystemDate;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    String modelName;
    @Attribute
    String modelNamespace;
    @Attribute
    String modelQualifiedName;
    @Attribute
    @Date
    Long modelSystemDate;
    @Attribute
    String modelType;
    @Attribute
    String modelVersionAgnosticQualifiedName;
    @Attribute
    String modelVersionName;
    @Attribute
    String modelVersionQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public ModelAttribute trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ModelAttribute.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ModelAttribute.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ModelAttribute.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ModelAttribute.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static ModelAttribute refByGuid(String guid) {
        return ModelAttribute.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static ModelAttribute refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ModelAttributeBuilder)((ModelAttributeBuilder)ModelAttribute._internal().guid(guid)).semantic(semantic)).build();
    }

    public static ModelAttribute refByQualifiedName(String qualifiedName) {
        return ModelAttribute.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static ModelAttribute refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ModelAttributeBuilder)((ModelAttributeBuilder)ModelAttribute._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static ModelAttribute get(AtlanClient client, String id) throws AtlanException {
        return ModelAttribute.get(client, id, false);
    }

    @JsonIgnore
    public static ModelAttribute get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ModelAttribute) {
                return (ModelAttribute)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof ModelAttribute) {
            return (ModelAttribute)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static ModelAttribute get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return ModelAttribute.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static ModelAttribute get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)ModelAttribute.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof ModelAttribute) {
                return (ModelAttribute)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)ModelAttribute.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof ModelAttribute) {
            return (ModelAttribute)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ModelAttributeBuilder<?, ?> creator(String name, ModelEntity entity) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("connectionQualifiedName", entity.getConnectionQualifiedName());
        map.put("name", entity.getName());
        map.put("qualifiedName", entity.getModelVersionAgnosticQualifiedName());
        map.put("type", entity.getModelType());
        ModelAttribute.validateRelationship("ModelEntity", map);
        return ((ModelAttributeBuilder)ModelAttribute.creator(name, entity.getConnectionQualifiedName(), entity.getName(), entity.getModelVersionAgnosticQualifiedName(), entity.getModelType()).clearModelAttributeEntities()).modelAttributeEntity((IModelEntity)((Object)((ModelEntity.ModelEntityBuilder)entity.trimToReference().toBuilder().semantic(Reference.SaveSemantic.APPEND)).build()));
    }

    public static ModelAttributeBuilder<?, ?> creator(String name, String entityQualifiedName, String modelType) {
        String entitySlug = StringUtils.getNameFromQualifiedName(entityQualifiedName);
        String entityName = IModel.getNameFromSlug(entitySlug);
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(entityQualifiedName);
        return ModelAttribute.creator(name, connectionQualifiedName, entityName, entityQualifiedName, modelType);
    }

    public static ModelAttributeBuilder<?, ?> creator(String name, String connectionQualifiedName, String entityName, String entityQualifiedName, String modelType) {
        String modelQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(entityQualifiedName);
        String modelName = IModel.getNameFromSlug(StringUtils.getNameFromQualifiedName(modelQualifiedName));
        return (ModelAttributeBuilder)((Asset.AssetBuilder)((ModelAttributeBuilder)((ModelAttributeBuilder)((ModelAttributeBuilder)((ModelAttributeBuilder)((ModelAttributeBuilder)((ModelAttributeBuilder)((ModelAttributeBuilder)((ModelAttributeBuilder)ModelAttribute._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).modelName(modelName)).modelQualifiedName(modelQualifiedName)).modelEntityName(entityName)).modelEntityQualifiedName(entityQualifiedName)).modelAttributeEntity(ModelEntity.refByQualifiedName(entityQualifiedName, Reference.SaveSemantic.APPEND))).modelVersionAgnosticQualifiedName(ModelAttribute.generateQualifiedName(name, entityQualifiedName))).modelType(modelType)).connectionQualifiedName(connectionQualifiedName);
    }

    public static ModelAttributeBuilder<?, ?> updater(String versionAgnosticQualifiedName, String name) {
        return (ModelAttributeBuilder)((Asset.AssetBuilder)((ModelAttributeBuilder)ModelAttribute._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).modelVersionAgnosticQualifiedName(versionAgnosticQualifiedName)).name(name);
    }

    public static ModelAttributeBuilder<?, ?> updaterForVersion(String qualifiedName, String name) {
        return (ModelAttributeBuilder)((ModelAttributeBuilder)((ModelAttributeBuilder)ModelAttribute._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public static String generateQualifiedName(String name, String parentQualifiedName) {
        return parentQualifiedName + "/" + IModel.getSlugForName(name);
    }

    public ModelAttributeBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("modelVersionAgnosticQualifiedName", this.getModelVersionAgnosticQualifiedName());
        map.put("name", this.getName());
        ModelAttribute.validateRequired(TYPE_NAME, map);
        return ModelAttribute.updater(this.getModelVersionAgnosticQualifiedName(), this.getName());
    }

    public static ModelAttribute removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelAttribute)Asset.removeDescription(client, ModelAttribute.updater(qualifiedName, name));
    }

    public static ModelAttribute removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelAttribute)Asset.removeUserDescription(client, ModelAttribute.updater(qualifiedName, name));
    }

    public static ModelAttribute removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelAttribute)Asset.removeOwners(client, ModelAttribute.updater(qualifiedName, name));
    }

    public static ModelAttribute updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ModelAttribute)Asset.updateCertificate(client, ModelAttribute._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ModelAttribute removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelAttribute)Asset.removeCertificate(client, ModelAttribute.updater(qualifiedName, name));
    }

    public static ModelAttribute updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModelAttribute)Asset.updateAnnouncement(client, ModelAttribute._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ModelAttribute removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelAttribute)Asset.removeAnnouncement(client, ModelAttribute.updater(qualifiedName, name));
    }

    public static ModelAttribute replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModelAttribute)Asset.replaceTerms(client, ModelAttribute.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static ModelAttribute appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModelAttribute)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static ModelAttribute removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModelAttribute)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static ModelAttribute appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ModelAttribute)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static ModelAttribute appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ModelAttribute)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ModelAttribute(ModelAttributeBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ModelAttribute.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.modelAttributeDataType = b.modelAttributeDataType;
        SortedSet<IModelEntity> modelAttributeEntities = new TreeSet<IModelEntity>();
        if (b.modelAttributeEntities != null) {
            modelAttributeEntities.addAll(b.modelAttributeEntities);
        }
        modelAttributeEntities = Collections.unmodifiableSortedSet(modelAttributeEntities);
        this.modelAttributeEntities = modelAttributeEntities;
        this.modelAttributeHasRelationships = b.modelAttributeHasRelationships;
        SortedSet<ICatalog> modelAttributeImplementedByAssets = new TreeSet<ICatalog>();
        if (b.modelAttributeImplementedByAssets != null) {
            modelAttributeImplementedByAssets.addAll(b.modelAttributeImplementedByAssets);
        }
        modelAttributeImplementedByAssets = Collections.unmodifiableSortedSet(modelAttributeImplementedByAssets);
        this.modelAttributeImplementedByAssets = modelAttributeImplementedByAssets;
        this.modelAttributeIsDerived = b.modelAttributeIsDerived;
        this.modelAttributeIsForeign = b.modelAttributeIsForeign;
        this.modelAttributeIsNullable = b.modelAttributeIsNullable;
        this.modelAttributeIsPrimary = b.modelAttributeIsPrimary;
        SortedSet<IModelAttribute> modelAttributeMappedFromAttributes = new TreeSet<IModelAttribute>();
        if (b.modelAttributeMappedFromAttributes != null) {
            modelAttributeMappedFromAttributes.addAll(b.modelAttributeMappedFromAttributes);
        }
        modelAttributeMappedFromAttributes = Collections.unmodifiableSortedSet(modelAttributeMappedFromAttributes);
        this.modelAttributeMappedFromAttributes = modelAttributeMappedFromAttributes;
        SortedSet<IModelAttribute> modelAttributeMappedToAttributes = new TreeSet<IModelAttribute>();
        if (b.modelAttributeMappedToAttributes != null) {
            modelAttributeMappedToAttributes.addAll(b.modelAttributeMappedToAttributes);
        }
        modelAttributeMappedToAttributes = Collections.unmodifiableSortedSet(modelAttributeMappedToAttributes);
        this.modelAttributeMappedToAttributes = modelAttributeMappedToAttributes;
        this.modelAttributePrecision = b.modelAttributePrecision;
        SortedSet<IModelAttributeAssociation> modelAttributeRelatedFromAttributes = new TreeSet<IModelAttributeAssociation>();
        if (b.modelAttributeRelatedFromAttributes != null) {
            modelAttributeRelatedFromAttributes.addAll(b.modelAttributeRelatedFromAttributes);
        }
        modelAttributeRelatedFromAttributes = Collections.unmodifiableSortedSet(modelAttributeRelatedFromAttributes);
        this.modelAttributeRelatedFromAttributes = modelAttributeRelatedFromAttributes;
        SortedSet<IModelAttributeAssociation> modelAttributeRelatedToAttributes = new TreeSet<IModelAttributeAssociation>();
        if (b.modelAttributeRelatedToAttributes != null) {
            modelAttributeRelatedToAttributes.addAll(b.modelAttributeRelatedToAttributes);
        }
        modelAttributeRelatedToAttributes = Collections.unmodifiableSortedSet(modelAttributeRelatedToAttributes);
        this.modelAttributeRelatedToAttributes = modelAttributeRelatedToAttributes;
        this.modelAttributeScale = b.modelAttributeScale;
        this.modelBusinessDate = b.modelBusinessDate;
        this.modelDomain = b.modelDomain;
        this.modelEntityName = b.modelEntityName;
        this.modelEntityQualifiedName = b.modelEntityQualifiedName;
        this.modelExpiredAtBusinessDate = b.modelExpiredAtBusinessDate;
        this.modelExpiredAtSystemDate = b.modelExpiredAtSystemDate;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        this.modelName = b.modelName;
        this.modelNamespace = b.modelNamespace;
        this.modelQualifiedName = b.modelQualifiedName;
        this.modelSystemDate = b.modelSystemDate;
        this.modelType = b.modelType;
        this.modelVersionAgnosticQualifiedName = b.modelVersionAgnosticQualifiedName;
        this.modelVersionName = b.modelVersionName;
        this.modelVersionQualifiedName = b.modelVersionQualifiedName;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static ModelAttributeBuilder<?, ?> _internal() {
        return new ModelAttributeBuilderImpl();
    }

    @Generated
    public ModelAttributeBuilder<?, ?> toBuilder() {
        return new ModelAttributeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public String getModelAttributeDataType() {
        return this.modelAttributeDataType;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelAttributeEntities() {
        return this.modelAttributeEntities;
    }

    @Override
    @Generated
    public Boolean getModelAttributeHasRelationships() {
        return this.modelAttributeHasRelationships;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getModelAttributeImplementedByAssets() {
        return this.modelAttributeImplementedByAssets;
    }

    @Override
    @Generated
    public Boolean getModelAttributeIsDerived() {
        return this.modelAttributeIsDerived;
    }

    @Override
    @Generated
    public Boolean getModelAttributeIsForeign() {
        return this.modelAttributeIsForeign;
    }

    @Override
    @Generated
    public Boolean getModelAttributeIsNullable() {
        return this.modelAttributeIsNullable;
    }

    @Override
    @Generated
    public Boolean getModelAttributeIsPrimary() {
        return this.modelAttributeIsPrimary;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelAttributeMappedFromAttributes() {
        return this.modelAttributeMappedFromAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelAttributeMappedToAttributes() {
        return this.modelAttributeMappedToAttributes;
    }

    @Override
    @Generated
    public Long getModelAttributePrecision() {
        return this.modelAttributePrecision;
    }

    @Override
    @Generated
    public SortedSet<IModelAttributeAssociation> getModelAttributeRelatedFromAttributes() {
        return this.modelAttributeRelatedFromAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelAttributeAssociation> getModelAttributeRelatedToAttributes() {
        return this.modelAttributeRelatedToAttributes;
    }

    @Override
    @Generated
    public Long getModelAttributeScale() {
        return this.modelAttributeScale;
    }

    @Override
    @Generated
    public Long getModelBusinessDate() {
        return this.modelBusinessDate;
    }

    @Override
    @Generated
    public String getModelDomain() {
        return this.modelDomain;
    }

    @Override
    @Generated
    public String getModelEntityName() {
        return this.modelEntityName;
    }

    @Override
    @Generated
    public String getModelEntityQualifiedName() {
        return this.modelEntityQualifiedName;
    }

    @Override
    @Generated
    public Long getModelExpiredAtBusinessDate() {
        return this.modelExpiredAtBusinessDate;
    }

    @Override
    @Generated
    public Long getModelExpiredAtSystemDate() {
        return this.modelExpiredAtSystemDate;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Override
    @Generated
    public String getModelNamespace() {
        return this.modelNamespace;
    }

    @Override
    @Generated
    public String getModelQualifiedName() {
        return this.modelQualifiedName;
    }

    @Override
    @Generated
    public Long getModelSystemDate() {
        return this.modelSystemDate;
    }

    @Override
    @Generated
    public String getModelType() {
        return this.modelType;
    }

    @Override
    @Generated
    public String getModelVersionAgnosticQualifiedName() {
        return this.modelVersionAgnosticQualifiedName;
    }

    @Override
    @Generated
    public String getModelVersionName() {
        return this.modelVersionName;
    }

    @Override
    @Generated
    public String getModelVersionQualifiedName() {
        return this.modelVersionQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelAttribute)) {
            return false;
        }
        ModelAttribute other = (ModelAttribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$modelAttributeHasRelationships = this.getModelAttributeHasRelationships();
        Boolean other$modelAttributeHasRelationships = other.getModelAttributeHasRelationships();
        if (this$modelAttributeHasRelationships == null ? other$modelAttributeHasRelationships != null : !((Object)this$modelAttributeHasRelationships).equals(other$modelAttributeHasRelationships)) {
            return false;
        }
        Boolean this$modelAttributeIsDerived = this.getModelAttributeIsDerived();
        Boolean other$modelAttributeIsDerived = other.getModelAttributeIsDerived();
        if (this$modelAttributeIsDerived == null ? other$modelAttributeIsDerived != null : !((Object)this$modelAttributeIsDerived).equals(other$modelAttributeIsDerived)) {
            return false;
        }
        Boolean this$modelAttributeIsForeign = this.getModelAttributeIsForeign();
        Boolean other$modelAttributeIsForeign = other.getModelAttributeIsForeign();
        if (this$modelAttributeIsForeign == null ? other$modelAttributeIsForeign != null : !((Object)this$modelAttributeIsForeign).equals(other$modelAttributeIsForeign)) {
            return false;
        }
        Boolean this$modelAttributeIsNullable = this.getModelAttributeIsNullable();
        Boolean other$modelAttributeIsNullable = other.getModelAttributeIsNullable();
        if (this$modelAttributeIsNullable == null ? other$modelAttributeIsNullable != null : !((Object)this$modelAttributeIsNullable).equals(other$modelAttributeIsNullable)) {
            return false;
        }
        Boolean this$modelAttributeIsPrimary = this.getModelAttributeIsPrimary();
        Boolean other$modelAttributeIsPrimary = other.getModelAttributeIsPrimary();
        if (this$modelAttributeIsPrimary == null ? other$modelAttributeIsPrimary != null : !((Object)this$modelAttributeIsPrimary).equals(other$modelAttributeIsPrimary)) {
            return false;
        }
        Long this$modelAttributePrecision = this.getModelAttributePrecision();
        Long other$modelAttributePrecision = other.getModelAttributePrecision();
        if (this$modelAttributePrecision == null ? other$modelAttributePrecision != null : !((Object)this$modelAttributePrecision).equals(other$modelAttributePrecision)) {
            return false;
        }
        Long this$modelAttributeScale = this.getModelAttributeScale();
        Long other$modelAttributeScale = other.getModelAttributeScale();
        if (this$modelAttributeScale == null ? other$modelAttributeScale != null : !((Object)this$modelAttributeScale).equals(other$modelAttributeScale)) {
            return false;
        }
        Long this$modelBusinessDate = this.getModelBusinessDate();
        Long other$modelBusinessDate = other.getModelBusinessDate();
        if (this$modelBusinessDate == null ? other$modelBusinessDate != null : !((Object)this$modelBusinessDate).equals(other$modelBusinessDate)) {
            return false;
        }
        Long this$modelExpiredAtBusinessDate = this.getModelExpiredAtBusinessDate();
        Long other$modelExpiredAtBusinessDate = other.getModelExpiredAtBusinessDate();
        if (this$modelExpiredAtBusinessDate == null ? other$modelExpiredAtBusinessDate != null : !((Object)this$modelExpiredAtBusinessDate).equals(other$modelExpiredAtBusinessDate)) {
            return false;
        }
        Long this$modelExpiredAtSystemDate = this.getModelExpiredAtSystemDate();
        Long other$modelExpiredAtSystemDate = other.getModelExpiredAtSystemDate();
        if (this$modelExpiredAtSystemDate == null ? other$modelExpiredAtSystemDate != null : !((Object)this$modelExpiredAtSystemDate).equals(other$modelExpiredAtSystemDate)) {
            return false;
        }
        Long this$modelSystemDate = this.getModelSystemDate();
        Long other$modelSystemDate = other.getModelSystemDate();
        if (this$modelSystemDate == null ? other$modelSystemDate != null : !((Object)this$modelSystemDate).equals(other$modelSystemDate)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        String this$modelAttributeDataType = this.getModelAttributeDataType();
        String other$modelAttributeDataType = other.getModelAttributeDataType();
        if (this$modelAttributeDataType == null ? other$modelAttributeDataType != null : !this$modelAttributeDataType.equals(other$modelAttributeDataType)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelAttributeEntities = this.getModelAttributeEntities();
        SortedSet<IModelEntity> other$modelAttributeEntities = other.getModelAttributeEntities();
        if (this$modelAttributeEntities == null ? other$modelAttributeEntities != null : !this$modelAttributeEntities.equals(other$modelAttributeEntities)) {
            return false;
        }
        SortedSet<ICatalog> this$modelAttributeImplementedByAssets = this.getModelAttributeImplementedByAssets();
        SortedSet<ICatalog> other$modelAttributeImplementedByAssets = other.getModelAttributeImplementedByAssets();
        if (this$modelAttributeImplementedByAssets == null ? other$modelAttributeImplementedByAssets != null : !this$modelAttributeImplementedByAssets.equals(other$modelAttributeImplementedByAssets)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelAttributeMappedFromAttributes = this.getModelAttributeMappedFromAttributes();
        SortedSet<IModelAttribute> other$modelAttributeMappedFromAttributes = other.getModelAttributeMappedFromAttributes();
        if (this$modelAttributeMappedFromAttributes == null ? other$modelAttributeMappedFromAttributes != null : !this$modelAttributeMappedFromAttributes.equals(other$modelAttributeMappedFromAttributes)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelAttributeMappedToAttributes = this.getModelAttributeMappedToAttributes();
        SortedSet<IModelAttribute> other$modelAttributeMappedToAttributes = other.getModelAttributeMappedToAttributes();
        if (this$modelAttributeMappedToAttributes == null ? other$modelAttributeMappedToAttributes != null : !this$modelAttributeMappedToAttributes.equals(other$modelAttributeMappedToAttributes)) {
            return false;
        }
        SortedSet<IModelAttributeAssociation> this$modelAttributeRelatedFromAttributes = this.getModelAttributeRelatedFromAttributes();
        SortedSet<IModelAttributeAssociation> other$modelAttributeRelatedFromAttributes = other.getModelAttributeRelatedFromAttributes();
        if (this$modelAttributeRelatedFromAttributes == null ? other$modelAttributeRelatedFromAttributes != null : !this$modelAttributeRelatedFromAttributes.equals(other$modelAttributeRelatedFromAttributes)) {
            return false;
        }
        SortedSet<IModelAttributeAssociation> this$modelAttributeRelatedToAttributes = this.getModelAttributeRelatedToAttributes();
        SortedSet<IModelAttributeAssociation> other$modelAttributeRelatedToAttributes = other.getModelAttributeRelatedToAttributes();
        if (this$modelAttributeRelatedToAttributes == null ? other$modelAttributeRelatedToAttributes != null : !this$modelAttributeRelatedToAttributes.equals(other$modelAttributeRelatedToAttributes)) {
            return false;
        }
        String this$modelDomain = this.getModelDomain();
        String other$modelDomain = other.getModelDomain();
        if (this$modelDomain == null ? other$modelDomain != null : !this$modelDomain.equals(other$modelDomain)) {
            return false;
        }
        String this$modelEntityName = this.getModelEntityName();
        String other$modelEntityName = other.getModelEntityName();
        if (this$modelEntityName == null ? other$modelEntityName != null : !this$modelEntityName.equals(other$modelEntityName)) {
            return false;
        }
        String this$modelEntityQualifiedName = this.getModelEntityQualifiedName();
        String other$modelEntityQualifiedName = other.getModelEntityQualifiedName();
        if (this$modelEntityQualifiedName == null ? other$modelEntityQualifiedName != null : !this$modelEntityQualifiedName.equals(other$modelEntityQualifiedName)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        String this$modelNamespace = this.getModelNamespace();
        String other$modelNamespace = other.getModelNamespace();
        if (this$modelNamespace == null ? other$modelNamespace != null : !this$modelNamespace.equals(other$modelNamespace)) {
            return false;
        }
        String this$modelQualifiedName = this.getModelQualifiedName();
        String other$modelQualifiedName = other.getModelQualifiedName();
        if (this$modelQualifiedName == null ? other$modelQualifiedName != null : !this$modelQualifiedName.equals(other$modelQualifiedName)) {
            return false;
        }
        String this$modelType = this.getModelType();
        String other$modelType = other.getModelType();
        if (this$modelType == null ? other$modelType != null : !this$modelType.equals(other$modelType)) {
            return false;
        }
        String this$modelVersionAgnosticQualifiedName = this.getModelVersionAgnosticQualifiedName();
        String other$modelVersionAgnosticQualifiedName = other.getModelVersionAgnosticQualifiedName();
        if (this$modelVersionAgnosticQualifiedName == null ? other$modelVersionAgnosticQualifiedName != null : !this$modelVersionAgnosticQualifiedName.equals(other$modelVersionAgnosticQualifiedName)) {
            return false;
        }
        String this$modelVersionName = this.getModelVersionName();
        String other$modelVersionName = other.getModelVersionName();
        if (this$modelVersionName == null ? other$modelVersionName != null : !this$modelVersionName.equals(other$modelVersionName)) {
            return false;
        }
        String this$modelVersionQualifiedName = this.getModelVersionQualifiedName();
        String other$modelVersionQualifiedName = other.getModelVersionQualifiedName();
        if (this$modelVersionQualifiedName == null ? other$modelVersionQualifiedName != null : !this$modelVersionQualifiedName.equals(other$modelVersionQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModelAttribute;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $modelAttributeHasRelationships = this.getModelAttributeHasRelationships();
        result = result * 59 + ($modelAttributeHasRelationships == null ? 43 : ((Object)$modelAttributeHasRelationships).hashCode());
        Boolean $modelAttributeIsDerived = this.getModelAttributeIsDerived();
        result = result * 59 + ($modelAttributeIsDerived == null ? 43 : ((Object)$modelAttributeIsDerived).hashCode());
        Boolean $modelAttributeIsForeign = this.getModelAttributeIsForeign();
        result = result * 59 + ($modelAttributeIsForeign == null ? 43 : ((Object)$modelAttributeIsForeign).hashCode());
        Boolean $modelAttributeIsNullable = this.getModelAttributeIsNullable();
        result = result * 59 + ($modelAttributeIsNullable == null ? 43 : ((Object)$modelAttributeIsNullable).hashCode());
        Boolean $modelAttributeIsPrimary = this.getModelAttributeIsPrimary();
        result = result * 59 + ($modelAttributeIsPrimary == null ? 43 : ((Object)$modelAttributeIsPrimary).hashCode());
        Long $modelAttributePrecision = this.getModelAttributePrecision();
        result = result * 59 + ($modelAttributePrecision == null ? 43 : ((Object)$modelAttributePrecision).hashCode());
        Long $modelAttributeScale = this.getModelAttributeScale();
        result = result * 59 + ($modelAttributeScale == null ? 43 : ((Object)$modelAttributeScale).hashCode());
        Long $modelBusinessDate = this.getModelBusinessDate();
        result = result * 59 + ($modelBusinessDate == null ? 43 : ((Object)$modelBusinessDate).hashCode());
        Long $modelExpiredAtBusinessDate = this.getModelExpiredAtBusinessDate();
        result = result * 59 + ($modelExpiredAtBusinessDate == null ? 43 : ((Object)$modelExpiredAtBusinessDate).hashCode());
        Long $modelExpiredAtSystemDate = this.getModelExpiredAtSystemDate();
        result = result * 59 + ($modelExpiredAtSystemDate == null ? 43 : ((Object)$modelExpiredAtSystemDate).hashCode());
        Long $modelSystemDate = this.getModelSystemDate();
        result = result * 59 + ($modelSystemDate == null ? 43 : ((Object)$modelSystemDate).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        String $modelAttributeDataType = this.getModelAttributeDataType();
        result = result * 59 + ($modelAttributeDataType == null ? 43 : $modelAttributeDataType.hashCode());
        SortedSet<IModelEntity> $modelAttributeEntities = this.getModelAttributeEntities();
        result = result * 59 + ($modelAttributeEntities == null ? 43 : $modelAttributeEntities.hashCode());
        SortedSet<ICatalog> $modelAttributeImplementedByAssets = this.getModelAttributeImplementedByAssets();
        result = result * 59 + ($modelAttributeImplementedByAssets == null ? 43 : $modelAttributeImplementedByAssets.hashCode());
        SortedSet<IModelAttribute> $modelAttributeMappedFromAttributes = this.getModelAttributeMappedFromAttributes();
        result = result * 59 + ($modelAttributeMappedFromAttributes == null ? 43 : $modelAttributeMappedFromAttributes.hashCode());
        SortedSet<IModelAttribute> $modelAttributeMappedToAttributes = this.getModelAttributeMappedToAttributes();
        result = result * 59 + ($modelAttributeMappedToAttributes == null ? 43 : $modelAttributeMappedToAttributes.hashCode());
        SortedSet<IModelAttributeAssociation> $modelAttributeRelatedFromAttributes = this.getModelAttributeRelatedFromAttributes();
        result = result * 59 + ($modelAttributeRelatedFromAttributes == null ? 43 : $modelAttributeRelatedFromAttributes.hashCode());
        SortedSet<IModelAttributeAssociation> $modelAttributeRelatedToAttributes = this.getModelAttributeRelatedToAttributes();
        result = result * 59 + ($modelAttributeRelatedToAttributes == null ? 43 : $modelAttributeRelatedToAttributes.hashCode());
        String $modelDomain = this.getModelDomain();
        result = result * 59 + ($modelDomain == null ? 43 : $modelDomain.hashCode());
        String $modelEntityName = this.getModelEntityName();
        result = result * 59 + ($modelEntityName == null ? 43 : $modelEntityName.hashCode());
        String $modelEntityQualifiedName = this.getModelEntityQualifiedName();
        result = result * 59 + ($modelEntityQualifiedName == null ? 43 : $modelEntityQualifiedName.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        String $modelNamespace = this.getModelNamespace();
        result = result * 59 + ($modelNamespace == null ? 43 : $modelNamespace.hashCode());
        String $modelQualifiedName = this.getModelQualifiedName();
        result = result * 59 + ($modelQualifiedName == null ? 43 : $modelQualifiedName.hashCode());
        String $modelType = this.getModelType();
        result = result * 59 + ($modelType == null ? 43 : $modelType.hashCode());
        String $modelVersionAgnosticQualifiedName = this.getModelVersionAgnosticQualifiedName();
        result = result * 59 + ($modelVersionAgnosticQualifiedName == null ? 43 : $modelVersionAgnosticQualifiedName.hashCode());
        String $modelVersionName = this.getModelVersionName();
        result = result * 59 + ($modelVersionName == null ? 43 : $modelVersionName.hashCode());
        String $modelVersionQualifiedName = this.getModelVersionQualifiedName();
        result = result * 59 + ($modelVersionQualifiedName == null ? 43 : $modelVersionQualifiedName.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ModelAttribute(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelAttributeDataType=" + this.getModelAttributeDataType() + ", modelAttributeEntities=" + String.valueOf(this.getModelAttributeEntities()) + ", modelAttributeHasRelationships=" + this.getModelAttributeHasRelationships() + ", modelAttributeImplementedByAssets=" + String.valueOf(this.getModelAttributeImplementedByAssets()) + ", modelAttributeIsDerived=" + this.getModelAttributeIsDerived() + ", modelAttributeIsForeign=" + this.getModelAttributeIsForeign() + ", modelAttributeIsNullable=" + this.getModelAttributeIsNullable() + ", modelAttributeIsPrimary=" + this.getModelAttributeIsPrimary() + ", modelAttributeMappedFromAttributes=" + String.valueOf(this.getModelAttributeMappedFromAttributes()) + ", modelAttributeMappedToAttributes=" + String.valueOf(this.getModelAttributeMappedToAttributes()) + ", modelAttributePrecision=" + this.getModelAttributePrecision() + ", modelAttributeRelatedFromAttributes=" + String.valueOf(this.getModelAttributeRelatedFromAttributes()) + ", modelAttributeRelatedToAttributes=" + String.valueOf(this.getModelAttributeRelatedToAttributes()) + ", modelAttributeScale=" + this.getModelAttributeScale() + ", modelBusinessDate=" + this.getModelBusinessDate() + ", modelDomain=" + this.getModelDomain() + ", modelEntityName=" + this.getModelEntityName() + ", modelEntityQualifiedName=" + this.getModelEntityQualifiedName() + ", modelExpiredAtBusinessDate=" + this.getModelExpiredAtBusinessDate() + ", modelExpiredAtSystemDate=" + this.getModelExpiredAtSystemDate() + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", modelName=" + this.getModelName() + ", modelNamespace=" + this.getModelNamespace() + ", modelQualifiedName=" + this.getModelQualifiedName() + ", modelSystemDate=" + this.getModelSystemDate() + ", modelType=" + this.getModelType() + ", modelVersionAgnosticQualifiedName=" + this.getModelVersionAgnosticQualifiedName() + ", modelVersionName=" + this.getModelVersionName() + ", modelVersionQualifiedName=" + this.getModelVersionQualifiedName() + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class ModelAttributeBuilder<C extends ModelAttribute, B extends ModelAttributeBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private String modelAttributeDataType;
        @Generated
        private ArrayList<IModelEntity> modelAttributeEntities;
        @Generated
        private Boolean modelAttributeHasRelationships;
        @Generated
        private ArrayList<ICatalog> modelAttributeImplementedByAssets;
        @Generated
        private Boolean modelAttributeIsDerived;
        @Generated
        private Boolean modelAttributeIsForeign;
        @Generated
        private Boolean modelAttributeIsNullable;
        @Generated
        private Boolean modelAttributeIsPrimary;
        @Generated
        private ArrayList<IModelAttribute> modelAttributeMappedFromAttributes;
        @Generated
        private ArrayList<IModelAttribute> modelAttributeMappedToAttributes;
        @Generated
        private Long modelAttributePrecision;
        @Generated
        private ArrayList<IModelAttributeAssociation> modelAttributeRelatedFromAttributes;
        @Generated
        private ArrayList<IModelAttributeAssociation> modelAttributeRelatedToAttributes;
        @Generated
        private Long modelAttributeScale;
        @Generated
        private Long modelBusinessDate;
        @Generated
        private String modelDomain;
        @Generated
        private String modelEntityName;
        @Generated
        private String modelEntityQualifiedName;
        @Generated
        private Long modelExpiredAtBusinessDate;
        @Generated
        private Long modelExpiredAtSystemDate;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private String modelName;
        @Generated
        private String modelNamespace;
        @Generated
        private String modelQualifiedName;
        @Generated
        private Long modelSystemDate;
        @Generated
        private String modelType;
        @Generated
        private String modelVersionAgnosticQualifiedName;
        @Generated
        private String modelVersionName;
        @Generated
        private String modelVersionQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModelAttributeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ModelAttribute instance, ModelAttributeBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelAttributeDataType(instance.modelAttributeDataType);
            b.modelAttributeEntities(instance.modelAttributeEntities == null ? Collections.emptySortedSet() : instance.modelAttributeEntities);
            b.modelAttributeHasRelationships(instance.modelAttributeHasRelationships);
            b.modelAttributeImplementedByAssets(instance.modelAttributeImplementedByAssets == null ? Collections.emptySortedSet() : instance.modelAttributeImplementedByAssets);
            b.modelAttributeIsDerived(instance.modelAttributeIsDerived);
            b.modelAttributeIsForeign(instance.modelAttributeIsForeign);
            b.modelAttributeIsNullable(instance.modelAttributeIsNullable);
            b.modelAttributeIsPrimary(instance.modelAttributeIsPrimary);
            b.modelAttributeMappedFromAttributes(instance.modelAttributeMappedFromAttributes == null ? Collections.emptySortedSet() : instance.modelAttributeMappedFromAttributes);
            b.modelAttributeMappedToAttributes(instance.modelAttributeMappedToAttributes == null ? Collections.emptySortedSet() : instance.modelAttributeMappedToAttributes);
            b.modelAttributePrecision(instance.modelAttributePrecision);
            b.modelAttributeRelatedFromAttributes(instance.modelAttributeRelatedFromAttributes == null ? Collections.emptySortedSet() : instance.modelAttributeRelatedFromAttributes);
            b.modelAttributeRelatedToAttributes(instance.modelAttributeRelatedToAttributes == null ? Collections.emptySortedSet() : instance.modelAttributeRelatedToAttributes);
            b.modelAttributeScale(instance.modelAttributeScale);
            b.modelBusinessDate(instance.modelBusinessDate);
            b.modelDomain(instance.modelDomain);
            b.modelEntityName(instance.modelEntityName);
            b.modelEntityQualifiedName(instance.modelEntityQualifiedName);
            b.modelExpiredAtBusinessDate(instance.modelExpiredAtBusinessDate);
            b.modelExpiredAtSystemDate(instance.modelExpiredAtSystemDate);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.modelName(instance.modelName);
            b.modelNamespace(instance.modelNamespace);
            b.modelQualifiedName(instance.modelQualifiedName);
            b.modelSystemDate(instance.modelSystemDate);
            b.modelType(instance.modelType);
            b.modelVersionAgnosticQualifiedName(instance.modelVersionAgnosticQualifiedName);
            b.modelVersionName(instance.modelVersionName);
            b.modelVersionQualifiedName(instance.modelVersionQualifiedName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelAttributeDataType(String modelAttributeDataType) {
            this.modelAttributeDataType = modelAttributeDataType;
            return (B)this.self();
        }

        @Generated
        public B modelAttributeEntity(IModelEntity modelAttributeEntity) {
            if (this.modelAttributeEntities == null) {
                this.modelAttributeEntities = new ArrayList();
            }
            this.modelAttributeEntities.add(modelAttributeEntity);
            return (B)this.self();
        }

        @Generated
        public B modelAttributeEntities(Collection<? extends IModelEntity> modelAttributeEntities) {
            if (modelAttributeEntities == null) {
                throw new NullPointerException("modelAttributeEntities cannot be null");
            }
            if (this.modelAttributeEntities == null) {
                this.modelAttributeEntities = new ArrayList();
            }
            this.modelAttributeEntities.addAll(modelAttributeEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelAttributeEntities() {
            if (this.modelAttributeEntities != null) {
                this.modelAttributeEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelAttributeHasRelationships(Boolean modelAttributeHasRelationships) {
            this.modelAttributeHasRelationships = modelAttributeHasRelationships;
            return (B)this.self();
        }

        @Generated
        public B modelAttributeImplementedByAsset(ICatalog modelAttributeImplementedByAsset) {
            if (this.modelAttributeImplementedByAssets == null) {
                this.modelAttributeImplementedByAssets = new ArrayList();
            }
            this.modelAttributeImplementedByAssets.add(modelAttributeImplementedByAsset);
            return (B)this.self();
        }

        @Generated
        public B modelAttributeImplementedByAssets(Collection<? extends ICatalog> modelAttributeImplementedByAssets) {
            if (modelAttributeImplementedByAssets == null) {
                throw new NullPointerException("modelAttributeImplementedByAssets cannot be null");
            }
            if (this.modelAttributeImplementedByAssets == null) {
                this.modelAttributeImplementedByAssets = new ArrayList();
            }
            this.modelAttributeImplementedByAssets.addAll(modelAttributeImplementedByAssets);
            return (B)this.self();
        }

        @Generated
        public B clearModelAttributeImplementedByAssets() {
            if (this.modelAttributeImplementedByAssets != null) {
                this.modelAttributeImplementedByAssets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelAttributeIsDerived(Boolean modelAttributeIsDerived) {
            this.modelAttributeIsDerived = modelAttributeIsDerived;
            return (B)this.self();
        }

        @Generated
        public B modelAttributeIsForeign(Boolean modelAttributeIsForeign) {
            this.modelAttributeIsForeign = modelAttributeIsForeign;
            return (B)this.self();
        }

        @Generated
        public B modelAttributeIsNullable(Boolean modelAttributeIsNullable) {
            this.modelAttributeIsNullable = modelAttributeIsNullable;
            return (B)this.self();
        }

        @Generated
        public B modelAttributeIsPrimary(Boolean modelAttributeIsPrimary) {
            this.modelAttributeIsPrimary = modelAttributeIsPrimary;
            return (B)this.self();
        }

        @Generated
        public B modelAttributeMappedFromAttribute(IModelAttribute modelAttributeMappedFromAttribute) {
            if (this.modelAttributeMappedFromAttributes == null) {
                this.modelAttributeMappedFromAttributes = new ArrayList();
            }
            this.modelAttributeMappedFromAttributes.add(modelAttributeMappedFromAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelAttributeMappedFromAttributes(Collection<? extends IModelAttribute> modelAttributeMappedFromAttributes) {
            if (modelAttributeMappedFromAttributes == null) {
                throw new NullPointerException("modelAttributeMappedFromAttributes cannot be null");
            }
            if (this.modelAttributeMappedFromAttributes == null) {
                this.modelAttributeMappedFromAttributes = new ArrayList();
            }
            this.modelAttributeMappedFromAttributes.addAll(modelAttributeMappedFromAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelAttributeMappedFromAttributes() {
            if (this.modelAttributeMappedFromAttributes != null) {
                this.modelAttributeMappedFromAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelAttributeMappedToAttribute(IModelAttribute modelAttributeMappedToAttribute) {
            if (this.modelAttributeMappedToAttributes == null) {
                this.modelAttributeMappedToAttributes = new ArrayList();
            }
            this.modelAttributeMappedToAttributes.add(modelAttributeMappedToAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelAttributeMappedToAttributes(Collection<? extends IModelAttribute> modelAttributeMappedToAttributes) {
            if (modelAttributeMappedToAttributes == null) {
                throw new NullPointerException("modelAttributeMappedToAttributes cannot be null");
            }
            if (this.modelAttributeMappedToAttributes == null) {
                this.modelAttributeMappedToAttributes = new ArrayList();
            }
            this.modelAttributeMappedToAttributes.addAll(modelAttributeMappedToAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelAttributeMappedToAttributes() {
            if (this.modelAttributeMappedToAttributes != null) {
                this.modelAttributeMappedToAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelAttributePrecision(Long modelAttributePrecision) {
            this.modelAttributePrecision = modelAttributePrecision;
            return (B)this.self();
        }

        @Generated
        public B modelAttributeRelatedFromAttribute(IModelAttributeAssociation modelAttributeRelatedFromAttribute) {
            if (this.modelAttributeRelatedFromAttributes == null) {
                this.modelAttributeRelatedFromAttributes = new ArrayList();
            }
            this.modelAttributeRelatedFromAttributes.add(modelAttributeRelatedFromAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelAttributeRelatedFromAttributes(Collection<? extends IModelAttributeAssociation> modelAttributeRelatedFromAttributes) {
            if (modelAttributeRelatedFromAttributes == null) {
                throw new NullPointerException("modelAttributeRelatedFromAttributes cannot be null");
            }
            if (this.modelAttributeRelatedFromAttributes == null) {
                this.modelAttributeRelatedFromAttributes = new ArrayList();
            }
            this.modelAttributeRelatedFromAttributes.addAll(modelAttributeRelatedFromAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelAttributeRelatedFromAttributes() {
            if (this.modelAttributeRelatedFromAttributes != null) {
                this.modelAttributeRelatedFromAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelAttributeRelatedToAttribute(IModelAttributeAssociation modelAttributeRelatedToAttribute) {
            if (this.modelAttributeRelatedToAttributes == null) {
                this.modelAttributeRelatedToAttributes = new ArrayList();
            }
            this.modelAttributeRelatedToAttributes.add(modelAttributeRelatedToAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelAttributeRelatedToAttributes(Collection<? extends IModelAttributeAssociation> modelAttributeRelatedToAttributes) {
            if (modelAttributeRelatedToAttributes == null) {
                throw new NullPointerException("modelAttributeRelatedToAttributes cannot be null");
            }
            if (this.modelAttributeRelatedToAttributes == null) {
                this.modelAttributeRelatedToAttributes = new ArrayList();
            }
            this.modelAttributeRelatedToAttributes.addAll(modelAttributeRelatedToAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelAttributeRelatedToAttributes() {
            if (this.modelAttributeRelatedToAttributes != null) {
                this.modelAttributeRelatedToAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelAttributeScale(Long modelAttributeScale) {
            this.modelAttributeScale = modelAttributeScale;
            return (B)this.self();
        }

        @Generated
        public B modelBusinessDate(Long modelBusinessDate) {
            this.modelBusinessDate = modelBusinessDate;
            return (B)this.self();
        }

        @Generated
        public B modelDomain(String modelDomain) {
            this.modelDomain = modelDomain;
            return (B)this.self();
        }

        @Generated
        public B modelEntityName(String modelEntityName) {
            this.modelEntityName = modelEntityName;
            return (B)this.self();
        }

        @Generated
        public B modelEntityQualifiedName(String modelEntityQualifiedName) {
            this.modelEntityQualifiedName = modelEntityQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modelExpiredAtBusinessDate(Long modelExpiredAtBusinessDate) {
            this.modelExpiredAtBusinessDate = modelExpiredAtBusinessDate;
            return (B)this.self();
        }

        @Generated
        public B modelExpiredAtSystemDate(Long modelExpiredAtSystemDate) {
            this.modelExpiredAtSystemDate = modelExpiredAtSystemDate;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelName(String modelName) {
            this.modelName = modelName;
            return (B)this.self();
        }

        @Generated
        public B modelNamespace(String modelNamespace) {
            this.modelNamespace = modelNamespace;
            return (B)this.self();
        }

        @Generated
        public B modelQualifiedName(String modelQualifiedName) {
            this.modelQualifiedName = modelQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modelSystemDate(Long modelSystemDate) {
            this.modelSystemDate = modelSystemDate;
            return (B)this.self();
        }

        @Generated
        public B modelType(String modelType) {
            this.modelType = modelType;
            return (B)this.self();
        }

        @Generated
        public B modelVersionAgnosticQualifiedName(String modelVersionAgnosticQualifiedName) {
            this.modelVersionAgnosticQualifiedName = modelVersionAgnosticQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modelVersionName(String modelVersionName) {
            this.modelVersionName = modelVersionName;
            return (B)this.self();
        }

        @Generated
        public B modelVersionQualifiedName(String modelVersionQualifiedName) {
            this.modelVersionQualifiedName = modelVersionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ModelAttribute.ModelAttributeBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelAttributeDataType=" + this.modelAttributeDataType + ", modelAttributeEntities=" + String.valueOf(this.modelAttributeEntities) + ", modelAttributeHasRelationships=" + this.modelAttributeHasRelationships + ", modelAttributeImplementedByAssets=" + String.valueOf(this.modelAttributeImplementedByAssets) + ", modelAttributeIsDerived=" + this.modelAttributeIsDerived + ", modelAttributeIsForeign=" + this.modelAttributeIsForeign + ", modelAttributeIsNullable=" + this.modelAttributeIsNullable + ", modelAttributeIsPrimary=" + this.modelAttributeIsPrimary + ", modelAttributeMappedFromAttributes=" + String.valueOf(this.modelAttributeMappedFromAttributes) + ", modelAttributeMappedToAttributes=" + String.valueOf(this.modelAttributeMappedToAttributes) + ", modelAttributePrecision=" + this.modelAttributePrecision + ", modelAttributeRelatedFromAttributes=" + String.valueOf(this.modelAttributeRelatedFromAttributes) + ", modelAttributeRelatedToAttributes=" + String.valueOf(this.modelAttributeRelatedToAttributes) + ", modelAttributeScale=" + this.modelAttributeScale + ", modelBusinessDate=" + this.modelBusinessDate + ", modelDomain=" + this.modelDomain + ", modelEntityName=" + this.modelEntityName + ", modelEntityQualifiedName=" + this.modelEntityQualifiedName + ", modelExpiredAtBusinessDate=" + this.modelExpiredAtBusinessDate + ", modelExpiredAtSystemDate=" + this.modelExpiredAtSystemDate + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", modelName=" + this.modelName + ", modelNamespace=" + this.modelNamespace + ", modelQualifiedName=" + this.modelQualifiedName + ", modelSystemDate=" + this.modelSystemDate + ", modelType=" + this.modelType + ", modelVersionAgnosticQualifiedName=" + this.modelVersionAgnosticQualifiedName + ", modelVersionName=" + this.modelVersionName + ", modelVersionQualifiedName=" + this.modelVersionQualifiedName + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class ModelAttributeBuilderImpl
    extends ModelAttributeBuilder<ModelAttribute, ModelAttributeBuilderImpl> {
        @Generated
        private ModelAttributeBuilderImpl() {
        }

        @Override
        @Generated
        protected ModelAttributeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModelAttribute build() {
            return new ModelAttribute(this);
        }
    }
}

