/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISisense;
import com.atlan.model.assets.ISisenseDashboard;
import com.atlan.model.assets.ISisenseDatamodelTable;
import com.atlan.model.assets.ISisenseFolder;
import com.atlan.model.assets.ISisenseWidget;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SisenseWidget
extends Asset
implements ISisenseWidget,
ISisense,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SisenseWidget.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SisenseWidget";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    ISisenseDashboard sisenseDashboard;
    @Attribute
    SortedSet<ISisenseDatamodelTable> sisenseDatamodelTables;
    @Attribute
    ISisenseFolder sisenseFolder;
    @Attribute
    Long sisenseWidgetColumnCount;
    @Attribute
    String sisenseWidgetDashboardQualifiedName;
    @Attribute
    String sisenseWidgetFolderQualifiedName;
    @Attribute
    String sisenseWidgetSize;
    @Attribute
    String sisenseWidgetSubType;

    @Override
    public SisenseWidget trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SisenseWidget.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SisenseWidget.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SisenseWidget.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SisenseWidget.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SisenseWidget refByGuid(String guid) {
        return SisenseWidget.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SisenseWidget refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SisenseWidgetBuilder)((SisenseWidgetBuilder)SisenseWidget._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SisenseWidget refByQualifiedName(String qualifiedName) {
        return SisenseWidget.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SisenseWidget refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SisenseWidgetBuilder)((SisenseWidgetBuilder)SisenseWidget._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SisenseWidget get(AtlanClient client, String id) throws AtlanException {
        return SisenseWidget.get(client, id, false);
    }

    @JsonIgnore
    public static SisenseWidget get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SisenseWidget) {
                return (SisenseWidget)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof SisenseWidget) {
            return (SisenseWidget)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static SisenseWidget get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return SisenseWidget.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static SisenseWidget get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SisenseWidget.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof SisenseWidget) {
                return (SisenseWidget)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SisenseWidget.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof SisenseWidget) {
            return (SisenseWidget)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SisenseWidgetBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SisenseWidgetBuilder)((SisenseWidgetBuilder)((SisenseWidgetBuilder)SisenseWidget._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SisenseWidgetBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        SisenseWidget.validateRequired(TYPE_NAME, map);
        return SisenseWidget.updater(this.getQualifiedName(), this.getName());
    }

    public static SisenseWidget removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseWidget)Asset.removeDescription(client, SisenseWidget.updater(qualifiedName, name));
    }

    public static SisenseWidget removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseWidget)Asset.removeUserDescription(client, SisenseWidget.updater(qualifiedName, name));
    }

    public static SisenseWidget removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseWidget)Asset.removeOwners(client, SisenseWidget.updater(qualifiedName, name));
    }

    public static SisenseWidget updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SisenseWidget)Asset.updateCertificate(client, SisenseWidget._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SisenseWidget removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseWidget)Asset.removeCertificate(client, SisenseWidget.updater(qualifiedName, name));
    }

    public static SisenseWidget updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SisenseWidget)Asset.updateAnnouncement(client, SisenseWidget._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SisenseWidget removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseWidget)Asset.removeAnnouncement(client, SisenseWidget.updater(qualifiedName, name));
    }

    public static SisenseWidget replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseWidget)Asset.replaceTerms(client, SisenseWidget.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static SisenseWidget appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseWidget)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static SisenseWidget removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseWidget)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static SisenseWidget appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SisenseWidget)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static SisenseWidget appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SisenseWidget)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SisenseWidget(SisenseWidgetBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SisenseWidget.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sisenseDashboard = b.sisenseDashboard;
        SortedSet<ISisenseDatamodelTable> sisenseDatamodelTables = new TreeSet<ISisenseDatamodelTable>();
        if (b.sisenseDatamodelTables != null) {
            sisenseDatamodelTables.addAll(b.sisenseDatamodelTables);
        }
        sisenseDatamodelTables = Collections.unmodifiableSortedSet(sisenseDatamodelTables);
        this.sisenseDatamodelTables = sisenseDatamodelTables;
        this.sisenseFolder = b.sisenseFolder;
        this.sisenseWidgetColumnCount = b.sisenseWidgetColumnCount;
        this.sisenseWidgetDashboardQualifiedName = b.sisenseWidgetDashboardQualifiedName;
        this.sisenseWidgetFolderQualifiedName = b.sisenseWidgetFolderQualifiedName;
        this.sisenseWidgetSize = b.sisenseWidgetSize;
        this.sisenseWidgetSubType = b.sisenseWidgetSubType;
    }

    @Generated
    public static SisenseWidgetBuilder<?, ?> _internal() {
        return new SisenseWidgetBuilderImpl();
    }

    @Generated
    public SisenseWidgetBuilder<?, ?> toBuilder() {
        return new SisenseWidgetBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public ISisenseDashboard getSisenseDashboard() {
        return this.sisenseDashboard;
    }

    @Override
    @Generated
    public SortedSet<ISisenseDatamodelTable> getSisenseDatamodelTables() {
        return this.sisenseDatamodelTables;
    }

    @Override
    @Generated
    public ISisenseFolder getSisenseFolder() {
        return this.sisenseFolder;
    }

    @Override
    @Generated
    public Long getSisenseWidgetColumnCount() {
        return this.sisenseWidgetColumnCount;
    }

    @Override
    @Generated
    public String getSisenseWidgetDashboardQualifiedName() {
        return this.sisenseWidgetDashboardQualifiedName;
    }

    @Override
    @Generated
    public String getSisenseWidgetFolderQualifiedName() {
        return this.sisenseWidgetFolderQualifiedName;
    }

    @Override
    @Generated
    public String getSisenseWidgetSize() {
        return this.sisenseWidgetSize;
    }

    @Override
    @Generated
    public String getSisenseWidgetSubType() {
        return this.sisenseWidgetSubType;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SisenseWidget)) {
            return false;
        }
        SisenseWidget other = (SisenseWidget)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sisenseWidgetColumnCount = this.getSisenseWidgetColumnCount();
        Long other$sisenseWidgetColumnCount = other.getSisenseWidgetColumnCount();
        if (this$sisenseWidgetColumnCount == null ? other$sisenseWidgetColumnCount != null : !((Object)this$sisenseWidgetColumnCount).equals(other$sisenseWidgetColumnCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        ISisenseDashboard this$sisenseDashboard = this.getSisenseDashboard();
        ISisenseDashboard other$sisenseDashboard = other.getSisenseDashboard();
        if (this$sisenseDashboard == null ? other$sisenseDashboard != null : !this$sisenseDashboard.equals(other$sisenseDashboard)) {
            return false;
        }
        SortedSet<ISisenseDatamodelTable> this$sisenseDatamodelTables = this.getSisenseDatamodelTables();
        SortedSet<ISisenseDatamodelTable> other$sisenseDatamodelTables = other.getSisenseDatamodelTables();
        if (this$sisenseDatamodelTables == null ? other$sisenseDatamodelTables != null : !this$sisenseDatamodelTables.equals(other$sisenseDatamodelTables)) {
            return false;
        }
        ISisenseFolder this$sisenseFolder = this.getSisenseFolder();
        ISisenseFolder other$sisenseFolder = other.getSisenseFolder();
        if (this$sisenseFolder == null ? other$sisenseFolder != null : !this$sisenseFolder.equals(other$sisenseFolder)) {
            return false;
        }
        String this$sisenseWidgetDashboardQualifiedName = this.getSisenseWidgetDashboardQualifiedName();
        String other$sisenseWidgetDashboardQualifiedName = other.getSisenseWidgetDashboardQualifiedName();
        if (this$sisenseWidgetDashboardQualifiedName == null ? other$sisenseWidgetDashboardQualifiedName != null : !this$sisenseWidgetDashboardQualifiedName.equals(other$sisenseWidgetDashboardQualifiedName)) {
            return false;
        }
        String this$sisenseWidgetFolderQualifiedName = this.getSisenseWidgetFolderQualifiedName();
        String other$sisenseWidgetFolderQualifiedName = other.getSisenseWidgetFolderQualifiedName();
        if (this$sisenseWidgetFolderQualifiedName == null ? other$sisenseWidgetFolderQualifiedName != null : !this$sisenseWidgetFolderQualifiedName.equals(other$sisenseWidgetFolderQualifiedName)) {
            return false;
        }
        String this$sisenseWidgetSize = this.getSisenseWidgetSize();
        String other$sisenseWidgetSize = other.getSisenseWidgetSize();
        if (this$sisenseWidgetSize == null ? other$sisenseWidgetSize != null : !this$sisenseWidgetSize.equals(other$sisenseWidgetSize)) {
            return false;
        }
        String this$sisenseWidgetSubType = this.getSisenseWidgetSubType();
        String other$sisenseWidgetSubType = other.getSisenseWidgetSubType();
        return !(this$sisenseWidgetSubType == null ? other$sisenseWidgetSubType != null : !this$sisenseWidgetSubType.equals(other$sisenseWidgetSubType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SisenseWidget;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sisenseWidgetColumnCount = this.getSisenseWidgetColumnCount();
        result = result * 59 + ($sisenseWidgetColumnCount == null ? 43 : ((Object)$sisenseWidgetColumnCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        ISisenseDashboard $sisenseDashboard = this.getSisenseDashboard();
        result = result * 59 + ($sisenseDashboard == null ? 43 : $sisenseDashboard.hashCode());
        SortedSet<ISisenseDatamodelTable> $sisenseDatamodelTables = this.getSisenseDatamodelTables();
        result = result * 59 + ($sisenseDatamodelTables == null ? 43 : $sisenseDatamodelTables.hashCode());
        ISisenseFolder $sisenseFolder = this.getSisenseFolder();
        result = result * 59 + ($sisenseFolder == null ? 43 : $sisenseFolder.hashCode());
        String $sisenseWidgetDashboardQualifiedName = this.getSisenseWidgetDashboardQualifiedName();
        result = result * 59 + ($sisenseWidgetDashboardQualifiedName == null ? 43 : $sisenseWidgetDashboardQualifiedName.hashCode());
        String $sisenseWidgetFolderQualifiedName = this.getSisenseWidgetFolderQualifiedName();
        result = result * 59 + ($sisenseWidgetFolderQualifiedName == null ? 43 : $sisenseWidgetFolderQualifiedName.hashCode());
        String $sisenseWidgetSize = this.getSisenseWidgetSize();
        result = result * 59 + ($sisenseWidgetSize == null ? 43 : $sisenseWidgetSize.hashCode());
        String $sisenseWidgetSubType = this.getSisenseWidgetSubType();
        result = result * 59 + ($sisenseWidgetSubType == null ? 43 : $sisenseWidgetSubType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SisenseWidget(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", sisenseDashboard=" + String.valueOf(this.getSisenseDashboard()) + ", sisenseDatamodelTables=" + String.valueOf(this.getSisenseDatamodelTables()) + ", sisenseFolder=" + String.valueOf(this.getSisenseFolder()) + ", sisenseWidgetColumnCount=" + this.getSisenseWidgetColumnCount() + ", sisenseWidgetDashboardQualifiedName=" + this.getSisenseWidgetDashboardQualifiedName() + ", sisenseWidgetFolderQualifiedName=" + this.getSisenseWidgetFolderQualifiedName() + ", sisenseWidgetSize=" + this.getSisenseWidgetSize() + ", sisenseWidgetSubType=" + this.getSisenseWidgetSubType() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class SisenseWidgetBuilder<C extends SisenseWidget, B extends SisenseWidgetBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ISisenseDashboard sisenseDashboard;
        @Generated
        private ArrayList<ISisenseDatamodelTable> sisenseDatamodelTables;
        @Generated
        private ISisenseFolder sisenseFolder;
        @Generated
        private Long sisenseWidgetColumnCount;
        @Generated
        private String sisenseWidgetDashboardQualifiedName;
        @Generated
        private String sisenseWidgetFolderQualifiedName;
        @Generated
        private String sisenseWidgetSize;
        @Generated
        private String sisenseWidgetSubType;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SisenseWidgetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SisenseWidget instance, SisenseWidgetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.sisenseDashboard(instance.sisenseDashboard);
            b.sisenseDatamodelTables(instance.sisenseDatamodelTables == null ? Collections.emptySortedSet() : instance.sisenseDatamodelTables);
            b.sisenseFolder(instance.sisenseFolder);
            b.sisenseWidgetColumnCount(instance.sisenseWidgetColumnCount);
            b.sisenseWidgetDashboardQualifiedName(instance.sisenseWidgetDashboardQualifiedName);
            b.sisenseWidgetFolderQualifiedName(instance.sisenseWidgetFolderQualifiedName);
            b.sisenseWidgetSize(instance.sisenseWidgetSize);
            b.sisenseWidgetSubType(instance.sisenseWidgetSubType);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sisenseDashboard(ISisenseDashboard sisenseDashboard) {
            this.sisenseDashboard = sisenseDashboard;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelTable(ISisenseDatamodelTable sisenseDatamodelTable) {
            if (this.sisenseDatamodelTables == null) {
                this.sisenseDatamodelTables = new ArrayList();
            }
            this.sisenseDatamodelTables.add(sisenseDatamodelTable);
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelTables(Collection<? extends ISisenseDatamodelTable> sisenseDatamodelTables) {
            if (sisenseDatamodelTables == null) {
                throw new NullPointerException("sisenseDatamodelTables cannot be null");
            }
            if (this.sisenseDatamodelTables == null) {
                this.sisenseDatamodelTables = new ArrayList();
            }
            this.sisenseDatamodelTables.addAll(sisenseDatamodelTables);
            return (B)this.self();
        }

        @Generated
        public B clearSisenseDatamodelTables() {
            if (this.sisenseDatamodelTables != null) {
                this.sisenseDatamodelTables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sisenseFolder(ISisenseFolder sisenseFolder) {
            this.sisenseFolder = sisenseFolder;
            return (B)this.self();
        }

        @Generated
        public B sisenseWidgetColumnCount(Long sisenseWidgetColumnCount) {
            this.sisenseWidgetColumnCount = sisenseWidgetColumnCount;
            return (B)this.self();
        }

        @Generated
        public B sisenseWidgetDashboardQualifiedName(String sisenseWidgetDashboardQualifiedName) {
            this.sisenseWidgetDashboardQualifiedName = sisenseWidgetDashboardQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sisenseWidgetFolderQualifiedName(String sisenseWidgetFolderQualifiedName) {
            this.sisenseWidgetFolderQualifiedName = sisenseWidgetFolderQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sisenseWidgetSize(String sisenseWidgetSize) {
            this.sisenseWidgetSize = sisenseWidgetSize;
            return (B)this.self();
        }

        @Generated
        public B sisenseWidgetSubType(String sisenseWidgetSubType) {
            this.sisenseWidgetSubType = sisenseWidgetSubType;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SisenseWidget.SisenseWidgetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", sisenseDashboard=" + String.valueOf(this.sisenseDashboard) + ", sisenseDatamodelTables=" + String.valueOf(this.sisenseDatamodelTables) + ", sisenseFolder=" + String.valueOf(this.sisenseFolder) + ", sisenseWidgetColumnCount=" + this.sisenseWidgetColumnCount + ", sisenseWidgetDashboardQualifiedName=" + this.sisenseWidgetDashboardQualifiedName + ", sisenseWidgetFolderQualifiedName=" + this.sisenseWidgetFolderQualifiedName + ", sisenseWidgetSize=" + this.sisenseWidgetSize + ", sisenseWidgetSubType=" + this.sisenseWidgetSubType + ")";
        }
    }

    @Generated
    private static final class SisenseWidgetBuilderImpl
    extends SisenseWidgetBuilder<SisenseWidget, SisenseWidgetBuilderImpl> {
        @Generated
        private SisenseWidgetBuilderImpl() {
        }

        @Override
        @Generated
        protected SisenseWidgetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SisenseWidget build() {
            return new SisenseWidget(this);
        }
    }
}

