/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.IStakeholder;
import com.atlan.model.assets.IStakeholderTitle;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StakeholderTitle
extends Asset
implements IStakeholderTitle,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StakeholderTitle.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "StakeholderTitle";
    String typeName;
    @Attribute
    SortedSet<String> stakeholderTitleDomainQualifiedNames;
    @Attribute
    SortedSet<IStakeholder> stakeholders;

    @Override
    public StakeholderTitle trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return StakeholderTitle.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return StakeholderTitle.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return StakeholderTitle.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return StakeholderTitle.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static StakeholderTitle refByGuid(String guid) {
        return StakeholderTitle.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static StakeholderTitle refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((StakeholderTitleBuilder)((StakeholderTitleBuilder)StakeholderTitle._internal().guid(guid)).semantic(semantic)).build();
    }

    public static StakeholderTitle refByQualifiedName(String qualifiedName) {
        return StakeholderTitle.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static StakeholderTitle refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((StakeholderTitleBuilder)((StakeholderTitleBuilder)StakeholderTitle._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static StakeholderTitle get(AtlanClient client, String id) throws AtlanException {
        return StakeholderTitle.get(client, id, false);
    }

    @JsonIgnore
    public static StakeholderTitle get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof StakeholderTitle) {
                return (StakeholderTitle)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof StakeholderTitle) {
            return (StakeholderTitle)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static StakeholderTitle get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return StakeholderTitle.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static StakeholderTitle get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)StakeholderTitle.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof StakeholderTitle) {
                return (StakeholderTitle)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)StakeholderTitle.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof StakeholderTitle) {
            return (StakeholderTitle)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static StakeholderTitleBuilder<?, ?> updater(String qualifiedName, String name) {
        return (StakeholderTitleBuilder)((StakeholderTitleBuilder)((StakeholderTitleBuilder)StakeholderTitle._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public StakeholderTitleBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        StakeholderTitle.validateRequired(TYPE_NAME, map);
        return StakeholderTitle.updater(this.getQualifiedName(), this.getName());
    }

    public static StakeholderTitle removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (StakeholderTitle)Asset.removeDescription(client, StakeholderTitle.updater(qualifiedName, name));
    }

    public static StakeholderTitle removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (StakeholderTitle)Asset.removeUserDescription(client, StakeholderTitle.updater(qualifiedName, name));
    }

    public static StakeholderTitle removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (StakeholderTitle)Asset.removeOwners(client, StakeholderTitle.updater(qualifiedName, name));
    }

    public static StakeholderTitle updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (StakeholderTitle)Asset.updateCertificate(client, StakeholderTitle._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static StakeholderTitle removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (StakeholderTitle)Asset.removeCertificate(client, StakeholderTitle.updater(qualifiedName, name));
    }

    public static StakeholderTitle updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (StakeholderTitle)Asset.updateAnnouncement(client, StakeholderTitle._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static StakeholderTitle removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (StakeholderTitle)Asset.removeAnnouncement(client, StakeholderTitle.updater(qualifiedName, name));
    }

    public static StakeholderTitle replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (StakeholderTitle)Asset.replaceTerms(client, StakeholderTitle.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static StakeholderTitle appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (StakeholderTitle)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static StakeholderTitle removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (StakeholderTitle)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static StakeholderTitle appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (StakeholderTitle)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static StakeholderTitle appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (StakeholderTitle)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected StakeholderTitle(StakeholderTitleBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : StakeholderTitle.$default$typeName();
        SortedSet<String> stakeholderTitleDomainQualifiedNames = new TreeSet<String>();
        if (b.stakeholderTitleDomainQualifiedNames != null) {
            stakeholderTitleDomainQualifiedNames.addAll(b.stakeholderTitleDomainQualifiedNames);
        }
        stakeholderTitleDomainQualifiedNames = Collections.unmodifiableSortedSet(stakeholderTitleDomainQualifiedNames);
        this.stakeholderTitleDomainQualifiedNames = stakeholderTitleDomainQualifiedNames;
        SortedSet<IStakeholder> stakeholders = new TreeSet<IStakeholder>();
        if (b.stakeholders != null) {
            stakeholders.addAll(b.stakeholders);
        }
        stakeholders = Collections.unmodifiableSortedSet(stakeholders);
        this.stakeholders = stakeholders;
    }

    @Generated
    public static StakeholderTitleBuilder<?, ?> _internal() {
        return new StakeholderTitleBuilderImpl();
    }

    @Generated
    public StakeholderTitleBuilder<?, ?> toBuilder() {
        return new StakeholderTitleBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<String> getStakeholderTitleDomainQualifiedNames() {
        return this.stakeholderTitleDomainQualifiedNames;
    }

    @Override
    @Generated
    public SortedSet<IStakeholder> getStakeholders() {
        return this.stakeholders;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StakeholderTitle)) {
            return false;
        }
        StakeholderTitle other = (StakeholderTitle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<String> this$stakeholderTitleDomainQualifiedNames = this.getStakeholderTitleDomainQualifiedNames();
        SortedSet<String> other$stakeholderTitleDomainQualifiedNames = other.getStakeholderTitleDomainQualifiedNames();
        if (this$stakeholderTitleDomainQualifiedNames == null ? other$stakeholderTitleDomainQualifiedNames != null : !this$stakeholderTitleDomainQualifiedNames.equals(other$stakeholderTitleDomainQualifiedNames)) {
            return false;
        }
        SortedSet<IStakeholder> this$stakeholders = this.getStakeholders();
        SortedSet<IStakeholder> other$stakeholders = other.getStakeholders();
        return !(this$stakeholders == null ? other$stakeholders != null : !this$stakeholders.equals(other$stakeholders));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StakeholderTitle;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<String> $stakeholderTitleDomainQualifiedNames = this.getStakeholderTitleDomainQualifiedNames();
        result = result * 59 + ($stakeholderTitleDomainQualifiedNames == null ? 43 : $stakeholderTitleDomainQualifiedNames.hashCode());
        SortedSet<IStakeholder> $stakeholders = this.getStakeholders();
        result = result * 59 + ($stakeholders == null ? 43 : $stakeholders.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "StakeholderTitle(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", stakeholderTitleDomainQualifiedNames=" + String.valueOf(this.getStakeholderTitleDomainQualifiedNames()) + ", stakeholders=" + String.valueOf(this.getStakeholders()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class StakeholderTitleBuilder<C extends StakeholderTitle, B extends StakeholderTitleBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<String> stakeholderTitleDomainQualifiedNames;
        @Generated
        private ArrayList<IStakeholder> stakeholders;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            StakeholderTitleBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(StakeholderTitle instance, StakeholderTitleBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.stakeholderTitleDomainQualifiedNames(instance.stakeholderTitleDomainQualifiedNames == null ? Collections.emptySortedSet() : instance.stakeholderTitleDomainQualifiedNames);
            b.stakeholders(instance.stakeholders == null ? Collections.emptySortedSet() : instance.stakeholders);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B stakeholderTitleDomainQualifiedName(String stakeholderTitleDomainQualifiedName) {
            if (this.stakeholderTitleDomainQualifiedNames == null) {
                this.stakeholderTitleDomainQualifiedNames = new ArrayList();
            }
            this.stakeholderTitleDomainQualifiedNames.add(stakeholderTitleDomainQualifiedName);
            return (B)this.self();
        }

        @Generated
        public B stakeholderTitleDomainQualifiedNames(Collection<? extends String> stakeholderTitleDomainQualifiedNames) {
            if (stakeholderTitleDomainQualifiedNames == null) {
                throw new NullPointerException("stakeholderTitleDomainQualifiedNames cannot be null");
            }
            if (this.stakeholderTitleDomainQualifiedNames == null) {
                this.stakeholderTitleDomainQualifiedNames = new ArrayList();
            }
            this.stakeholderTitleDomainQualifiedNames.addAll(stakeholderTitleDomainQualifiedNames);
            return (B)this.self();
        }

        @Generated
        public B clearStakeholderTitleDomainQualifiedNames() {
            if (this.stakeholderTitleDomainQualifiedNames != null) {
                this.stakeholderTitleDomainQualifiedNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B stakeholder(IStakeholder stakeholder) {
            if (this.stakeholders == null) {
                this.stakeholders = new ArrayList();
            }
            this.stakeholders.add(stakeholder);
            return (B)this.self();
        }

        @Generated
        public B stakeholders(Collection<? extends IStakeholder> stakeholders) {
            if (stakeholders == null) {
                throw new NullPointerException("stakeholders cannot be null");
            }
            if (this.stakeholders == null) {
                this.stakeholders = new ArrayList();
            }
            this.stakeholders.addAll(stakeholders);
            return (B)this.self();
        }

        @Generated
        public B clearStakeholders() {
            if (this.stakeholders != null) {
                this.stakeholders.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "StakeholderTitle.StakeholderTitleBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", stakeholderTitleDomainQualifiedNames=" + String.valueOf(this.stakeholderTitleDomainQualifiedNames) + ", stakeholders=" + String.valueOf(this.stakeholders) + ")";
        }
    }

    @Generated
    private static final class StakeholderTitleBuilderImpl
    extends StakeholderTitleBuilder<StakeholderTitle, StakeholderTitleBuilderImpl> {
        @Generated
        private StakeholderTitleBuilderImpl() {
        }

        @Override
        @Generated
        protected StakeholderTitleBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public StakeholderTitle build() {
            return new StakeholderTitle(this);
        }
    }
}

