/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.fields;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch._types.query_dsl.PrefixQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.RegexpQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQueryField;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsSetQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.WildcardQuery;
import com.atlan.model.enums.AtlanEnum;
import com.atlan.model.enums.ElasticRegexOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public interface IKeywordSearchable {
    public String getKeywordFieldName();

    default public Query startsWith(String value) {
        return this.startsWith(value, false);
    }

    public Query startsWith(String var1, boolean var2);

    public static Query startsWith(String field, String value, boolean caseInsensitive) {
        return PrefixQuery.of(t -> t.field(field).value(value).caseInsensitive(Boolean.valueOf(caseInsensitive)))._toQuery();
    }

    public Query eq(AtlanEnum var1);

    public static Query eq(String field, AtlanEnum value) {
        return TermQuery.of(t -> t.field(field).value(value.getValue()))._toQuery();
    }

    default public Query eq(String value) {
        return this.eq(value, false);
    }

    public Query eq(String var1, boolean var2);

    public static Query eq(String field, String value, boolean caseInsensitive) {
        return TermQuery.of(t -> t.field(field).value(value).caseInsensitive(Boolean.valueOf(caseInsensitive)))._toQuery();
    }

    public Query in(Collection<String> var1);

    public static Query in(String field, Collection<String> values) {
        ArrayList<FieldValue> list = new ArrayList<FieldValue>();
        for (String value : values) {
            list.add(FieldValue.of((String)value));
        }
        return TermsQuery.of(t -> t.field(field).terms(TermsQueryField.of(f -> f.value(list))))._toQuery();
    }

    public Query in(List<String> var1, int var2);

    public static Query in(String field, List<String> values, int minMustMatch) {
        return TermsSetQuery.of(t -> t.field(field).terms(values).minimumShouldMatchScript(s -> s.lang(ScriptLanguage.Painless).source("" + minMustMatch)))._toQuery();
    }

    default public Query wildcard(String value) {
        return this.wildcard(value, false);
    }

    public Query wildcard(String var1, boolean var2);

    public static Query wildcard(String field, String value, boolean caseInsensitive) {
        return WildcardQuery.of(w -> w.field(field).value(value).caseInsensitive(Boolean.valueOf(caseInsensitive)))._toQuery();
    }

    default public Query regex(String regexp) {
        return this.regex(regexp, false);
    }

    default public Query regex(String regexp, boolean caseInsensitive) {
        return this.regex(regexp, null, caseInsensitive);
    }

    public Query regex(String var1, Collection<ElasticRegexOperator> var2, boolean var3);

    public static Query regex(String field, String regexp, Collection<ElasticRegexOperator> flags, boolean caseInsensitive) {
        String flagsToUse = flags != null && !flags.isEmpty() ? flags.stream().map(ElasticRegexOperator::getValue).collect(Collectors.joining("|")) : "";
        return RegexpQuery.of(r -> r.field(field).value(regexp).caseInsensitive(Boolean.valueOf(caseInsensitive)).flags(flagsToUse))._toQuery();
    }
}

