/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.Credential;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class AthenaCrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.ATHENA.getValue();

    public static AthenaCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return AthenaCrawler.creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null, true, true, 10000L);
    }

    public static AthenaCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, boolean allowQuery, boolean allowSamples, long rowLimit) throws AtlanException {
        return ((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)AthenaCrawler._internal().setup(PREFIX, "@atlan/athena", client, AthenaCrawler.getConnection(client, connectionName, AtlanConnectorType.ATHENA, adminRoles, adminGroups, adminUsers, allowQuery, allowSamples, rowLimit, "https://atlan-public.s3.eu-west-1.amazonaws.com/atlan/logos/aws-athena.png"))).include(null)).exclude((Map<String, List<String>>)null);
    }

    @Generated
    protected AthenaCrawler(AthenaCrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static AthenaCrawlerBuilder<?, ?> _internal() {
        return new AthenaCrawlerBuilderImpl();
    }

    @Generated
    public AthenaCrawlerBuilder<?, ?> toBuilder() {
        return new AthenaCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AthenaCrawler)) {
            return false;
        }
        AthenaCrawler other = (AthenaCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AthenaCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AthenaCrawler(super=" + super.toString() + ")";
    }

    public static abstract class AthenaCrawlerBuilder<C extends AthenaCrawler, B extends AthenaCrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B direct(String hostname, String workgroup, String s3Output) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.name("default-athena-" + this.epoch + "-0")).host(hostname)).port(443)).extra("workgroup", workgroup)).extra("s3_output_location", s3Output)).connectorConfigName("atlan-connectors-athena");
            return (B)((AthenaCrawlerBuilder)this._credential(this.localCreds));
        }

        public B iamUserAuth(String accessKey, String secretKey) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("basic")).username(accessKey)).password(secretKey);
            return (B)((AthenaCrawlerBuilder)this._credential(this.localCreds));
        }

        public B include(Map<String, List<String>> assets) throws InvalidRequestException {
            Map<String, List<String>> toInclude = AbstractCrawler.buildHierarchicalFilter(assets);
            try {
                return (B)((AthenaCrawlerBuilder)this._parameter("include-filter", Serde.allInclusiveMapper.writeValueAsString(toInclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(Map<String, List<String>> assets) throws InvalidRequestException {
            Map<String, List<String>> toExclude = AbstractCrawler.buildHierarchicalFilter(assets);
            try {
                return (B)((AthenaCrawlerBuilder)this._parameter("exclude-filter", Serde.allInclusiveMapper.writeValueAsString(toExclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(String regex) {
            return (B)((AthenaCrawlerBuilder)this._parameter("temp-table-regex", regex));
        }

        @Override
        protected B metadata() {
            return (B)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)((AthenaCrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "athena"))._label("orchestration.atlan.com/sourceCategory", "queryengine"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hathena"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-athena-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6325285989009"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://atlan-public.s3.eu-west-1.amazonaws.com/atlan/logos/aws-athena.png"))._annotation("orchestration.atlan.com/logo", "https://atlan-public.s3.eu-west-1.amazonaws.com/atlan/logos/aws-athena.png"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/athena"))._annotation("orchestration.atlan.com/name", "Athena Assets"))._annotation("orchestration.atlan.com/usecase", "crawling,auto-classifications"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Scan all your Athena assets and publish to Atlan."))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/athena"))._annotation("package.argoproj.io/keywords", "[\"athena\",\"lake\",\"connector\",\"crawler\",\"glue\",\"aws\",\"s3\"]"))._annotation("package.argoproj.io/name", "@atlan/athena"))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-athena-" + this.epoch))._parameters(Map.ofEntries(Map.entry("credentials-fetch-strategy", "credential_guid"), Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("connection", this.connection.toJson(this.client)), Map.entry("publish-mode", "production"), Map.entry("atlas-auth-type", "internal"))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AthenaCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AthenaCrawler instance, AthenaCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AthenaCrawler.AthenaCrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class AthenaCrawlerBuilderImpl
    extends AthenaCrawlerBuilder<AthenaCrawler, AthenaCrawlerBuilderImpl> {
        @Generated
        private AthenaCrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected AthenaCrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AthenaCrawler build() {
            return new AthenaCrawler(this);
        }
    }
}

