/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.Credential;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class FivetranCrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.FIVETRAN.getValue();

    public static FivetranCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return FivetranCrawler.creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null);
    }

    public static FivetranCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers) throws AtlanException {
        return ((FivetranCrawlerBuilder)FivetranCrawler._internal().setup(PREFIX, "@atlan/fivetran", client, FivetranCrawler.getConnection(client, connectionName, AtlanConnectorType.FIVETRAN, adminRoles, adminGroups, adminUsers, false, false, 0L, "https://res.cloudinary.com/crunchbase-production/image/upload/c_lpad,f_auto,q_auto:eco,dpr_1/mmhosuxvz2msbiieekl3"))).publishAnnouncements(false);
    }

    @Generated
    protected FivetranCrawler(FivetranCrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static FivetranCrawlerBuilder<?, ?> _internal() {
        return new FivetranCrawlerBuilderImpl();
    }

    @Generated
    public FivetranCrawlerBuilder<?, ?> toBuilder() {
        return new FivetranCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FivetranCrawler)) {
            return false;
        }
        FivetranCrawler other = (FivetranCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FivetranCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FivetranCrawler(super=" + super.toString() + ")";
    }

    public static abstract class FivetranCrawlerBuilder<C extends FivetranCrawler, B extends FivetranCrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B apiToken(String apiKey, String apiSecret) {
            String epoch = Connection.getEpochFromQualifiedName(this.connection.getQualifiedName());
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.name("default-fivetran-" + epoch + "-0")).host("https://api.fivetran.com")).port(443)).authType("api")).username(apiKey)).password(apiSecret)).connectorConfigName("atlan-connectors-fivetran");
            return (B)((FivetranCrawlerBuilder)this._credential(this.localCreds));
        }

        public B publishAnnouncements(boolean enabled) {
            return (B)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)this._parameter("advanced-config-strategy", "custom"))._parameter("publish-announcements", "" + enabled));
        }

        @Override
        protected B metadata() {
            return (B)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)((FivetranCrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "fivetran"))._label("orchestration.atlan.com/sourceCategory", "elt"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hfivetran"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-fivetran-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/8427123935121"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://res.cloudinary.com/crunchbase-production/image/upload/c_lpad,f_auto,q_auto:eco,dpr_1/mmhosuxvz2msbiieekl3"))._annotation("orchestration.atlan.com/logo", "https://alternative.me/media/256/fivetran-icon-qfxkppdpdx2oh4r9-c.png"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/fivetran"))._annotation("orchestration.atlan.com/name", "Fivetran Enrichment"))._annotation("orchestration.atlan.com/usecase", "crawling,enrichment"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Enrich known assets associated with Fivetran Connectors with column-level lineage.  Requires access to Fivetran's Metadata API."))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/fivetran"))._annotation("package.argoproj.io/keywords", "[\"connector\",\"elt\",\"fivetran\",\"lineage\"]"))._annotation("package.argoproj.io/name", "@atlan/fivetran"))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-fivetran-" + this.epoch))._parameters(Map.ofEntries(Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("connection", this.connection.toJson(this.client)))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FivetranCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(FivetranCrawler instance, FivetranCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FivetranCrawler.FivetranCrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class FivetranCrawlerBuilderImpl
    extends FivetranCrawlerBuilder<FivetranCrawler, FivetranCrawlerBuilderImpl> {
        @Generated
        private FivetranCrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected FivetranCrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FivetranCrawler build() {
            return new FivetranCrawler(this);
        }
    }
}

