/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.Credential;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PostgreSQLCrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.POSTGRES.getValue();

    public static PostgreSQLCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return PostgreSQLCrawler.creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null, true, true, 10000L);
    }

    public static PostgreSQLCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, boolean allowQuery, boolean allowSamples, long rowLimit) throws AtlanException {
        return ((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)PostgreSQLCrawler._internal().setup(PREFIX, "@atlan/postgres", client, PostgreSQLCrawler.getConnection(client, connectionName, AtlanConnectorType.POSTGRES, adminRoles, adminGroups, adminUsers, allowQuery, allowSamples, rowLimit, "https://www.postgresql.org/media/img/about/press/elephant.png"))).metadata()).include(null)).exclude((Map<String, List<String>>)null);
    }

    @Generated
    protected PostgreSQLCrawler(PostgreSQLCrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static PostgreSQLCrawlerBuilder<?, ?> _internal() {
        return new PostgreSQLCrawlerBuilderImpl();
    }

    @Generated
    public PostgreSQLCrawlerBuilder<?, ?> toBuilder() {
        return new PostgreSQLCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgreSQLCrawler)) {
            return false;
        }
        PostgreSQLCrawler other = (PostgreSQLCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PostgreSQLCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PostgreSQLCrawler(super=" + super.toString() + ")";
    }

    public static abstract class PostgreSQLCrawlerBuilder<C extends PostgreSQLCrawler, B extends PostgreSQLCrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B direct(String hostname, String database) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.name("default-postgres-" + this.epoch + "-0")).host(hostname)).port(5432)).extra("database", database)).connectorConfigName("atlan-connectors-postgres");
            return (B)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)this._parameter("extraction-method", "direct"))._credential(this.localCreds));
        }

        public B basicAuth(String username, String password) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("basic")).username(username)).password(password);
            return (B)((PostgreSQLCrawlerBuilder)this._credential(this.localCreds));
        }

        public B iamUserAuth(String username, String accessKey, String secretKey) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("iam")).username(accessKey)).password(secretKey)).extra("dbuser", username);
            return (B)((PostgreSQLCrawlerBuilder)this._credential(this.localCreds));
        }

        public B include(Map<String, List<String>> assets) throws InvalidRequestException {
            Map<String, List<String>> toInclude = AbstractCrawler.buildHierarchicalFilter(assets);
            try {
                return (B)((PostgreSQLCrawlerBuilder)this._parameter("include-filter", Serde.allInclusiveMapper.writeValueAsString(toInclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(Map<String, List<String>> assets) throws InvalidRequestException {
            Map<String, List<String>> toExclude = AbstractCrawler.buildHierarchicalFilter(assets);
            try {
                return (B)((PostgreSQLCrawlerBuilder)this._parameter("exclude-filter", Serde.allInclusiveMapper.writeValueAsString(toExclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(String regex) {
            return (B)((PostgreSQLCrawlerBuilder)this._parameter("temp-table-regex", regex));
        }

        @Override
        protected B metadata() {
            return (B)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)((PostgreSQLCrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "postgres"))._label("orchestration.atlan.com/sourceCategory", "database"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hpostgres"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-postgres-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/categories", "postgres,crawler"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6329557275793"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://www.postgresql.org/media/img/about/press/elephant.png"))._annotation("orchestration.atlan.com/logo", "https://www.postgresql.org/media/img/about/press/elephant.png"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/postgres"))._annotation("orchestration.atlan.com/name", "Postgres Assets"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Package to crawl PostgreSQL assets and publish to Atlan for discovery"))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/postgres"))._annotation("package.argoproj.io/keywords", "[\"postgres\",\"database\",\"sql\",\"connector\",\"crawler\"]"))._annotation("package.argoproj.io/name", "@atlan/postgres"))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-postgres-" + this.epoch))._parameters(Map.ofEntries(Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("connection", this.connection.toJson(this.client)), Map.entry("publish-mode", "production"))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PostgreSQLCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PostgreSQLCrawler instance, PostgreSQLCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PostgreSQLCrawler.PostgreSQLCrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class PostgreSQLCrawlerBuilderImpl
    extends PostgreSQLCrawlerBuilder<PostgreSQLCrawler, PostgreSQLCrawlerBuilderImpl> {
        @Generated
        private PostgreSQLCrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected PostgreSQLCrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PostgreSQLCrawler build() {
            return new PostgreSQLCrawler(this);
        }
    }
}

