/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.search.AggregationResult;
import com.atlan.model.search.AuditSearchRequest;
import com.atlan.model.search.EntityAudit;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditSearchResponse
extends ApiResource
implements Iterable<EntityAudit> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditSearchResponse.class);
    private static final long serialVersionUID = 2L;
    private static final long MASS_EXTRACT_THRESHOLD = 9700L;
    private static final int CHARACTERISTICS = 1296;
    @JsonIgnore
    AtlanClient client;
    @JsonIgnore
    AuditSearchRequest request;
    List<EntityAudit> entityAudits;
    Map<String, AggregationResult> aggregations;
    Long count;
    Long totalCount;

    @JsonIgnore
    public AuditSearchResponse getNextPage() throws AtlanException {
        AtlanObject dsl = this.getRequest().getDsl();
        int from = dsl.getFrom() == null ? 0 : dsl.getFrom();
        int page = dsl.getSize() == null ? 300 : dsl.getSize();
        dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(from + page)).build();
        Object next = AuditSearchRequest.builder().dsl((IndexSearchDSL)dsl);
        if (this.getRequest().getAttributes() != null) {
            next = ((AuditSearchRequest.AuditSearchRequestBuilder)next).attributes(this.getRequest().getAttributes());
        }
        return ((AuditSearchRequest)((AuditSearchRequest.AuditSearchRequestBuilder)next).build()).search(this.client);
    }

    @JsonIgnore
    public List<EntityAudit> getSpecificPage(int offset, int pageSize) throws AtlanException {
        AuditSearchResponse response;
        AtlanObject dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)this.getRequest().getDsl().toBuilder().from(offset)).size(pageSize)).build();
        Object next = AuditSearchRequest.builder().dsl((IndexSearchDSL)dsl);
        if (this.getRequest().getAttributes() != null) {
            next = ((AuditSearchRequest.AuditSearchRequestBuilder)next).attributes(this.getRequest().getAttributes());
        }
        if ((response = ((AuditSearchRequest)((AuditSearchRequest.AuditSearchRequestBuilder)next).build()).search(this.client)) != null && response.getEntityAudits() != null) {
            return response.getEntityAudits();
        }
        return Collections.emptyList();
    }

    @JsonIgnore
    protected AuditSearchResponse getNextBulkPage() throws AtlanException {
        long lastRecord;
        if (this.getEntityAudits() == null) {
            return this;
        }
        AtlanObject dsl = this.getRequest().getDsl();
        Query query = dsl.getQuery();
        ArrayList<Query> rewrittenFilters = new ArrayList<Query>();
        boolean streamed = AuditSearchResponse.presortedByTimestamp(dsl.getSort());
        if (query.isBool()) {
            BoolQuery original = query.bool();
            List filters = original.filter();
            for (Query candidate : filters) {
                if (this.isPagingTimestampQuery(candidate)) continue;
                rewrittenFilters.add(candidate);
            }
        }
        int page = dsl.getSize() == null ? 300 : dsl.getSize();
        long firstRecord = -2L;
        if (this.getEntityAudits().size() > 1) {
            firstRecord = this.getEntityAudits().get(0).getCreated();
            lastRecord = this.getEntityAudits().get(this.getEntityAudits().size() - 1).getCreated();
        } else {
            lastRecord = -2L;
        }
        if (streamed && firstRecord != lastRecord) {
            rewrittenFilters.add(this.getPagingTimestampQuery(lastRecord));
            BoolQuery original = query.bool();
            BoolQuery rewritten = BoolQuery.of(b -> (ObjectBuilder)b.filter(rewrittenFilters).must(original.must()).mustNot(original.mustNot()).minimumShouldMatch(original.minimumShouldMatch()).should(original.should()).boost(original.boost()));
            dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(0)).size(page)).query(rewritten._toQuery())).build();
        } else {
            int from = dsl.getFrom() == null ? 0 : dsl.getFrom();
            dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(from + this.getEntityAudits().size())).size(page)).build();
        }
        Object next = AuditSearchRequest.builder().dsl((IndexSearchDSL)dsl);
        if (this.getRequest().getAttributes() != null) {
            next = ((AuditSearchRequest.AuditSearchRequestBuilder)next).attributes(this.getRequest().getAttributes());
        }
        return ((AuditSearchRequest)((AuditSearchRequest.AuditSearchRequestBuilder)next).build()).search(this.client);
    }

    private boolean isPagingTimestampQuery(Query candidate) {
        return candidate.isRange() && candidate.range().untyped().field().equals(AuditSearchRequest.CREATED.getNumericFieldName()) && candidate.range().untyped().gte() != null && (Long)((JsonData)candidate.range().untyped().gte()).to(Long.class) > 0L && candidate.range().untyped().lt() == null && candidate.range().untyped().lte() == null;
    }

    private Query getPagingTimestampQuery(long lastTimestamp) {
        return AuditSearchRequest.CREATED.gte(lastTimestamp);
    }

    private AuditSearchResponse getFirstPageTimestampOrdered() throws AtlanException {
        AtlanObject dsl = this.getRequest().getDsl();
        List<SortOptions> revisedSort = AuditSearchResponse.sortByTimestampFirst(dsl.getSort());
        int page = dsl.getSize() == null ? 300 : dsl.getSize();
        dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(0)).size(page)).clearSort()).sort(revisedSort)).build();
        Object first = AuditSearchRequest.builder().dsl((IndexSearchDSL)dsl);
        if (this.getRequest().getAttributes() != null) {
            first = ((AuditSearchRequest.AuditSearchRequestBuilder)first).attributes(this.getRequest().getAttributes());
        }
        return ((AuditSearchRequest)((AuditSearchRequest.AuditSearchRequestBuilder)first).build()).search(this.client);
    }

    @Override
    public Iterator<EntityAudit> iterator() {
        return new AuditSearchResponseIterator(this);
    }

    public Iterator<EntityAudit> biterator() {
        return new AuditSearchResponseBulkIterator(this);
    }

    @Override
    public Spliterator<EntityAudit> spliterator() {
        long pageSize = this.getRequest().getDsl().getSize().intValue();
        AuditSearchResponseSpliterator spliterator = new AuditSearchResponseSpliterator(this, 0L, this.getTotalCount(), pageSize);
        List<Object> audits = this.getEntityAudits() == null ? Collections.emptyList() : this.getEntityAudits();
        spliterator.firstPage = audits.spliterator();
        return spliterator;
    }

    public Stream<EntityAudit> stream() {
        if (this.totalCount > 9700L) {
            log.debug("Results size exceeds threshold ({}), rewriting stream as a bulk stream (ignoring original sorting).", (Object)9700L);
            return this.bulkStream();
        }
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.totalCount, 1296), false);
    }

    public Stream<EntityAudit> parallelStream() {
        if (this.totalCount > 9700L) {
            log.debug("Results size exceeds threshold ({}), ignoring request for parallelized streaming and falling back to bulk streaming.", (Object)9700L);
            return this.bulkStream();
        }
        return StreamSupport.stream(this::spliterator, 1296, true);
    }

    public Stream<EntityAudit> bulkStream() {
        return StreamSupport.stream(Spliterators.spliterator(this.biterator(), (long)this.totalCount, 1296), false);
    }

    public static boolean presortedByTimestamp(List<SortOptions> sort) {
        return sort != null && !sort.isEmpty() && sort.get(0).isField() && sort.get(0).field().field().equals(AuditSearchRequest.CREATED.getNumericFieldName()) && sort.get(0).field().order() == SortOrder.Asc;
    }

    public static boolean hasUserRequestedSort(List<SortOptions> sort) {
        if (AuditSearchResponse.presortedByTimestamp(sort)) {
            return false;
        }
        if (sort != null && !sort.isEmpty() && sort.get(0).isField()) {
            String fieldName = sort.get(0).field().field();
            return !fieldName.equals(AuditSearchRequest.ENTITY_ID.getKeywordFieldName()) || sort.size() != 1;
        }
        return true;
    }

    public static List<SortOptions> sortByTimestampFirst(List<SortOptions> sort) {
        if (sort == null || sort.isEmpty()) {
            return List.of(AuditSearchRequest.CREATED.order(SortOrder.Asc));
        }
        ArrayList<SortOptions> rewritten = new ArrayList<SortOptions>();
        rewritten.add(AuditSearchRequest.CREATED.order(SortOrder.Asc));
        for (SortOptions candidate : sort) {
            if (candidate.isField() && candidate.field().field().equals(AuditSearchRequest.CREATED.getNumericFieldName())) continue;
            rewritten.add(candidate);
        }
        return rewritten;
    }

    @Generated
    public AtlanClient getClient() {
        return this.client;
    }

    @Generated
    public AuditSearchRequest getRequest() {
        return this.request;
    }

    @Generated
    public List<EntityAudit> getEntityAudits() {
        return this.entityAudits;
    }

    @Generated
    public Map<String, AggregationResult> getAggregations() {
        return this.aggregations;
    }

    @Generated
    public Long getCount() {
        return this.count;
    }

    @Generated
    public Long getTotalCount() {
        return this.totalCount;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditSearchResponse)) {
            return false;
        }
        AuditSearchResponse other = (AuditSearchResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$count = this.getCount();
        Long other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        AtlanClient this$client = this.getClient();
        AtlanClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        AuditSearchRequest this$request = this.getRequest();
        AuditSearchRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        List<EntityAudit> this$entityAudits = this.getEntityAudits();
        List<EntityAudit> other$entityAudits = other.getEntityAudits();
        if (this$entityAudits == null ? other$entityAudits != null : !((Object)this$entityAudits).equals(other$entityAudits)) {
            return false;
        }
        Map<String, AggregationResult> this$aggregations = this.getAggregations();
        Map<String, AggregationResult> other$aggregations = other.getAggregations();
        return !(this$aggregations == null ? other$aggregations != null : !((Object)this$aggregations).equals(other$aggregations));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuditSearchResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        AtlanClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        AuditSearchRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        List<EntityAudit> $entityAudits = this.getEntityAudits();
        result = result * 59 + ($entityAudits == null ? 43 : ((Object)$entityAudits).hashCode());
        Map<String, AggregationResult> $aggregations = this.getAggregations();
        result = result * 59 + ($aggregations == null ? 43 : ((Object)$aggregations).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AuditSearchResponse(super=" + super.toString() + ", client=" + String.valueOf(this.getClient()) + ", request=" + String.valueOf(this.getRequest()) + ", entityAudits=" + String.valueOf(this.getEntityAudits()) + ", aggregations=" + String.valueOf(this.getAggregations()) + ", count=" + this.getCount() + ", totalCount=" + this.getTotalCount() + ")";
    }

    @JsonIgnore
    @Generated
    public void setClient(AtlanClient client) {
        this.client = client;
    }

    @JsonIgnore
    @Generated
    public void setRequest(AuditSearchRequest request) {
        this.request = request;
    }

    private static class AuditSearchResponseIterator
    implements Iterator<EntityAudit> {
        private AuditSearchResponse response;
        private int i;

        public AuditSearchResponseIterator(AuditSearchResponse response) {
            this.response = response;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.response.getEntityAudits() != null && this.response.getEntityAudits().size() > this.i) {
                return true;
            }
            try {
                this.response = this.response.getNextPage();
                this.i = 0;
                return this.response.getEntityAudits() != null && this.response.getEntityAudits().size() > this.i;
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to iterate through all pages of search results.", e);
            }
        }

        @Override
        public EntityAudit next() {
            return this.response.getEntityAudits().get(this.i++);
        }
    }

    private static class AuditSearchResponseBulkIterator
    implements Iterator<EntityAudit> {
        private AuditSearchResponse response;
        private final Set<String> processedGuids;
        private int i;

        public AuditSearchResponseBulkIterator(AuditSearchResponse response) {
            try {
                IndexSearchDSL dsl = response.getRequest().getDsl();
                if (AuditSearchResponse.presortedByTimestamp(dsl.getSort())) {
                    this.response = response;
                } else {
                    if (AuditSearchResponse.hasUserRequestedSort(dsl.getSort())) {
                        throw new IllegalArgumentException("Bulk searches can only be sorted by timestamp in ascending order - you must remove your own requested sorting to run a bulk search.");
                    }
                    this.response = response.getFirstPageTimestampOrdered();
                }
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to rewrite original query in preparation for iteration.", e);
            }
            this.processedGuids = new HashSet<String>();
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.response.getEntityAudits() == null) {
                return false;
            }
            if (this.response.getEntityAudits().size() > this.i) {
                EntityAudit candidate = this.response.getEntityAudits().get(this.i);
                if (candidate != null && !this.processedGuids.contains(candidate.getEventKey())) {
                    return true;
                }
                for (int j = this.i; j < this.response.getEntityAudits().size(); ++j) {
                    candidate = this.response.getEntityAudits().get(j);
                    if (candidate == null || this.processedGuids.contains(candidate.getEventKey())) continue;
                    this.i = j;
                    return true;
                }
            }
            try {
                this.response = this.response.getNextBulkPage();
                this.i = 0;
                return this.response.getEntityAudits() != null && this.response.getEntityAudits().size() > this.i;
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to iterate through all pages of search results.", e);
            }
        }

        @Override
        public EntityAudit next() {
            EntityAudit candidate = this.response.getEntityAudits().get(this.i++);
            this.processedGuids.add(candidate.getEventKey());
            return candidate;
        }
    }

    private static class AuditSearchResponseSpliterator
    implements Spliterator<EntityAudit> {
        private final AuditSearchResponse response;
        private long start;
        private final long end;
        private final long pageSize;
        private Spliterator<EntityAudit> firstPage;
        private Spliterator<EntityAudit> currentPage;

        AuditSearchResponseSpliterator(AuditSearchResponse response, long start, long end, long pageSize) {
            this.response = response;
            this.start = start;
            this.end = end;
            this.pageSize = pageSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super EntityAudit> action) {
            while (!this.ensurePage().tryAdvance(action)) {
                if (this.start >= this.end) {
                    return false;
                }
                this.currentPage = null;
            }
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super EntityAudit> action) {
            do {
                this.ensurePage().forEachRemaining(action);
                this.currentPage = null;
            } while (this.start < this.end);
        }

        @Override
        public Spliterator<EntityAudit> trySplit() {
            if (this.firstPage != null) {
                Spliterator<EntityAudit> fp = this.firstPage;
                this.firstPage = null;
                this.start = fp.getExactSizeIfKnown();
                return fp;
            }
            if (this.currentPage != null) {
                return this.currentPage.trySplit();
            }
            if (this.end - this.start > this.pageSize) {
                long mid = this.start + this.end >>> 1;
                if ((mid = mid / this.pageSize * this.pageSize) == this.start) {
                    mid += this.pageSize;
                }
                this.start = mid;
                return new AuditSearchResponseSpliterator(this.response, this.start, this.start, this.pageSize);
            }
            return this.ensurePage().trySplit();
        }

        private Spliterator<EntityAudit> ensurePage() {
            if (this.firstPage != null) {
                Spliterator<EntityAudit> fp = this.firstPage;
                this.firstPage = null;
                this.currentPage = fp;
                this.start = fp.getExactSizeIfKnown();
                return fp;
            }
            Spliterator<EntityAudit> sp = this.currentPage;
            if (sp == null) {
                List<EntityAudit> audits;
                if (this.start >= this.end) {
                    return Spliterators.emptySpliterator();
                }
                try {
                    audits = this.response.getSpecificPage((int)this.start, (int)Math.min(this.end - this.start, this.pageSize));
                }
                catch (AtlanException e) {
                    log.warn("Unable to fetch the specific page from {} to {}", new Object[]{this.start, Math.min(this.end - this.start, this.pageSize), e});
                    audits = Collections.emptyList();
                }
                sp = audits.spliterator();
                this.start = sp.getExactSizeIfKnown() > 0L ? (this.start += sp.getExactSizeIfKnown()) : (this.start += this.pageSize);
                this.currentPage = sp;
            }
            return sp;
        }

        @Override
        public long estimateSize() {
            if (this.currentPage != null) {
                return this.currentPage.estimateSize();
            }
            return this.end - this.start;
        }

        @Override
        public int characteristics() {
            return 1296;
        }
    }
}

