/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.UTMTags;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(builder=IndexSearchRequestBuilderImpl.class)
public class IndexSearchRequest
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    IndexSearchDSL dsl;
    List<String> attributes;
    List<String> relationAttributes;
    Boolean suppressLogs;
    Boolean showSearchScore;
    Boolean excludeMeanings;
    @JsonProperty(value="excludeClassifications")
    Boolean excludeAtlanTags;
    @JsonProperty(value="includeClassificationNames")
    Boolean includeAtlanTagNames;
    Boolean allowDeletedRelations;
    Boolean requestRelationshipAttrsForSearch;
    Metadata requestMetadata;
    Boolean showSearchMetadata;
    Boolean showHighlights;
    String persona;
    String purpose;

    public static IndexSearchRequestBuilder<?, ?> builder(Query query) {
        return IndexSearchRequest.builder(IndexSearchDSL.of(query));
    }

    public static IndexSearchRequestBuilder<?, ?> builder(IndexSearchDSL dsl) {
        return IndexSearchRequest._internal().dsl(dsl);
    }

    public IndexSearchResponse search(AtlanClient client) throws AtlanException {
        return client.assets.search(this);
    }

    @Generated
    private static Boolean $default$suppressLogs() {
        return true;
    }

    @Generated
    private static Boolean $default$showSearchScore() {
        return false;
    }

    @Generated
    private static Boolean $default$excludeMeanings() {
        return false;
    }

    @Generated
    private static Boolean $default$excludeAtlanTags() {
        return false;
    }

    @Generated
    private static Boolean $default$includeAtlanTagNames() {
        return true;
    }

    @Generated
    private static Boolean $default$allowDeletedRelations() {
        return false;
    }

    @Generated
    private static Boolean $default$requestRelationshipAttrsForSearch() {
        return false;
    }

    @Generated
    private static Metadata $default$requestMetadata() {
        return ((Metadata.MetadataBuilder)Metadata.builder().utmTag(UTMTags.PROJECT_SDK_JAVA.getValue())).build();
    }

    @Generated
    private static Boolean $default$showSearchMetadata() {
        return false;
    }

    @Generated
    private static Boolean $default$showHighlights() {
        return false;
    }

    @Generated
    protected IndexSearchRequest(IndexSearchRequestBuilder<?, ?> b) {
        super(b);
        this.dsl = b.dsl;
        this.attributes = switch (b.attributes == null ? 0 : b.attributes.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.attributes.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.attributes));
        };
        this.relationAttributes = switch (b.relationAttributes == null ? 0 : b.relationAttributes.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.relationAttributes.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.relationAttributes));
        };
        this.suppressLogs = b.suppressLogs$set ? b.suppressLogs$value : IndexSearchRequest.$default$suppressLogs();
        this.showSearchScore = b.showSearchScore$set ? b.showSearchScore$value : IndexSearchRequest.$default$showSearchScore();
        this.excludeMeanings = b.excludeMeanings$set ? b.excludeMeanings$value : IndexSearchRequest.$default$excludeMeanings();
        this.excludeAtlanTags = b.excludeAtlanTags$set ? b.excludeAtlanTags$value : IndexSearchRequest.$default$excludeAtlanTags();
        this.includeAtlanTagNames = b.includeAtlanTagNames$set ? b.includeAtlanTagNames$value : IndexSearchRequest.$default$includeAtlanTagNames();
        this.allowDeletedRelations = b.allowDeletedRelations$set ? b.allowDeletedRelations$value : IndexSearchRequest.$default$allowDeletedRelations();
        this.requestRelationshipAttrsForSearch = b.requestRelationshipAttrsForSearch$set ? b.requestRelationshipAttrsForSearch$value : IndexSearchRequest.$default$requestRelationshipAttrsForSearch();
        this.requestMetadata = b.requestMetadata$set ? b.requestMetadata$value : IndexSearchRequest.$default$requestMetadata();
        this.showSearchMetadata = b.showSearchMetadata$set ? b.showSearchMetadata$value : IndexSearchRequest.$default$showSearchMetadata();
        this.showHighlights = b.showHighlights$set ? b.showHighlights$value : IndexSearchRequest.$default$showHighlights();
        this.persona = b.persona;
        this.purpose = b.purpose;
    }

    @Generated
    public static IndexSearchRequestBuilder<?, ?> _internal() {
        return new IndexSearchRequestBuilderImpl();
    }

    @Generated
    public IndexSearchRequestBuilder<?, ?> toBuilder() {
        return new IndexSearchRequestBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public IndexSearchDSL getDsl() {
        return this.dsl;
    }

    @Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public List<String> getRelationAttributes() {
        return this.relationAttributes;
    }

    @Generated
    public Boolean getSuppressLogs() {
        return this.suppressLogs;
    }

    @Generated
    public Boolean getShowSearchScore() {
        return this.showSearchScore;
    }

    @Generated
    public Boolean getExcludeMeanings() {
        return this.excludeMeanings;
    }

    @Generated
    public Boolean getExcludeAtlanTags() {
        return this.excludeAtlanTags;
    }

    @Generated
    public Boolean getIncludeAtlanTagNames() {
        return this.includeAtlanTagNames;
    }

    @Generated
    public Boolean getAllowDeletedRelations() {
        return this.allowDeletedRelations;
    }

    @Generated
    public Boolean getRequestRelationshipAttrsForSearch() {
        return this.requestRelationshipAttrsForSearch;
    }

    @Generated
    public Metadata getRequestMetadata() {
        return this.requestMetadata;
    }

    @Generated
    public Boolean getShowSearchMetadata() {
        return this.showSearchMetadata;
    }

    @Generated
    public Boolean getShowHighlights() {
        return this.showHighlights;
    }

    @Generated
    public String getPersona() {
        return this.persona;
    }

    @Generated
    public String getPurpose() {
        return this.purpose;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexSearchRequest)) {
            return false;
        }
        IndexSearchRequest other = (IndexSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$suppressLogs = this.getSuppressLogs();
        Boolean other$suppressLogs = other.getSuppressLogs();
        if (this$suppressLogs == null ? other$suppressLogs != null : !((Object)this$suppressLogs).equals(other$suppressLogs)) {
            return false;
        }
        Boolean this$showSearchScore = this.getShowSearchScore();
        Boolean other$showSearchScore = other.getShowSearchScore();
        if (this$showSearchScore == null ? other$showSearchScore != null : !((Object)this$showSearchScore).equals(other$showSearchScore)) {
            return false;
        }
        Boolean this$excludeMeanings = this.getExcludeMeanings();
        Boolean other$excludeMeanings = other.getExcludeMeanings();
        if (this$excludeMeanings == null ? other$excludeMeanings != null : !((Object)this$excludeMeanings).equals(other$excludeMeanings)) {
            return false;
        }
        Boolean this$excludeAtlanTags = this.getExcludeAtlanTags();
        Boolean other$excludeAtlanTags = other.getExcludeAtlanTags();
        if (this$excludeAtlanTags == null ? other$excludeAtlanTags != null : !((Object)this$excludeAtlanTags).equals(other$excludeAtlanTags)) {
            return false;
        }
        Boolean this$includeAtlanTagNames = this.getIncludeAtlanTagNames();
        Boolean other$includeAtlanTagNames = other.getIncludeAtlanTagNames();
        if (this$includeAtlanTagNames == null ? other$includeAtlanTagNames != null : !((Object)this$includeAtlanTagNames).equals(other$includeAtlanTagNames)) {
            return false;
        }
        Boolean this$allowDeletedRelations = this.getAllowDeletedRelations();
        Boolean other$allowDeletedRelations = other.getAllowDeletedRelations();
        if (this$allowDeletedRelations == null ? other$allowDeletedRelations != null : !((Object)this$allowDeletedRelations).equals(other$allowDeletedRelations)) {
            return false;
        }
        Boolean this$requestRelationshipAttrsForSearch = this.getRequestRelationshipAttrsForSearch();
        Boolean other$requestRelationshipAttrsForSearch = other.getRequestRelationshipAttrsForSearch();
        if (this$requestRelationshipAttrsForSearch == null ? other$requestRelationshipAttrsForSearch != null : !((Object)this$requestRelationshipAttrsForSearch).equals(other$requestRelationshipAttrsForSearch)) {
            return false;
        }
        Boolean this$showSearchMetadata = this.getShowSearchMetadata();
        Boolean other$showSearchMetadata = other.getShowSearchMetadata();
        if (this$showSearchMetadata == null ? other$showSearchMetadata != null : !((Object)this$showSearchMetadata).equals(other$showSearchMetadata)) {
            return false;
        }
        Boolean this$showHighlights = this.getShowHighlights();
        Boolean other$showHighlights = other.getShowHighlights();
        if (this$showHighlights == null ? other$showHighlights != null : !((Object)this$showHighlights).equals(other$showHighlights)) {
            return false;
        }
        IndexSearchDSL this$dsl = this.getDsl();
        IndexSearchDSL other$dsl = other.getDsl();
        if (this$dsl == null ? other$dsl != null : !((Object)this$dsl).equals(other$dsl)) {
            return false;
        }
        List<String> this$attributes = this.getAttributes();
        List<String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        List<String> this$relationAttributes = this.getRelationAttributes();
        List<String> other$relationAttributes = other.getRelationAttributes();
        if (this$relationAttributes == null ? other$relationAttributes != null : !((Object)this$relationAttributes).equals(other$relationAttributes)) {
            return false;
        }
        Metadata this$requestMetadata = this.getRequestMetadata();
        Metadata other$requestMetadata = other.getRequestMetadata();
        if (this$requestMetadata == null ? other$requestMetadata != null : !((Object)this$requestMetadata).equals(other$requestMetadata)) {
            return false;
        }
        String this$persona = this.getPersona();
        String other$persona = other.getPersona();
        if (this$persona == null ? other$persona != null : !this$persona.equals(other$persona)) {
            return false;
        }
        String this$purpose = this.getPurpose();
        String other$purpose = other.getPurpose();
        return !(this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexSearchRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $suppressLogs = this.getSuppressLogs();
        result = result * 59 + ($suppressLogs == null ? 43 : ((Object)$suppressLogs).hashCode());
        Boolean $showSearchScore = this.getShowSearchScore();
        result = result * 59 + ($showSearchScore == null ? 43 : ((Object)$showSearchScore).hashCode());
        Boolean $excludeMeanings = this.getExcludeMeanings();
        result = result * 59 + ($excludeMeanings == null ? 43 : ((Object)$excludeMeanings).hashCode());
        Boolean $excludeAtlanTags = this.getExcludeAtlanTags();
        result = result * 59 + ($excludeAtlanTags == null ? 43 : ((Object)$excludeAtlanTags).hashCode());
        Boolean $includeAtlanTagNames = this.getIncludeAtlanTagNames();
        result = result * 59 + ($includeAtlanTagNames == null ? 43 : ((Object)$includeAtlanTagNames).hashCode());
        Boolean $allowDeletedRelations = this.getAllowDeletedRelations();
        result = result * 59 + ($allowDeletedRelations == null ? 43 : ((Object)$allowDeletedRelations).hashCode());
        Boolean $requestRelationshipAttrsForSearch = this.getRequestRelationshipAttrsForSearch();
        result = result * 59 + ($requestRelationshipAttrsForSearch == null ? 43 : ((Object)$requestRelationshipAttrsForSearch).hashCode());
        Boolean $showSearchMetadata = this.getShowSearchMetadata();
        result = result * 59 + ($showSearchMetadata == null ? 43 : ((Object)$showSearchMetadata).hashCode());
        Boolean $showHighlights = this.getShowHighlights();
        result = result * 59 + ($showHighlights == null ? 43 : ((Object)$showHighlights).hashCode());
        IndexSearchDSL $dsl = this.getDsl();
        result = result * 59 + ($dsl == null ? 43 : ((Object)$dsl).hashCode());
        List<String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        List<String> $relationAttributes = this.getRelationAttributes();
        result = result * 59 + ($relationAttributes == null ? 43 : ((Object)$relationAttributes).hashCode());
        Metadata $requestMetadata = this.getRequestMetadata();
        result = result * 59 + ($requestMetadata == null ? 43 : ((Object)$requestMetadata).hashCode());
        String $persona = this.getPersona();
        result = result * 59 + ($persona == null ? 43 : $persona.hashCode());
        String $purpose = this.getPurpose();
        result = result * 59 + ($purpose == null ? 43 : $purpose.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "IndexSearchRequest(super=" + super.toString() + ", dsl=" + String.valueOf(this.getDsl()) + ", attributes=" + String.valueOf(this.getAttributes()) + ", relationAttributes=" + String.valueOf(this.getRelationAttributes()) + ", suppressLogs=" + this.getSuppressLogs() + ", showSearchScore=" + this.getShowSearchScore() + ", excludeMeanings=" + this.getExcludeMeanings() + ", excludeAtlanTags=" + this.getExcludeAtlanTags() + ", includeAtlanTagNames=" + this.getIncludeAtlanTagNames() + ", allowDeletedRelations=" + this.getAllowDeletedRelations() + ", requestRelationshipAttrsForSearch=" + this.getRequestRelationshipAttrsForSearch() + ", requestMetadata=" + String.valueOf(this.getRequestMetadata()) + ", showSearchMetadata=" + this.getShowSearchMetadata() + ", showHighlights=" + this.getShowHighlights() + ", persona=" + this.getPersona() + ", purpose=" + this.getPurpose() + ")";
    }

    public static abstract class IndexSearchRequestBuilder<C extends IndexSearchRequest, B extends IndexSearchRequestBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private IndexSearchDSL dsl;
        @Generated
        private ArrayList<String> attributes;
        @Generated
        private ArrayList<String> relationAttributes;
        @Generated
        private boolean suppressLogs$set;
        @Generated
        private Boolean suppressLogs$value;
        @Generated
        private boolean showSearchScore$set;
        @Generated
        private Boolean showSearchScore$value;
        @Generated
        private boolean excludeMeanings$set;
        @Generated
        private Boolean excludeMeanings$value;
        @Generated
        private boolean excludeAtlanTags$set;
        @Generated
        private Boolean excludeAtlanTags$value;
        @Generated
        private boolean includeAtlanTagNames$set;
        @Generated
        private Boolean includeAtlanTagNames$value;
        @Generated
        private boolean allowDeletedRelations$set;
        @Generated
        private Boolean allowDeletedRelations$value;
        @Generated
        private boolean requestRelationshipAttrsForSearch$set;
        @Generated
        private Boolean requestRelationshipAttrsForSearch$value;
        @Generated
        private boolean requestMetadata$set;
        @Generated
        private Metadata requestMetadata$value;
        @Generated
        private boolean showSearchMetadata$set;
        @Generated
        private Boolean showSearchMetadata$value;
        @Generated
        private boolean showHighlights$set;
        @Generated
        private Boolean showHighlights$value;
        @Generated
        private String persona;
        @Generated
        private String purpose;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            IndexSearchRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(IndexSearchRequest instance, IndexSearchRequestBuilder<?, ?> b) {
            b.dsl(instance.dsl);
            b.attributes(instance.attributes == null ? Collections.emptyList() : instance.attributes);
            b.relationAttributes(instance.relationAttributes == null ? Collections.emptyList() : instance.relationAttributes);
            b.suppressLogs(instance.suppressLogs);
            b.showSearchScore(instance.showSearchScore);
            b.excludeMeanings(instance.excludeMeanings);
            b.excludeAtlanTags(instance.excludeAtlanTags);
            b.includeAtlanTagNames(instance.includeAtlanTagNames);
            b.allowDeletedRelations(instance.allowDeletedRelations);
            b.requestRelationshipAttrsForSearch(instance.requestRelationshipAttrsForSearch);
            b.requestMetadata(instance.requestMetadata);
            b.showSearchMetadata(instance.showSearchMetadata);
            b.showHighlights(instance.showHighlights);
            b.persona(instance.persona);
            b.purpose(instance.purpose);
        }

        @Generated
        public B dsl(IndexSearchDSL dsl) {
            this.dsl = dsl;
            return (B)this.self();
        }

        @Generated
        public B attribute(String attribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(attribute);
            return (B)this.self();
        }

        @Generated
        public B attributes(Collection<? extends String> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes cannot be null");
            }
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.addAll(attributes);
            return (B)this.self();
        }

        @Generated
        public B clearAttributes() {
            if (this.attributes != null) {
                this.attributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B relationAttribute(String relationAttribute) {
            if (this.relationAttributes == null) {
                this.relationAttributes = new ArrayList();
            }
            this.relationAttributes.add(relationAttribute);
            return (B)this.self();
        }

        @Generated
        public B relationAttributes(Collection<? extends String> relationAttributes) {
            if (relationAttributes == null) {
                throw new NullPointerException("relationAttributes cannot be null");
            }
            if (this.relationAttributes == null) {
                this.relationAttributes = new ArrayList();
            }
            this.relationAttributes.addAll(relationAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearRelationAttributes() {
            if (this.relationAttributes != null) {
                this.relationAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B suppressLogs(Boolean suppressLogs) {
            this.suppressLogs$value = suppressLogs;
            this.suppressLogs$set = true;
            return (B)this.self();
        }

        @Generated
        public B showSearchScore(Boolean showSearchScore) {
            this.showSearchScore$value = showSearchScore;
            this.showSearchScore$set = true;
            return (B)this.self();
        }

        @Generated
        public B excludeMeanings(Boolean excludeMeanings) {
            this.excludeMeanings$value = excludeMeanings;
            this.excludeMeanings$set = true;
            return (B)this.self();
        }

        @JsonProperty(value="excludeClassifications")
        @Generated
        public B excludeAtlanTags(Boolean excludeAtlanTags) {
            this.excludeAtlanTags$value = excludeAtlanTags;
            this.excludeAtlanTags$set = true;
            return (B)this.self();
        }

        @JsonProperty(value="includeClassificationNames")
        @Generated
        public B includeAtlanTagNames(Boolean includeAtlanTagNames) {
            this.includeAtlanTagNames$value = includeAtlanTagNames;
            this.includeAtlanTagNames$set = true;
            return (B)this.self();
        }

        @Generated
        public B allowDeletedRelations(Boolean allowDeletedRelations) {
            this.allowDeletedRelations$value = allowDeletedRelations;
            this.allowDeletedRelations$set = true;
            return (B)this.self();
        }

        @Generated
        public B requestRelationshipAttrsForSearch(Boolean requestRelationshipAttrsForSearch) {
            this.requestRelationshipAttrsForSearch$value = requestRelationshipAttrsForSearch;
            this.requestRelationshipAttrsForSearch$set = true;
            return (B)this.self();
        }

        @Generated
        public B requestMetadata(Metadata requestMetadata) {
            this.requestMetadata$value = requestMetadata;
            this.requestMetadata$set = true;
            return (B)this.self();
        }

        @Generated
        public B showSearchMetadata(Boolean showSearchMetadata) {
            this.showSearchMetadata$value = showSearchMetadata;
            this.showSearchMetadata$set = true;
            return (B)this.self();
        }

        @Generated
        public B showHighlights(Boolean showHighlights) {
            this.showHighlights$value = showHighlights;
            this.showHighlights$set = true;
            return (B)this.self();
        }

        @Generated
        public B persona(String persona) {
            this.persona = persona;
            return (B)this.self();
        }

        @Generated
        public B purpose(String purpose) {
            this.purpose = purpose;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "IndexSearchRequest.IndexSearchRequestBuilder(super=" + super.toString() + ", dsl=" + String.valueOf(this.dsl) + ", attributes=" + String.valueOf(this.attributes) + ", relationAttributes=" + String.valueOf(this.relationAttributes) + ", suppressLogs$value=" + this.suppressLogs$value + ", showSearchScore$value=" + this.showSearchScore$value + ", excludeMeanings$value=" + this.excludeMeanings$value + ", excludeAtlanTags$value=" + this.excludeAtlanTags$value + ", includeAtlanTagNames$value=" + this.includeAtlanTagNames$value + ", allowDeletedRelations$value=" + this.allowDeletedRelations$value + ", requestRelationshipAttrsForSearch$value=" + this.requestRelationshipAttrsForSearch$value + ", requestMetadata$value=" + String.valueOf(this.requestMetadata$value) + ", showSearchMetadata$value=" + this.showSearchMetadata$value + ", showHighlights$value=" + this.showHighlights$value + ", persona=" + this.persona + ", purpose=" + this.purpose + ")";
        }
    }

    @JsonDeserialize(builder=MetadataBuilderImpl.class)
    public static final class Metadata
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        Boolean saveSearchLog;
        List<String> utmTags;
        String searchInput;

        @Generated
        private static Boolean $default$saveSearchLog() {
            return false;
        }

        @Generated
        protected Metadata(MetadataBuilder<?, ?> b) {
            super(b);
            this.saveSearchLog = b.saveSearchLog$set ? b.saveSearchLog$value : Metadata.$default$saveSearchLog();
            this.utmTags = switch (b.utmTags == null ? 0 : b.utmTags.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.utmTags.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(b.utmTags));
            };
            this.searchInput = b.searchInput;
        }

        @Generated
        public static MetadataBuilder<?, ?> builder() {
            return new MetadataBuilderImpl();
        }

        @Generated
        public MetadataBuilder<?, ?> toBuilder() {
            return new MetadataBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public Boolean getSaveSearchLog() {
            return this.saveSearchLog;
        }

        @Generated
        public List<String> getUtmTags() {
            return this.utmTags;
        }

        @Generated
        public String getSearchInput() {
            return this.searchInput;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata other = (Metadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$saveSearchLog = this.getSaveSearchLog();
            Boolean other$saveSearchLog = other.getSaveSearchLog();
            if (this$saveSearchLog == null ? other$saveSearchLog != null : !((Object)this$saveSearchLog).equals(other$saveSearchLog)) {
                return false;
            }
            List<String> this$utmTags = this.getUtmTags();
            List<String> other$utmTags = other.getUtmTags();
            if (this$utmTags == null ? other$utmTags != null : !((Object)this$utmTags).equals(other$utmTags)) {
                return false;
            }
            String this$searchInput = this.getSearchInput();
            String other$searchInput = other.getSearchInput();
            return !(this$searchInput == null ? other$searchInput != null : !this$searchInput.equals(other$searchInput));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Metadata;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $saveSearchLog = this.getSaveSearchLog();
            result = result * 59 + ($saveSearchLog == null ? 43 : ((Object)$saveSearchLog).hashCode());
            List<String> $utmTags = this.getUtmTags();
            result = result * 59 + ($utmTags == null ? 43 : ((Object)$utmTags).hashCode());
            String $searchInput = this.getSearchInput();
            result = result * 59 + ($searchInput == null ? 43 : $searchInput.hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "IndexSearchRequest.Metadata(super=" + super.toString() + ", saveSearchLog=" + this.getSaveSearchLog() + ", utmTags=" + String.valueOf(this.getUtmTags()) + ", searchInput=" + this.getSearchInput() + ")";
        }

        @Generated
        public static abstract class MetadataBuilder<C extends Metadata, B extends MetadataBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private boolean saveSearchLog$set;
            @Generated
            private Boolean saveSearchLog$value;
            @Generated
            private ArrayList<String> utmTags;
            @Generated
            private String searchInput;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                MetadataBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Metadata instance, MetadataBuilder<?, ?> b) {
                b.saveSearchLog(instance.saveSearchLog);
                b.utmTags(instance.utmTags == null ? Collections.emptyList() : instance.utmTags);
                b.searchInput(instance.searchInput);
            }

            @Generated
            public B saveSearchLog(Boolean saveSearchLog) {
                this.saveSearchLog$value = saveSearchLog;
                this.saveSearchLog$set = true;
                return (B)this.self();
            }

            @Generated
            public B utmTag(String utmTag) {
                if (this.utmTags == null) {
                    this.utmTags = new ArrayList();
                }
                this.utmTags.add(utmTag);
                return (B)this.self();
            }

            @Generated
            public B utmTags(Collection<? extends String> utmTags) {
                if (utmTags == null) {
                    throw new NullPointerException("utmTags cannot be null");
                }
                if (this.utmTags == null) {
                    this.utmTags = new ArrayList();
                }
                this.utmTags.addAll(utmTags);
                return (B)this.self();
            }

            @Generated
            public B clearUtmTags() {
                if (this.utmTags != null) {
                    this.utmTags.clear();
                }
                return (B)this.self();
            }

            @Generated
            public B searchInput(String searchInput) {
                this.searchInput = searchInput;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "IndexSearchRequest.Metadata.MetadataBuilder(super=" + super.toString() + ", saveSearchLog$value=" + this.saveSearchLog$value + ", utmTags=" + String.valueOf(this.utmTags) + ", searchInput=" + this.searchInput + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class MetadataBuilderImpl
        extends MetadataBuilder<Metadata, MetadataBuilderImpl> {
            @Generated
            private MetadataBuilderImpl() {
            }

            @Override
            @Generated
            protected MetadataBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Metadata build() {
                return new Metadata(this);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class IndexSearchRequestBuilderImpl
    extends IndexSearchRequestBuilder<IndexSearchRequest, IndexSearchRequestBuilderImpl> {
        @Generated
        private IndexSearchRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected IndexSearchRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public IndexSearchRequest build() {
            return new IndexSearchRequest(this);
        }
    }
}

