/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.LogicException;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.search.AggregationResult;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.SearchParameters;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSearchResponse
extends ApiResource
implements Iterable<Asset> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexSearchResponse.class);
    private static final long serialVersionUID = 2L;
    private static final long MASS_EXTRACT_THRESHOLD = 99700L;
    private static final int CHARACTERISTICS = 1296;
    @JsonIgnore
    AtlanClient client;
    String queryType;
    SearchParameters searchParameters;
    @JsonProperty(value="entities")
    List<Asset> assets;
    Long approximateCount;
    Map<String, Metadata> searchMetadata;
    Map<String, AggregationResult> aggregations;

    @JsonIgnore
    public IndexSearchResponse getNextPage() throws AtlanException {
        AtlanObject dsl = this.getQuery();
        int from = dsl.getFrom() == null ? 0 : dsl.getFrom();
        int page = dsl.getSize() == null ? 300 : dsl.getSize();
        dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(from + page)).build();
        IndexSearchRequest.IndexSearchRequestBuilder<Object, Object> next = IndexSearchRequest.builder(dsl);
        if (this.searchParameters.getAttributes() != null) {
            next = next.attributes(this.searchParameters.getAttributes());
        }
        if (this.searchParameters.getRelationAttributes() != null) {
            next = next.relationAttributes(this.searchParameters.getRelationAttributes());
        }
        return ((IndexSearchRequest)next.build()).search(this.client);
    }

    @JsonIgnore
    protected IndexSearchResponse getNextBulkPage() throws AtlanException {
        if (this.getAssets() == null) {
            return this;
        }
        AtlanObject dsl = this.getQuery();
        int page = dsl.getSize() == null ? 300 : dsl.getSize();
        List<Asset> results = this.getAssets();
        Asset last = results.get(results.size() - 1);
        Metadata offsets = this.getSearchMetadata().get(last.getGuid());
        dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(0)).size(page)).clearPageOffsets()).pageOffsets(offsets.getSorts())).build();
        IndexSearchRequest.IndexSearchRequestBuilder<Object, Object> next = IndexSearchRequest.builder(dsl);
        if (this.searchParameters.getAttributes() != null) {
            next = next.attributes(this.searchParameters.getAttributes());
        }
        if (this.searchParameters.getRelationAttributes() != null) {
            next = next.relationAttributes(this.searchParameters.getRelationAttributes());
        }
        return ((IndexSearchRequest)((IndexSearchRequest.IndexSearchRequestBuilder)next.showSearchMetadata(true)).build()).search(this.client);
    }

    private IndexSearchResponse getFirstPageTimestampOrdered() throws AtlanException {
        AtlanObject dsl = this.getQuery();
        List<SortOptions> revisedSort = IndexSearchResponse.sortByTimestampFirst(dsl.getSort());
        int page = dsl.getSize() == null ? 300 : dsl.getSize();
        dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(0)).size(page)).clearSort()).sort(revisedSort)).build();
        IndexSearchRequest.IndexSearchRequestBuilder<Object, Object> first = IndexSearchRequest.builder(dsl);
        if (this.searchParameters.getAttributes() != null) {
            first = first.attributes(this.searchParameters.getAttributes());
        }
        if (this.searchParameters.getRelationAttributes() != null) {
            first = first.relationAttributes(this.searchParameters.getRelationAttributes());
        }
        return ((IndexSearchRequest)((IndexSearchRequest.IndexSearchRequestBuilder)first.showSearchMetadata(true)).build()).search(this.client);
    }

    @JsonIgnore
    public List<Asset> getSpecificPage(int offset, int pageSize) throws AtlanException {
        IndexSearchResponse response;
        AtlanObject dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)this.getQuery().toBuilder().from(offset)).size(pageSize)).build();
        IndexSearchRequest.IndexSearchRequestBuilder<Object, Object> next = IndexSearchRequest.builder((IndexSearchDSL)dsl);
        if (this.searchParameters.getAttributes() != null) {
            next = next.attributes(this.searchParameters.getAttributes());
        }
        if (this.searchParameters.getRelationAttributes() != null) {
            next = next.relationAttributes(this.searchParameters.getRelationAttributes());
        }
        if ((response = ((IndexSearchRequest)next.build()).search(this.client)) != null && response.getAssets() != null) {
            return response.getAssets();
        }
        return Collections.emptyList();
    }

    @Override
    public Iterator<Asset> iterator() {
        return new IndexSearchResponseIterator(this);
    }

    public Iterator<Asset> biterator() {
        return new IndexSearchResponseBulkIterator(this);
    }

    @Override
    public Spliterator<Asset> spliterator() {
        long pageSize;
        try {
            pageSize = this.getQuery().getSize().intValue();
        }
        catch (LogicException e) {
            log.warn("Unable to parse page size from query, falling back to {}.", (Object)300, (Object)e);
            pageSize = 300L;
        }
        IndexSearchResponseSpliterator spliterator = new IndexSearchResponseSpliterator(this, 0L, this.getApproximateCount(), pageSize);
        List<Object> assets = this.getAssets() == null ? Collections.emptyList() : this.getAssets();
        spliterator.firstPage = assets.spliterator();
        return spliterator;
    }

    public Stream<Asset> stream() {
        if (this.approximateCount > 99700L) {
            log.debug("Results size exceeds threshold ({}), rewriting stream as a bulk stream (ignoring original sorting).", (Object)99700L);
            return this.bulkStream();
        }
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.approximateCount, 1296), false);
    }

    public Stream<Asset> bulkStream() {
        return StreamSupport.stream(Spliterators.spliterator(this.biterator(), (long)this.approximateCount, 1296), false);
    }

    public Stream<Asset> parallelStream() {
        if (this.approximateCount > 99700L) {
            log.debug("Results size exceeds threshold ({}), ignoring request for parallelized streaming and falling back to bulk streaming.", (Object)99700L);
            return this.bulkStream();
        }
        return StreamSupport.stream(this::spliterator, 1296, true);
    }

    @JsonIgnore
    public IndexSearchDSL getQuery() throws LogicException {
        try {
            return this.client.readValue(this.searchParameters.getQuery(), IndexSearchDSL.class);
        }
        catch (IOException e) {
            throw new LogicException(ErrorCode.UNABLE_TO_PARSE_ORIGINAL_QUERY, (Throwable)e);
        }
    }

    public static boolean presortedByTimestamp(List<SortOptions> sort) {
        return sort != null && !sort.isEmpty() && sort.get(0).isField() && sort.get(0).field().field().equals(Asset.CREATE_TIME.getInternalFieldName()) && sort.get(0).field().order() == SortOrder.Asc;
    }

    public static boolean readyForSearchAfter(IndexSearchResponse response) {
        return response.getSearchMetadata() != null && !response.getSearchMetadata().isEmpty();
    }

    public static boolean hasUserRequestedSort(List<SortOptions> sort) {
        if (IndexSearchResponse.presortedByTimestamp(sort)) {
            return false;
        }
        if (sort != null && !sort.isEmpty() && sort.get(0).isField()) {
            String fieldName = sort.get(0).field().field();
            return !fieldName.equals(Asset.GUID.getInternalFieldName()) || sort.size() != 1;
        }
        return true;
    }

    public static List<SortOptions> sortByTimestampFirst(List<SortOptions> sort) {
        if (sort == null || sort.isEmpty()) {
            return List.of(Asset.CREATE_TIME.order(SortOrder.Asc));
        }
        ArrayList<SortOptions> rewritten = new ArrayList<SortOptions>();
        rewritten.add(Asset.CREATE_TIME.order(SortOrder.Asc));
        for (SortOptions candidate : sort) {
            if (candidate.isField() && candidate.field().field().equals(Asset.CREATE_TIME.getInternalFieldName())) continue;
            rewritten.add(candidate);
        }
        return rewritten;
    }

    @Generated
    public AtlanClient getClient() {
        return this.client;
    }

    @Generated
    public String getQueryType() {
        return this.queryType;
    }

    @Generated
    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    @Generated
    public List<Asset> getAssets() {
        return this.assets;
    }

    @Generated
    public Long getApproximateCount() {
        return this.approximateCount;
    }

    @Generated
    public Map<String, Metadata> getSearchMetadata() {
        return this.searchMetadata;
    }

    @Generated
    public Map<String, AggregationResult> getAggregations() {
        return this.aggregations;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexSearchResponse)) {
            return false;
        }
        IndexSearchResponse other = (IndexSearchResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$approximateCount = this.getApproximateCount();
        Long other$approximateCount = other.getApproximateCount();
        if (this$approximateCount == null ? other$approximateCount != null : !((Object)this$approximateCount).equals(other$approximateCount)) {
            return false;
        }
        AtlanClient this$client = this.getClient();
        AtlanClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$queryType = this.getQueryType();
        String other$queryType = other.getQueryType();
        if (this$queryType == null ? other$queryType != null : !this$queryType.equals(other$queryType)) {
            return false;
        }
        SearchParameters this$searchParameters = this.getSearchParameters();
        SearchParameters other$searchParameters = other.getSearchParameters();
        if (this$searchParameters == null ? other$searchParameters != null : !((Object)this$searchParameters).equals(other$searchParameters)) {
            return false;
        }
        List<Asset> this$assets = this.getAssets();
        List<Asset> other$assets = other.getAssets();
        if (this$assets == null ? other$assets != null : !((Object)this$assets).equals(other$assets)) {
            return false;
        }
        Map<String, Metadata> this$searchMetadata = this.getSearchMetadata();
        Map<String, Metadata> other$searchMetadata = other.getSearchMetadata();
        if (this$searchMetadata == null ? other$searchMetadata != null : !((Object)this$searchMetadata).equals(other$searchMetadata)) {
            return false;
        }
        Map<String, AggregationResult> this$aggregations = this.getAggregations();
        Map<String, AggregationResult> other$aggregations = other.getAggregations();
        return !(this$aggregations == null ? other$aggregations != null : !((Object)this$aggregations).equals(other$aggregations));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexSearchResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $approximateCount = this.getApproximateCount();
        result = result * 59 + ($approximateCount == null ? 43 : ((Object)$approximateCount).hashCode());
        AtlanClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $queryType = this.getQueryType();
        result = result * 59 + ($queryType == null ? 43 : $queryType.hashCode());
        SearchParameters $searchParameters = this.getSearchParameters();
        result = result * 59 + ($searchParameters == null ? 43 : ((Object)$searchParameters).hashCode());
        List<Asset> $assets = this.getAssets();
        result = result * 59 + ($assets == null ? 43 : ((Object)$assets).hashCode());
        Map<String, Metadata> $searchMetadata = this.getSearchMetadata();
        result = result * 59 + ($searchMetadata == null ? 43 : ((Object)$searchMetadata).hashCode());
        Map<String, AggregationResult> $aggregations = this.getAggregations();
        result = result * 59 + ($aggregations == null ? 43 : ((Object)$aggregations).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "IndexSearchResponse(super=" + super.toString() + ", client=" + String.valueOf(this.getClient()) + ", queryType=" + this.getQueryType() + ", searchParameters=" + String.valueOf(this.getSearchParameters()) + ", assets=" + String.valueOf(this.getAssets()) + ", approximateCount=" + this.getApproximateCount() + ", searchMetadata=" + String.valueOf(this.getSearchMetadata()) + ", aggregations=" + String.valueOf(this.getAggregations()) + ")";
    }

    @JsonIgnore
    @Generated
    public void setClient(AtlanClient client) {
        this.client = client;
    }

    @JsonDeserialize(builder=MetadataBuilderImpl.class)
    public static final class Metadata
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        Object highlights;
        @JsonProperty(value="sort")
        List<Object> sorts;

        @Generated
        protected Metadata(MetadataBuilder<?, ?> b) {
            super(b);
            this.highlights = b.highlights;
            this.sorts = switch (b.sorts == null ? 0 : b.sorts.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.sorts.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Object>(b.sorts));
            };
        }

        @Generated
        public static MetadataBuilder<?, ?> builder() {
            return new MetadataBuilderImpl();
        }

        @Generated
        public MetadataBuilder<?, ?> toBuilder() {
            return new MetadataBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public Object getHighlights() {
            return this.highlights;
        }

        @Generated
        public List<Object> getSorts() {
            return this.sorts;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata other = (Metadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Object this$highlights = this.getHighlights();
            Object other$highlights = other.getHighlights();
            if (this$highlights == null ? other$highlights != null : !this$highlights.equals(other$highlights)) {
                return false;
            }
            List<Object> this$sorts = this.getSorts();
            List<Object> other$sorts = other.getSorts();
            return !(this$sorts == null ? other$sorts != null : !((Object)this$sorts).equals(other$sorts));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Metadata;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Object $highlights = this.getHighlights();
            result = result * 59 + ($highlights == null ? 43 : $highlights.hashCode());
            List<Object> $sorts = this.getSorts();
            result = result * 59 + ($sorts == null ? 43 : ((Object)$sorts).hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "IndexSearchResponse.Metadata(super=" + super.toString() + ", highlights=" + String.valueOf(this.getHighlights()) + ", sorts=" + String.valueOf(this.getSorts()) + ")";
        }

        @Generated
        public static abstract class MetadataBuilder<C extends Metadata, B extends MetadataBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private Object highlights;
            @Generated
            private ArrayList<Object> sorts;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                MetadataBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Metadata instance, MetadataBuilder<?, ?> b) {
                b.highlights(instance.highlights);
                b.sorts(instance.sorts == null ? Collections.emptyList() : instance.sorts);
            }

            @Generated
            public B highlights(Object highlights) {
                this.highlights = highlights;
                return (B)this.self();
            }

            @Generated
            public B sort(Object sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return (B)this.self();
            }

            @JsonProperty(value="sort")
            @Generated
            public B sorts(Collection<? extends Object> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return (B)this.self();
            }

            @Generated
            public B clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "IndexSearchResponse.Metadata.MetadataBuilder(super=" + super.toString() + ", highlights=" + String.valueOf(this.highlights) + ", sorts=" + String.valueOf(this.sorts) + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class MetadataBuilderImpl
        extends MetadataBuilder<Metadata, MetadataBuilderImpl> {
            @Generated
            private MetadataBuilderImpl() {
            }

            @Override
            @Generated
            protected MetadataBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Metadata build() {
                return new Metadata(this);
            }
        }
    }

    private static class IndexSearchResponseIterator
    implements Iterator<Asset> {
        private IndexSearchResponse response;
        private int i;

        public IndexSearchResponseIterator(IndexSearchResponse response) {
            this.response = response;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.response.getAssets() != null && this.response.getAssets().size() > this.i) {
                return true;
            }
            try {
                this.response = this.response.getNextPage();
                this.i = 0;
                return this.response.getAssets() != null && this.response.getAssets().size() > this.i;
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to iterate through all pages of search results.", e);
            }
        }

        @Override
        public Asset next() {
            return this.response.getAssets().get(this.i++);
        }
    }

    private static class IndexSearchResponseBulkIterator
    implements Iterator<Asset> {
        private IndexSearchResponse response;
        private int i;

        public IndexSearchResponseBulkIterator(IndexSearchResponse response) {
            try {
                IndexSearchDSL dsl = response.getQuery();
                if (IndexSearchResponse.presortedByTimestamp(dsl.getSort()) && IndexSearchResponse.readyForSearchAfter(response)) {
                    this.response = response;
                } else {
                    if (IndexSearchResponse.hasUserRequestedSort(dsl.getSort())) {
                        throw new IllegalArgumentException("Bulk searches can only be sorted by timestamp in ascending order - you must remove your own requested sorting to run a bulk search.");
                    }
                    this.response = response.getFirstPageTimestampOrdered();
                }
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to rewrite original query in preparation for iteration.", e);
            }
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            Asset candidate;
            if (this.response.getAssets() == null) {
                return false;
            }
            if (this.response.getAssets().size() > this.i && (candidate = this.response.getAssets().get(this.i)) != null) {
                return true;
            }
            try {
                this.response = this.response.getNextBulkPage();
                this.i = 0;
                return this.response.getAssets() != null && this.response.getAssets().size() > this.i;
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to iterate through all pages of search results.", e);
            }
        }

        @Override
        public Asset next() {
            return this.response.getAssets().get(this.i++);
        }
    }

    private static class IndexSearchResponseSpliterator
    implements Spliterator<Asset> {
        private final IndexSearchResponse response;
        private long start;
        private final long end;
        private final long pageSize;
        private Spliterator<Asset> firstPage;
        private Spliterator<Asset> currentPage;

        IndexSearchResponseSpliterator(IndexSearchResponse response, long start, long end, long pageSize) {
            this.response = response;
            this.start = start;
            this.end = end;
            this.pageSize = pageSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Asset> action) {
            while (!this.ensurePage().tryAdvance(action)) {
                if (this.start >= this.end) {
                    return false;
                }
                this.currentPage = null;
            }
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super Asset> action) {
            do {
                this.ensurePage().forEachRemaining(action);
                this.currentPage = null;
            } while (this.start < this.end);
        }

        @Override
        public Spliterator<Asset> trySplit() {
            if (this.firstPage != null) {
                Spliterator<Asset> fp = this.firstPage;
                this.firstPage = null;
                this.start = fp.getExactSizeIfKnown();
                return fp;
            }
            if (this.currentPage != null) {
                return this.currentPage.trySplit();
            }
            if (this.end - this.start > this.pageSize) {
                long mid = this.start + this.end >>> 1;
                if ((mid = mid / this.pageSize * this.pageSize) == this.start) {
                    mid += this.pageSize;
                }
                this.start = mid;
                return new IndexSearchResponseSpliterator(this.response, this.start, this.start, this.pageSize);
            }
            return this.ensurePage().trySplit();
        }

        private Spliterator<Asset> ensurePage() {
            if (this.firstPage != null) {
                Spliterator<Asset> fp = this.firstPage;
                this.firstPage = null;
                this.currentPage = fp;
                this.start = fp.getExactSizeIfKnown();
                return fp;
            }
            Spliterator<Asset> sp = this.currentPage;
            if (sp == null) {
                List<Asset> assets;
                if (this.start >= this.end) {
                    return Spliterators.emptySpliterator();
                }
                try {
                    assets = this.response.getSpecificPage((int)this.start, (int)Math.min(this.end - this.start, this.pageSize));
                }
                catch (AtlanException e) {
                    log.warn("Unable to fetch the specific page from {} to {}", new Object[]{this.start, Math.min(this.end - this.start, this.pageSize), e});
                    assets = Collections.emptyList();
                }
                sp = assets.spliterator();
                this.start = sp.getExactSizeIfKnown() > 0L ? (this.start += sp.getExactSizeIfKnown()) : (this.start += this.pageSize);
                this.currentPage = sp;
            }
            return sp;
        }

        @Override
        public long estimateSize() {
            if (this.currentPage != null) {
                return this.currentPage.estimateSize();
            }
            return this.end - this.start;
        }

        @Override
        public int characteristics() {
            return 1296;
        }
    }
}

