/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.util.NamedValue;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.UTMTags;
import com.atlan.model.search.AggregationBucketDetails;
import com.atlan.model.search.AggregationBucketResult;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.SearchLogEntry;
import com.atlan.model.search.SearchLogRequest;
import com.atlan.model.search.SearchLogResponse;
import com.atlan.model.search.aggregates.AssetViews;
import com.atlan.model.search.aggregates.UserViews;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;

public class SearchLog
extends CompoundQuery {
    public static final List<String> EXCLUDE_USERS = List.of("support", "atlansupport");
    public static final Query VIEWED = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FluentSearch._internal().whereSome(SearchLogEntry.UTM_TAGS.eq(UTMTags.UI_PROFILE))).whereSome(SearchLogEntry.UTM_TAGS.eq(UTMTags.UI_SIDEBAR))).minSomes(1)).build().toQuery();
    public static final Query SEARCHED = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FluentSearch._internal().whereSome(SearchLogEntry.UTM_TAGS.eq(UTMTags.UI_MAIN_LIST))).whereSome(SearchLogEntry.UTM_TAGS.eq(UTMTags.UI_SEARCHBAR))).minSomes(1)).build().toQuery();
    List<SortOptions> sorts;
    Map<String, Aggregation> aggregations;
    Integer pageSize;

    public static SearchLogBuilder<?, ?> builder(AtlanClient client) {
        return (SearchLogBuilder)SearchLog._internal().client(client);
    }

    public static SearchLogBuilder<?, ?> views(AtlanClient client) {
        return SearchLog.views(client, null);
    }

    public static SearchLogBuilder<?, ?> views(AtlanClient client, List<String> excludeUsers) {
        return SearchLog.views(client, -1L, -1L, excludeUsers);
    }

    public static SearchLogBuilder<?, ?> views(AtlanClient client, long from, long to) {
        return SearchLog.views(client, from, to, null);
    }

    public static SearchLogBuilder<?, ?> views(AtlanClient client, long from, long to, List<String> excludeUsers) {
        ArrayList<String> exclusion = new ArrayList<String>(EXCLUDE_USERS);
        if (excludeUsers != null) {
            exclusion.addAll(excludeUsers);
        }
        SearchLogBuilder builder = (SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)SearchLog.builder(client).where(SearchLogEntry.UTM_TAGS.eq(UTMTags.ACTION_ASSET_VIEWED))).where(VIEWED)).whereNot(SearchLogEntry.USER.in(exclusion))).whereNot(SearchLogEntry.USER.startsWith("service-account-"));
        if (from > 0L && to > 0L) {
            builder.where(((SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)SearchLog._internal().whereSome(SearchLogEntry.LOGGED_AT.between(from, to))).whereSome(SearchLogEntry.SEARCHED_AT.between(from, to))).minSomes(1)).build().toQuery());
        } else if (from > 0L) {
            builder.where(((SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)SearchLog._internal().whereSome(SearchLogEntry.LOGGED_AT.gte(from))).whereSome(SearchLogEntry.SEARCHED_AT.gte(from))).minSomes(1)).build().toQuery());
        } else if (to > 0L) {
            builder.where(((SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)SearchLog._internal().whereSome(SearchLogEntry.LOGGED_AT.lte(to))).whereSome(SearchLogEntry.SEARCHED_AT.lte(to))).minSomes(1)).build().toQuery());
        }
        return builder;
    }

    public static SearchLogBuilder<?, ?> searches(AtlanClient client) {
        return SearchLog.searches(client, null);
    }

    public static SearchLogBuilder<?, ?> searches(AtlanClient client, List<String> excludeUsers) {
        return SearchLog.searches(client, -1L, -1L, excludeUsers);
    }

    public static SearchLogBuilder<?, ?> searches(AtlanClient client, long from, long to) {
        return SearchLog.searches(client, from, to, null);
    }

    public static SearchLogBuilder<?, ?> searches(AtlanClient client, long from, long to, List<String> excludeUsers) {
        ArrayList<String> exclusion = new ArrayList<String>(EXCLUDE_USERS);
        if (excludeUsers != null) {
            exclusion.addAll(excludeUsers);
        }
        SearchLogBuilder builder = (SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)SearchLog.builder(client).where(SearchLogEntry.UTM_TAGS.eq(UTMTags.ACTION_SEARCHED))).where(SEARCHED)).whereNot(SearchLogEntry.USER.in(exclusion))).whereNot(SearchLogEntry.USER.startsWith("service-account-"));
        if (from > 0L && to > 0L) {
            builder.where(((SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)SearchLog._internal().whereSome(SearchLogEntry.LOGGED_AT.between(from, to))).whereSome(SearchLogEntry.SEARCHED_AT.between(from, to))).minSomes(1)).build().toQuery());
        } else if (from > 0L) {
            builder.where(((SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)SearchLog._internal().whereSome(SearchLogEntry.LOGGED_AT.gte(from))).whereSome(SearchLogEntry.SEARCHED_AT.gte(from))).minSomes(1)).build().toQuery());
        } else if (to > 0L) {
            builder.where(((SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)SearchLog._internal().whereSome(SearchLogEntry.LOGGED_AT.lte(to))).whereSome(SearchLogEntry.SEARCHED_AT.lte(to))).minSomes(1)).build().toQuery());
        }
        return builder;
    }

    public static SearchLogBuilder<?, ?> viewsByGuid(AtlanClient client, String guid) {
        return SearchLog.viewsByGuid(client, guid, null);
    }

    public static SearchLogBuilder<?, ?> viewsByGuid(AtlanClient client, String guid, List<String> excludeUsers) {
        ArrayList<String> exclusion = new ArrayList<String>(EXCLUDE_USERS);
        if (excludeUsers != null) {
            exclusion.addAll(excludeUsers);
        }
        return (SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)SearchLog.builder(client).where(SearchLogEntry.UTM_TAGS.eq(UTMTags.ACTION_ASSET_VIEWED))).where(SearchLogEntry.ENTITY_ID.eq(guid))).where(VIEWED)).whereNot(SearchLogEntry.USER.in(exclusion));
    }

    public static List<UserViews> mostRecentViewers(AtlanClient client, String guid, int maxUsers) throws AtlanException {
        return SearchLog.mostRecentViewers(client, guid, maxUsers, null);
    }

    public static List<UserViews> mostRecentViewers(AtlanClient client, String guid, int maxUsers, List<String> excludeUsers) throws AtlanException {
        ArrayList<UserViews> list = new ArrayList<UserViews>();
        Aggregation byUser = SearchLogEntry.USER.bucketBy(maxUsers, Map.of("latestTimestamp", SearchLogEntry.SEARCHED_AT.max()), List.of(NamedValue.of((String)"latestTimestamp", (Object)SortOrder.Desc)));
        SearchLogRequest request = ((SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)SearchLog.viewsByGuid(client, guid, excludeUsers).aggregate("uniqueUsers", byUser)).aggregate("totalDistinctUsers", SearchLogEntry.USER.distinct(1000))).pageSize(0)).toRequest();
        SearchLogResponse response = request.search(client);
        AggregationBucketResult uniqueUsers = (AggregationBucketResult)response.getAggregations().get("uniqueUsers");
        for (AggregationBucketDetails details : uniqueUsers.getBuckets()) {
            list.add(UserViews.builder().username(details.key.toString()).viewCount(details.docCount).mostRecentView(details.getNestedResults().get("latestTimestamp").getMetric().longValue()).build());
        }
        return list;
    }

    public static List<AssetViews> mostViewedAssets(AtlanClient client, int maxAssets, boolean byDifferentUsers) throws AtlanException {
        return SearchLog.mostViewedAssets(client, maxAssets, byDifferentUsers, null);
    }

    public static List<AssetViews> mostViewedAssets(AtlanClient client, int maxAssets, boolean byDifferentUsers, List<String> excludeUsers) throws AtlanException {
        ArrayList<AssetViews> list = new ArrayList<AssetViews>();
        List<NamedValue<SortOrder>> sort = null;
        if (byDifferentUsers) {
            sort = List.of(NamedValue.of((String)"uniqueUsers", (Object)SortOrder.Desc));
        }
        Aggregation byGuid = SearchLogEntry.ENTITY_ID.bucketBy(maxAssets, Map.of("uniqueUsers", SearchLogEntry.USER.distinct(1000)), sort);
        SearchLogRequest request = ((SearchLogBuilder)((SearchLogBuilder)((SearchLogBuilder)SearchLog.views(client, excludeUsers).aggregate("uniqueAssets", byGuid)).aggregate("totalDistinctUsers", SearchLogEntry.USER.distinct(1000))).pageSize(1)).toRequest();
        SearchLogResponse response = request.search(client);
        AggregationBucketResult uniqueAssets = (AggregationBucketResult)response.getAggregations().get("uniqueAssets");
        for (AggregationBucketDetails details : uniqueAssets.getBuckets()) {
            list.add(AssetViews.builder().guid(details.key.toString()).totalViews(details.docCount).distinctUsers(details.getNestedResults().get("uniqueUsers").getMetric().longValue()).build());
        }
        return list;
    }

    public SearchLogRequest toRequest() {
        return this._requestBuilder().build();
    }

    public long count() throws AtlanException {
        if (this.client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        AtlanObject request = SearchLogRequest.builder((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)this._dsl().size(1)).clearAggregations()).build()).build();
        return ((SearchLogRequest)request).search(this.client).getApproximateCount();
    }

    public Stream<SearchLogEntry> stream() throws AtlanException {
        return this.stream(false);
    }

    public Stream<SearchLogEntry> stream(boolean parallel) throws AtlanException {
        if (this.client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        if (parallel) {
            return this.toRequest().search(this.client).parallelStream();
        }
        return this.toRequest().search(this.client).stream();
    }

    public Stream<SearchLogEntry> parallelStream() throws AtlanException {
        return this.stream(true);
    }

    public Stream<SearchLogEntry> bulkStream() throws AtlanException {
        if (!SearchLogResponse.presortedByTimestamp(this.sorts)) {
            this.sorts = SearchLogResponse.sortByTimestampFirst(this.sorts);
        }
        return this.toRequest().search(this.client).bulkStream();
    }

    protected IndexSearchDSL.IndexSearchDSLBuilder<?, ?> _dsl() {
        return IndexSearchDSL.builder(this.toQuery());
    }

    protected SearchLogRequest.SearchLogRequestBuilder<?, ?> _requestBuilder() {
        IndexSearchDSL.IndexSearchDSLBuilder<?, ?> dsl = this._dsl();
        if (this.pageSize != null) {
            dsl.size(this.pageSize);
        }
        if (this.sorts != null) {
            dsl.sort(this.sorts);
        }
        if (this.aggregations != null) {
            dsl.aggregations(this.aggregations);
        }
        return SearchLogRequest.builder((IndexSearchDSL)dsl.build());
    }

    @Generated
    private static Integer $default$pageSize() {
        return 300;
    }

    @Generated
    protected SearchLog(SearchLogBuilder<?, ?> b) {
        super(b);
        Map<Object, Object> aggregations;
        this.sorts = switch (b.sorts == null ? 0 : b.sorts.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.sorts.get(0));
            default -> Collections.unmodifiableList(new ArrayList<SortOptions>(b.sorts));
        };
        switch (b.aggregations$key == null ? 0 : b.aggregations$key.size()) {
            case 0: {
                aggregations = Collections.emptyMap();
                break;
            }
            case 1: {
                aggregations = Collections.singletonMap(b.aggregations$key.get(0), b.aggregations$value.get(0));
                break;
            }
            default: {
                aggregations = new LinkedHashMap(b.aggregations$key.size() < 0x40000000 ? 1 + b.aggregations$key.size() + (b.aggregations$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.aggregations$key.size(); ++$i) {
                    aggregations.put(b.aggregations$key.get($i), b.aggregations$value.get($i));
                }
                aggregations = Collections.unmodifiableMap(aggregations);
            }
        }
        this.aggregations = aggregations;
        this.pageSize = b.pageSize$set ? b.pageSize$value : SearchLog.$default$pageSize();
    }

    @Generated
    public static SearchLogBuilder<?, ?> _internal() {
        return new SearchLogBuilderImpl();
    }

    public static abstract class SearchLogBuilder<C extends SearchLog, B extends SearchLogBuilder<C, B>>
    extends CompoundQuery.CompoundQueryBuilder<C, B> {
        @Generated
        private ArrayList<SortOptions> sorts;
        @Generated
        private ArrayList<String> aggregations$key;
        @Generated
        private ArrayList<Aggregation> aggregations$value;
        @Generated
        private boolean pageSize$set;
        @Generated
        private Integer pageSize$value;

        public SearchLogRequest.SearchLogRequestBuilder<?, ?> toRequestBuilder() {
            return ((SearchLog)this.build())._requestBuilder();
        }

        public SearchLogRequest toRequest() {
            return ((SearchLog)this.build()).toRequest();
        }

        public long count() throws AtlanException {
            return ((SearchLog)this.build()).count();
        }

        public Stream<SearchLogEntry> stream() throws AtlanException {
            return ((SearchLog)this.build()).stream();
        }

        public Stream<SearchLogEntry> stream(boolean parallel) throws AtlanException {
            return ((SearchLog)this.build()).stream(parallel);
        }

        @Generated
        public B sort(SortOptions sort) {
            if (this.sorts == null) {
                this.sorts = new ArrayList();
            }
            this.sorts.add(sort);
            return (B)this.self();
        }

        @Generated
        public B sorts(Collection<? extends SortOptions> sorts) {
            if (sorts == null) {
                throw new NullPointerException("sorts cannot be null");
            }
            if (this.sorts == null) {
                this.sorts = new ArrayList();
            }
            this.sorts.addAll(sorts);
            return (B)this.self();
        }

        @Generated
        public B clearSorts() {
            if (this.sorts != null) {
                this.sorts.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B aggregate(String aggregateKey, Aggregation aggregateValue) {
            if (this.aggregations$key == null) {
                this.aggregations$key = new ArrayList();
                this.aggregations$value = new ArrayList();
            }
            this.aggregations$key.add(aggregateKey);
            this.aggregations$value.add(aggregateValue);
            return (B)this.self();
        }

        @Generated
        public B aggregations(Map<? extends String, ? extends Aggregation> aggregations) {
            if (aggregations == null) {
                throw new NullPointerException("aggregations cannot be null");
            }
            if (this.aggregations$key == null) {
                this.aggregations$key = new ArrayList();
                this.aggregations$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Aggregation> $lombokEntry : aggregations.entrySet()) {
                this.aggregations$key.add($lombokEntry.getKey());
                this.aggregations$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearAggregations() {
            if (this.aggregations$key != null) {
                this.aggregations$key.clear();
                this.aggregations$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B pageSize(Integer pageSize) {
            this.pageSize$value = pageSize;
            this.pageSize$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SearchLog.SearchLogBuilder(super=" + super.toString() + ", sorts=" + String.valueOf(this.sorts) + ", aggregations$key=" + String.valueOf(this.aggregations$key) + ", aggregations$value=" + String.valueOf(this.aggregations$value) + ", pageSize$value=" + this.pageSize$value + ")";
        }
    }

    @Generated
    private static final class SearchLogBuilderImpl
    extends SearchLogBuilder<SearchLog, SearchLogBuilderImpl> {
        @Generated
        private SearchLogBuilderImpl() {
        }

        @Override
        @Generated
        protected SearchLogBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SearchLog build() {
            return new SearchLog(this);
        }
    }
}

