/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.workflow;

import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.NestedSortValue;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.NestedQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.RegexpQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.enums.AtlanWorkflowPhase;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.workflow.WorkflowSearchResponse;
import com.atlan.model.workflow.WorkflowSearchResult;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(builder=WorkflowSearchRequestBuilderImpl.class)
public class WorkflowSearchRequest
extends IndexSearchDSL {
    private static final long serialVersionUID = 2L;

    public WorkflowSearchResponse search(AtlanClient client) throws AtlanException {
        return client.workflows.searchRuns(this);
    }

    public static WorkflowSearchResult findLatestRun(AtlanClient client, String workflowName) throws AtlanException {
        List<WorkflowSearchResult> results;
        SortOptions sort = SortOptions.of((T s) -> s.field(FieldSort.of((T f) -> f.field("metadata.creationTimestamp").order(SortOrder.Desc).nested(NestedSortValue.of((T v) -> v.path("metadata"))))));
        Query term = TermQuery.of((T t) -> t.field("spec.workflowTemplateRef.name.keyword").value(workflowName))._toQuery();
        Query nested = NestedQuery.of((T n) -> n.path("spec").query(term))._toQuery();
        Query query = BoolQuery.of((T b) -> b.filter(nested, new Query[0]))._toQuery();
        IndexSearchDSL request = ((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)WorkflowSearchRequest.builder().from(0)).size(10)).sortOption(sort)).query(query)).build();
        WorkflowSearchResponse response = client.workflows.searchRuns((WorkflowSearchRequest)request);
        if (response != null && (results = response.getHits().getHits()) != null && !results.isEmpty()) {
            return results.get(0);
        }
        return null;
    }

    public static WorkflowSearchResult findCurrentRun(AtlanClient client, String workflowName) throws AtlanException {
        List<WorkflowSearchResult> results;
        SortOptions sort = SortOptions.of((T s) -> s.field(FieldSort.of((T f) -> f.field("metadata.creationTimestamp").order(SortOrder.Desc).nested(NestedSortValue.of((T v) -> v.path("metadata"))))));
        Query name = TermQuery.of((T t) -> t.field("spec.workflowTemplateRef.name.keyword").value(workflowName))._toQuery();
        Query byName = NestedQuery.of((T n) -> n.path("spec").query(name))._toQuery();
        Query query = BoolQuery.of((T b) -> b.filter(byName, new Query[0]))._toQuery();
        IndexSearchDSL request = ((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)WorkflowSearchRequest.builder().from(0)).size(50)).sortOption(sort)).query(query)).build();
        WorkflowSearchResponse response = client.workflows.searchRuns((WorkflowSearchRequest)request);
        if (response != null && (results = response.getHits().getHits()) != null && !results.isEmpty()) {
            for (WorkflowSearchResult result : results) {
                if (result.getStatus() != AtlanWorkflowPhase.RUNNING && result.getStatus() != AtlanWorkflowPhase.PENDING) continue;
                return result;
            }
        }
        return null;
    }

    public static WorkflowSearchResult findRunByName(AtlanClient client, String workflowRunName) throws AtlanException {
        List<WorkflowSearchResult> results;
        SortOptions sort = SortOptions.of((T s) -> s.field(FieldSort.of((T f) -> f.field("metadata.creationTimestamp").order(SortOrder.Desc).nested(NestedSortValue.of((T v) -> v.path("metadata"))))));
        Query term = TermQuery.of((T t) -> t.field("metadata.name.keyword").value(workflowRunName))._toQuery();
        Query nested = NestedQuery.of((T n) -> n.path("metadata").query(term))._toQuery();
        Query query = BoolQuery.of((T b) -> b.filter(nested, new Query[0]))._toQuery();
        IndexSearchDSL request = ((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)WorkflowSearchRequest.builder().from(0)).size(10)).sortOption(sort)).query(query)).build();
        WorkflowSearchResponse response = client.workflows.searchRuns((WorkflowSearchRequest)request);
        if (response != null && (results = response.getHits().getHits()) != null && !results.isEmpty()) {
            return results.get(0);
        }
        return null;
    }

    public static List<WorkflowSearchResult> findByType(AtlanClient client, AtlanPackageType type, int maxResults) throws AtlanException {
        String regExBuilder = type.getValue().replace("-", "[-]") + "[-][0-9]{10}";
        SortOptions sort = SortOptions.of((T s) -> s.field(FieldSort.of((T f) -> f.field("metadata.creationTimestamp").order(SortOrder.Desc).nested(NestedSortValue.of((T v) -> v.path("metadata"))))));
        Query term = RegexpQuery.of((T t) -> t.field("metadata.name.keyword").value(regExBuilder))._toQuery();
        Query nested = NestedQuery.of((T n) -> n.path("metadata").query(term))._toQuery();
        Query query = BoolQuery.of((T b) -> b.filter(nested, new Query[0]))._toQuery();
        IndexSearchDSL request = ((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)WorkflowSearchRequest.builder().from(0)).size(maxResults)).sortOption(sort)).query(query)).build();
        WorkflowSearchResponse response = client.workflows.search((WorkflowSearchRequest)request);
        if (response != null && response.getHits() != null) {
            return response.getHits().getHits();
        }
        return null;
    }

    public static WorkflowSearchResult findById(AtlanClient client, String id) throws AtlanException {
        Query term = TermQuery.of((T t) -> t.field("metadata.name.keyword").value(id))._toQuery();
        Query nested = NestedQuery.of((T n) -> n.path("metadata").query(term))._toQuery();
        Query query = BoolQuery.of((T b) -> b.filter(nested, new Query[0]))._toQuery();
        IndexSearchDSL request = ((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)((WorkflowSearchRequestBuilder)WorkflowSearchRequest.builder().from(0)).size(2)).query(query)).build();
        WorkflowSearchResponse response = client.workflows.search((WorkflowSearchRequest)request);
        if (response != null && response.getHits() != null && !response.getHits().getHits().isEmpty()) {
            return response.getHits().getHits().get(0);
        }
        return null;
    }

    @Generated
    protected WorkflowSearchRequest(WorkflowSearchRequestBuilder<?, ?> b) {
        super((IndexSearchDSL.IndexSearchDSLBuilder<?, ?>)b);
    }

    @Generated
    public static WorkflowSearchRequestBuilder<?, ?> builder() {
        return new WorkflowSearchRequestBuilderImpl();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowSearchRequest)) {
            return false;
        }
        WorkflowSearchRequest other = (WorkflowSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowSearchRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "WorkflowSearchRequest(super=" + super.toString() + ")";
    }

    public static abstract class WorkflowSearchRequestBuilder<C extends WorkflowSearchRequest, B extends WorkflowSearchRequestBuilder<C, B>>
    extends IndexSearchDSL.IndexSearchDSLBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "WorkflowSearchRequest.WorkflowSearchRequestBuilder(super=" + super.toString() + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class WorkflowSearchRequestBuilderImpl
    extends WorkflowSearchRequestBuilder<WorkflowSearchRequest, WorkflowSearchRequestBuilderImpl> {
        @Generated
        private WorkflowSearchRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected WorkflowSearchRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public WorkflowSearchRequest build() {
            return new WorkflowSearchRequest(this);
        }
    }
}

