/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.AtlanClient;
import com.atlan.exception.ApiConnectionException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.AuthenticationException;
import com.atlan.exception.ErrorCode;
import com.atlan.net.ApiResource;
import com.atlan.net.FormEncoder;
import com.atlan.net.HttpContent;
import com.atlan.net.HttpHeaders;
import com.atlan.net.KeyValuePair;
import com.atlan.net.RequestOptions;
import com.atlan.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class AtlanRequest {
    private AtlanClient client;
    private ApiResource.RequestMethod method;
    private URL url;
    private HttpContent content;
    private HttpHeaders headers;
    private String body;
    private RequestOptions options;
    private String requestId;
    private boolean checkApiToken;
    private String acceptType;

    public AtlanRequest(AtlanClient client, ApiResource.RequestMethod method, String url, String body, RequestOptions options, String requestId) throws AtlanException {
        this(client, method, url, body, options, requestId, "application/json");
    }

    public AtlanRequest(AtlanClient client, ApiResource.RequestMethod method, String url, String body, RequestOptions options, String requestId, String acceptType) throws AtlanException {
        try {
            this.client = client;
            this.body = body;
            this.options = options != null ? options : RequestOptions.from(client).build();
            this.requestId = requestId;
            this.method = method;
            this.url = new URL(url);
            this.content = body == null || body.isEmpty() ? null : HttpContent.buildJSONEncodedContent(body);
            this.checkApiToken = true;
            this.acceptType = acceptType;
            this.headers = this.buildHeaders(true, options, acceptType);
        }
        catch (IOException e) {
            throw new ApiConnectionException(ErrorCode.CONNECTION_ERROR, (Throwable)e, client.getBaseUrl());
        }
    }

    public AtlanRequest(AtlanClient client, ApiResource.RequestMethod method, String url, InputStream file, String filename, Map<String, String> extras, RequestOptions options, String requestId) throws AtlanException {
        try {
            this.client = client;
            this.body = null;
            this.options = options != null ? options : RequestOptions.from(client).build();
            this.requestId = requestId;
            this.method = method;
            this.url = new URL(url);
            ArrayList<KeyValuePair<String, Object>> parameters = new ArrayList<KeyValuePair<String, Object>>();
            parameters.add(new KeyValuePair<String, InputStream>("file", file));
            if (extras != null) {
                for (Map.Entry<String, String> entry : extras.entrySet()) {
                    parameters.add(new KeyValuePair<String, String>(entry.getKey(), entry.getValue()));
                }
            }
            this.content = HttpContent.buildMultipartFormDataContent(parameters, filename);
            this.checkApiToken = true;
            this.acceptType = "application/json";
            this.headers = this.buildHeaders(true, options, this.acceptType);
        }
        catch (IOException e) {
            throw new ApiConnectionException(ErrorCode.CONNECTION_ERROR, (Throwable)e, client.getBaseUrl());
        }
    }

    public AtlanRequest(AtlanClient client, ApiResource.RequestMethod method, String url, Map<String, Object> map, RequestOptions options, String requestId) throws AtlanException {
        try {
            this.client = client;
            this.body = null;
            this.options = options != null ? options : RequestOptions.from(client).build();
            this.requestId = requestId;
            this.method = method;
            this.url = new URL(url);
            this.content = FormEncoder.createHttpContent(map);
            this.checkApiToken = false;
            this.acceptType = "application/json";
            this.headers = this.buildHeaders(false, options, this.acceptType);
        }
        catch (IOException e) {
            throw new ApiConnectionException(ErrorCode.CONNECTION_ERROR, (Throwable)e, client.getBaseUrl());
        }
    }

    public void rebuildHeaders() throws AuthenticationException {
        this.headers = this.buildHeaders(this.checkApiToken, this.options(), this.acceptType);
    }

    private HttpHeaders buildHeaders(boolean checkApiToken, RequestOptions provided, String acceptType) throws AuthenticationException {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        headerMap.put("X-Atlan-Request-Id", List.of(this.requestId));
        if (this.client.getExtraHeaders() != null) {
            headerMap.putAll(this.client.getExtraHeaders());
        }
        if (provided != null && provided.getExtraHeaders() != null) {
            headerMap.putAll(provided.getExtraHeaders());
        }
        headerMap.put("Accept", List.of(acceptType));
        headerMap.put("Accept-Charset", List.of(ApiResource.CHARSET.name()));
        String apiToken = this.client.getApiToken();
        if (checkApiToken) {
            if (apiToken == null) {
                throw new AuthenticationException(ErrorCode.NO_API_TOKEN);
            }
            if (apiToken.isEmpty()) {
                throw new AuthenticationException(ErrorCode.EMPTY_API_TOKEN);
            }
            if (StringUtils.containsWhitespace(apiToken)) {
                throw new AuthenticationException(ErrorCode.INVALID_API_TOKEN);
            }
        }
        headerMap.put("Authorization", List.of(String.format("Bearer %s", apiToken)));
        return HttpHeaders.of(headerMap);
    }

    @Generated
    public AtlanClient client() {
        return this.client;
    }

    @Generated
    public ApiResource.RequestMethod method() {
        return this.method;
    }

    @Generated
    public URL url() {
        return this.url;
    }

    @Generated
    public HttpContent content() {
        return this.content;
    }

    @Generated
    public HttpHeaders headers() {
        return this.headers;
    }

    @Generated
    public String body() {
        return this.body;
    }

    @Generated
    public RequestOptions options() {
        return this.options;
    }

    @Generated
    public String requestId() {
        return this.requestId;
    }

    @Generated
    public boolean checkApiToken() {
        return this.checkApiToken;
    }

    @Generated
    public String acceptType() {
        return this.acceptType;
    }

    @Generated
    protected AtlanRequest(AtlanClient client, ApiResource.RequestMethod method, URL url, HttpContent content, HttpHeaders headers, String body, RequestOptions options, String requestId, boolean checkApiToken, String acceptType) {
        this.client = client;
        this.method = method;
        this.url = url;
        this.content = content;
        this.headers = headers;
        this.body = body;
        this.options = options;
        this.requestId = requestId;
        this.checkApiToken = checkApiToken;
        this.acceptType = acceptType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanRequest)) {
            return false;
        }
        AtlanRequest other = (AtlanRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.checkApiToken() != other.checkApiToken()) {
            return false;
        }
        AtlanClient this$client = this.client();
        AtlanClient other$client = other.client();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        ApiResource.RequestMethod this$method = this.method();
        ApiResource.RequestMethod other$method = other.method();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        URL this$url = this.url();
        URL other$url = other.url();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        HttpContent this$content = this.content();
        HttpContent other$content = other.content();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        HttpHeaders this$headers = this.headers();
        HttpHeaders other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$body = this.body();
        String other$body = other.body();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        RequestOptions this$options = this.options();
        RequestOptions other$options = other.options();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$requestId = this.requestId();
        String other$requestId = other.requestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$acceptType = this.acceptType();
        String other$acceptType = other.acceptType();
        return !(this$acceptType == null ? other$acceptType != null : !this$acceptType.equals(other$acceptType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.checkApiToken() ? 79 : 97);
        AtlanClient $client = this.client();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        ApiResource.RequestMethod $method = this.method();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        URL $url = this.url();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        HttpContent $content = this.content();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        HttpHeaders $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $body = this.body();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        RequestOptions $options = this.options();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $requestId = this.requestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $acceptType = this.acceptType();
        result = result * 59 + ($acceptType == null ? 43 : $acceptType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AtlanRequest(client=" + String.valueOf(this.client()) + ", method=" + String.valueOf((Object)this.method()) + ", url=" + String.valueOf(this.url()) + ", content=" + String.valueOf(this.content()) + ", headers=" + String.valueOf(this.headers()) + ", body=" + this.body() + ", options=" + String.valueOf(this.options()) + ", requestId=" + this.requestId() + ", checkApiToken=" + this.checkApiToken() + ", acceptType=" + this.acceptType() + ")";
    }
}

