/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.net.AbstractAtlanResponse;
import com.atlan.net.ApiResource;
import com.atlan.net.AtlanEventStreamResponse;
import com.atlan.net.AtlanResponse;
import com.atlan.net.HttpHeaders;
import com.atlan.util.StreamUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class AtlanResponseStream
extends AbstractAtlanResponse<InputStream> {
    public AtlanResponseStream(int code, HttpHeaders headers, InputStream body) {
        super(code, headers, body);
    }

    AtlanResponse unstream() throws IOException {
        String bodyString = StreamUtils.readToEnd((InputStream)this.body, ApiResource.CHARSET);
        ((InputStream)this.body).close();
        return new AtlanResponse(this.code, this.headers, bodyString);
    }

    AtlanEventStreamResponse toEvents() throws IOException {
        ArrayList<String> events = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.body, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                events.add(line);
            }
        }
        return new AtlanEventStreamResponse(this.code, this.headers, (List<String>)events);
    }
}

