/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.ApiConnectionException;
import com.atlan.exception.ApiException;
import com.atlan.exception.AtlanException;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.TypeDefResponse;
import com.atlan.net.AbstractAtlanResponse;
import com.atlan.net.AtlanEventStreamResponse;
import com.atlan.net.AtlanRequest;
import com.atlan.net.AtlanResponse;
import com.atlan.net.AtlanResponseStream;
import com.atlan.net.RequestMetrics;
import com.atlan.util.Stopwatch;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    public static final Duration maxNetworkRetriesDelay = Duration.ofSeconds(5L);
    public static final Duration minNetworkRetriesDelay = Duration.ofMillis(500L);
    boolean networkRetriesSleep = true;

    protected HttpClient() {
    }

    public abstract AtlanResponse request(AtlanRequest var1) throws AtlanException;

    public abstract AtlanEventStreamResponse requestES(AtlanRequest var1) throws AtlanException;

    public AtlanResponseStream requestStream(AtlanRequest request) throws AtlanException {
        throw new UnsupportedOperationException("requestStream is unimplemented for this HttpClient");
    }

    private <T extends AbstractAtlanResponse<?>> T sendWithTelemetry(AtlanRequest request, RequestSendFunction<T> send) throws AtlanException {
        if (!Atlan.enableTelemetry) {
            return (T)((AbstractAtlanResponse)send.apply(request));
        }
        Stopwatch stopwatch = Stopwatch.startNew();
        AbstractAtlanResponse response = (AbstractAtlanResponse)send.apply(request);
        stopwatch.stop();
        RequestMetrics.embed(response, stopwatch.getElapsed());
        return (T)response;
    }

    public AtlanResponse requestWithTelemetry(AtlanRequest request) throws AtlanException {
        return this.sendWithTelemetry(request, this::request);
    }

    public <T extends AbstractAtlanResponse<?>> T sendWithRetries(AtlanRequest request, RequestSendFunction<T> send) throws AtlanException {
        ApiConnectionException requestException = null;
        AbstractAtlanResponse response = null;
        int retry = 0;
        while (true) {
            requestException = null;
            try {
                response = (AbstractAtlanResponse)send.apply(request);
            }
            catch (ApiConnectionException e) {
                requestException = e;
            }
            if (!this.shouldRetry(retry, requestException, request, response)) break;
            ++retry;
            try {
                Thread.sleep(this.sleepTime(retry).toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (requestException != null) {
            throw requestException;
        }
        response.numRetries(retry);
        return (T)response;
    }

    public AtlanResponse requestWithRetries(AtlanRequest request) throws AtlanException {
        return this.sendWithRetries(request, r -> this.requestWithTelemetry(r));
    }

    public AtlanEventStreamResponse requestEventStream(AtlanRequest request) throws AtlanException {
        ApiException requestException = null;
        AtlanEventStreamResponse response = null;
        try {
            response = this.requestES(request);
        }
        catch (ApiException e) {
            requestException = e;
        }
        if (requestException != null) {
            throw requestException;
        }
        return response;
    }

    protected static String buildUserAgentString(AtlanClient client) {
        return HttpClient.buildXAtlanClientUserAgentString(client);
    }

    protected static String buildXAtlanClientUserAgentString(AtlanClient client) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("atlan-java/%s", "5.2.2"));
        sb.append(String.format(" (%s; %s; rv:%s)", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")));
        sb.append(String.format(" %s/%s", System.getProperty("java.vendor"), System.getProperty("java.version")));
        sb.append(String.format(" %s/%s", System.getProperty("java.vm.vendor"), System.getProperty("java.vm.version")));
        if (client.getAppInfo() != null) {
            sb.append(HttpClient.formatAppInfo(client.getAppInfo()));
        }
        return sb.toString();
    }

    private static String formatAppInfo(Map<String, String> info) {
        Object str = info.get("name");
        if (info.get("version") != null) {
            str = (String)str + String.format("/%s", info.get("version"));
        }
        if (info.get("url") != null) {
            str = (String)str + String.format(" (%s)", info.get("url"));
        }
        return str;
    }

    private <T extends AbstractAtlanResponse<?>> boolean shouldRetry(int numRetries, AtlanException exception, AtlanRequest request, T response) {
        if (numRetries >= request.options().getMaxNetworkRetries()) {
            if (exception != null) {
                log.error(" ... beyond max retries ({}), failing! If this is unexpected, you can try increasing the maximum retries through Atlan.setMaxNetworkRetries()", (Object)request.options().getMaxNetworkRetries(), (Object)exception);
            } else {
                log.error(" ... beyond max retries ({}), failing! If this is unexpected, you can try increasing the maximum retries through Atlan.setMaxNetworkRetries()", (Object)request.options().getMaxNetworkRetries());
            }
            return false;
        }
        if (exception != null && exception.getCause() != null && (exception.getCause() instanceof ConnectException || exception.getCause() instanceof SocketTimeoutException)) {
            log.debug(" ... network issue, will retry.", (Throwable)exception);
            return true;
        }
        if (response != null) {
            if (response.code() == 302) {
                log.debug(" ... redirect received, will retry: {}", response.body());
            } else {
                if (response.code() == 401) {
                    String userId = request.client().getUserId();
                    if (userId != null) {
                        try {
                            log.info(" ... authentication failed, attempting to exchange new token for user: {}", (Object)userId);
                            AtlanClient client = request.client();
                            String token = client.impersonate.user(userId);
                            client.setApiToken(token);
                            request.rebuildHeaders();
                            TypeDefResponse td = client.typeDefs.list(List.of(AtlanTypeCategory.STRUCT));
                            try {
                                for (int retryCount = 1; retryCount < client.getMaxNetworkRetries() && (td == null || td.getStructDefs() == null || td.getStructDefs().isEmpty()); ++retryCount) {
                                    Thread.sleep(HttpClient.waitTime(retryCount).toMillis());
                                    td = client.typeDefs.list(List.of(AtlanTypeCategory.STRUCT));
                                }
                            }
                            catch (InterruptedException e) {
                                log.warn(" ... retry loop interrupted.", (Throwable)exception);
                            }
                            return true;
                        }
                        catch (AtlanException e) {
                            log.warn(" ... attempt to impersonate user {} failed, not retrying.", (Object)userId, (Object)exception);
                        }
                    }
                    return false;
                }
                if (response.code() == 403) {
                    if (exception != null) {
                        log.debug(" ... no permission for the operation (yet), will retry: {}", response.body(), (Object)exception);
                    } else {
                        log.debug(" ... no permission for the operation (yet), will retry: {}", response.body());
                    }
                } else if (response.code() == 429) {
                    if (exception != null) {
                        log.debug(" ... rate-limited, will retry with a delay: {}", response.body(), (Object)exception);
                    } else {
                        log.debug(" ... rate-limited, will retry with a delay: {}", response.body());
                    }
                    Optional<String> retryAfter = response.headers.firstValue("Retry-After");
                    if (retryAfter.isPresent()) {
                        try {
                            String retryInSeconds = retryAfter.get();
                            log.debug(" ... pausing for {} seconds before retrying, given the rate-limit", (Object)retryInSeconds);
                            long waitTime = Long.parseLong(retryInSeconds);
                            Thread.sleep(waitTime * 1000L);
                        }
                        catch (NumberFormatException e) {
                            log.warn(" ... unable to parse retry-after header value: {}", (Object)retryAfter.get(), (Object)e);
                        }
                        catch (InterruptedException e) {
                            log.warn(" ... wait on retry-after was interrupted: {}", (Object)retryAfter.get(), (Object)e);
                        }
                    } else {
                        log.debug(" ... rate limit had no Retry-After header in its response, so only exponentially backing-off retries");
                    }
                } else if (response.code() >= 500) {
                    if (exception != null) {
                        log.debug(" ... internal server error, will retry: {}", response.body(), (Object)exception);
                    } else {
                        log.debug(" ... internal server error, will retry: {}", response.body());
                    }
                }
            }
            return response.code() == 302 || response.code() == 403 || response.code() == 429 || response.code() >= 500;
        }
        return false;
    }

    private Duration sleepTime(int numRetries) {
        if (!this.networkRetriesSleep) {
            return Duration.ZERO;
        }
        return HttpClient.waitTime(numRetries);
    }

    public static Duration waitTime(int attempt) {
        Duration delay = Duration.ofNanos((long)((double)minNetworkRetriesDelay.toNanos() * Math.pow(2.0, attempt - 1)));
        if (delay.compareTo(maxNetworkRetriesDelay) > 0) {
            delay = maxNetworkRetriesDelay;
        }
        double jitter = ThreadLocalRandom.current().nextDouble(0.75, 1.0);
        if ((delay = Duration.ofNanos((long)((double)delay.toNanos() * jitter))).compareTo(minNetworkRetriesDelay) < 0) {
            delay = minNetworkRetriesDelay;
        }
        return delay;
    }

    @FunctionalInterface
    private static interface RequestSendFunction<R> {
        public R apply(AtlanRequest var1) throws AtlanException;
    }
}

