/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.AtlanClient;
import com.atlan.exception.ApiException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.AuthenticationException;
import com.atlan.exception.ConflictException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.LogicException;
import com.atlan.exception.NotFoundException;
import com.atlan.exception.PermissionException;
import com.atlan.exception.RateLimitException;
import com.atlan.model.core.AtlanError;
import com.atlan.model.core.AtlanEventStreamResponseInterface;
import com.atlan.model.core.AtlanResponseInterface;
import com.atlan.net.ApiResource;
import com.atlan.net.AtlanEventStreamResponse;
import com.atlan.net.AtlanRequest;
import com.atlan.net.AtlanResponse;
import com.atlan.net.AtlanResponseGetter;
import com.atlan.net.HttpClient;
import com.atlan.net.HttpURLConnectionClient;
import com.atlan.net.RequestOptions;
import com.atlan.serde.Serde;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LiveAtlanResponseGetter
implements AtlanResponseGetter {
    private final HttpClient httpClient;

    public LiveAtlanResponseGetter() {
        this(null);
    }

    public LiveAtlanResponseGetter(HttpClient httpClient) {
        this.httpClient = httpClient != null ? httpClient : LiveAtlanResponseGetter.buildDefaultHttpClient();
    }

    @Override
    public void request(AtlanClient client, ApiResource.RequestMethod method, String url, String body, RequestOptions options, String requestId) throws AtlanException {
        AtlanRequest request = new AtlanRequest(client, method, url, body, options, requestId);
        this.request(request);
    }

    private void request(AtlanRequest request) throws AtlanException {
        AtlanResponse response = this.httpClient.requestWithRetries(request);
        int responseCode = response.code();
        if (responseCode < 200 || responseCode >= 300) {
            LiveAtlanResponseGetter.handleApiError(response);
        }
    }

    @Override
    public <T extends AtlanResponseInterface> T request(AtlanClient client, ApiResource.RequestMethod method, String url, String body, Class<T> clazz, RequestOptions options, String requestId) throws AtlanException {
        AtlanRequest request = new AtlanRequest(client, method, url, body, options, requestId);
        return this.request(request, clazz);
    }

    @Override
    public String requestPlainText(AtlanClient client, ApiResource.RequestMethod method, String url, String body, RequestOptions options, String requestId) throws AtlanException {
        AtlanRequest request = new AtlanRequest(client, method, url, body, options, requestId);
        return this.requestPlainText(request);
    }

    @Override
    public <T extends AtlanEventStreamResponseInterface> T requestStream(AtlanClient client, ApiResource.RequestMethod method, String url, String body, Class<T> clazz, RequestOptions options, String requestId) throws AtlanException {
        AtlanRequest request = new AtlanRequest(client, method, url, body, options, requestId, "text/event-stream");
        return this.requestStream(request, clazz);
    }

    @Override
    public <T extends AtlanResponseInterface> T request(AtlanClient client, ApiResource.RequestMethod method, String url, InputStream upload, String filename, Class<T> clazz, Map<String, String> extras, RequestOptions options, String requestId) throws AtlanException {
        AtlanRequest request = new AtlanRequest(client, method, url, upload, filename, extras, options, requestId);
        return this.request(request, clazz);
    }

    @Override
    public <T extends AtlanResponseInterface> T request(AtlanClient client, ApiResource.RequestMethod method, String url, Map<String, Object> map, Class<T> clazz, RequestOptions options, String requestId) throws AtlanException {
        AtlanRequest request = new AtlanRequest(client, method, url, map, options, requestId);
        return this.request(request, clazz);
    }

    private <T extends AtlanResponseInterface> T request(AtlanRequest request, Class<T> clazz) throws AtlanException {
        AtlanResponse response = this.httpClient.requestWithRetries(request);
        int responseCode = response.code();
        String responseBody = (String)response.body();
        if (responseCode < 200 || responseCode >= 300) {
            LiveAtlanResponseGetter.handleApiError(response);
        }
        AtlanResponseInterface resource = null;
        if (clazz != null) {
            try {
                resource = (AtlanResponseInterface)request.client().readValue(responseBody, clazz);
            }
            catch (IOException e) {
                LiveAtlanResponseGetter.raiseMalformedJsonError(responseBody, responseCode, e);
            }
        }
        if (resource != null) {
            resource.setLastResponse(response);
        }
        return (T)resource;
    }

    private String requestPlainText(AtlanRequest request) throws AtlanException {
        AtlanResponse response = this.httpClient.requestWithRetries(request);
        int responseCode = response.code();
        String responseBody = (String)response.body();
        if (responseCode < 200 || responseCode >= 300) {
            LiveAtlanResponseGetter.handleApiError(responseCode, responseBody);
        }
        return responseBody;
    }

    private <T extends AtlanEventStreamResponseInterface> T requestStream(AtlanRequest request, Class<T> clazz) throws AtlanException {
        AtlanEventStreamResponse response = this.httpClient.requestEventStream(request);
        int responseCode = response.code();
        List responseBody = (List)response.body();
        if (responseCode < 200 || responseCode >= 300) {
            LiveAtlanResponseGetter.handleApiError(response);
        }
        AtlanEventStreamResponseInterface resource = null;
        if (clazz != null) {
            try {
                ArrayList<AtlanEventStreamResponseInterface> events = new ArrayList<AtlanEventStreamResponseInterface>();
                for (String eventBody : responseBody) {
                    if (!eventBody.startsWith("data: ")) continue;
                    events.add((AtlanEventStreamResponseInterface)request.client().readValue(eventBody.substring(6), clazz));
                }
                resource = (AtlanEventStreamResponseInterface)clazz.getConstructor(List.class).newInstance(events);
            }
            catch (IOException e) {
                LiveAtlanResponseGetter.raiseMalformedJsonError(responseBody.toString(), responseCode, e);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new LogicException(ErrorCode.UNABLE_TO_DESERIALIZE, responseBody.toString());
            }
        }
        if (resource != null) {
            resource.setLastResponse(response);
        }
        return (T)resource;
    }

    private static HttpClient buildDefaultHttpClient() {
        return new HttpURLConnectionClient();
    }

    private static void raiseMalformedJsonError(String responseBody, int responseCode, Throwable e) throws ApiException {
        throw new ApiException(ErrorCode.ERROR_PASSTHROUGH, e, "" + responseCode, responseBody, "");
    }

    private static void handleApiError(AtlanResponse response) throws AtlanException {
        AtlanError error = null;
        try {
            error = (AtlanError)Serde.allInclusiveMapper.readValue((String)response.body(), AtlanError.class);
        }
        catch (IOException e) {
            error = new AtlanError();
            error.setCode(Long.valueOf(response.code()));
            error.setErrorMessage((String)response.body());
        }
        if (error == null) {
            LiveAtlanResponseGetter.raiseMalformedJsonError((String)response.body(), response.code(), null);
        }
        LiveAtlanResponseGetter.raiseError(response.code(), error);
    }

    private static void handleApiError(int code, String body) throws AtlanException {
        if (code >= 500) {
            LiveAtlanResponseGetter.raiseMalformedJsonError(body, code, null);
        }
        AtlanError error = new AtlanError();
        error.setCode(Long.valueOf(code));
        error.setErrorMessage(body);
        LiveAtlanResponseGetter.raiseError(code, error);
    }

    private static void handleApiError(AtlanEventStreamResponse response) throws AtlanException {
        AtlanError error = null;
        try {
            error = (AtlanError)Serde.allInclusiveMapper.readValue((String)((List)response.body()).get(0), AtlanError.class);
        }
        catch (IOException e) {
            LiveAtlanResponseGetter.raiseMalformedJsonError((String)((List)response.body()).get(0), response.code(), e);
        }
        if (error == null) {
            LiveAtlanResponseGetter.raiseMalformedJsonError(((List)response.body()).toString(), response.code(), null);
        }
        LiveAtlanResponseGetter.raiseError(response.code(), error);
    }

    private static void raiseError(int code, AtlanError error) throws AtlanException {
        AtlanException exception = switch (code) {
            case 400 -> new InvalidRequestException(ErrorCode.INVALID_REQUEST_PASSTHROUGH, error.findCode(), error.findMessage(), error.renderCauses());
            case 404 -> new NotFoundException(ErrorCode.NOT_FOUND_PASSTHROUGH, error.findCode(), error.findMessage(), error.renderCauses());
            case 401 -> new AuthenticationException(ErrorCode.AUTHENTICATION_PASSTHROUGH, error.findCode(), error.findMessage(), error.renderCauses());
            case 403 -> new PermissionException(ErrorCode.PERMISSION_PASSTHROUGH, error.findCode(), error.findMessage(), error.renderCauses());
            case 409 -> new ConflictException(ErrorCode.CONFLICT_PASSTHROUGH, error.findCode(), error.findMessage(), error.renderCauses());
            case 429 -> new RateLimitException(ErrorCode.RATE_LIMIT_PASSTHROUGH, error.findCode(), error.findMessage(), error.renderCauses());
            default -> new ApiException(ErrorCode.ERROR_PASSTHROUGH, null, error.findCode(), error.findMessage(), error.renderCauses());
        };
        exception.setAtlanError(error);
        throw exception;
    }
}

