/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.admin.AtlanRequest;
import com.atlan.model.admin.AtlanTagPayload;
import com.atlan.model.admin.AtlanTagRequest;
import com.atlan.model.admin.CustomMetadataPayload;
import com.atlan.model.admin.CustomMetadataRequest;
import com.atlan.model.assets.Asset;
import com.atlan.model.relations.Reference;
import com.atlan.util.JacksonUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

public class AtlanRequestSerializer
extends StdSerializer<AtlanRequest> {
    private static final long serialVersionUID = 2L;
    private final transient AtlanClient client;

    public AtlanRequestSerializer(AtlanClient client) {
        this(AtlanRequest.class, client);
    }

    public AtlanRequestSerializer(Class<AtlanRequest> t, AtlanClient client) {
        super(t);
        this.client = client;
    }

    public void serializeWithType(AtlanRequest value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, serializers);
    }

    public void serialize(AtlanRequest request, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
        String destinationAttribute = request.getDestinationAttribute();
        Serializable translatedPayload = null;
        if (request instanceof AtlanTagRequest) {
            String clsId;
            AtlanTagPayload cls = ((AtlanTagRequest)request).getPayload();
            String clsName = cls.getTypeName();
            try {
                clsId = this.client.getAtlanTagCache().getSidForName(clsName);
            }
            catch (NotFoundException e) {
                clsId = "(DELETED)";
            }
            catch (AtlanException e) {
                throw new IOException("Unable to translate Atlan tag with name: " + clsName, e);
            }
            if (clsId == null) {
                clsId = "(DELETED)";
            }
            translatedPayload = cls.toBuilder().typeName(clsId).build();
        } else if (request instanceof CustomMetadataRequest) {
            CustomMetadataPayload cm = ((CustomMetadataRequest)request).getPayload();
            String cmName = destinationAttribute;
            HashMap<String, Object> attrValues = new HashMap<String, Object>();
            try {
                destinationAttribute = this.client.getCustomMetadataCache().getSidForName(cmName);
                this.client.getCustomMetadataCache().getAttributesFromCustomMetadata(destinationAttribute, cmName, cm.getAttributes(), attrValues);
            }
            catch (NotFoundException e) {
                destinationAttribute = "(DELETED)";
            }
            catch (AtlanException e) {
                throw new IOException("Unable to find custom metadata with name: " + cmName, e);
            }
            translatedPayload = attrValues;
        }
        gen.writeStartObject();
        JacksonUtils.serializeString(gen, "id", request.getId());
        JacksonUtils.serializeString(gen, "version", request.getVersion());
        JacksonUtils.serializeBoolean(gen, "isActive", request.getIsActive());
        JacksonUtils.serializeLong(gen, "createdAt", request.getCreatedAt());
        JacksonUtils.serializeLong(gen, "updatedAt", request.getUpdatedAt());
        JacksonUtils.serializeString(gen, "createdBy", request.getCreatedBy());
        JacksonUtils.serializeString(gen, "tenantId", request.getTenantId());
        JacksonUtils.serializeString(gen, "sourceType", request.getSourceType());
        JacksonUtils.serializeString(gen, "sourceGuid", request.getSourceGuid());
        JacksonUtils.serializeString(gen, "sourceQualifiedName", request.getSourceQualifiedName());
        JacksonUtils.serializeString(gen, "sourceAttribute", request.getSourceAttribute());
        JacksonUtils.serializeString(gen, "destinationGuid", request.getDestinationGuid());
        JacksonUtils.serializeString(gen, "destinationQualifiedName", request.getDestinationQualifiedName());
        JacksonUtils.serializeString(gen, "destinationAttribute", destinationAttribute);
        JacksonUtils.serializeString(gen, "destinationValue", request.getDestinationValue());
        JacksonUtils.serializeString(gen, "destinationValueType", request.getDestinationValueType());
        JacksonUtils.serializeString(gen, "entityType", request.getEntityType());
        JacksonUtils.serializeObject(gen, "requestType", request.getRequestType());
        JacksonUtils.serializeString(gen, "approvedBy", request.getApprovedBy());
        JacksonUtils.serializeString(gen, "rejectedBy", request.getRejectedBy());
        JacksonUtils.serializeObject(gen, "status", request.getStatus());
        JacksonUtils.serializeString(gen, "message", request.getMessage());
        JacksonUtils.serializeString(gen, "approvalType", request.getApprovalType());
        JacksonUtils.serializeLong(gen, "hash", request.getHash());
        JacksonUtils.serializeBoolean(gen, "isDuplicate", request.getIsDuplicate());
        JacksonUtils.serializeString(gen, "destinationValueAction", request.getDestinationValueAction());
        JacksonUtils.serializeObject(gen, "requestApproverUsers", request.getRequestApproverUsers());
        JacksonUtils.serializeObject(gen, "requestApproverGroups", request.getRequestApproverGroups());
        JacksonUtils.serializeObject(gen, "requestApproverRoles", request.getRequestApproverRoles());
        JacksonUtils.serializeObject(gen, "requestDenyUsers", request.getRequestDenyUsers());
        JacksonUtils.serializeObject(gen, "requestDenyGroups", request.getRequestDenyGroups());
        JacksonUtils.serializeObject(gen, "requestDenyRoles", request.getRequestDenyRoles());
        JacksonUtils.serializeObject(gen, "payload", translatedPayload);
        Asset destinationAsset = request.getDestinationEntity();
        if (destinationAsset != null) {
            JacksonUtils.serializeObject(gen, "destinationEntity", ((Reference.ReferenceBuilder)destinationAsset.toBuilder().typeName(null)).build());
        }
        gen.writeEndObject();
    }
}

