/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.cache.CustomMetadataCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.LogicException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.serde.CustomMetadataMapDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadableCustomMetadataDeserializer
extends StdDeserializer<Map<String, CustomMetadataAttributes>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadableCustomMetadataDeserializer.class);
    private static final long serialVersionUID = 2L;

    public ReadableCustomMetadataDeserializer() {
        super(CustomMetadataMapDeserializer.class);
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser, context);
    }

    public Map<String, CustomMetadataAttributes> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return this.deserialize((JsonNode)parser.getCodec().readTree(parser));
    }

    Map<String, CustomMetadataAttributes> deserialize(JsonNode root) throws IOException {
        HashMap<String, AtlanObject> map = new HashMap<String, AtlanObject>();
        Iterator it = root.fieldNames();
        while (it.hasNext()) {
            String cmName = (String)it.next();
            CustomMetadataAttributes.CustomMetadataAttributesBuilder<?, ?> builder = CustomMetadataAttributes.builder();
            JsonNode attributeNames = root.get(cmName);
            try {
                Iterator attrs = attributeNames.fieldNames();
                while (attrs.hasNext()) {
                    String attrName = (String)attrs.next();
                    JsonNode jsonValue = attributeNames.get(attrName);
                    if (jsonValue.isArray()) {
                        HashSet<Object> values = new HashSet<Object>();
                        ArrayNode array = (ArrayNode)jsonValue;
                        for (JsonNode element : array) {
                            Object primitive = CustomMetadataCache.deserializePrimitive(element);
                            values.add(primitive);
                        }
                        if (values.isEmpty()) continue;
                        builder.attribute(attrName, values);
                        continue;
                    }
                    if (jsonValue.isValueNode()) {
                        Object primitive = CustomMetadataCache.deserializePrimitive(jsonValue);
                        builder.attribute(attrName, primitive);
                        continue;
                    }
                    throw new LogicException(ErrorCode.UNABLE_TO_DESERIALIZE, jsonValue.toString());
                }
            }
            catch (AtlanException e) {
                log.error("Unable to translate one of the provided custom metadata attributes of: {}.", (Object)cmName, (Object)e);
            }
            map.put(cmName, builder.build());
        }
        return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }
}

