/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.util;

import com.atlan.AtlanClient;
import com.atlan.cache.OffHeapAssetCache;
import com.atlan.cache.OffHeapFailureCache;
import com.atlan.cache.ReflectionCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.LogicException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Column;
import com.atlan.model.assets.IndistinctAsset;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AsyncCreationResponse;
import com.atlan.model.core.AtlanCloseable;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.enums.AssetCreationHandling;
import com.atlan.model.enums.AtlanTagHandling;
import com.atlan.model.enums.CustomMetadataHandling;
import com.atlan.model.relations.Reference;
import com.atlan.model.search.FluentSearch;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;

public class AssetBatch
implements AtlanCloseable {
    private static final Set<String> TABLE_LEVEL_ASSETS = Set.of("Table", "View", "MaterialisedView", "SnowflakeDynamicTable");
    private final AtlanClient client;
    private final int maxSize;
    private final AtlanTagHandling atlanTagHandling;
    private final CustomMetadataHandling customMetadataHandling;
    private final boolean captureFailures;
    private final boolean updateOnly;
    private final boolean track;
    private final boolean caseInsensitive;
    private final AssetCreationHandling creationHandling;
    private final boolean tableViewAgnostic;
    private final List<Asset> _batch = Collections.synchronizedList(new ArrayList());
    private final AtomicLong numCreated = new AtomicLong(0L);
    private final AtomicLong numUpdated = new AtomicLong(0L);
    private final AtomicLong numRestored = new AtomicLong(0L);
    private final AtomicLong numSkipped = new AtomicLong(0L);
    private final OffHeapAssetCache created;
    private final OffHeapAssetCache updated;
    private final OffHeapAssetCache restored;
    private final OffHeapFailureCache failures;
    private final OffHeapAssetCache skipped;
    private final Map<String, String> resolvedGuids = new ConcurrentHashMap<String, String>();
    private final Map<AssetIdentity, String> resolvedQualifiedNames = new ConcurrentHashMap<AssetIdentity, String>();

    public AssetBatch(AtlanClient client, int maxSize) {
        this(client, maxSize, AtlanTagHandling.IGNORE, CustomMetadataHandling.IGNORE);
    }

    public AssetBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, false);
    }

    public AssetBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, captureFailures, false);
    }

    public AssetBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, captureFailures, updateOnly, true);
    }

    public AssetBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, captureFailures, updateOnly, track, false);
    }

    public AssetBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseInsensitive) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, captureFailures, updateOnly, track, caseInsensitive, AssetCreationHandling.FULL);
    }

    public AssetBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseInsensitive, AssetCreationHandling creationHandling) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, captureFailures, updateOnly, track, caseInsensitive, creationHandling, false);
    }

    public AssetBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseInsensitive, AssetCreationHandling creationHandling, boolean tableViewAgnostic) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, captureFailures, updateOnly, track, caseInsensitive, creationHandling, tableViewAgnostic, new OffHeapAssetCache(client, "created_" + Thread.currentThread().getId()), new OffHeapAssetCache(client, "updated_" + Thread.currentThread().getId()), new OffHeapAssetCache(client, "restored_" + Thread.currentThread().getId()), new OffHeapAssetCache(client, "skipped_" + Thread.currentThread().getId()), new OffHeapFailureCache(client, "failed_" + Thread.currentThread().getId()));
    }

    public AssetBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseInsensitive, AssetCreationHandling creationHandling, boolean tableViewAgnostic, OffHeapAssetCache created, OffHeapAssetCache updated, OffHeapAssetCache restored, OffHeapAssetCache skipped, OffHeapFailureCache failed) {
        this.client = client;
        this.maxSize = maxSize;
        this.atlanTagHandling = atlanTagHandling;
        this.customMetadataHandling = customMetadataHandling;
        this.creationHandling = creationHandling;
        this.track = track;
        this.captureFailures = captureFailures;
        this.updateOnly = updateOnly;
        this.caseInsensitive = caseInsensitive;
        this.tableViewAgnostic = tableViewAgnostic;
        this.created = created;
        this.updated = updated;
        this.restored = restored;
        this.skipped = skipped;
        this.failures = failed;
    }

    public AssetMutationResponse add(Asset single) throws AtlanException {
        if (single != null) {
            if (single.getAtlanTags() != null && !single.getAtlanTags().isEmpty()) {
                this._batch.add(this.handleTags(single));
            } else {
                this._batch.add(single);
            }
        }
        return this.process();
    }

    private Asset handleTags(Asset asset) throws LogicException {
        Reference.ReferenceBuilder<?, ?> assetBuilder = asset.toBuilder();
        Method clearAtlanTags = ReflectionCache.getSetter(assetBuilder.getClass(), "clearAtlanTags");
        Method setAtlanTags = ReflectionCache.getSetter(assetBuilder.getClass(), "atlanTags");
        try {
            SortedSet<AtlanTag> existing = asset.getAtlanTags();
            TreeSet<AtlanTag> revisedTags = new TreeSet<AtlanTag>();
            if (this.atlanTagHandling != AtlanTagHandling.IGNORE) {
                Iterator iterator = existing.iterator();
                while (iterator.hasNext()) {
                    AtlanTag tag;
                    AtlanTag revised = tag = (AtlanTag)iterator.next();
                    if (tag.getSemantic() == Reference.SaveSemantic.REPLACE) {
                        switch (this.atlanTagHandling) {
                            case APPEND: {
                                AtlanObject atlanObject = ((AtlanTag.AtlanTagBuilder)tag.toBuilder().semantic(Reference.SaveSemantic.APPEND)).build();
                                break;
                            }
                            case REPLACE: {
                                AtlanObject atlanObject = ((AtlanTag.AtlanTagBuilder)tag.toBuilder().semantic(Reference.SaveSemantic.REPLACE)).build();
                                break;
                            }
                            case REMOVE: {
                                AtlanObject atlanObject = ((AtlanTag.AtlanTagBuilder)tag.toBuilder().semantic(Reference.SaveSemantic.REMOVE)).build();
                                break;
                            }
                            default: {
                                AtlanObject atlanObject = revised = null;
                            }
                        }
                    }
                    if (revised == null) continue;
                    revisedTags.add(revised);
                }
            }
            clearAtlanTags.invoke(assetBuilder, new Object[0]);
            if (this.atlanTagHandling != AtlanTagHandling.IGNORE) {
                setAtlanTags.invoke(assetBuilder, revisedTags);
            }
            return (Asset)assetBuilder.build();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new LogicException(ErrorCode.ASSET_MODIFICATION_ERROR, (Throwable)e, Asset.ATLAN_TAGS.getAtlanFieldName());
        }
    }

    @Override
    public void close() {
        AtlanCloseable.close(this.created);
        AtlanCloseable.close(this.updated);
        AtlanCloseable.close(this.restored);
        AtlanCloseable.close(this.skipped);
    }

    private AssetMutationResponse process() throws AtlanException {
        if (this._batch.size() == this.maxSize) {
            return this.flush();
        }
        return null;
    }

    public synchronized AssetMutationResponse flush() throws AtlanException {
        AsyncCreationResponse response = null;
        ArrayList<Asset> revised = null;
        if (!this._batch.isEmpty()) {
            boolean fuzzyMatch = false;
            if (this.tableViewAgnostic) {
                Set typesInBatch = this._batch.stream().map(Reference::getTypeName).collect(Collectors.toSet());
                typesInBatch.retainAll(TABLE_LEVEL_ASSETS);
                boolean bl = fuzzyMatch = !typesInBatch.isEmpty();
            }
            if (this.updateOnly || this.creationHandling != AssetCreationHandling.FULL || fuzzyMatch) {
                FluentSearch.FluentSearchBuilder builder;
                HashMap found = new HashMap();
                List<String> qualifiedNames = this._batch.stream().map(Asset::getQualifiedName).collect(Collectors.toList());
                if (this.caseInsensitive) {
                    builder = (FluentSearch.FluentSearchBuilder)this.client.assets.select(true).minSomes(1);
                    for (String qn : qualifiedNames) {
                        builder.whereSome(Asset.QUALIFIED_NAME.eq(qn, this.caseInsensitive));
                    }
                } else {
                    builder = (FluentSearch.FluentSearchBuilder)this.client.assets.select(true).where(Asset.QUALIFIED_NAME.in(qualifiedNames));
                }
                ((FluentSearch.FluentSearchBuilder)builder.pageSize(Math.max(this.maxSize * 2, 300))).stream().forEach(asset -> {
                    AssetIdentity assetId = new AssetIdentity(asset.getTypeName(), asset.getQualifiedName(), this.caseInsensitive);
                    found.put(assetId, asset.getQualifiedName());
                });
                revised = new ArrayList();
                for (Asset asset2 : this._batch) {
                    AssetIdentity assetId = new AssetIdentity(asset2.getTypeName(), asset2.getQualifiedName(), this.caseInsensitive);
                    if (found.containsKey(assetId)) {
                        this.addFuzzyMatched(asset2, asset2.getTypeName(), (String)found.get(assetId), revised);
                        continue;
                    }
                    if (this.tableViewAgnostic && TABLE_LEVEL_ASSETS.contains(asset2.getTypeName())) {
                        AssetIdentity asTable = new AssetIdentity("Table", asset2.getQualifiedName(), this.caseInsensitive);
                        AssetIdentity asView = new AssetIdentity("View", asset2.getQualifiedName(), this.caseInsensitive);
                        AssetIdentity asMaterializedView = new AssetIdentity("MaterialisedView", asset2.getQualifiedName(), this.caseInsensitive);
                        AssetIdentity asDynamicTable = new AssetIdentity("SnowflakeDynamicTable", asset2.getQualifiedName(), this.caseInsensitive);
                        if (found.containsKey(asTable)) {
                            this.addFuzzyMatched(asset2, "Table", (String)found.get(asTable), revised);
                            continue;
                        }
                        if (found.containsKey(asView)) {
                            this.addFuzzyMatched(asset2, "View", (String)found.get(asView), revised);
                            continue;
                        }
                        if (found.containsKey(asMaterializedView)) {
                            this.addFuzzyMatched(asset2, "MaterialisedView", (String)found.get(asMaterializedView), revised);
                            continue;
                        }
                        if (found.containsKey(asDynamicTable)) {
                            this.addFuzzyMatched(asset2, "SnowflakeDynamicTable", (String)found.get(asDynamicTable), revised);
                            continue;
                        }
                        if (this.creationHandling == AssetCreationHandling.PARTIAL) {
                            this.addPartialAsset(asset2, revised);
                            continue;
                        }
                        if (this.creationHandling == AssetCreationHandling.FULL) {
                            revised.add(asset2);
                            continue;
                        }
                        this.track(this.skipped, asset2);
                        this.numSkipped.getAndIncrement();
                        continue;
                    }
                    if (this.creationHandling == AssetCreationHandling.PARTIAL) {
                        this.addPartialAsset(asset2, revised);
                        continue;
                    }
                    this.track(this.skipped, asset2);
                    this.numSkipped.getAndIncrement();
                }
            } else {
                revised = new ArrayList<Asset>(this._batch);
            }
            if (!revised.isEmpty()) {
                try {
                    switch (this.customMetadataHandling) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case IGNORE: {
                            AsyncCreationResponse asyncCreationResponse = this.client.assets.save(revised, this.atlanTagHandling);
                            break;
                        }
                        case OVERWRITE: {
                            AsyncCreationResponse asyncCreationResponse = this.client.assets.saveReplacingCM(revised, this.atlanTagHandling);
                            break;
                        }
                        case MERGE: {
                            AsyncCreationResponse asyncCreationResponse = response = this.client.assets.saveMergingCM(revised, this.atlanTagHandling);
                        }
                    }
                    if (response != null) {
                        response.block();
                    }
                }
                catch (AtlanException e) {
                    if (this.captureFailures) {
                        this.track(this.failures, this._batch, e);
                    }
                    throw e;
                }
            }
            this._batch.clear();
        }
        this.trackResponse(response, revised);
        return response;
    }

    private void addFuzzyMatched(Asset asset, String typeName, String actualQN, List<Asset> revised) throws LogicException {
        Reference.ReferenceBuilder<?, ?> assetBuilder = asset.toBuilder();
        Method setQualifiedName = ReflectionCache.getSetter(assetBuilder.getClass(), Asset.QUALIFIED_NAME.getAtlanFieldName());
        Method setTypeName = ReflectionCache.getSetter(assetBuilder.getClass(), Asset.TYPE_NAME.getAtlanFieldName());
        try {
            setTypeName.invoke(assetBuilder, typeName);
            setQualifiedName.invoke(assetBuilder, actualQN);
            revised.add((Asset)assetBuilder.build());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new LogicException(ErrorCode.ASSET_MODIFICATION_ERROR, (Throwable)e, Asset.QUALIFIED_NAME.getAtlanFieldName() + " or " + Asset.TYPE_NAME.getAtlanFieldName());
        }
    }

    private void addPartialAsset(Asset asset, List<Asset> revised) throws LogicException {
        Reference.ReferenceBuilder<?, ?> assetBuilder = asset.toBuilder();
        Method setIsPartial = ReflectionCache.getSetter(assetBuilder.getClass(), Asset.IS_PARTIAL.getAtlanFieldName());
        try {
            setIsPartial.invoke(assetBuilder, true);
            revised.add((Asset)assetBuilder.build());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new LogicException(ErrorCode.ASSET_MODIFICATION_ERROR, (Throwable)e, Asset.QUALIFIED_NAME.getAtlanFieldName());
        }
    }

    private void trackResponse(AssetMutationResponse response, List<Asset> sent) {
        if (response != null) {
            if (this.track) {
                response.getCreatedAssets().forEach(a -> this.track(this.created, (Asset)a));
                response.getUpdatedAssets().forEach(a -> this.track(this.updated, (Asset)a));
            }
            this.numCreated.getAndAdd(response.getCreatedAssets().size());
            this.numUpdated.getAndAdd(response.getUpdatedAssets().size());
            if (response.getGuidAssignments() != null) {
                this.resolvedGuids.putAll(response.getGuidAssignments());
            }
            if (sent != null) {
                for (Asset one : sent) {
                    String mappedGuid;
                    String guid = one.getGuid();
                    if (!(guid == null || response.getGuidAssignments() != null && response.getGuidAssignments().containsKey(guid))) {
                        this.resolvedGuids.put(guid, guid);
                    }
                    if (!this.created.containsKey(mappedGuid = this.resolvedGuids.getOrDefault(guid, guid)) && !this.updated.containsKey(mappedGuid)) {
                        this.track(this.restored, (Asset)((Reference.ReferenceBuilder)one.toBuilder().guid(mappedGuid)).build());
                        this.numRestored.getAndIncrement();
                    }
                    if (!this.caseInsensitive) continue;
                    String typeName = one.getTypeName();
                    String qualifiedName = one.getQualifiedName();
                    AssetIdentity id = new AssetIdentity(typeName, qualifiedName, this.caseInsensitive);
                    this.resolvedQualifiedNames.put(id, qualifiedName);
                }
            }
        }
    }

    private void track(OffHeapAssetCache tracker, Asset candidate) {
        try {
            tracker.add(this.buildCacheable(candidate.trimToRequired(), candidate));
        }
        catch (InvalidRequestException e) {
            try {
                Class<?> assetClass = Serde.getAssetClassForType(candidate.getTypeName());
                Method method = assetClass.getMethod("_internal", new Class[0]);
                Object result = method.invoke(null, new Object[0]);
                tracker.add(this.buildCacheable((Asset.AssetBuilder)result, candidate));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException eRef) {
                tracker.add(this.buildCacheable((Asset.AssetBuilder<?, ?>)IndistinctAsset._internal().typeName(candidate.getTypeName()), candidate));
            }
        }
    }

    private void track(OffHeapFailureCache tracker, List<Asset> batch, Exception failureReason) {
        ArrayList<Asset> minimal = new ArrayList<Asset>();
        for (Asset asset : batch) {
            try {
                minimal.add((Asset)((Asset.AssetBuilder)((Asset.AssetBuilder)asset.trimToRequired().guid(asset.getGuid())).qualifiedName(asset.getQualifiedName())).build());
            }
            catch (InvalidRequestException e) {
                minimal.add(((IndistinctAsset.IndistinctAssetBuilder)((IndistinctAsset.IndistinctAssetBuilder)IndistinctAsset._internal().typeName(asset.getTypeName()).guid(asset.getGuid())).qualifiedName(asset.getQualifiedName())).build());
            }
        }
        tracker.put(UUID.randomUUID().toString(), new FailedBatch(minimal, failureReason));
    }

    private Asset buildCacheable(Asset.AssetBuilder<?, ?> builder, Asset candidate) {
        Integer order;
        ((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)builder.guid(candidate.getGuid())).qualifiedName(candidate.getQualifiedName())).connectionQualifiedName(candidate.getConnectionQualifiedName())).name(candidate.getName())).tenantId(candidate.getTenantId());
        if (candidate instanceof Column && (order = ((Column)candidate).getOrder()) != null) {
            ((Column.ColumnBuilder)builder).order(order);
        }
        return builder.build();
    }

    @Generated
    public AtomicLong getNumCreated() {
        return this.numCreated;
    }

    @Generated
    public AtomicLong getNumUpdated() {
        return this.numUpdated;
    }

    @Generated
    public AtomicLong getNumRestored() {
        return this.numRestored;
    }

    @Generated
    public AtomicLong getNumSkipped() {
        return this.numSkipped;
    }

    @Generated
    public OffHeapAssetCache getCreated() {
        return this.created;
    }

    @Generated
    public OffHeapAssetCache getUpdated() {
        return this.updated;
    }

    @Generated
    public OffHeapAssetCache getRestored() {
        return this.restored;
    }

    @Generated
    public OffHeapFailureCache getFailures() {
        return this.failures;
    }

    @Generated
    public OffHeapAssetCache getSkipped() {
        return this.skipped;
    }

    @Generated
    public Map<String, String> getResolvedGuids() {
        return this.resolvedGuids;
    }

    @Generated
    public Map<AssetIdentity, String> getResolvedQualifiedNames() {
        return this.resolvedQualifiedNames;
    }

    public static final class AssetIdentity {
        private final String typeName;
        private final String qualifiedName;

        public AssetIdentity(String typeName, String qualifiedName) {
            this(typeName, qualifiedName, false);
        }

        public AssetIdentity(String typeName, String qualifiedName, boolean caseInsensitive) {
            this.typeName = typeName;
            this.qualifiedName = caseInsensitive ? qualifiedName.toLowerCase(Locale.ROOT) : qualifiedName;
        }

        public static AssetIdentity fromString(String combined) {
            String[] tokens = combined.split("::");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Invalid asset identity: " + combined);
            }
            return new AssetIdentity(tokens[0], tokens[1]);
        }

        public String toString() {
            return this.typeName + "::" + this.qualifiedName;
        }

        @Generated
        public String getTypeName() {
            return this.typeName;
        }

        @Generated
        public String getQualifiedName() {
            return this.qualifiedName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssetIdentity)) {
                return false;
            }
            AssetIdentity other = (AssetIdentity)o;
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
                return false;
            }
            String this$qualifiedName = this.getQualifiedName();
            String other$qualifiedName = other.getQualifiedName();
            return !(this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            String $qualifiedName = this.getQualifiedName();
            result = result * 59 + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
            return result;
        }
    }

    @JsonDeserialize(builder=FailedBatchBuilder.class)
    public static final class FailedBatch {
        private final List<Asset> failedAssets;
        private final Exception failureReason;

        public FailedBatch(List<Asset> failedAssets, Exception failureReason) {
            this.failedAssets = failedAssets;
            this.failureReason = failureReason;
        }

        @Generated
        public static FailedBatchBuilder builder() {
            return new FailedBatchBuilder();
        }

        @Generated
        public List<Asset> getFailedAssets() {
            return this.failedAssets;
        }

        @Generated
        public Exception getFailureReason() {
            return this.failureReason;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FailedBatch)) {
                return false;
            }
            FailedBatch other = (FailedBatch)o;
            List<Asset> this$failedAssets = this.getFailedAssets();
            List<Asset> other$failedAssets = other.getFailedAssets();
            if (this$failedAssets == null ? other$failedAssets != null : !((Object)this$failedAssets).equals(other$failedAssets)) {
                return false;
            }
            Exception this$failureReason = this.getFailureReason();
            Exception other$failureReason = other.getFailureReason();
            return !(this$failureReason == null ? other$failureReason != null : !this$failureReason.equals(other$failureReason));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Asset> $failedAssets = this.getFailedAssets();
            result = result * 59 + ($failedAssets == null ? 43 : ((Object)$failedAssets).hashCode());
            Exception $failureReason = this.getFailureReason();
            result = result * 59 + ($failureReason == null ? 43 : $failureReason.hashCode());
            return result;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class FailedBatchBuilder {
            @Generated
            private List<Asset> failedAssets;
            @Generated
            private Exception failureReason;

            @Generated
            FailedBatchBuilder() {
            }

            @Generated
            public FailedBatchBuilder failedAssets(List<Asset> failedAssets) {
                this.failedAssets = failedAssets;
                return this;
            }

            @Generated
            public FailedBatchBuilder failureReason(Exception failureReason) {
                this.failureReason = failureReason;
                return this;
            }

            @Generated
            public FailedBatch build() {
                return new FailedBatch(this.failedAssets, this.failureReason);
            }

            @Generated
            public String toString() {
                return "AssetBatch.FailedBatch.FailedBatchBuilder(failedAssets=" + String.valueOf(this.failedAssets) + ", failureReason=" + String.valueOf(this.failureReason) + ")";
            }
        }
    }
}

