/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.util;

import com.atlan.AtlanClient;
import com.atlan.cache.ReflectionCache;
import com.atlan.model.enums.AtlanPolicyAction;
import com.atlan.serde.AtlanPolicyActionDeserializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class JacksonUtils {
    public static Object deserializePrimitive(JsonNode primitive, Method method) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        return JacksonUtils.deserializePrimitive(primitive, method, null);
    }

    public static Object deserializePrimitive(JsonNode primitive, Method method, Class<?> singularClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (singularClass == null) {
            singularClass = ReflectionCache.getParameterOfMethod(method);
        }
        if (primitive.isTextual()) {
            if (singularClass == AtlanPolicyAction.class) {
                return AtlanPolicyActionDeserializer.deserialize(primitive.asText());
            }
            if (singularClass.isEnum()) {
                Method fromValue = singularClass.getMethod("fromValue", String.class);
                return fromValue.invoke(null, primitive.asText());
            }
            if (singularClass == Boolean.class) {
                return primitive.asBoolean();
            }
            if (Number.class.isAssignableFrom(singularClass)) {
                return JacksonUtils.deserializeNumber(primitive, method);
            }
            return primitive.asText();
        }
        if (primitive.isBoolean()) {
            return primitive.asBoolean();
        }
        if (primitive.isNumber()) {
            return JacksonUtils.deserializeNumber(primitive, method);
        }
        return null;
    }

    public static Object deserializeNumber(JsonNode primitive, Method method) throws IOException {
        Parameter[] parameters = method.getParameters();
        if (parameters.length != 1) {
            throw new IOException("Unexpected number of parameters (" + parameters.length + ") found for method: " + String.valueOf(method));
        }
        Class<?> parameterType = parameters[0].getType();
        if (parameterType == Integer.class) {
            return primitive.asInt();
        }
        if (parameterType == Long.class) {
            return primitive.asLong();
        }
        if (parameterType == Double.class) {
            return primitive.asDouble();
        }
        if (parameterType == Float.class) {
            return Float.valueOf(primitive.floatValue());
        }
        if (parameterType == Short.class) {
            return primitive.shortValue();
        }
        throw new IOException("Unhandled parameter type (" + String.valueOf(parameterType) + ") found for method: " + String.valueOf(method));
    }

    public static String deserializeString(JsonNode node, String path) {
        JsonNode value = node.get(path);
        return value == null || value.isNull() ? null : value.asText();
    }

    public static void serializeString(JsonGenerator gen, String name, String value) throws IOException {
        if (value != null) {
            gen.writeFieldName(name);
            gen.writeString(value);
        }
    }

    public static Long deserializeLong(JsonNode node, String path) {
        JsonNode value = node.get(path);
        return value == null || value.isNull() ? null : Long.valueOf(value.asLong());
    }

    public static void serializeLong(JsonGenerator gen, String name, Long value) throws IOException {
        if (value != null) {
            gen.writeFieldName(name);
            gen.writeNumber(value.longValue());
        }
    }

    public static Double deserializeDouble(JsonNode node, String path) {
        JsonNode value = node.get(path);
        return value == null || value.isNull() ? null : Double.valueOf(value.asDouble());
    }

    public static void serializeDouble(JsonGenerator gen, String name, Double value) throws IOException {
        if (value != null) {
            gen.writeFieldName(name);
            gen.writeNumber(value.doubleValue());
        }
    }

    public static Boolean deserializeBoolean(JsonNode node, String path) {
        JsonNode value = node.get(path);
        return value == null || value.isNull() ? null : Boolean.valueOf(value.asBoolean());
    }

    public static void serializeBoolean(JsonGenerator gen, String name, Boolean value) throws IOException {
        if (value != null) {
            gen.writeFieldName(name);
            gen.writeBoolean(value.booleanValue());
        }
    }

    public static <T> T deserializeObject(AtlanClient client, JsonNode node, String path, TypeReference<T> typeReference) throws JsonProcessingException {
        JsonNode value = node.get(path);
        return value == null || value.isNull() ? null : (T)client.convertValue(value, typeReference);
    }

    public static void serializeObject(JsonGenerator gen, String name, Object value) throws IOException {
        if (value != null) {
            gen.writeFieldName(name);
            gen.writeObject(value);
        }
    }
}

