/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.model.core.AtlanCloseable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOffHeapCache<K, V>
implements AtlanCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractOffHeapCache.class);
    private final Path backingStore;
    private volatile RocksDB internal;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final String name;

    public AbstractOffHeapCache(String name) {
        this.name = name;
        this.lock.writeLock().lock();
        try {
            this.backingStore = Files.createTempDirectory("rdb_" + name + "_", new FileAttribute[0]);
            this.internal = RocksDB.open((String)this.backingStore.toString());
        }
        catch (IOException | RocksDBException e) {
            throw new RuntimeException("Unable to create off-heap cache for tracking.", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected abstract byte[] serializeKey(K var1);

    protected abstract K deserializeKey(byte[] var1) throws IOException;

    protected abstract byte[] serializeValue(V var1);

    protected abstract V deserializeValue(byte[] var1) throws IOException;

    public V get(K key) {
        byte[] value;
        if (this.internal.isClosed()) {
            return null;
        }
        byte[] kb = this.serializeKey(key);
        this.lock.readLock().lock();
        try {
            value = this.internal.get(kb);
        }
        catch (RocksDBException e) {
            throw new IllegalStateException("Unable to get value for key: " + String.valueOf(key), e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            if (value == null || value.length == 0) {
                log.warn("Null or empty value retrieved for ID: {} -- short-circuiting.", key);
                return null;
            }
            return this.deserializeValue(value);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to translate value for key: " + String.valueOf(key), e);
        }
    }

    public void put(K key, V value) {
        if (this.internal.isClosed()) {
            throw new IllegalStateException("Off-heap cache is closed -- cannot add a key/value to it: " + String.valueOf(key));
        }
        byte[] kb = this.serializeKey(key);
        byte[] vb = this.serializeValue(value);
        if (vb == null || vb.length == 0) {
            log.warn(" ... zero-length serialized object being added ({}): {}", key, value);
        }
        this.lock.writeLock().lock();
        try {
            this.internal.put(kb, vb);
        }
        catch (RocksDBException e) {
            throw new IllegalStateException("Unable to put value for key: " + String.valueOf(key), e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(AbstractOffHeapCache<K, V> other) {
        if (other != null) {
            if (this.internal.isClosed()) {
                throw new IllegalStateException("Off-heap cache is closed -- cannot bulk-add keys and values to it.");
            }
            try (WriteBatch batch = new WriteBatch();
                 WriteOptions options = new WriteOptions();){
                try (RocksIterator iterator = other.internal.newIterator();){
                    iterator.seekToFirst();
                    while (iterator.isValid()) {
                        batch.put(iterator.key(), iterator.value());
                        iterator.next();
                    }
                }
                this.lock.writeLock().lock();
                try {
                    this.internal.write(options, batch);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            catch (RocksDBException e) {
                throw new IllegalStateException("Error putting all values into cache.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        if (this.internal.isClosed()) {
            return false;
        }
        byte[] kb = this.serializeKey(key);
        this.lock.readLock().lock();
        try {
            boolean bl = this.internal.keyExists(kb);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long size() {
        return this.entrySet().count();
    }

    public long getSize() {
        return this.size();
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public Stream<V> values() {
        if (this.internal.isClosed()) {
            return Stream.empty();
        }
        return new EntryIterator(this, this.internal.newIterator()).stream().map(Map.Entry::getValue);
    }

    public Stream<Map.Entry<K, V>> entrySet() {
        if (this.internal.isClosed()) {
            return Stream.empty();
        }
        return new EntryIterator(this, this.internal.newIterator()).stream();
    }

    public boolean isNotClosed() {
        return !this.internal.isClosed();
    }

    @Override
    public void close() {
        log.debug("Closing off-heap cache ({}): {}", (Object)this.getName(), (Object)this.backingStore);
        this.lock.writeLock().lock();
        try {
            this.internal.close();
            File file = this.backingStore.toFile();
            if (file.exists() && file.isDirectory()) {
                this.deleteDirectory(this.backingStore);
            }
        }
        catch (IOException e) {
            log.warn("Unable to remove backing store for off-heap cache -- leaving it behind.");
            log.debug("Full details: ", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void deleteDirectory(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Generated
    public String getName() {
        return this.name;
    }

    private static final class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>>,
    AtlanCloseable {
        private final AbstractOffHeapCache<K, V> cache;
        private final RocksIterator iterator;

        public EntryIterator(AbstractOffHeapCache<K, V> cache, RocksIterator iterator) {
            this.cache = cache;
            this.iterator = iterator;
            this.iterator.seekToFirst();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.isValid();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("No more elements in the cache.");
            }
            byte[] key = this.iterator.key();
            byte[] value = this.iterator.value();
            try {
                AbstractMap.SimpleEntry<K, V> entry = new AbstractMap.SimpleEntry<K, V>(this.cache.deserializeKey(key), this.cache.deserializeValue(value));
                this.iterator.next();
                return entry;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to deserialize value.", e);
            }
        }

        @Override
        public void close() {
            this.iterator.close();
        }

        public Stream<Map.Entry<K, V>> stream() {
            return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 272), false).onClose(this::close);
        }
    }
}

