/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.cache.AbstractOffHeapCache;
import com.atlan.util.AssetBatch;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class OffHeapFailureCache
extends AbstractOffHeapCache<String, AssetBatch.FailedBatch> {
    private final AtlanClient client;

    public OffHeapFailureCache(AtlanClient client, String name) {
        super(name);
        this.client = client;
    }

    @Override
    public byte[] serializeKey(String key) {
        return key.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String deserializeKey(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] serializeValue(AssetBatch.FailedBatch value) {
        try {
            return this.client.writeValueAsBytes(value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public AssetBatch.FailedBatch deserializeValue(byte[] bytes) {
        try {
            return this.client.readValue(bytes, AssetBatch.FailedBatch.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void extendedWith(OffHeapFailureCache other, boolean closeOriginal) {
        if (other != null) {
            this.putAll(other);
            if (closeOriginal) {
                other.close();
            }
        }
    }
}

