/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.AtlanClient;
import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.ModelCache;
import freemarker.template.Configuration;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractGenerator.class);
    protected final AtlanClient client;
    protected final ModelCache cache;
    protected final GeneratorConfig cfg;
    protected final Configuration ftl;

    protected AbstractGenerator(AtlanClient client, GeneratorConfig cfg) {
        this.client = client;
        this.cfg = cfg;
        this.ftl = cfg.getFreemarkerConfig();
        this.cache = ModelCache.getInstance(client);
    }

    public abstract void generate() throws Exception;

    protected void createDirectoryIdempotent(String directory) {
        File dir = new File(directory);
        if (!dir.exists()) {
            log.info("Creating directory: " + directory);
            if (!dir.mkdirs()) {
                log.error("Unable to create target directory: {}", (Object)directory);
            }
        }
    }
}

